<!doctype html>
<html lang="<?php echo e(defaultLanguage()); ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="title" content="<?php echo isset($tag)?$tag->meta_title:''; ?>">
    <meta name="description" content="<?php echo isset($tag)?$tag->meta_description:''; ?>"/>
    <meta name="keywords" content="<?php echo isset($tag)?$tag->meta_keyword:''; ?>"/>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>"/>
    <title><?php echo e(config('app.name')); ?> - <?php echo isset($tag)?$tag->meta_title:''; ?></title>
    <?php echo isset($tag)?$tag->other_meta_tag:''; ?>

    <?php echo $siteInformation->header_tag??''; ?>

    <meta name="author" content="Pentacodes">
    <link rel="icon" type="image/x-icon" href="<?php echo e(asset('web/images/Logo.svg')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('web/vendor/bootstrap/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('web/css/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('web/css/jquery.fancybox.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('web/vendor/slick/slick.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('web/vendor/slick/slick-theme.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('web/vendor/fontawesome/css/all.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('web/css/animate.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('web/css/star-rating-svg.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('web/vendor/select2/css/select2.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('web/vendor/select2-bootstrap4-theme/select2-bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
    <link rel="stylesheet" href="<?php echo e(asset('web/vendor/xzoom/css/xzoom.css')); ?>">
    <!-- SweetAlert2 -->
    <link rel="stylesheet" href="<?php echo e(asset('app/plugins/sweetalert2/sweetalert2.min.css')); ?>">
    <script type="text/javascript">
        var base_url = "<?php echo e(url('/')); ?>";
        var logo = '<?php echo printImage($siteInformation, 'logo','logo_webp','logo_attribute'); ?>';
        var tadbeer_logo = '<?php echo printImage($siteInformation, 'tadbeer_logo','tadbeer_logo_webp','tadbeer_logo_attribute'); ?>';
        var waitText = "<?php echo staticLangString($websiteLanguages,'title.wait_text'); ?>";
    </script>
</head>
<body>
<?php echo $siteInformation->body_tag??''; ?>

<div id="loading">
    <img id="loading-image" src="<?php echo e(asset('web/images/loading.gif')); ?>" alt="Loading..."/>
</div>
<section class="top_header">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="top_header_contents">
                    <div class="Top_contents_left">
                        <?php echo printImage($siteInformation, 'logo','logo_webp','logo_attribute'); ?>

                    </div>
                    <div class="Top_contents_right">
                        <ul>
                            <li>
                                <a href="javascript:void(0)">
                                    <img src="<?php echo e(asset('web/images/top-header/location.svg')); ?>" alt="">
                                    <div class="connect_us">
                                        <h6>Locate us</h6>
                                        <p>Business Bay, Dubai</p>
                                    </div>
                                </a>
                            </li>
                            <li>
                                <a href="javascript:void(0)">
                                    <img src="<?php echo e(asset('web/images/top-header/email.svg')); ?>" alt="">
                                    <div class="connect_us">
                                        <h6>Email us</h6>
                                        <p>support@target.com</p>
                                    </div>
                                </a>
                            </li>
                            <li>
                                <a href="javascript:void(0)">
                                    <img src="<?php echo e(asset('web/images/top-header/phone.svg')); ?>" alt="">
                                    <div class="connect_us">
                                        <h6>Contact us</h6>
                                        <p>(+971) - 2333 6999</p>
                                    </div>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<header>
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <nav class="navbar navbar-expand-lg navbar-light">
                    <div class="container-fluid">
                        <a class="navbar-brand" href="<?php echo e(url('/')); ?>">
                            <?php echo printImage($siteInformation, 'tadbeer_logo','tadbeer_logo_webp','tadbeer_logo_attribute'); ?>

                            <img class="" src="<?php echo e(asset('web/images/Logo.svg')); ?>" alt="">
                        </a>
                        <div class="collapse navbar-collapse" id="navbarSupportedContent">
                            <ul class="navbar-nav mb-2 mb-lg-0">
                                <li class="nav-item">
                                    <a class="nav-link <?php echo e(Request::is('/')?'active':''); ?>" aria-current="page"
                                       href="<?php echo e(url('/')); ?>">Home</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link <?php echo e(Request::is('about')?'active':''); ?>"
                                       href="<?php echo e(url('about')); ?>">About</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link <?php echo e(Request::is('maids')?'active':''); ?>"
                                       href="<?php echo e(url('maids')); ?>">Maids</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link <?php echo e(Request::is('services')?'active':''); ?>"
                                       href="<?php echo e(url('services')); ?>">Services</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" href="<?php echo e(url("visa-service")); ?>">Visa Services</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link <?php echo e(Request::is('blogs')?'active':''); ?>"
                                       href="<?php echo e(url('blogs')); ?>">Blog</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" href="<?php echo e(url('contact-us')); ?>">Contact Us</a>
                                </li>
                            </ul>
                        </div>
                        <div class="mobile_right_section">
                            <div class="navbar_right_contents ">
                                <div class="language_selection">
                                    <img class="language-flag" alt="flag"
                                         src="<?php echo e(defaultLanguage()=='en'? asset('web/images/Header/united-kingdom.svg'): asset('web/images/united-arab-emirates.svg')); ?>">
                                    <select class="form-select" aria-label="Default select example"
                                            id="language-selector">
                                        <option data-lang="English" data-lang_code="en"
                                                value="en" <?php echo e(defaultLanguage()=='en'? 'selected': ''); ?>>EN
                                        </option>
                                        <option data-lang="Arabic" data-lang_code="ar"
                                                value="ar" <?php echo e(defaultLanguage()=='ar'? 'selected': ''); ?>>AR
                                        </option>
                                    </select>
                                </div>
                                <a href="#" class="primary_btn" data-bs-toggle="modal" data-bs-target="#EnquiryModal">Enquire
                                    Now</a>
                            </div>
                            <button class="navbar-toggler" type="button" data-bs-toggle="offcanvas"
                                    href="#offcanvasExample">
                                <span class="navbar-toggler-icon"></span>
                            </button>
                        </div>

                    </div>
                </nav>
            </div>
        </div>
    </div>
</header>


<div class="offcanvas offcanvas-start" tabindex="-1" id="offcanvasExample" aria-labelledby="offcanvasExampleLabel">
    <div class="offcanvas-header">
        <!-- <h5 class="offcanvas-title" id="offcanvasExampleLabel">Offcanvas</h5> -->
        <a href="<?php echo e(url('/')); ?>">
            <?php echo printImage($siteInformation, 'logo','logo_webp','logo_attribute'); ?>

        </a>
        <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body">
        <ul class="navbar-nav mb-2 mb-lg-0">
            <li class="nav-item">
                <a class="nav-link active" aria-current="page" href="index.php">Home</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="about.php">About</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="maid.php">Maids</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="service.php">Services</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="<?php echo e(url('visa-service')); ?>">Visa Services</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="<?php echo e(url('blogs')); ?>">Blog</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="<?php echo e(url('contact-us')); ?>">Contact Us</a>
            </li>
        </ul>
    </div>
</div>


<!--<div class="fixedBottomBar">-->
<!--    <div class="iconWhatsapp">-->
<!--        <a href="#">-->
<!--            <div class="imgCircle whasapp">-->
<!--                <img src="<?php echo e(asset('web/images/svg/topheader/whatsapp.svg')); ?>" alt="">-->
<!--            </div>-->
<!--        </a>-->
<!--    </div>-->
<!--    <div class="iconPhone">-->
<!--        <a href="#">-->
<!--            <div class="imgCircle call">-->
<!--                <img src="<?php echo e(asset('web/images/svg/callWhite.svg')); ?>" alt="">-->
<!--            </div>-->
<!--        </a>-->
<!--    </div>-->
<!--    <div class="btnBottom">-->
<!--        <a href="#!" class="primary_btn">Book now</a>-->
<!--    </div>-->
<!--</div>-->


<div class="modal fade enquiry_modal" id="EnquiryModal" tabindex="-1" aria-labelledby="exampleModalLabel"
     aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Enquire Now</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form>
                    <div class="form-group">
                        <input type="text" class="form-control" id="exampleInputEmail1" aria-describedby="emailHelp"
                               placeholder="Name*">
                    </div>
                    <div class="form-group">
                        <input type="email" class="form-control" id="exampleInputEmail1" aria-describedby="emailHelp"
                               placeholder="Email*">
                    </div>
                    <div class="form-group">
                        <input type="number" class="form-control" id="exampleInputEmail1" aria-describedby="emailHelp"
                               placeholder="Phone*">
                    </div>
                    <div class="form-group">
                        <select class="form-select" aria-label="Default select example">
                            <option selected>Services</option>
                            <option value="1">One</option>
                            <option value="2">Two</option>
                            <option value="3">Three</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <textarea class="form-control" name="" id="" rows="4" placeholder="Message*"></textarea>
                    </div>
                    <button type="submit" class="primary_btn d-block m-auto">Submit</button>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="modal fade enquiry_modal" id="BookingModal" tabindex="-1" aria-labelledby="exampleModalLabel"
     aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Book Now</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form>
                    <div class="form-group">
                        <input type="text" class="form-control" id="exampleInputEmail1" aria-describedby="emailHelp"
                               placeholder="Name*">
                    </div>
                    <div class="form-group">
                        <input type="email" class="form-control" id="exampleInputEmail1" aria-describedby="emailHelp"
                               placeholder="Email*">
                    </div>
                    <div class="form-group">
                        <input type="number" class="form-control" id="exampleInputEmail1" aria-describedby="emailHelp"
                               placeholder="Phone*">
                    </div>
                    <div class="form-group">
                        <input class="form-control" id="disabledInput" type="text" placeholder="Maid" disabled>
                    </div>
                    <div class="form-group">
                        <textarea class="form-control" name="" id="" rows="4" placeholder="Message*"></textarea>
                    </div>
                    <button type="submit" class="primary_btn d-block m-auto">Book Now</button>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="modal fade enquiry_modal" id="ServiceBookingModal" tabindex="-1" aria-labelledby="exampleModalLabel"
     aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Book Now</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form>
                    <div class="form-group">
                        <input type="text" class="form-control" id="exampleInputEmail1" aria-describedby="emailHelp"
                               placeholder="Name*">
                    </div>
                    <div class="form-group">
                        <input type="email" class="form-control" id="exampleInputEmail1" aria-describedby="emailHelp"
                               placeholder="Email*">
                    </div>
                    <div class="form-group">
                        <input type="number" class="form-control" id="exampleInputEmail1" aria-describedby="emailHelp"
                               placeholder="Phone*">
                    </div>
                    <div class="form-group">
                        <input class="form-control" id="disabledInput" type="text" placeholder="Visa Service" disabled>
                    </div>
                    <div class="form-group">
                        <textarea class="form-control" name="" id="" rows="4" placeholder="Message*"></textarea>
                    </div>
                    <button type="submit" class="primary_btn d-block m-auto">Book Now</button>
                </form>
            </div>
        </div>
    </div>
</div>

<?php echo $__env->yieldContent('content'); ?>


<footer>
    <?php echo $siteInformation->footer_tag??''; ?>

    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="footer_top">
                    <div class="footer_top_left">
                        <h5>Join Our Newsletter</h5>
                        <p>Sign up for our monthly newsletter for the latest Vemlo Downs <br> news, ideas for creation.
                        </p>
                    </div>
                    <div class="footer_top_right">
                        <form>
                            <div class="form-group">
                                <input type="email" class="form-control" id="exampleInputEmail1"
                                       aria-describedby="emailHelp" placeholder="Enter Your Email Address...">
                            </div>
                            <button type="submit" class="primary_btn">Subscribe</button>
                        </form>
                    </div>
                </div>
                <div class="footer_center">
                    <div class="quick_links">
                        <h6>Quick Links</h6>
                        <ul>
                            <li><a href="javascript:void(0)">Home</a></li>
                            <li><a href="javascript:void(0)">About Us</a></li>
                            <li><a href="javascript:void(0)">Maids</a></li>
                            <li><a href="javascript:void(0)">Work Visa</a></li>
                            <li><a href="javascript:void(0)">Blog</a></li>
                            <li><a href="javascript:void(0)">Contact Us</a></li>
                        </ul>
                    </div>
                    <div class="services">
                        <h6>Our Services</h6>
                        <ul>
                            <li><a href="javascript:void(0)">Cook</a></li>
                            <li><a href="javascript:void(0)">Nannay / Baby Sitter</a></li>
                            <li><a href="javascript:void(0)">Driver</a></li>
                            <li><a href="javascript:void(0)">Tutor</a></li>
                            <li><a href="javascript:void(0)">Housemaid</a></li>
                            <li><a href="javascript:void(0)">Care Giver / Nurse</a></li>
                            <li><a href="404.php">Training Programs</a></li>
                        </ul>
                    </div>
                    <div class="contacts">
                        <h6>Contact Info</h6>
                        <ul>
                            <li>
                                <a href="javascript:void(0)">
                                    <svg width="18" height="18" viewBox="0 0 18 18" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M13.4993 17.3333C10.0971 17.3289 6.83544 15.9754 4.42968 13.5696C2.02392 11.1638 0.670426 7.90219 0.666016 4.49993C0.666016 3.48327 1.06988 2.50825 1.78877 1.78936C2.50766 1.07047 3.48269 0.666599 4.49935 0.666599C4.71463 0.664959 4.92956 0.684498 5.14102 0.724932C5.34544 0.755183 5.5464 0.805424 5.74102 0.874932C5.87789 0.922957 5.99986 1.00588 6.09486 1.11549C6.18986 1.22511 6.2546 1.35762 6.28268 1.49993L7.42435 6.49993C7.45512 6.63565 7.45142 6.77692 7.41357 6.91083C7.37572 7.04475 7.30494 7.16706 7.20768 7.2666C7.09935 7.38327 7.09101 7.3916 6.06601 7.92493C6.88684 9.72565 8.32701 11.1717 10.1243 11.9999C10.666 10.9666 10.6743 10.9583 10.791 10.8499C10.8906 10.7527 11.0129 10.6819 11.1468 10.644C11.2807 10.6062 11.422 10.6025 11.5577 10.6333L16.5577 11.7749C16.6954 11.8069 16.8228 11.8734 16.9278 11.9681C17.0327 12.0629 17.1118 12.1828 17.1577 12.3166C17.228 12.5144 17.281 12.7179 17.316 12.9249C17.3496 13.1344 17.3663 13.3462 17.366 13.5583C17.3506 14.5706 16.9354 15.5357 16.211 16.243C15.4866 16.9502 14.5117 17.3422 13.4993 17.3333Z"/>
                                    </svg>
                                    <p>(+971) 6787 8989</p>
                                </a>
                            </li>
                            <li>
                                <a href="javascript:void(0)">
                                    <svg width="18" height="15" viewBox="0 0 18 15" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M15.666 0.833496H2.33268C1.41602 0.833496 0.674349 1.5835 0.674349 2.50016L0.666016 12.5002C0.666016 13.4168 1.41602 14.1668 2.33268 14.1668H15.666C16.5827 14.1668 17.3327 13.4168 17.3327 12.5002V2.50016C17.3327 1.5835 16.5827 0.833496 15.666 0.833496ZM15.3327 4.37516L9.44102 8.0585C9.17435 8.22516 8.82435 8.22516 8.55768 8.0585L2.66602 4.37516C2.58246 4.32826 2.50928 4.26488 2.45092 4.18887C2.39256 4.11287 2.35023 4.02581 2.3265 3.93297C2.30276 3.84013 2.2981 3.74344 2.31281 3.64875C2.32752 3.55406 2.3613 3.46334 2.41208 3.38208C2.46287 3.30082 2.52962 3.23071 2.60829 3.17599C2.68696 3.12127 2.77591 3.08309 2.86976 3.06374C2.96362 3.0444 3.06042 3.0443 3.15431 3.06345C3.2482 3.0826 3.33724 3.12061 3.41602 3.17516L8.99935 6.66683L14.5827 3.17516C14.6615 3.12061 14.7505 3.0826 14.8444 3.06345C14.9383 3.0443 15.0351 3.0444 15.1289 3.06374C15.2228 3.08309 15.3117 3.12127 15.3904 3.17599C15.4691 3.23071 15.5358 3.30082 15.5866 3.38208C15.6374 3.46334 15.6712 3.55406 15.6859 3.64875C15.7006 3.74344 15.6959 3.84013 15.6722 3.93297C15.6485 4.02581 15.6061 4.11287 15.5478 4.18887C15.4894 4.26488 15.4162 4.32826 15.3327 4.37516Z"/>
                                    </svg>
                                    <p>service@target.com.au</p>
                                </a>
                            </li>
                            <li>
                                <a href="javascript:void(0)">
                                    <svg width="15" height="20" viewBox="0 0 15 20" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M6.57422 19.5C4.53516 16.9922 0 10.9141 0 7.5C0 3.35781 3.35781 0 7.5 0C11.6406 0 15 3.35781 15 7.5C15 10.9141 10.4297 16.9922 8.42578 19.5C7.94531 20.0977 7.05469 20.0977 6.57422 19.5ZM7.5 10C8.87891 10 10 8.87891 10 7.5C10 6.12109 8.87891 5 7.5 5C6.12109 5 5 6.12109 5 7.5C5 8.87891 6.12109 10 7.5 10Z"/>
                                    </svg>
                                    <p>32 Eastbrook Terrace 6004 Perth - East Perth Western Australia</p>
                                </a>
                            </li>
                        </ul>
                        <div class="social_media_icons">
                            <ul>
                                <li>
                                    <a href="javascript:void(0)">
                                        <i class="fa-brands fa-facebook"></i>
                                    </a>
                                </li>
                                <li>
                                    <a href="javascript:void(0)">
                                        <i class="fa-brands fa-twitter"></i>
                                    </a>
                                </li>
                                <li>
                                    <a href="javascript:void(0)">
                                        <i class="fa-brands fa-youtube"></i>
                                    </a>
                                </li>
                                <li>
                                    <a href="javascript:void(0)">
                                        <i class="fa-brands fa-pinterest"></i>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="footer_bottom">
                    <div class="footer_bottom_left">
                        <p>© Copyright 2022. Target. All Rights Reserved</p>
                    </div>
                    <div class="footer_bottom_right">
                        <ul>
                            <li>
                                <a href="javascript:void(0)">
                                    Privacy Policy
                                </a>
                            </li>
                            <li>
                                <p>
                                    |
                                </p>
                            </li>
                            <li>
                                <a href="javascript:void(0)">
                                    Terms & Conditions
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</footer>


<script src="<?php echo e(asset('web/js/jquery-3.4.1.min.js')); ?>"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.0/jquery-ui.min.js"></script>
<script src="<?php echo e(asset('web/vendor/bootstrap/js/bootstrap.min.js')); ?>"></script>
<!--    <script src="<?php echo e(asset('web/vendor/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>-->
<script src="<?php echo e(asset('web/vendor/slick/slick.min.js')); ?>"></script>
<script src="<?php echo e(asset('web/vendor/select2/js/select2.full.min.js')); ?>"></script>
<script src="<?php echo e(asset('web/js/jquery.fancybox.min.js')); ?>"></script>
<script src="<?php echo e(asset('web/js/packery.pkgd.min.js')); ?>"></script>
<script src="<?php echo e(asset('web/js/jquery.star-rating-svg.js')); ?>"></script>
<script src="<?php echo e(asset('web/vendor/xzoom/js/xzoom.min.js')); ?>"></script>
<script src="<?php echo e(asset('web/vendor/xzoom/js/setup.js')); ?>"></script>
<!-- SweetAlert2 -->
<script src="<?php echo e(asset('app/plugins/sweetalert2/sweetalert2.min.js')); ?>"></script>
<script src="<?php echo e(asset('web/js/scripts.js')); ?>"></script>
<script src="<?php echo e(asset('web/js/custom.js')); ?>"></script>

</body>
</html>
<?php /**PATH /mnt/7871a22a-b945-4422-8f26-e0a587b878b6/Works/0000Pentacodes/tadbeer/resources/views/web/layouts/main.blade.php ENDPATH**/ ?>