<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1><i class="nav-icon fas fa-user-shield"></i> <?php echo e($adminData->role); ?> - Profile</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item">
                                <a href="<?php echo e(url(sitePrefix().'/dashboard')); ?>">Home</a>
                            </li>
                            <?php if(isset($title)): ?>
                                <li class="breadcrumb-item">
                                    <a href="<?php echo e(url(sitePrefix().'/administration')); ?>">Admin list</a>
                                </li>
                            <?php endif; ?>
                            <li class="breadcrumb-item active"><?php echo e($adminData->role); ?> - Profile</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        <section class="content">
            <div class="container-fluid">
                <?php if(session('success')): ?>
                    <div class="alert alert-success" user_type="alert">
                        <button type="button" class="close" data-dismiss="alert">×</button>
                        <?php echo e(session('success')); ?>

                    </div>
                <?php elseif(session('error')): ?>
                    <div class="alert alert-danger" user_type="alert">
                        <button type="button" class="close" data-dismiss="alert">×</button>
                        <?php echo e(session('error')); ?>

                    </div>
                <?php endif; ?>
                <form role="form" id="formWizard" class="form--wizard" enctype="multipart/form-data" method="post">
                    <?php echo e(csrf_field()); ?>

                    <div class="card card-info">
                        <div class="card-header">
                            <h3 class="card-title">Basic Information</h3>
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label for="name">Name*</label>
                                    <input type="text" class="form-control required" name="name" placeholder="Name"
                                           id="name" value="<?php echo e(old('name', @$adminData->name)); ?>">
                                    <div class="help-block with-errors" id="name_error"></div>
                                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback">
                                        <?php echo e($message); ?>

                                    </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="login_email_id">Email*</label>
                                    <input type="email" name="email_id" id="login_email_id" placeholder="Email ID"
                                           class="form-control required" autocomplete="off"
                                           value="<?php echo e(old('email_id', @$adminData->email)); ?>">
                                    <div class="help-block with-errors" id="login_email_id_error"></div>
                                    <?php $__errorArgs = ['email_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback">
                                        <?php echo e($message); ?>

                                    </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label for="phone_number">Phone Number</label>
                                    <input type="number" class="form-control required" id="phone_number"
                                           name="phone_number" placeholder="Phone Number"
                                           value="<?php echo e(old('phone_number', @$adminData->phone_number)); ?>">
                                    <div class="help-block with-errors" id="phone_number_error"></div>
                                    <?php $__errorArgs = ['phone_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback">
                                        <?php echo e($message); ?>

                                    </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="image_meta_tag"> Profile Image Attribute</label>
                                    <input type="text" name="image_meta_tag" id="image_meta_tag"
                                           placeholder="Alt='Image Attribute'" class="form-control placeholder-cls" autocomplete="off"
                                           value="<?php echo e(old('image_meta_tag',@$adminData->image_meta_tag)); ?>">
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label for="profile_image">Profile Image</label>
                                    <div class="file-loading">
                                        <input id="profile_image" name="profile_image" type="file" accept="image/*">
                                    </div>
                                    <span class="caption_note">Note: Image size must be 300X300</span>
                                    <?php $__errorArgs = ['profile_image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback">
                                        <?php echo e($message); ?>

                                    </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                            </div>
                        </div>
                    </div>
                    <div class="card card-success">
                        <div class="card-header">
                            <h3 class="card-title">Authentication Credentials</h3>
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label for="username">Username*</label>
                                    <input type="email" class="form-control required" id="username" name="username"
                                           placeholder="Username" readonly
                                           value="<?php echo e(old('username', @$adminData->username)); ?>">
                                    <div class="help-block with-errors" id="username_error"></div>
                                    <?php $__errorArgs = ['username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback">
                                        <?php echo e($message); ?>

                                    </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <input type="submit" name="btn_save" value="Submit"
                                   class="btn btn-primary pull-left submitBtn">
                            <button type="reset" class="btn btn-default">Cancel</button>
                            <img class="animation__shake loadingImg" src="<?php echo e(url('backend/dist/img/loading.gif')); ?>"
                                 style="display:none;">
                        </div>
                    </div>
                </form>
            </div>
        </section>
    </div>
    <script type="text/javascript">
        $(document).ready(function () {
            $("#profile_image").fileinput({
                'theme': 'explorer-fas',
                validateInitialCount: true,
                overwriteInitial: false,
                autoReplace: true,
                initialPreviewShowDelete: false,
                layoutTemplates: {actionDelete: ''},
                removeLabel: "Remove",
                initialPreviewAsData: true,
                dropZoneEnabled: false,
                allowedFileTypes: ['image'],
                required: false,
                minImageWidth: 300,
                minImageHeight: 300,
                maxImageWidth: 300,
                maxImageHeight: 300,
                maxFileSize: 512,
                showRemove: false,
                <?php if(isset($adminData) && $adminData->profile_image!=NULL): ?>
                initialPreview: ["<?php echo e(asset($adminData->profile_image)); ?>",],
                initialPreviewConfig: [{
                    caption: "<?php echo e(last(explode('/',$adminData->profile_image))); ?>",
                    width: "120px",
                    key: "<?php echo e(($adminData->profile_image!=NULL)?'1':'0'); ?>"
                }]
                <?php endif; ?>
            });

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('app.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/yrnfurqqiphb/public_html/demo/resources/views/app/admin/profile.blade.php ENDPATH**/ ?>