<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1><i class="nav-icon fas fa-user-shield"></i> <?php echo e($title); ?> </h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="<?php echo e(url(sitePrefix().'dashboard')); ?>">Home</a></li>
                            <li class="breadcrumb-item"><a href="<?php echo e(url(sitePrefix().'home/slider')); ?>">Slider List</a>
                            </li>
                            <li class="breadcrumb-item active"><?php echo e($title); ?> Slider</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        <section class="content">
            <div class="container-fluid">
                <form role="form" id="formWizard" class="form--wizard" enctype="multipart/form-data" method="post">
                    <?php echo e(csrf_field()); ?>

                    <div class="card card-info">
                        <div class="card-header">
                            <h3 class="card-title">Basic Informations</h3>
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <?php if(session('success')): ?>
                                <div class="alert alert-success" user_type="alert">
                                    <button type="button" class="close" data-dismiss="alert">×</button>
                                    <?php echo e(session('success')); ?>

                                </div>
                            <?php elseif(session('error')): ?>
                                <div class="alert alert-danger" user_type="alert">
                                    <button type="button" class="close" data-dismiss="alert">×</button>
                                    <?php echo e(session('error')); ?>

                                </div>
                            <?php endif; ?>



                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label for="inputEmail4">Title (English)*</label>
                                        <textarea class="form-control tinyeditor required" id="title_en" name="title_en"><?php echo e(old('title',isset($slider)?$slider->title_en:'')); ?></textarea>
                                        <div class="help-block with-errors" id="title_en_error"></div>
                                        <?php $__errorArgs = ['title_en'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label for="inputEmail4">Title (Arabic)*</label>
                                        <textarea class="form-control tinyeditor required" id="title_ar" name="title_ar"><?php echo e(old('title',isset($slider)?$slider->title_ar:'')); ?></textarea>
                                        <div class="help-block with-errors" id="title_ar_error"></div>
                                        <?php $__errorArgs = ['title_ar'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label for="title">Description (English)*</label>
                                    <input type="text" name="description_en" id="description_en"
                                           placeholder="Description English" class="form-control required"
                                           autocomplete="off"
                                           value="<?php echo e(old('description_en',isset($slider)?$slider->description_en:'')); ?>"
                                           maxlength="255">
                                    <div class="help-block with-errors" id="description_en_error"></div>
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="title">Description (Arabic)*</label>
                                    <input type="text" name="description_ar" id="description_ar"
                                           placeholder="Description Arabic"
                                           class="form-control required" autocomplete="off"
                                           value="<?php echo e(old('description_ar',isset($slider)?$slider->description_ar:'')); ?>"
                                           maxlength="255">
                                    <div class="help-block with-errors" id="description_ar_error"></div>
                                </div>
                            </div>

                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label>Image*</label>
                                    <div class="file-loading">
                                        <input id="image" name="image" type="file" accept="image/*">
                                    </div>
                                    <span class="caption_note">Note: Image dimension must be 1920 x 1000 PX and Size must be less than 512 KB</span>
                                    <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="image_meta_tag">Image Meta Tag*</label>
                                    <input type="text" name="image_meta_tag" id="image_meta_tag"
                                           placeholder="Image Alternate Text"
                                           class="form-control required placeholder-cls" required autocomplete="off"
                                           value="<?php echo e(isset($slider)?$slider->image_meta_tag:''); ?>" maxlength="255">
                                    <div class="help-block with-errors" id="image_meta_tag_error"></div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label>Button Text (English)* </label>
                                    <input type="text" class="form-control required" id="button_txt_en"
                                           name="button_txt_en" placeholder="Button Text in English"
                                           value="<?php echo e(isset($slider)?$slider->button_txt_en:''); ?>" maxlength="255">
                                    <div class="help-block with-errors" id="button_txt_en_error"></div>

                                </div>
                                <div class="form-group col-md-6">
                                    <label>Button Text (Arabic)* </label>
                                    <input type="text" class="form-control required" id="button_txt_ar"
                                           name="button_txt_ar" placeholder="Button Text in Arabic"
                                           value="<?php echo e(isset($slider)?$slider->button_txt_ar:''); ?>" maxlength="255">
                                    <div class="help-block with-errors" id="button_txt_ar_error"></div>
                                </div>
                            </div>

                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label> Button URL*</label>
                                    <input type="text" class="form-control required" id="button_url" name="button_url"
                                           placeholder="URL" value="<?php echo e(isset($slider)?$slider->button_url:''); ?>"
                                           maxlength="255">
                                    <div class="help-block with-errors" id="button_url_error"></div>
                                </div>
                                <div class="form-group col-md-6">
                                    <label> Show Enquiry*</label>
                                    <select class="form-control required" name="show_enquiry" id="show_enquiry">
                                        <option value="Yes" <?php echo e((@$slider->show_enquiry=='Yes')?'selected':''); ?>>Yes
                                        </option>
                                        <option value="No" <?php echo e((@$slider->show_enquiry=='No')?'selected':''); ?>>No
                                        </option>
                                    </select>
                                    <div class="help-block with-errors" id="show_enquiry_error"></div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <input type="submit" class="btn btn-success form_submit_btn submitBtn"
                                           value="Submit">
                                    <input type="reset" class="btn btn-default" value="Reset">
                                    <img class="animation__shake loadingImg" src="<?php echo e(url('app/dist/img/loading.gif')); ?>"
                                         style="display:none;">
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </section>
    </div>
    <script type="text/javascript">
        $(document).ready(function () {
            $("#image").fileinput({
                'theme': 'explorer-fas',
                validateInitialCount: true,
                overwriteInitial: false,
                autoReplace: true,
                layoutTemplates: {actionDelete: ''},
                removeLabel: "Remove",
                initialPreviewAsData: true,
                dropZoneEnabled: false,
                required: true,
                showRemove: false,
                allowedFileTypes: ['image'],
                minImageWidth: 1920,
                minImageHeight: 1000,
                maxImageWidth: 1920,
                maxImageHeight: 1000,
                maxFileSize: 512,
                <?php if(isset($slider) && $slider->image!=NULL): ?>
                initialPreview: ["<?php echo e(asset($slider->image)); ?>",],
                initialPreviewConfig: [{
                    caption: "<?php echo e(last(explode('/',$slider->image))); ?>",
                    width: "120px",
                    key: "<?php echo e(($slider->image)); ?>",
                }]
                <?php endif; ?>
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('app.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp1\htdocs\mgt\resources\views/app/home/slider/slider_form.blade.php ENDPATH**/ ?>