<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1><i class="nav-icon fas fa-user-shield"></i> Manage <?php echo e(ucfirst($type)); ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="<?php echo e(url(sitePrefix().'dashboard')); ?>">Home</a></li>
                            <li class="breadcrumb-item active"><?php echo e(ucfirst($type)); ?> List</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <?php if(session('success')): ?>
                            <div class="alert alert-success" role="alert">
                                <button type="button" class="close" data-dismiss="alert">×</button>
                                <?php echo e(session('success')); ?>

                            </div>
                        <?php elseif(session('error')): ?>
                            <div class="alert alert-danger" role="alert">
                                <button type="button" class="close" data-dismiss="alert">×</button>
                                <?php echo e(session('error')); ?>

                            </div>
                        <?php endif; ?>
                        <div class="card card-success card-outline">
                            <div class="card-header">
                                <a href="<?php echo e(url(sitePrefix().'skill-set/create')); ?>"
                                   class="btn btn-success pull-right">Add <?php echo e(ucfirst($type)); ?>

                                    <i class="fa fa-plus-circle pull-right mt-1 ml-2"></i>
                                </a>
                            </div>
                            <div class="card-body">
                                <table class="table table-bordered table-hover dataTable" width="100%">
                                    <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Title</th>
                                        <th>Status</th>
                                        <th>Created Date</th>
                                        <th class="not-sortable">Actions</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $i=1?><?php $__currentLoopData = $skillSetList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $skillSet): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                        <tr>
                                            <td><?php echo e($i); ?></td>
                                            <td><?php echo $skillSet->title_en; ?></td>
                                            <td>
                                                <label class="switch">
                                                    <input id="switch-state" type="checkbox" class="status_check"
                                                           data-size="mini" data-url="/status-change"
                                                           data-table="SkillSet" data-field="status"
                                                           data-pk="<?php echo e($skillSet->id); ?>"
                                                        <?php echo e(($skillSet->status=="Active")?'checked':''); ?>>
                                                    <span class="slider"></span>
                                                </label>
                                            </td>
                                            <td><?php echo e(date("d-M-Y", strtotime($skillSet->created_at))); ?></td>
                                            <td class="text-right py-0 align-middle">
                                                <div class="btn-group btn-group-sm">
                                                    <a href="<?php echo e(url(sitePrefix().'skill-set/edit/'.$skillSet->id)); ?>"
                                                       class="btn btn-success mr-2 tooltips" title="Edit Skill Set"><i
                                                            class="fas fa-edit"></i></a>
                                                    <a href="#" class="btn btn-danger mr-2 delete_entry tooltips"
                                                       data-url="skill-set/delete" data-id="<?php echo e($skillSet->id); ?>"
                                                       title="Delete Skill Set"><i class="fas fa-trash"></i></a>
                                                </div>
                                            </td>
                                        </tr>
                                        <?php $i++?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('app.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp1\htdocs\mgt\resources\views/app/skill_set/list.blade.php ENDPATH**/ ?>