<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <link rel="icon" type="image/x-icon" href="<?php echo e(asset('app/dist/img/logo.svg')); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo e(config('app.name')); ?> | Reset Password</title>
    <link rel="stylesheet" href="<?php echo e(asset('app/dist/css/sweetalert.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('app/dist/css/sweetalert-overrides.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(url('app/dist/css/login.css?v=1.0')); ?>">
    <script type="text/javascript">
        var base_url = "<?php echo e(url('/')); ?>";
        var token = "<?php echo e(csrf_token()); ?>";
    </script>
</head>
<body>
    <div class="main">
        <input type="checkbox" id="chk" aria-hidden="true">
        <div class=" alignText">
            <img class="animation__shake logo" src="<?php echo e(asset('app/dist/img/logo.png')); ?>" alt="<?php echo e(config('app.name')); ?>">
        </div>
        <div class="signup login-show">
            <form method="post">
                <?php echo csrf_field(); ?>
                <label for="chk" aria-hidden="true">Reset-Password</label>
                <?php if($errors->any()): ?>
                    <?php $__errorArgs = ['username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span class="invalid-feedback" role="alert"><strong><?php echo e($message); ?></strong></span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                <?php endif; ?>
                <input type="text" name="c_password" class="<?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="c_password" placeholder="Password">
                <input type="hidden" name="token" id="token" value="<?php echo e($user->token); ?>">
                <input type="hidden" name="id" id="id" value="<?php echo e($user->id); ?>">
                <input type="password" name="confirm_password" class="<?php $__errorArgs = ['confirm_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="confirm_password" placeholder="Confirm Password">
                <input type="submit" value="Reset Password" class="login-btn" id="password_reset">
            </form>
        </div>
    </div>
    <script src="//cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
    <script src="<?php echo e(asset('app/dist/js/sweetalert.min.js')); ?>"></script>
    <script src="<?php echo e(asset('app/dist/js/sweetalert-init.js')); ?>"></script>
    <script src="<?php echo e(url('app/dist/js/custom.js?v=1.0')); ?>"></script>
</body>
</html>
<?php /**PATH /home1/virtual2050/public_html/target/resources/views/app/auth/reset_password.blade.php ENDPATH**/ ?>