
<?php $__env->startSection('content'); ?>
<div class="content-wrapper">
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1><i class="nav-icon fas fa-user-shield"></i> Manage Administration</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="<?php echo e(url(sitePrefix().'dashboard')); ?>">Home</a></li>
              <li class="breadcrumb-item active">Administration</li>
            </ol>
          </div>
        </div>
      </div>
    </section>

    <section class="content">
      	<div class="container-fluid">
        	<div class="row">
          		<div class="col-12">
          			<?php if(session('success')): ?>
		              <div class="alert alert-success" role="alert">
		                <button type="button" class="close" data-dismiss="alert">×</button>
		                <?php echo e(session('success')); ?>

		              </div>
		            <?php elseif(session('error')): ?>
		              <div class="alert alert-danger" role="alert">
		                <button type="button" class="close" data-dismiss="alert">×</button>
		                <?php echo e(session('error')); ?>

		              </div>
		            <?php endif; ?>
          			<div class="card card-success card-outline">
		              	<div class="card-header">
		                	<a href="<?php echo e(url(sitePrefix().'administration/create')); ?>" class="btn btn-success pull-right">Add Admin <i class="fa fa-plus-circle pull-right mt-1 ml-2"></i></a>
		              	</div>
              			<div class="card-body">
                			<table class="dataTable table table-bordered table-striped">
                  				<thead>
				                    <tr>
				                        <th>#</th>
				                        <th>Name</th>
				                        <th>Email</th>
				                        <th>Username</th>
				                        <th>Phone Number</th>
				                        <th>Status</th>
				                        <th>Created Date</th>
				                        <th class="not-sortable">Actions</th>
				                    </tr>
				                	</thead>
				                	<tbody>
				                   <?php $i=1 ?> <?php $__currentLoopData = $adminList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
				                        <tr>
				                            <td><?php echo e($i); ?></td>
				                            <td><?php echo e($user->name); ?></td>
				                            <td><?php echo e($user->email); ?></td>
				                            <td><?php echo e($user->username); ?></td>
				                            <td><?php echo e($user->phone_number); ?></td>

                                            <td>
                                                <label class="switch">
                                                    <input id="switch-state" type="checkbox" class="status_check"
                                                           data-size="mini" data-url="/status-change"
                                                           data-table="Admin" data-field="status"
                                                           data-pk="<?php echo e($user->id); ?>"
                                                        <?php echo e(($user->status=="Active")?'checked':''); ?>>
                                                    <span class="slider"></span>
                                                </label>
                                            </td>
                                            <td><?php echo e(date("d-M-Y", strtotime($user->created_at))); ?></td>
				                            <td class="text-right py-0 align-middle">
								                      <div class="btn-group btn-group-sm">
								                        <a href="<?php echo e(url(sitePrefix().'administration/edit/'.$user->id)); ?>" class="btn btn-success mr-2 tooltips" title="Edit <?php echo e($user->role); ?>"><i class="fas fa-edit"></i></a>
								                        <?php if($user->id!=1): ?>
								                        	<a href="#" class="btn btn-danger mr-2 delete_entry tooltips" data-url="administration/delete" data-id="<?php echo e($user->id); ?>" title="Delete <?php echo e($user->role); ?>"><i class="fas fa-trash"></i></a>
								                        <?php endif; ?>
								                        <!-- <a href="<?php echo e(url(sitePrefix().'reset-password/'.$user->id)); ?>" class="btn btn-primary mr-2 tooltips" title="Reset Password <?php echo e($user->role); ?>"><i class="fas fa-unlock"></i></a> -->
								                      </div>
								                    </td>
				                        </tr>
				                    <?php $i++;?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				                	</tbody>
                			</table>
              			</div>
            		</div>
          		</div>
          	</div>
        </div>
    </section>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('app.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home1/virtual2050/public_html/target/resources/views/app/admin/admin_list.blade.php ENDPATH**/ ?>