<?php $__env->startSection('content'); ?>

    <!--inner banners -->
    <section class="inner_banner">
        <div class="background_img">
            <?php echo printImage($blog,'banner_image','banner_webp_image','banner_attribute'); ?>

        </div>
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="caption">
                        <h1><?php echo e(langString($blog,'banner_title')); ?></h1>
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>"><?php echo e(staticLangString($websiteLanguages,'menu.home')); ?></a></li>
                                <li class="breadcrumb-item active"><a href="<?php echo e(url('blogs')); ?>">Blog</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Blog Details</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--inner banners -->


    <!--Blog Details section Start-->

    <section class="blog_destails_section">
        <div class="container">
            <div class="row align-items-start">
                <div class="col-lg-8 pe-lg-5">
                    <div class="blog_details_left">
                        <div class="All_main_Headings">
                            <h6 class="sub_heading"><?php echo e(langString($blog,'sub_title')); ?></h6>
                            <h3 class="main_heading"><?php echo e(langString($blog,'title')); ?></h3>
                        </div>
                        <h6><?php echo e(date('d.m.Y',strtotime($blog->posted_date))); ?>

                            <span><?php echo e(langString($blog,'written_by')); ?></span></h6>
                        <?php echo langString($blog,'list_description'); ?>


                        <?php echo printImage($blog,'image','webp_image','image_meta_tag','img-fluid'); ?>


                        <?php echo langString($blog,'description'); ?>


                        <div class="video-area aos-init aos-animate" data-aos="fade-up">
                            <a href="https://youtu.be/JsnzZF0_13I" data-fancybox="group">
                                <?php echo printImage($blog,'video_thumbnail_image','video_thumbnail_webp_image','video_meta_tag','img-fluid'); ?>

                                <?php if($blog->video_url): ?>
                                    <button type="button" class="video-btn"><img
                                            src="<?php echo e(asset('web/images/svg/play.svg')); ?>" alt=""></button>
                                <?php endif; ?>
                            </a>
                        </div>
                        <?php echo langString($blog,'alternate_description'); ?>


                        <div class="share_navigation">
                            <div class="share">
                                <a href="<?php echo e('https://www.facebook.com/sharer/sharer.php?u='.Request::fullUrl()); ?>" target="_blank"><i class="fa-brands fa-facebook"></i></a>
                                <a href="<?php echo e('https://www.linkedin.com/shareArticle?mini=true&url='.Request::fullUrl()); ?>" target="_blank"><i class="fa-brands fa-linkedin"></i></a>
                                <a href="<?php echo e('https://twitter.com/intent/tweet/?url='.Request::fullUrl()); ?>" target="_blank"><i class="fa-brands fa-twitter"></i></a>
                                <a href="<?php echo e('https://wa.me/?text='.Request::fullUrl()); ?>" target="_blank"><i class="fa-brands fa-whatsapp"></i></a>
                            </div>
                            <div class="navigation">
                                <?php if($previousItem): ?>
                                    <a href="<?php echo e(url('blog/'.$previousItem->short_url)); ?>" class="primary_btn"><?php echo e(staticLangString($websiteLanguages,'title.previous')); ?></a>
                                <?php endif; ?>
                                <?php if($nextItem): ?>
                                    <a href="<?php echo e(url('blog/'.$nextItem->short_url)); ?>" class="secondary_btn"><?php echo e(staticLangString($websiteLanguages,'title.next')); ?></a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>

                <?php if($recentBlogs->isNotEmpty()): ?>
                <div class="col-lg-4 sticky-lg-top sticky-lg-top-110">
                    <div class="blog_list_wrapper">
                        <h4><?php echo e(staticLangString($websiteLanguages,'title.recent_blog')); ?></h4>
                        <ul>

                            <?php $__currentLoopData = $recentBlogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $recent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>

                                <?php echo printImage($recent,'image','webp_image','image_meta_tag','img-fluid'); ?>


                                <h4>
                                    <?php echo e(langString($recent,'title')); ?>

                                </h4>
                                <h6><?php echo e(date('d.m.Y',strtotime($recent->posted_date))); ?><span><?php echo e(langString($recent,'written_by')); ?></span></h6>
                                <a href="<?php echo e(url('blog/'.$recent->short_url)); ?>">Read More</a>
                            </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </ul>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </section>

    <!--Blog Details section End-->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('web.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/yrnfurqqiphb/public_html/resources/views/web/blog-details.blade.php ENDPATH**/ ?>