<?php $__env->startSection('content'); ?>
<div class="content-wrapper">
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1><i class="nav-icon fas fa-user-shield"></i> <?php echo e($title); ?></h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(url(sitePrefix().'dashboard')); ?>">Home</a></li>
                        <li class="breadcrumb-item active">Key Feature</li>
                    </ol>
                </div>
            </div>
        </div>
    </section>

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <?php if(session('success')): ?>
                      <div class="alert alert-success" role="alert">
                        <button type="button" class="close" data-dismiss="alert">×</button>
                        <?php echo e(session('success')); ?>

                      </div>
                    <?php elseif(session('error')): ?>
                      <div class="alert alert-danger" role="alert">
                        <button type="button" class="close" data-dismiss="alert">×</button>
                        <?php echo e(session('error')); ?>

                      </div>
                    <?php endif; ?>
                    <div class="card card-success card-outline">
                        <div class="card-header">
                            <a href="<?php echo e(url(sitePrefix().'home/key-feature/create')); ?>" class="btn btn-success pull-right">Add Key Feature <i class="fa fa-plus-circle pull-right mt-1 ml-2"></i></a>
                        </div>
                        <div class="card-body">
                            <table class="dataTable table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Title</th>
                                        <th>Sort Order</th>
                                        <th>Status</th>
                                        <th>Created Date</th>
                                        <th class="not-sortable">Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $keyfeatureList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($loop->iteration); ?></td>
                                        <td><?php echo $feature->title_en; ?></td>
                                        <td>
                                            <input type="text" name="sort_order" id="sort_order_<?php echo e($loop->iteration); ?>" data-extra="id"
                                                   data-extra_key="<?php echo e($feature->id); ?>" data-table="KeyFeature"
                                                   data-id="<?php echo e($feature->id); ?>" class="common_sort_order" style="width:25%"
                                                   value="<?php echo e($feature->sort_order); ?>">
                                        </td>
                                        <td>
                                            <label class="switch">
                                                <input id="switch-state" type="checkbox" class="status_check"
                                                       data-size="mini" data-url="/status-change"
                                                       data-table="KeyFeature"
                                                       data-field="status" data-pk="<?php echo e($feature->id); ?>"
                                                    <?php echo e(($feature->status=="Active")?'checked':''); ?>>
                                                <span class="slider"></span>
                                            </label>
                                        </td>

                                        <td><?php echo e(date("d-M-Y", strtotime($feature->created_at))); ?></td>
                                        <td class="text-right py-0 align-middle">
                                            <div class="btn-group btn-group-sm">
                                                <a href="<?php echo e(url(sitePrefix().'home/key-feature/edit/'.$feature->id)); ?>" class="btn btn-success mr-2 tooltips" title="Edit Key Feature"><i class="fas fa-edit"></i></a>
                                                <a href="#" class="btn btn-danger mr-2 delete_entry tooltips" title="Delete Key Feature" data-url="home/key-feature/delete" data-id="<?php echo e($feature->id); ?>"><i class="fas fa-trash"></i></a>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('app.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/itworlde/public_html/resources/views/app/home/keyfeature/list.blade.php ENDPATH**/ ?>