<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1><i class="nav-icon fas fa-user-shield"></i> <?php echo e($title); ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="<?php echo e(url(sitePrefix().'dashboard')); ?>">Home</a></li>
                            <li class="breadcrumb-item active"><?php echo e($title); ?></li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        <section class="content">
            <div class="container-fluid">
                <?php if(session('success')): ?>
                    <div class="alert alert-success" role="alert">
                        <button type="button" class="close" data-dismiss="alert">×</button>
                        <?php echo e(session('success')); ?>

                    </div>
                <?php elseif(session('error')): ?>
                    <div class="alert alert-danger" role="alert">
                        <button type="button" class="close" data-dismiss="alert">×</button>
                        <?php echo e(session('error')); ?>

                    </div>
                <?php endif; ?>
                <form role="form" id="formWizard" class="form--wizard" enctype="multipart/form-data" method="post">
                    <?php echo e(csrf_field()); ?>

                    <div class="card card-info">
                        <div class="card-header">
                            <h3 class="card-title"><?php echo e($key); ?> Banner - <?php echo e(ucfirst($type)); ?></h3>
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label> Banner Title(English)*</label>
                                    <input type="text" name="banner_title_en" id="banner_title_en"
                                           placeholder="Banner Title English"
                                           class="form-control required" autocomplete="off"
                                           value="<?php echo e(isset($banner)?$banner->banner_title_en:''); ?>">
                                    <div class="help-block with-errors" id="banner_title_en_error"></div>
                                    <?php $__errorArgs = ['banner_title_en'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="form-group col-md-6">
                                    <label> Banner Title (Arabic)*</label>
                                    <input type="text" name="banner_title_ar" id="banner_title_ar"
                                           placeholder="Banner Title Arabic"
                                           class="form-control required" autocomplete="off"
                                           value="<?php echo e(isset($banner)?$banner->banner_title_ar:''); ?>">
                                    <div class="help-block with-errors" id="banner_title_ar_error"></div>
                                    <?php $__errorArgs = ['banner_title_ar'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label>Banner Image*</label>
                                    <div class="file-loading">
                                        <input id="image" name="image" type="file" accept="image/*">
                                    </div>
                                    <span class="caption_note">Note: Image dimension must be 1920 x 500 PX and Size must be less than 512 KB</span>
                                    <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="form-group col-md-6">
                                    <label> Banner Attribute</label>
                                    <input type="text" class="form-control placeholder-cls" id="banner_attribute"
                                           name="banner_attribute" placeholder="Alt='Banner Attribute'"
                                           value="<?php echo e(isset($banner)?$banner->banner_attribute:''); ?>">
                                    <?php $__errorArgs = ['banner_attribute'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                            </div>
                        </div>
                        <div class="card-footer">
                            <input type="hidden" name="id" id="id" value="<?php echo e(isset($banner)?$banner->id:'0'); ?>">
                            <input type="hidden" name="type" id="type" value="<?php echo e($type); ?>">
                            <input type="submit" name="btn_save" value="Submit"
                                   class="btn btn-primary pull-left submitBtn">
                            <img class="animation__shake loadingImg" src="<?php echo e(url('app/dist/img/loading.gif')); ?>"
                                 style="display:none;">
                        </div>
                    </div>
                </form>
            </div>
        </section>
    </div>
    <script type="text/javascript">
        $(document).ready(function () {
            $("#image").fileinput({
                'theme': 'explorer-fas',
                validateInitialCount: true,
                overwriteInitial: false,
                autoReplace: true,
                layoutTemplates: {actionDelete: ''},
                removeLabel: "Remove",
                initialPreviewAsData: true,
                dropZoneEnabled: false,
                required: true,
                showRemove: false,
                minImageWidth: 1920,
                minImageHeight: 500,
                maxImageWidth: 1920,
                maxImageHeight: 500,
                maxFileSize: 512,
                    <?php if (isset($banner) && $banner->image != NULL){ ?>
                initialPreview: ["<?php echo e(asset($banner->image)); ?>"],
                initialPreviewConfig: [{
                    caption: "<?php echo e(last(explode('/',$banner->image))); ?>",
                    width: "120px",
                    key: "<?php echo e(($banner->image)); ?>",
                }]
                <?php } ?>
            });

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('app.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/yrnfurqqiphb/public_html/resources/views/app/banner/banner_form.blade.php ENDPATH**/ ?>