<!doctype html>
<html lang="{{ defaultLanguage() }}">
<head>

    <meta charset="UTF-8">
    <meta name="viewport"content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="title" content="{!! isset($meta_data)?$meta_data->meta_title:'' !!}">
    <meta name="csrf-token" content="{{ csrf_token() }}"/>
    <title>{{ langString($siteInformation,'brand_name') }}
        - {!! isset($meta_data)?$meta_data->meta_title:'' !!}</title>
    {!! isset($meta_data)?$meta_data->other_meta_tag:'' !!}
    {!! isset($siteInformation)?$siteInformation->header_tag:'' !!}

	<link rel="icon" type="image/x-icon" href="{{ asset('public/web/images/logo.png') }}">
	<meta name="author" content="Uzair Mehbub">
    <link rel="icon" type="image/x-icon" href="{{ asset($siteInformation->logo) ?? asset('html/assets/images/logo.png') }}">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.4.1/jquery.fancybox.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick-theme.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">
    <link rel="stylesheet" href="{{ asset('web/css/star-rating-svg.css') }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css">
    <link rel="stylesheet"href="https://cdnjs.cloudflare.com/ajax/libs/select2-bootstrap-theme/0.1.0-beta.10/select2-bootstrap.min.css">
    <link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/xzoom/1.0.15/xzoom.css">
    <link rel="stylesheet"href="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/10.15.6/sweetalert2.min.css">
    <link rel="stylesheet" href="{{ asset('web/css/style.css') }}">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
	<script type="text/javascript">
    var base_url = "{{ url('/') }}";
    var logo = base_url + "/public/web/images/logo.png";
    var tadbeer_logo = base_url + "/public/web/images/logo.png"; // or another file if you have a separate tadbeer logo
    var waitText = "{!! staticLangString($websiteLanguages,'title.wait_text') !!}";
    var servicePlaceholder = "{!! staticLangString($websiteLanguages,'placeholder.service') !!}";
</script> 
<body>


{!! $siteInformation->body_tag??'' !!}
<!--<div id="loading">
    <img id="loading-image" src="{{ asset('web/images/loading.webp') }}" alt="Loading..."/>
</div> -->
<section class="top_header">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="top_header_contents">
<div class="Top_contents_left">
    <img src="{{ asset('public/web/images/logo.png') }}" alt="Company Logo">
</div>

                    <div class="Top_contents_right">
                        <ul>
                            @if(langString($siteInformation,'footer_location'))
                                <li>
                                    <a href="{{url('contact-us')}}">
                                        <img src="{{ asset('web/images/top-header/location.png') }}" alt="">
                                        <div class="connect_us">
                                            <h6>{{ staticLangString($websiteLanguages,'title.our_location') }}</h6>
                                            <p>{!!  langString($siteInformation,'footer_location') !!}</p>
                                        </div>
                                    </a>
                                </li>
                            @endif

                            @if($siteInformation->email)
                                <li>
                                    <a href="mailto:{{@$siteInformation->email}}">
                                        <img src="{{ asset('web/images/top-header/email.png') }}" alt="">
                                        <div class="connect_us">
                                            <h6>{{ staticLangString($websiteLanguages,'title.email_us') }}</h6>
                                            <p>{{$siteInformation->email}}</p>
                                        </div>
                                    </a>
                                </li>
                            @endif
                            @if($siteInformation->phone)
                                <li>
                                    <a href="tel:{{@$siteInformation->phone}}">
                                        <img src="{{ asset('web/images/top-header/phone.png') }}" alt="">
                                        <div class="connect_us">
                                            <h6>{{ staticLangString($websiteLanguages,'title.call_us') }}</h6>
                                            <p>{{$siteInformation->phone}}</p>
                                        </div>
                                    </a>
                                </li>
                            @endif
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<header>
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <nav class="navbar navbar-expand-lg navbar-light">
                    <div class="container-fluid">
                     <!--   <a class="navbar-brand" href="{{ url('/') }}">
                            {!! printImage($siteInformation, 'tadbeer_logo','tadbeer_logo_webp','tadbeer_logo_attribute') !!}
                        </a> -->
                        <div class="collapse navbar-collapse" id="navbarSupportedContent">
                            <ul class="navbar-nav mb-2 mb-lg-0">
                                <li class="nav-item">
                                    <a class="nav-link {{ Request::is('/')?'active':'' }}" aria-current="page"
                                       href="{{ url('/') }}">{{ staticLangString($websiteLanguages,'menu.home') }}</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link {{ Request::is('about-us')?'active':'' }}"
                                       href="{{ url('about-us') }}">{{ staticLangString($websiteLanguages,'menu.about') }}</a>
                                </li>
                          <!--      <li class="nav-item">
                                <a class="nav-link {{ Request::is('maids') ? 'active' : '' }}"
                                href="{{ url('maids') }}">Team</a>
                                </li> -->

                                <li class="nav-item">
                                    <a class="nav-link {{ Request::is('services')?'active':'' }}"
                                       href="{{ url('services') }}">{{ staticLangString($websiteLanguages,'menu.services') }}</a>
                                </li>
                                
                                <li class="nav-item">
                                <a class="nav-link {{ Request::is('visa-service') ? 'active' : '' }}"
                                href="{{ url('visa-service') }}">Pricing</a>
                                </li>

                                
                    <!--            <li class="nav-item">
                                <a class="nav-link {{ Request::is('blogs') ? 'active' : '' }}"
                                href="{{ url('blogs') }}">News</a>
                                </li> -->

                                <li class="nav-item">
                                    <a class="nav-link"
                                       href="{{url('contact-us')}}">{{ staticLangString($websiteLanguages,'menu.contact') }}</a>
                                </li>
                            </ul>
                        </div>
                       <div class="mobile_right_section">
    <div class="navbar_right_contents">
        <div class="language_selection">
            <!-- Show only the other language flag -->
            @if(defaultLanguage() == 'en')
                <img class="language-flag" alt="Arabic Flag" src="{{ asset('web/images/united-arab-emirates.svg') }}">
            @elseif(defaultLanguage() == 'ar')
                <img class="language-flag" alt="English Flag" src="{{ asset('web/images/Header/united-kingdom.svg') }}">
            @endif

            <select class="form-select" aria-label="Default select example" id="language-selector">
                <option data-lang="English" data-lang_code="en" value="en" {{ defaultLanguage()=='en'? 'selected': '' }}>EN</option>
                <option data-lang="Arabic" data-lang_code="ar" value="ar" {{ defaultLanguage()=='ar'? 'selected': '' }}>AR</option>
            </select>
        </div>

        <a href="#" class="primary_btn clear-form" data-bs-toggle="modal" data-bs-target="#EnquiryModal">
            {{ staticLangString($websiteLanguages,'title.enquire_now') }}
        </a>
    </div>

    <button class="navbar-toggler" type="button" data-bs-toggle="offcanvas" href="#offcanvasExample">
        <span class="navbar-toggler-icon"></span>
    </button>
</div>

</header>


<div class="offcanvas offcanvas-start" tabindex="-1" id="offcanvasExample" aria-labelledby="offcanvasExampleLabel">
    <div class="offcanvas-header">
         <h5 class="offcanvas-title" id="offcanvasExampleLabel">Offcanvas</h5> 
        <a href="{{ url('/') }}">
            {!! printImage($siteInformation, 'logo','logo_webp','logo_attribute') !!}
        </a>
        <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body">
        <ul class="navbar-nav mb-2 mb-lg-0">
            <li class="nav-item">
                <a class="nav-link {{ Request::is('/')?'active':'' }}" aria-current="page"
                   href="{{url('/')}}">{{ staticLangString($websiteLanguages,'menu.home') }}</a>
            </li>
            <li class="nav-item">
                <a class="nav-link {{ Request::is('about-us')?'active':'' }}"
                   href="{{ url('about-us') }}">{{ staticLangString($websiteLanguages,'menu.about') }}</a>
            </li>
  <!--          <li class="nav-item">
            <a class="nav-link {{ Request::is('maids') ? 'active' : '' }}"
            href="{{ url('maids') }}">Team</a>
            </li> -->

            <li class="nav-item">
                <a class="nav-link {{ Request::is('services')?'active':'' }}"
                   href="{{url('services')}}">{{ staticLangString($websiteLanguages,'menu.services') }}</a>
            </li>
            
            <li class="nav-item">
    <a class="nav-link {{ Request::is('visa-service') ? 'active' : '' }}"
       href="{{ url('visa-service') }}">Pricing</a>
</li>

     <!--       
<li class="nav-item">
    <a class="nav-link {{ Request::is('blogs') ? 'active' : '' }}"
       href="{{ url('blogs') }}">News</a>
</li> -->

            <li class="nav-item">
                <a class="nav-link {{ Request::is('contact-us')?'active':'' }}"
                   href="{{url('contact-us')}}">{{ staticLangString($websiteLanguages,'menu.contact') }}
                    Us</a>
            </li>
        </ul>
    </div>
</div>




<div class="modal fade enquiry_modal" id="EnquiryModal" tabindex="-1" aria-labelledby="exampleModalLabel"
     aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"
                    id="exampleModalLabel">{{ staticLangString($websiteLanguages,'title.enquire_now') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="serviceEnquiryForm" action="">
                    <input type="hidden" id="type" name="type" value="services">

                    <div class="form-group">
                        <input type="text" name="name" id="name" class="form-control" id="exampleInputEmail1"
                               aria-describedby="emailHelp"
                               placeholder="{{ staticLangString($websiteLanguages,'title.name') }}*">
                    </div>
                    <div class="form-group">
                        <input type="email" name="email" id="email" class="form-control" id="exampleInputEmail1"
                               aria-describedby="emailHelp"
                               placeholder="{{ staticLangString($websiteLanguages,'title.email') }}*">
                    </div>
                    <div class="form-group">
                        <input type="number" name="phone" id="phone" class="form-control" id="exampleInputEmail1"
                               aria-describedby="emailHelp"
                               placeholder="{{ staticLangString($websiteLanguages,'title.phone') }}*">
                    </div>
                    <div class="form-group">
                        <select name="services[]" id="service_id" multiple class="form-control"
                                aria-label="Default select example">
                            @foreach($allServices as $service)
                                <option value="{{$service->id}}">{{ langString(@$service,'title') }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <textarea class="form-control" name="message" id="message" rows="4"
                                  placeholder="{{ staticLangString($websiteLanguages,'title.message') }}*"></textarea>
                    </div>
                    <button type="submit" data-url="/enquiry"
                            class="primary_btn d-block form_submit_btn m-auto">{{ staticLangString($websiteLanguages,'title.submit') }}</button>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="modal fade enquiry_modal" id="BookingModal" tabindex="-1" aria-labelledby="exampleModalLabel"
     aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">
                    {{ staticLangString($websiteLanguages,'title.book_now') }}
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="maidBookingForm" action="">
                    <input type="hidden" id="maid_id" name="maid_id">
                    <input type="hidden" id="type" name="type" value="booking">

                    <div class="form-group">
                        <input type="text" class="form-control" id="exampleInputEmail1" name="name" id="name"
                               aria-describedby="emailHelp"
                               placeholder="{{ staticLangString($websiteLanguages,'title.name') }}*">
                    </div>
                    <div class="form-group">
                        <input type="email" class="form-control" id="exampleInputEmail1" name="email" id="email"
                               aria-describedby="emailHelp"
                               placeholder="{{ staticLangString($websiteLanguages,'title.email') }}*">
                    </div>
                    <div class="form-group">
                        <input type="number" class="form-control" id="exampleInputEmail1" name="phone" id="phone"
                               aria-describedby="emailHelp"
                               placeholder="{{ staticLangString($websiteLanguages,'title.phone') }}*">
                    </div>
                    <div class="form-group">
                        <input class="form-control" id="maid_name" name="maid_name" type="text" placeholder="Maid"
                               disabled>
                    </div>
                    <div class="form-group">
                        <textarea class="form-control" name="message" id="message" rows="4"
                                  placeholder="{{ staticLangString($websiteLanguages,'title.message') }}*"></textarea>
                    </div>
                    <button type="submit" data-url="/enquiry"
                            class="primary_btn form_submit_btn d-block m-auto">{{ staticLangString($websiteLanguages,'title.book_now') }}</button>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="modal fade enquiry_modal" id="ServiceBookingModal" tabindex="-1" aria-labelledby="exampleModalLabel"
     aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">
                    {{ staticLangString($websiteLanguages,'title.book_now') }}
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="serviceBookingForm" action="">
                    <input type="hidden" id="visa_service_id" name="visa_service_id">
                    <input type="hidden" id="type" name="type" value="booking">

                    <div class="form-group">
                        <input type="text" name="name" id="name" class="form-control" aria-describedby="emailHelp"
                               placeholder="{{ staticLangString($websiteLanguages,'title.name') }}*">
                    </div>
                    <div class="form-group">
                        <input type="email" class="form-control" id="email" name="email" aria-describedby="emailHelp"
                               placeholder="{{ staticLangString($websiteLanguages,'title.email') }}*">
                    </div>
                    <div class="form-group">
                        <input type="number" class="form-control" name="phone" id="phone" aria-describedby="emailHelp"
                               placeholder="{{ staticLangString($websiteLanguages,'title.phone') }}*">
                    </div>
                    <div class="form-group">
                        <input class="form-control" name="visa_service_name" id="visa_service_name" type="text"
                               placeholder="Visa Service" disabled>
                    </div>
                    <div class="form-group">
                        <textarea class="form-control" name="message" id="message" rows="4"
                                  placeholder="{{ staticLangString($websiteLanguages,'title.message') }}*"></textarea>
                    </div>
                    <button type="submit" data-url="/enquiry" class="primary_btn d-block m-auto form_submit_btn">
                        {{ staticLangString($websiteLanguages,'title.book_now') }}
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

@yield('content')


<footer>
    {!! $siteInformation->footer_tag??'' !!}
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="footer_top">
                    <div class="footer_top_left">
                        <h5>{{ staticLangString($websiteLanguages,'title.news_letter') }}</h5>
                        <p>{{ staticLangString($websiteLanguages,'title.news_letter_description') }}
                        </p>
                    </div>
                    <div class="footer_top_right">
                        <form action="" id="newsLetterForm">
                            <div class="form-group">
                                <input type="email" name="email" class="form-control newsLetterForm" id="email"
                                       aria-describedby="emailHelp"
                                       placeholder="{{ staticLangString($websiteLanguages,'placeholder.newletter_email') }}">
                            </div>
                            <button type="submit" data-url="/newsletter"
                                    class="primary_btn form_submit_btn">{{ staticLangString($websiteLanguages,'title.subscribe') }}</button>
                        </form>
                    </div>
                </div>
                <div class="footer_center">
                    <div class="quick_links">
                        <h6>{{ staticLangString($websiteLanguages,'title.quick_links') }}</h6>
                        <ul>
                            <li><a href="{{url('/')}}">{{ staticLangString($websiteLanguages,'menu.home') }}</a></li>
                            <li><a href="{{url('about-us')}}">{{ staticLangString($websiteLanguages,'menu.about') }}</a>
                            </li>
                            <li title="Team"><a href="{{ url('maids') }}">Team</a> </li>                          
                            <li> <a href="{{ url('visa-service') }}">Pricing</a> </li>
                            <li><a href="{{url('blogs')}}">{{ staticLangString($websiteLanguages,'menu.blog') }}</a>
                            </li>
                            <li>
                                <a href="{{url('contact-us')}}">{{ staticLangString($websiteLanguages,'menu.contact') }}</a>
                            </li>
                        </ul>
                    </div>
                    <div class="services">
                        <h6>{{ staticLangString($websiteLanguages,'title.our_services') }}</h6>
                        <ul>
                            @foreach($allServices as $service)
                                <li>
                                    <a href="{{url('services#service_'.$service->id)}}">{{ langString($service,'title') }}</a>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                    <div class="contacts">
                        <h6>{{ staticLangString($websiteLanguages,'title.contact_info') }}</h6>
                        <ul>
                            
{{--                            @if($siteInformation->phone)--}}
                                <li>
                                    <a href="javascript:void(0)" style="cursor: default">
                                        <svg width="18" height="18" viewBox="0 0 18 18" fill="none"
                                             xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M13.4993 17.3333C10.0971 17.3289 6.83544 15.9754 4.42968 13.5696C2.02392 11.1638 0.670426 7.90219 0.666016 4.49993C0.666016 3.48327 1.06988 2.50825 1.78877 1.78936C2.50766 1.07047 3.48269 0.666599 4.49935 0.666599C4.71463 0.664959 4.92956 0.684498 5.14102 0.724932C5.34544 0.755183 5.5464 0.805424 5.74102 0.874932C5.87789 0.922957 5.99986 1.00588 6.09486 1.11549C6.18986 1.22511 6.2546 1.35762 6.28268 1.49993L7.42435 6.49993C7.45512 6.63565 7.45142 6.77692 7.41357 6.91083C7.37572 7.04475 7.30494 7.16706 7.20768 7.2666C7.09935 7.38327 7.09101 7.3916 6.06601 7.92493C6.88684 9.72565 8.32701 11.1717 10.1243 11.9999C10.666 10.9666 10.6743 10.9583 10.791 10.8499C10.8906 10.7527 11.0129 10.6819 11.1468 10.644C11.2807 10.6062 11.422 10.6025 11.5577 10.6333L16.5577 11.7749C16.6954 11.8069 16.8228 11.8734 16.9278 11.9681C17.0327 12.0629 17.1118 12.1828 17.1577 12.3166C17.228 12.5144 17.281 12.7179 17.316 12.9249C17.3496 13.1344 17.3663 13.3462 17.366 13.5583C17.3506 14.5706 16.9354 15.5357 16.211 16.243C15.4866 16.9502 14.5117 17.3422 13.4993 17.3333Z"/>
                                        </svg>
                                        <p>0544818499</p>
                                    </a>
                                </li>
                                <li>
                                <a href="javascript:void(0)" style="cursor: default">
                                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M2 3.00004C2 1.34316 3.34316 0 5.00004 0H7.00013C8.65701 0 10.0002 1.34316 10.0002 3.00004V13C10.0002 14.6569 8.65701 16.0001 7.00013 16.0001H5.00004C3.34316 16.0001 2 14.6569 2 13V3.00004Z"
                                            fill="#A4D8FD"/>
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                              d="M0.999957 13.0003V4.7639C0.386234 5.31316 0 6.11156 0 7.00004V17C0 18.6571 1.34316 20.0001 3.00004 20.0001H17C18.657 20.0001 20 18.6571 20 17V7.00004C20 5.34316 18.657 4 17 4H10.9999V13.0001C10.9999 15.2093 9.20906 17.0001 6.99987 17.0001H4.99979C2.7906 17.0001 0.999786 15.2093 0.999786 13.0001L0.999957 13.0003ZM14 9.0003C14 9.55261 13.5524 10.0003 13 10.0003C12.4477 10.0003 12.0001 9.55261 12.0001 9.0003C12.0001 8.44799 12.4477 8.00017 13 8.00017C13.5524 8.00017 14 8.44799 14 9.0003ZM13 13.0003C13.5524 13.0003 14 12.5526 14 12.0003C14 11.448 13.5524 11.0002 13 11.0002C12.4477 11.0002 12.0001 11.448 12.0001 12.0003C12.0001 12.5526 12.4477 13.0003 13 13.0003ZM14 15.0004C14 15.5527 13.5524 16.0003 13 16.0003C12.4477 16.0003 12.0001 15.5527 12.0001 15.0004C12.0001 14.4481 12.4477 14.0003 13 14.0003C13.5524 14.0003 14 14.4481 14 15.0004ZM16.0001 10.0002C16.5524 10.0002 17 9.55252 17 9.00021C17 8.44791 16.5524 8.00009 16.0001 8.00009C15.4478 8.00009 15.0001 8.44791 15.0001 9.00021C15.0001 9.55252 15.4478 10.0002 16.0001 10.0002V10.0002ZM17 12.0003C17 12.5526 16.5524 13.0002 16.0001 13.0002C15.4478 13.0002 15.0001 12.5526 15.0001 12.0003C15.0001 11.4479 15.4478 11.0001 16.0001 11.0001C16.5524 11.0001 17 11.4479 17 12.0003ZM16.0001 16.0003C16.5524 16.0003 17 15.5526 17 15.0003C17 14.448 16.5524 14.0002 16.0001 14.0002C15.4478 14.0002 15.0001 14.448 15.0001 15.0003C15.0001 15.5526 15.4478 16.0003 16.0001 16.0003Z"
                                              fill="#A4D8FD"/>
                                    </svg>
                                    <p>0544818499</p>
                                </a>
                            </li>
{{--                            @endif--}}
                            @if($siteInformation->email)
                                <li>
                                    <a href="mailto:{{@$siteInformation->email}}">
                                        <svg width="18" height="15" viewBox="0 0 18 15" fill="none"
                                             xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M15.666 0.833496H2.33268C1.41602 0.833496 0.674349 1.5835 0.674349 2.50016L0.666016 12.5002C0.666016 13.4168 1.41602 14.1668 2.33268 14.1668H15.666C16.5827 14.1668 17.3327 13.4168 17.3327 12.5002V2.50016C17.3327 1.5835 16.5827 0.833496 15.666 0.833496ZM15.3327 4.37516L9.44102 8.0585C9.17435 8.22516 8.82435 8.22516 8.55768 8.0585L2.66602 4.37516C2.58246 4.32826 2.50928 4.26488 2.45092 4.18887C2.39256 4.11287 2.35023 4.02581 2.3265 3.93297C2.30276 3.84013 2.2981 3.74344 2.31281 3.64875C2.32752 3.55406 2.3613 3.46334 2.41208 3.38208C2.46287 3.30082 2.52962 3.23071 2.60829 3.17599C2.68696 3.12127 2.77591 3.08309 2.86976 3.06374C2.96362 3.0444 3.06042 3.0443 3.15431 3.06345C3.2482 3.0826 3.33724 3.12061 3.41602 3.17516L8.99935 6.66683L14.5827 3.17516C14.6615 3.12061 14.7505 3.0826 14.8444 3.06345C14.9383 3.0443 15.0351 3.0444 15.1289 3.06374C15.2228 3.08309 15.3117 3.12127 15.3904 3.17599C15.4691 3.23071 15.5358 3.30082 15.5866 3.38208C15.6374 3.46334 15.6712 3.55406 15.6859 3.64875C15.7006 3.74344 15.6959 3.84013 15.6722 3.93297C15.6485 4.02581 15.6061 4.11287 15.5478 4.18887C15.4894 4.26488 15.4162 4.32826 15.3327 4.37516Z"/>
                                        </svg>
                                        <p>{{ @$siteInformation->email }}</p>
                                    </a>
                                </li>
                            @endif
                            @if(langString($siteInformation,'footer_location'))
                                <li>
                                    <a href="javascript:void(0)">
                                        <svg width="15" height="20" viewBox="0 0 15 20" fill="none"
                                             xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M6.57422 19.5C4.53516 16.9922 0 10.9141 0 7.5C0 3.35781 3.35781 0 7.5 0C11.6406 0 15 3.35781 15 7.5C15 10.9141 10.4297 16.9922 8.42578 19.5C7.94531 20.0977 7.05469 20.0977 6.57422 19.5ZM7.5 10C8.87891 10 10 8.87891 10 7.5C10 6.12109 8.87891 5 7.5 5C6.12109 5 5 6.12109 5 7.5C5 8.87891 6.12109 10 7.5 10Z"/>
                                        </svg>
                                        <p> {{ langString($siteInformation,'footer_location') }}</p>
                                    </a>
                                </li>
                            @endif
                        </ul>
                        <div class="social_media_icons">
                            <ul>
                                @if($siteInformation->facebook_url)

                                    <li>
                                        <a href="{{$siteInformation->facebook_url}}">
                                            <i class="fa-brands fa-facebook"></i>
                                        </a>
                                    </li>
                                @endif
                                @if($siteInformation->twitter_url)
                                    <li>
                                        <a href="{{$siteInformation->twitter_url}}">
                                            <i class="fa-brands fa-twitter"></i>
                                        </a>
                                    </li>
                                @endif
                                @if($siteInformation->youtube_url)
                                    <li>
                                        <a href="{{$siteInformation->youtube_url}}">
                                            <i class="fa-brands fa-youtube"></i>
                                        </a>
                                    </li>
                                @endif
                                @if($siteInformation->pinterest_url)
                                    <li>
                                        <a href="{{$siteInformation->pinterest_url}}">
                                            <i class="fa-brands fa-pinterest"></i>
                                        </a>
                                    </li>
                                @endif
                                @if($siteInformation->instagram_url)
                                    <li>
                                        <a href="{{$siteInformation->instagram_url}}">
                                            <i class="fa-brands fa-instagram"></i>
                                        </a>
                                    </li>
                                @endif
                                @if($siteInformation->linkedin_url)
                                    <li>
                                        <a href="{{$siteInformation->linkedin_url}}">
                                            <i class="fa-brands fa-linkedin"></i>
                                        </a>
                                    </li>
                                @endif
                                @if($siteInformation->snapchat_url)
                                    <li>
                                        <a href="{{$siteInformation->snapchat_url}}">
                                            <i class="fa-brands fa-snapchat"></i>
                                        </a>
                                    </li>
                                @endif
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="footer_bottom">
                    <div class="footer_bottom_left">
                        <p>© {{langString($siteInformation,'copyright') ?? config('app.name')}}</p>
                    </div>
                    <div class="footer_bottom_right">
                        <ul>
                            <li>
                                <a href="{{url('privacy-policy')}}">
                                    {{ staticLangString($websiteLanguages,'menu.privacy_policy') }}
                                </a>
                            </li>
                            <li>
                                <p>
                                    |
                                </p>
                            </li>
                            <li>
                                <a href="{{url('terms-and-conditions')}}">
                                    {{ staticLangString($websiteLanguages,'menu.terms_and_condition') }}
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</footer>
<!--<div class="social_contact_icon_section">
    <ul>
        @if($siteInformation->whatsapp_number)
            <li>
                <a href="https://wa.me/{{ @$siteInformation->whatsapp_number }}" target="_blank">
                    <img class="img-fluid" src="{{ asset('web/images/whatsapp_icon.png') }}" alt="">
                </a>
            </li>
        @endif
        @if($siteInformation->phone)
            <li>
                <a href="tel:{{ @$siteInformation->phone }}" target="_blank">
                    <img class="img-fluid" src="{{ asset('web/images/call_icon.png') }}" alt="">
                </a>
            </li>
        @endif
    </ul>
</div> -->

<!-- Include Font Awesome -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css"/>

<!-- Floating Buttons -->
<div id="floating-icons" style="position: fixed; bottom: 20px; right: 20px; display: flex; flex-direction: column; gap: 15px; z-index: 999;">

    <!-- Call -->
    <a href="tel:+97142666654" style="display: flex; align-items: center; justify-content: center; width: 50px; height: 50px; background-color: #007bff; color: #fff; border-radius: 50%; box-shadow: 0 4px 12px rgba(0,0,0,0.15); font-size: 24px; text-decoration: none; transition: all 0.3s ease;">
        <i class="fas fa-phone"></i>
    </a>

    <!-- WhatsApp -->
    <a href="https://api.whatsapp.com/send/?phone=97142666654" target="_blank" style="display: flex; align-items: center; justify-content: center; width: 50px; height: 50px; background-color: #25D366; color: #fff; border-radius: 50%; box-shadow: 0 4px 12px rgba(0,0,0,0.15); font-size: 24px; text-decoration: none; transition: all 0.3s ease;">
        <i class="fab fa-whatsapp"></i>
    </a>

    <!-- Location -->
    <a href="https://goo.gl/maps/your-location" target="_blank" style="display: flex; align-items: center; justify-content: center; width: 50px; height: 50px; background-color: #FF5722; color: #fff; border-radius: 50%; box-shadow: 0 4px 12px rgba(0,0,0,0.15); font-size: 24px; text-decoration: none; transition: all 0.3s ease;">
        <i class="fas fa-map-marker-alt"></i>
    </a>

</div>

<!-- JS for hover lift effect -->
<script>
    const icons = document.querySelectorAll('#floating-icons a');
    icons.forEach(icon => {
        icon.addEventListener('mouseenter', () => icon.style.transform = 'translateY(-5px)');
        icon.addEventListener('mouseleave', () => icon.style.transform = 'translateY(0)');
    });
</script>




<script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.0/jquery-ui.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.4.1/jquery.fancybox.min.js"></script>
<script src="{{ asset('web/js/jquery.star-rating-svg.js') }}"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xzoom/1.0.15/xzoom.min.js"></script>
<script src="{{ asset('web/vendor/xzoom/js/setup.js') }}"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/10.15.6/sweetalert2.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.full.min.js"></script>
<script src="{{ asset('web/js/form-select2_new.js') }}"></script>
<script src="{{ asset('web/js/scripts.min.js') }}"></script>
<script src="{{ asset('web/js/custom.min.js') }}"></script>


</body>
</html>
