@if($maids->isNotempty())
@foreach($maids as $maid)

    <div class="maid_box" id="maid{{$maid->maid_id}}">
        <div class="img_box">
            @if($maid->video_url)
                <a href="{{ $maid->video_url }}" data-fancybox="group">
                    {!! printImage($maid,'image','image_webp','image_attribute') !!}
                    <button type="button" class="video-btn">
                        <img src="{{ asset('web/images/svg/youtube.svg')}}" alt="">
                    </button>
                </a>
            @else
                {!! printImage($maid,'image','image_webp','image_attribute') !!}
            @endif
        </div>
        <div class="name_box">
            <div>
                <h5>{{ langString($maid,'name') }}</h5>
                <div class="ages">
                    <p>{{ \Carbon::parse($maid->dob)->age}}
                        {{ staticLangString($websiteLanguages,'title.years_old') }}
                    </p>
                </div>
                <ul>
                    <li>
                        <p>{{ staticLangString($websiteLanguages,'title.experience') }}:</p>
                        @if($maid->experience_year == 0 && $maid->experience_month == 0 )
                            <p>{{ staticLangString($websiteLanguages,'title.none') }}</p>
                        @else
                            <p> {{ $maid->experience_year >0 ? $maid->experience_year .' '.staticLangString($websiteLanguages,'title.years'):'' }}
                                {{ $maid->experience_month >0 ? $maid->experience_month .' '.staticLangString($websiteLanguages,'title.months'):'' }}
                            </p>
                        @endif
                    </li>
                    <li>
                        <p>{{ staticLangString($websiteLanguages,'title.nationality') }}
                            :</p>
                        <p> {{ langString($maid->country,'nationality')}}</p>
                    </li>
                    <li>
                        <p>{{ staticLangString($websiteLanguages,'title.services') }}: </p>
                        <p>
                            @foreach(@$maid->services as $service)
                                {!! langString($service,'title') !!}
                                @if(!$loop->last)
                                    ,
                                @endif
                            @endforeach
                        </p>
                    </li>
                    <li class="skill_list">
                        <p>{{ staticLangString($websiteLanguages,'title.skills') }}: </p>
                        <ul>
                            @foreach(@$maid->skill_sets as $skill)
                                <li>{!! langString($skill,'title') !!}</li>
                            @endforeach
                        </ul>
                    </li>
                </ul>
            </div>
        </div>
        <div class="share_box">
            <div class="share">

                <div class="btn-group dropend">
                    <a class="btn dropdown-toggle dropdownMenuLinkSocial " href="#" role="button"
                       id="dropdownMenuLinkSocial" data-bs-toggle="dropdown"
                       aria-expanded="false">
                        <img src="{{asset('web/images/svg/shares.svg')}}" alt="">
                        <p>{{ staticLangString($websiteLanguages,'title.share') }}</p>
                    </a>
                    <ul class="dropdown-menu" aria-labelledby="dropdownMenuLink" id="socialDropContent">
                        <li><a class="dropdown-item" target="_blank"
                               href="{{'https://www.facebook.com/sharer/sharer.php?u='.url('maid') .'/'.$maid->maid_id.'%23maid'.$maid->maid_id}}"><img
                                    src="{{asset('web/images/svg/sharefb.svg')}}" alt=""></a></li>
                        <hr>
                        <li><a class="dropdown-item" target="_blank"
                               href="{{'https://wa.me/?text='.url('maid') .'/'.$maid->maid_id.'%23maid'.$maid->maid_id}}"><img
                                    src="{{asset('web/images/svg/sharewhatsapp.svg')}}" alt=""></a>
                        </li>
                    </ul>
                </div>
            </div>

            <a href="javascript:void(0)" class="primary_btn maid_book" data-maid="{{$maid->id}}"
               data-maid_name="{{ langString($maid,'name') }}"
            >{{ staticLangString($websiteLanguages,'title.book_now') }}</a>
        </div>
    </div>
    @if($loop->last)
        <div class="appendHere_{{$offset}}"></div>
    @endif
@endforeach
@else
    <div>
        <a>Sorry, No results found.</a>
    </div>
@endif

{{--<input type="hidden" id="totalMaids" name="total_maids" value="{{$totalmaids}}">--}}
{{--<input type="hidden" id="maid_loading_offset" name="maid_loading_offset" value="{{$offset}}">--}}
{{--<input type="hidden" id="maid_loading_limit" name="maid_loading_limit" value="{{$loading_limit}}">--}}

@if($totalmaids>$offset)
    <div class="more-maid-{{$offset}}">
        <a href="javascript:void(0)"
           class="loads load-maids-button">{{ staticLangString($websiteLanguages,'title.load_more') }}</a>
    </div>
@endif

<script>
    {{--$('#product_count').html({{ $offset }});--}}
    $('#maid_loading_offset').val({{ $offset }});
</script>
