@extends('web.layouts.main')
@section('content')
    <section class="fourZeroFour">
        <div class="container">
            <div class="row">
                <div class="col-md-12 text-center">
                    <picture>
                        <img class="animated bounceIn" src="{{asset('web/images/500.png')}}" alt="500">
                    </picture>
                    <h1 class="animated fadeInUp">Oops! Something went wrong.</h1>
                    <p class="animated fadeInUp delay-1s">Our server is currently experiencing an issue.</p>
                    <button class="primary_btn animated pulse infinite delay-2s">BACK TO HOME</button>
                </div>
            </div>
        </div>
    </section>
@endsection

@push('styles')
    <style>
        /* General Section Styles */
        .fourZeroFour {
            background-color: #2c2f38;
            color: #fff;
            text-align: center;
            padding: 100px 0;
        }

        .fourZeroFour img {
            width: 250px;
            animation: bounceIn 1s ease;
        }

        h1, p {
            font-family: 'Roboto', sans-serif;
            color: #fff;
            margin-top: 20px;
        }

        h1 {
            font-size: 40px;
            font-weight: bold;
        }

        .primary_btn {
            background-color: #ff6347;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }

        .primary_btn:hover {
            background-color: #ff4500;
        }

        /* Keyframe Animations */
        @keyframes bounceIn {
            0% {
                transform: scale(0);
                opacity: 0;
            }
            60% {
                transform: scale(1.1);
                opacity: 1;
            }
            100% {
                transform: scale(1);
                opacity: 1;
            }
        }

        .animated {
            animation-duration: 1s;
            animation-fill-mode: both;
        }

        .fadeInUp {
            animation-name: fadeInUp;
        }

        @keyframes fadeInUp {
            0% {
                opacity: 0;
                transform: translate3d(0, 30px, 0);
            }
            100% {
                opacity: 1;
                transform: translate3d(0, 0, 0);
            }
        }

        .pulse {
            animation-name: pulse;
        }

        @keyframes pulse {
            0% {
                transform: scale(1);
            }
            50% {
                transform: scale(1.05);
            }
            100% {
                transform: scale(1);
            }
        }
    </style>
@endpush
