@extends('web.layouts.main')

@section('content')
 <!--   @include('web.includes.banner',[$banner]) -->


    <!--contact Page Start-->

    <section class="contact_share_info">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="All_main_Headings All_main_Headings_center">
                        <h6 class="sub_heading">{{ staticLangString($websiteLanguages,'page_heading.contact_sub_title') }}</h6>
                        <h3 class="main_heading">{{ staticLangString($websiteLanguages,'page_heading.contact_title') }}</h3>
                    </div>
                    <div class="col-12">
                        <ul class="info_list">

                            @if(langString($siteInformation,'location'))
                            <li>
                                <img src="{{asset('web/images/svg/location-info.svg')}}" alt="">
                                {!!  langString($siteInformation,'location') !!}
                                <a href=""
                                   class="primary_btn mt-auto">{{ staticLangString($websiteLanguages,'title.our_location') }}</a>
                            </li>
                            @endif
                                @if($siteInformation->phone || $siteInformation->alternate_phone)

                            <li>
                                <img src="{{asset('web/images/svg/phone-info.svg')}}" alt="">
                                <p>
                                    <a href="tel:{{@$siteInformation->phone}}">{{@$siteInformation->phone }}</a>
                                </p>
                                <p>
                                    <a href="tel:{{@$siteInformation->alternate_phone}}">{{ @$siteInformation->alternate_phone }}</a>
                                </p>
                                <a href="javascript:void(0)"
                                   class="primary_btn mt-auto">{{ staticLangString($websiteLanguages,'title.call_us') }}</a>
                            </li>
                                @endif
                                @if($siteInformation->email || $siteInformation->alternate_email)

                            <li>
                                <img src="{{asset('web/images/svg/envelope-info.svg')}}" alt="">
                                <p>
                                    <a href="mailto:{{@$siteInformation->email}}">{{ @$siteInformation->email }}</a>
                                </p>
                                <p>
                                    <a href="mailto:{{@$siteInformation->alternate_email}}">{{ @$siteInformation->alternate_email }}</a>
                                </p>
                                <a href="mailto:{{@$siteInformation->email?$siteInformation->email:$siteInformation->alternate_email}}"
                                   class="primary_btn mt-auto">{{ staticLangString($websiteLanguages,'title.email_us') }}</a>
                            </li>
                                @endif
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="business_time">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-9 hours_wrapper">
                    <h3>{{ staticLangString($websiteLanguages,'title.business_hours') }}: </h3>
                    {!! langString($siteInformation,'working_hours') !!}
                </div>
                <div class="col-lg-3 icons">
                    @if($siteInformation->facebook_url)
                        <a href="{{$siteInformation->facebook_url}}"><i class="fa-brands fa-facebook"></i></a>
                    @endif
                    @if($siteInformation->instagram_url)
                        <a href="{{$siteInformation->instagram_url}}"><i class="fa-brands fa-instagram"></i></a>
                    @endif
                    @if($siteInformation->linkedin_url)
                        <a href="{{$siteInformation->linkedin_url}}"><i class="fa-brands fa-linkedin"></i></a>
                    @endif
                    @if($siteInformation->twitter_url)
                        <a href="{{$siteInformation->twitter_url}}"><i class="fa-brands fa-twitter"></i></a>
                    @endif
                    @if($siteInformation->pinterest_url)
                        <a href="{{$siteInformation->pinterest_url}}"><i class="fa-brands fa-pinterest"></i></a>
                    @endif
                    @if($siteInformation->youtube_url)
                        <a href="{{$siteInformation->youtube_url}}"><i class="fa-brands fa-youtube"></i></a>
                    @endif
                    @if($siteInformation->snapchat_url)
                        <a href="{{$siteInformation->snapchat_url}}"><i class="fa-brands fa-snapchat"></i></a>
                    @endif
                </div>
            </div>
        </div>
    </section>

    <div class="message_section">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="All_main_Headings All_main_Headings_center">
                        <h6 class="sub_heading">{{ staticLangString($websiteLanguages,'title.send_message_sub_title') }}</h6>
                        <h3 class="main_heading">{{ staticLangString($websiteLanguages,'title.send_message_title') }}</h3>
                    </div>
                </div>
                <div class="col-12">

                @include('web.includes.enquire_now',['type'=>'Contact'])
                </div>
            </div>
        </div>
    </div>

    @if($siteInformation->google_map)
    <div class="map_frame">
        <iframe
            src="{{$siteInformation->google_map}}"
            width="100%" height="auto" style="border:0;" allowfullscreen="" loading="lazy"
            referrerpolicy="no-referrer-when-downgrade"></iframe>
    </div>
    @endif

    <!--contact Page End-->

@endsection
