@extends('web.layouts.main')

@section('content')
 <!--   @include('web.includes.banner',[$banner])--> 

<section class="about-us-section py-5 bg-light">
  <div class="container">
    <div class="row align-items-center gy-4">

      <!-- Left: Images -->
      <div class="col-lg-6 d-flex flex-column align-items-center gap-4">
        <div class="about-image-card">
          <img src="https://royalvisa.ae/wp-content/uploads/2024/03/Getting_Help_with_Your_UAE_Visa_Application_Visa_Services_Available.jpg" 
               alt="Visa Application Services" class="img-fluid">
        </div>
        <div class="about-image-card">
          <img src="https://3.imimg.com/data3/PG/NW/MY-11945651/wp-content-uploads-2014-08-passport-and-visa-300x213-250x250.png" 
               alt="Passport and Visa" class="img-fluid">
        </div>
      </div>

      <!-- Right: Content -->
      <div class="col-lg-6">
        <div class="about-content p-4">
          <h2 class="fw-bold mb-3">Your Trusted Visa Partner</h2>
          <p class="lead mb-4 text-dark">
            At <strong>MG Tadbeer</strong>, we provide <em>comprehensive visa services</em> including 
            <strong>application, renewal, cancellation, and sponsorship management</strong>. 
            With our experienced team and dedicated PRO officers, you can enjoy a 
            <span class="highlight">fast, reliable, and stress-free</span> process.
          </p>

          <div class="row g-3 mb-4">
            <div class="col-6">
              <div class="feature-box shadow-sm">
                <i class="bi bi-check-circle-fill text-primary me-2"></i> Hassle-free Applications
              </div>
            </div>
            <div class="col-6">
              <div class="feature-box shadow-sm">
                <i class="bi bi-check-circle-fill text-primary me-2"></i> Fast-track Renewals
              </div>
            </div>
            <div class="col-6">
              <div class="feature-box shadow-sm">
                <i class="bi bi-check-circle-fill text-primary me-2"></i> Document Collection & Delivery
              </div>
            </div>
            <div class="col-6">
              <div class="feature-box shadow-sm">
                <i class="bi bi-check-circle-fill text-primary me-2"></i> Dedicated PRO Officer
              </div>
            </div>
            <div class="col-6">
              <div class="feature-box shadow-sm">
                <i class="bi bi-check-circle-fill text-primary me-2"></i> Transparent Pricing
              </div>
            </div>
          </div>

          <a href="https://mgtadbeer.com/visa_services" class="btn btn-lg btn-primary shadow-lg px-4">
            Explore Visa Services
          </a>
        </div>
      </div>
    </div>
  </div>

  <style>
    .about-us-section {
      background: #f8f9fa;
    }
    .about-image-card {
      width: 100%;
      max-width: 360px;
      height: 220px;
      border-radius: 20px;
      overflow: hidden;
      box-shadow: 0 12px 35px rgba(0,0,0,0.08);
      transition: all 0.4s ease;
    }
    .about-image-card img {
      width: 100%;
      height: 100%;
      object-fit: cover;
      transition: transform 0.4s ease;
    }
    .about-image-card:hover img {
      transform: scale(1.08);
    }

    .about-content h2 {
      font-weight: 700;
      color: #161616;
    }
    .highlight {
      color: #ED7625;
      font-weight: 600;
    }
    .feature-box {
      background: #fff;
      border-radius: 12px;
      padding: 12px 15px;
      font-weight: 500;
      color: #444;
      display: flex;
      align-items: center;
      transition: transform 0.3s, box-shadow 0.3s;
    }
    .feature-box:hover {
      transform: translateY(-5px);
      box-shadow: 0 8px 20px rgba(0,0,0,0.12);
    }
    .btn-primary {
      background-color: #ED7625;
      border-color: #ED7625;
      transition: all 0.3s;
    }
    .btn-primary:hover {
      background-color: #f07b34;
      border-color: #f07b34;
      transform: translateY(-2px);
    }
  </style>
</section>

@endsection
