<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>EmailJS Enquiry Test</title>
    <script src="https://cdn.jsdelivr.net/npm/emailjs-com@3.2.0/dist/email.min.js"></script>
</head>
<body>
    <h2>Test Enquiry Form (EmailJS)</h2>

    <form id="testForm">
        <label>Name:* <input type="text" id="name" required></label><br><br>
        <label>Email:* <input type="email" id="email" required></label><br><br>
        <label>Phone:* <input type="text" id="phone" required></label><br><br>
        <label>Service: <input type="text" id="service"></label><br><br>
        <label>Message:* <br>
            <textarea id="message" rows="4" cols="50" required></textarea>
        </label><br><br>
        <button type="submit">Send Enquiry</button>
    </form>

    <div id="status" style="margin-top:20px;"></div>

    <script>
        // Initialize EmailJS with your correct Public Key
        emailjs.init("bUGdQXT5UHOdrbG2t"); // ✅ correct public key
        console.log("EmailJS initialized with correct public key.");

        const form = document.getElementById("testForm");
        const statusDiv = document.getElementById("status");

        form.addEventListener("submit", function(e) {
            e.preventDefault();

            // Collect form values
            const from_name = document.getElementById("name").value.trim();
            const from_email = document.getElementById("email").value.trim();
            const phone = document.getElementById("phone").value.trim();
            const service = document.getElementById("service").value.trim();
            const message = document.getElementById("message").value.trim();

            // Validate required fields
            if (!from_name || !from_email || !phone || !message) {
                alert("Please fill all required fields!");
                return;
            }

            const templateParams = {
                from_name: from_name,
                from_email: from_email,
                phone: phone,
                service: service,
                message: message
            };

            console.log("Sending EmailJS params:", templateParams);

            emailjs.send("service_tgkjiop", "template_frnszmo", templateParams)
            .then(function(response) {
                console.log("SUCCESS!", response.status, response.text);
                statusDiv.innerHTML = "<span style='color:green;'>Email sent successfully!</span>";
                form.reset();
            }, function(error) {
                console.error("FAILED!", error);
                statusDiv.innerHTML = "<span style='color:red;'>Failed to send email. Check console for details.</span>";
            });
        });
    </script>
</body>
</html>
