@extends('app.layouts.main')
@section('content')
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1><i class="nav-icon fas fa-user-shield"></i> {{$title}}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{url(sitePrefix().'dashboard')}}">Home</a></li>
                            @if($type=="service")
                                <li class="breadcrumb-item"><a href="{{url(sitePrefix().'service')}}">Service</a></li>
                            @else
                                <li class="breadcrumb-item"><a
                                        href="{{url(sitePrefix().'service/sub')}}">Sub-service</a></li>
                            @endif
                            <li class="breadcrumb-item active">{{$title}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        <section class="content">
            <div class="container-fluid">
                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
                <form role="form" id="formWizard" class="form--wizard" enctype="multipart/form-data" method="post">
                    {{csrf_field()}}
                    <div class="card card-info">
                        <div class="card-header">
                            <h3 class="card-title">{{ucfirst($type)}} Form</h3>
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            @if (session('success'))
                                <div class="alert alert-success" role="alert">
                                    <button type="button" class="close" data-dismiss="alert">×</button>
                                    {{ session('success') }}
                                </div>
                            @elseif(session('error'))
                                <div class="alert alert-danger" role="alert">
                                    <button type="button" class="close" data-dismiss="alert">×</button>
                                    {{ session('error') }}
                                </div>
                            @endif
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label> Title(English)*</label>
                                    <input type="text" name="title_en" id="title_en" placeholder="Title(English)"
                                           class="form-control required" autocomplete="off"
                                           value="{{ old('title_en',isset($service)?$service->title_en:'') }}"
                                           maxlength="255">
                                    <div class="help-block with-errors" id="title_en_error"></div>
                                    @error('title_en')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group col-md-6">
                                    <label> Title(Arabic)*</label>
                                    <input type="text" name="title_ar" id="title_ar" placeholder="Title(Arabic)"
                                           class="form-control required" autocomplete="off"
                                           value="{{ old('title_ar',isset($service)?$service->title_ar:'') }}"
                                           maxlength="255">
                                    <div class="help-block with-errors" id="title_ar_error"></div>
                                    @error('title_ar')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label> Description(English)*</label>
                                    <textarea name="description_en" id="description_en"
                                              class="form-control tinyeditor required"
                                              placeholder="Description(English)"
                                    >{{ old('description_en',isset($service)?$service->description_en:'') }}</textarea>
                                    <div class="help-block with-errors" id="description_en_error"></div>
                                    @error('description_en')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group col-md-6">
                                    <label> Description(Arabic)*</label>
                                    <textarea name="description_ar" id="description_ar"
                                              class="form-control tinyeditor required"
                                              placeholder="Description(Arabic)"
                                    >{{ old('description_ar',isset($service)?$service->description_ar:'') }}</textarea>
                                    <div class="help-block with-errors" id="description_ar_error"></div>
                                    @error('description_ar')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label> Alternate Description(English)</label>
                                    <textarea name="alternate_description_en" id="alternate_description_en"
                                              class="form-control tinyeditor"
                                              placeholder="Alternate Description(English)"
                                    >{{ old('alternate_description_en',isset($service)?$service->alternate_description_en:'') }}</textarea>
                                    <div class="help-block with-errors" id="alternate_description_en_error"></div>
                                    @error('alternate_description_en')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group col-md-6">
                                    <label> Alternate Description(Arabic)</label>
                                    <textarea name="alternate_description_ar" id="alternate_description_ar"
                                              class="form-control tinyeditor"
                                              placeholder="Alternate Description(Arabic)"
                                    >{{ old('alternate_description_ar',isset($service)?$service->alternate_description_ar:'') }}</textarea>
                                    <div class="help-block with-errors" id="alternate_description_ar_error"></div>
                                    @error('alternate_description_ar')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label> Image*</label>
                                    <div class="file-loading">
                                        <input id="image" name="image" type="file" accept="image/*">
                                    </div>
                                    <span class="caption_note">Note: Image dimension must be 390 x 400 PX and Size must be less than 512 KB</span>
                                    @error('image')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group col-md-6">
                                    <label> Image Attribute</label>
                                    <input type="text" name="image_attribute" id="image_attribute"
                                           placeholder="Alt='Image Attribute'"
                                           class="form-control placeholder-cls" autocomplete="off" maxlength="255"
                                           value="{{ old('image_attribute',isset($service)?$service->image_attribute:'') }}">
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <input type="submit" id="btn_save" name="btn_save"
                                   data-id="{{isset($service)?$service->id:''}}" value="Submit"
                                   class="btn btn-primary pull-left submitBtn">
                            <button type="reset" class="btn btn-default">Cancel</button>
                            <input type="hidden" name="id" id="id" value="{{ isset($service)?$service->id:'0' }}">
                            <input type="hidden" name="service_type" id="service_type" value="{{$type}}">
                            <img class="animation__shake loadingImg" src="{{url('app/dist/img/loading.gif')}}"
                                 style="display:none;">
                        </div>
                    </div>
                </form>
            </div>
        </section>
    </div>
    <script type="text/javascript">
        $(document).ready(function () {
            $("#image").fileinput({
                'theme': 'explorer-fas',
                validateInitialCount: true,
                overwriteInitial: false,
                autoReplace: true,
                layoutTemplates: {actionDelete: ''},
                initialPreviewShowDelete: false,
                removeLabel: "Remove",
                initialPreviewAsData: true,
                dropZoneEnabled: false,
                required: true,
                allowedFileTypes: ['image'],
                minImageWidth: 390,
                minImageHeight: 400,
                maxImageWidth: 390,
                maxImageHeight: 400,
                maxFileSize: 512,
                showRemove: false,
                @if(isset($service) && $service->image!=NULL)
                initialPreview: ["{{asset($service->image)}}",],
                initialPreviewConfig: [{
                    caption: "{{last(explode('/',$service->image))}}", width: "120px",
                }]
                @endif
            });
        });
    </script>
@endsection
