@extends('app.layouts.main')
@section('content')
<div class="content-wrapper">
  <!-- Content Header -->
  <div class="content-header">
    <div class="container-fluid">
      <div class="row mb-4 align-items-center">
        <div class="col-md-6">
          <h1 class="m-0 text-white"><i class="nav-icon fas fa-tachometer-alt"></i> Admin Dashboard</h1>
          <p class="text-muted">Welcome back, {{ auth()->user()->name ?? 'Admin' }} 👋</p>
        </div>
      </div>
    </div>
  </div>

  <!-- Main Content -->
  <section class="content">
    <div class="container-fluid">

      <!-- Quick Stats -->
      <div class="row text-white">
        <div class="col-md-4 mb-3">
          <div class="card bg-primary shadow-sm">
            <div class="card-body d-flex justify-content-between align-items-center">
              <div>
                <h5>Total Users</h5>
                <h3>1,248</h3>
              </div>
              <i class="fas fa-users fa-2x"></i>
            </div>
          </div>
        </div>
        <div class="col-md-4 mb-3">
          <div class="card bg-success shadow-sm">
            <div class="card-body d-flex justify-content-between align-items-center">
              <div>
                <h5>Active Sessions</h5>
                <h3>86</h3>
              </div>
              <i class="fas fa-signal fa-2x"></i>
            </div>
          </div>
        </div>
        <div class="col-md-4 mb-3">
          <div class="card bg-warning shadow-sm">
            <div class="card-body d-flex justify-content-between align-items-center">
              <div>
                <h5>Pending Tasks</h5>
                <h3>12</h3>
              </div>
              <i class="fas fa-tasks fa-2x"></i>
            </div>
          </div>
        </div>
      </div>

      <!-- Recent Activity -->
      <div class="row">
        <div class="col-md-6">
          <div class="card shadow-sm">
            <div class="card-header bg-info text-white">
              <h5 class="mb-0">Recent Activities</h5>
            </div>
            <ul class="list-group list-group-flush">
              <li class="list-group-item">👤 New user registered - <small>2 hrs ago</small></li>
              <li class="list-group-item">🛠️ Maintenance update - <small>1 day ago</small></li>
              <li class="list-group-item">✅ Task completed by admin - <small>3 days ago</small></li>
            </ul>
          </div>
        </div>
        <div class="col-md-6">
          <div class="card shadow-sm">
            <div class="card-header bg-secondary text-white">
              <h5 class="mb-0">System Overview</h5>
            </div>
            <div class="card-body">
              <p>Server uptime: <strong>99.99%</strong></p>
              <p>Last backup: <strong>Today, 3:45 AM</strong></p>
              <p>Next update: <strong>Scheduled</strong></p>
            </div>
          </div>
        </div>
      </div>

    </div>
  </section>
</div>
@endsection
