@extends('app.layouts.main')
@section('content')
<div class="content-wrapper">
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1><i class="nav-icon fas fa-user-shield"></i> {{$title}}</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{url(sitePrefix().'dashboard')}}">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{url(sitePrefix().'blog')}}">Blog</a></li>
                        <li class="breadcrumb-item active">{{$title}}</li>
                    </ol>
                </div>
            </div>
        </div>
    </section>
    <section class="content">
        <div class="container-fluid">
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
            <form role="form" id="formWizard" class="form--wizard" enctype="multipart/form-data" method="post">
                {{csrf_field()}}
                <div class="card card-info">
                    <div class="card-header">
                        <h3 class="card-title">Blog Form</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                         </div>
                    </div>
                    <div class="card-body">
                        @if (session('success'))
                            <div class="alert alert-success" role="alert">
                                <button type="button" class="close" data-dismiss="alert">×</button>
                                {{ session('success') }}
                            </div>
                        @elseif(session('error'))
                            <div class="alert alert-danger" role="alert">
                                <button type="button" class="close" data-dismiss="alert">×</button>
                                {{ session('error') }}
                            </div>
                        @endif
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label> Title (English)*</label>
                                    <input type="text" name="title_en" id="title_en" placeholder="Title English" class="form-control required for_canonical_url"
                                           autocomplete="off"  value="{{ old('title_en',isset($blog)?$blog->title_en:'') }}" maxlength="230">
                                    <div class="help-block with-errors" id="title_en_error"></div>
                                    @error('title_en')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="form-group col-md-6">
                                    <label> Title (Arabic)*</label>
                                    <input type="text" name="title_ar" id="title_ar" placeholder="Title Arabic" class="form-control required"
                                           autocomplete="off"  value="{{ old('title_ar',isset($blog)?$blog->title_ar:'') }}" maxlength="230">
                                    <div class="help-block with-errors" id="title_ar_error"></div>
                                    @error('title_ar')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                            </div>
                        <div class="form-row">

                            <div class="form-group col-md-4">
                                <label>Canonical URL*</label>
                                <input type="text" name="short_url" id="short_url" placeholder="Canonical URL" class="form-control required"
                                       autocomplete="off" value="{{ old('short_url',isset($blog)?$blog->short_url:'') }}" maxlength="230">
                                <div class="help-block with-errors" id="short_url_error"></div>
                                @error('short_url')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="form-group col-md-4">
                                <label>Sub Title (English)*</label>
                                <input type="text" name="sub_title_en" id="sub_title_en" placeholder="Sub Title English" class="form-control required"
                                       autocomplete="off"  value="{{ old('sub_title_en',isset($blog)?$blog->sub_title_en:'') }}" maxlength="230">
                                <div class="help-block with-errors" id="sub_title_en_error"></div>
                                @error('sub_title_en')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="form-group col-md-4">
                                <label>Sub Title (Arabic)*</label>
                                <input type="text" name="sub_title_ar" id="sub_title_ar" placeholder="Sub Title Arabic" class="form-control required"
                                       autocomplete="off"  value="{{ old('sub_title_ar',isset($blog)?$blog->sub_title_ar:'') }}" maxlength="230">
                                <div class="help-block with-errors" id="sub_title_ar_error"></div>
                                @error('sub_title_ar')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                        </div>
                            <div class="form-row">
                                <div class="form-group col-md-4">
                                    <label> Posted date *</label>
                                    <input type="date" name="posted_date" id="posted_date" placeholder="Posted Date" class="form-control required"
                                           autocomplete="off"  value="{{ old('posted_date',isset($blog)?$blog->posted_date:'') }}" maxlength="230">
                                    <div class="help-block with-errors" id="posted_date_error"></div>
                                    @error('posted_date')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group col-md-4">
                                    <label> Witten By (English)</label>
                                    <input type="text" name="written_by_en" id="written_by_en" placeholder="Written By " class="form-control"
                                           autocomplete="off"  value="{{ old('written_by_en',isset($blog)?$blog->written_by_en:'') }}" maxlength="60">
                                    <div class="help-block with-errors" id="written_by_error"></div>
                                    @error('written_by_en')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group col-md-4">
                                    <label> Witten By (Arabic) </label>
                                    <input type="text" name="written_by_ar" id="written_by_ar" placeholder="Written By" class="form-control "
                                           autocomplete="off"  value="{{ old('written_by_ar',isset($blog)?$blog->written_by_ar:'') }}" maxlength="60">
                                    <div class="help-block with-errors" id="written_by_error"></div>
                                    @error('written_by_ar')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="form-row">
                            <div class="form-group col-md-6">
                                <label> Image*</label>
                                <div class="file-loading">
                                    <input id="image" name="image" type="file" accept="image/*">
                                </div>
                                <span class="caption_note">Note: Image dimension must be 941 x 480 PX and Size must be less than 512 KB</span>
                                @error('image')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="form-group col-md-6">
                                <label> Image Attribute</label>
                                <input type="text" name="image_meta_tag" id="image_meta_tag" placeholder="Alt='Banner Attribute'"
                                       class="form-control placeholder-cls" autocomplete="off" maxlength="230"
                                       value="{{ old('image_meta_tag',isset($blog)?$blog->image_meta_tag:'') }}" >
                            </div>
                        </div>

                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label>List Description (English)*</label>
                                    <textarea class="form-control tinyeditor required" id="list_description_en"  name="list_description_en" placeholder="List Description English">
                                    {{ old('list_description_en',isset($blog)?$blog->list_description_en:'') }}</textarea>
                                    <div class="help-block with-errors" id="list_description_en_error"></div>
                                    @error('list_description_en')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group col-md-6">
                                    <label>List Description (Arabic)*</label>
                                    <textarea class="form-control tinyeditor required" id="list_description_ar"  name="list_description_ar" placeholder="List Description Arabic">
                                    {{ old('list_description_ar',isset($blog)?$blog->list_description_ar:'') }}</textarea>
                                    <div class="help-block with-errors" id="list_description_ar_error"></div>
                                    @error('list_description_ar')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label>Description (English)*</label>
                                    <textarea class="form-control tinyeditor required" id="description_en"  name="description_en" placeholder="Description English">
                                    {{ old('description_en',isset($blog)?$blog->description_en:'') }}</textarea>
                                    <div class="help-block with-errors" id="description_en_error"></div>
                                    @error('description_en')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group col-md-6">
                                    <label>Description (Arabic)*</label>
                                    <textarea class="form-control tinyeditor required" id="description_ar"  name="description_ar" placeholder="Description Arabic">
                                    {{ old('description_ar',isset($blog)?$blog->description_ar:'') }}</textarea>
                                    <div class="help-block with-errors" id="description_ar_error"></div>
                                    @error('description_ar')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>


                        <div class="form-row">
                            <div class="form-group col-md-4">
                                <label> Video URL</label>
                                <input type="text" name="video_url" id="video_url" placeholder="Video" class="form-control" autocomplete="off"
                                       value="{{ old('video_url',isset($blog)?$blog->video_url:'') }}" maxlength="230">
                            </div>
                            <div class="form-group col-md-4">
                                <label for="thumbnail_image">Video Thumbnail Image</label>
                                <div class="file-loading">
                                    <input id="video_thumbnail_image" name="video_thumbnail_image" type="file" accept="image/*">
                                </div>
                                <span class="caption_note">Note: Image dimension must be of 941 x 480 PX and Size must be less than 512 KB</span>
                                @error('video_thumbnail_image')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="form-group col-md-4">
                                <label> Video Thumbnail Image Attribute</label>
                                <input type="text" class="form-control placeholder-cls" id="video_meta_tag" name="video_meta_tag"
                                       placeholder="Alt='Banner Attribute'" maxlength="230"
                                       value="{{ old('video_meta_tag',isset($blog)?$blog->video_meta_tag:'') }}" >
                            </div>
                        </div>

                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label>Alternate Description (English)</label>
                                    <textarea class="form-control tinyeditor " id="alternate_description_en"  name="alternate_description_en" placeholder="Alternate Description English">
                                    {{ old('alternate_description_en',isset($blog)?$blog->alternate_description_en:'') }}</textarea>
                                    <div class="help-block with-errors" id="alternate_description_en_error"></div>
                                    @error('alternate_description_en')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group col-md-6">
                                    <label>Alternate Description (Arabic)</label>
                                    <textarea class="form-control tinyeditor " id="alternate_description_ar"  name="alternate_description_ar" placeholder="Alternate Description Arabic">
                                    {{ old('alternate_description_ar',isset($blog)?$blog->alternate_description_ar:'') }}</textarea>
                                    <div class="help-block with-errors" id="alternate_description_ar_error"></div>
                                    @error('alternate_description_ar')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label for="inputPassword4">Banner Title(English)</label>
                                <input type="text" name="banner_title_en" id="banner_title_en" placeholder="Banner Title English" class="form-control"
                                       autocomplete="off" value="{{ old('banner_title_en',isset($blog)?$blog->banner_title_en:'') }}" maxlength="230">
                            </div>
                            <div class="form-group col-md-6">
                                <label for="inputPassword4">Banner Title(Arabic)</label>
                                <input type="text" name="banner_title_ar" id="banner_title_ar" placeholder="Banner Title Arabic" class="form-control"
                                       autocomplete="off" value="{{ old('banner_title_ar',isset($blog)?$blog->banner_title_ar:'') }}" maxlength="230">
                            </div>

                        </div>
                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label for="inputEmail4">Banner Image</label>
                                <div class="file-loading">
                                    <input id="banner_image" name="banner_image" type="file" accept="image/*">
                                </div>
                                <span class="caption_note">Note: Image dimension must be 1920 X 500 PX and Size must be less than 512 KB</span>
                                @error('desktop_banner')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="form-group col-md-6">
                                <label for="inputPassword4">Banner Attribute</label>
                                <input type="text" name="banner_attribute" id="banner_attribute" placeholder="alt='alt Image'"
                                       class="form-control placeholder-cls" autocomplete="off"
                                       value="{{ old('banner_attribute',isset($blog)?$blog->banner_attribute:'') }}" maxlength="230">
                                <div class="help-block with-errors" id="banner_attribute_error"></div>
                            </div>
                        </div>
                        <div class="form-row">

                        </div>
						<div class="form-row">
                            <div class="form-group col-md-6">
                                <label> Meta Title</label>
                                <textarea class="form-control" id="meta_title" name="meta_title" placeholder="Meta Title">
                                    {{ old('meta_title',isset($blog)?$blog->meta_title:'') }}</textarea>
                            </div>
							<div class="form-group col-md-6">
                                <label> Meta Description</label>
                                <textarea class="form-control" id="meta_description" name="meta_description" placeholder="Meta Description">
                                    {{ old('meta_description',isset($blog)?$blog->meta_description:'') }}</textarea>
                            </div>
                        </div>
						<div class="form-row">
                            <div class="form-group col-md-6">
                                <label> Meta Keyword</label>
								<textarea class="form-control" id="meta_keyword" name="meta_keyword" placeholder="Meta Keyword">
                                    {{ old('meta_keyword',isset($blog)?$blog->meta_keyword:'') }}</textarea>
                            </div>
							<div class="form-group col-md-6">
                                <label> Other Meta Tag</label>
								<textarea class="form-control" id="other_meta_tag" name="other_meta_tag" placeholder="Other Meta Tag">
                                    {{ old('other_meta_tag',isset($blog)?$blog->other_meta_tag:'') }}</textarea>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <input type="submit" name="btn_save" value="Submit" class="btn btn-primary pull-left submitBtn">
                        <button type="reset" class="btn btn-default">Cancel</button>
                        <img class="animation__shake loadingImg" src="{{url('app/dist/img/loading.gif')}}" style="display:none;">
                    </div>
                </div>
            </form>
        </div>
    </section>
</div>
<script type="text/javascript">
$(document).ready(function(){
    $("#image").fileinput({
        'theme': 'explorer-fas',
        validateInitialCount: true,
        overwriteInitial: false,
        autoReplace: true,
        layoutTemplates: {actionDelete: ''},
        initialPreviewShowDelete: false,
        removeLabel: "Remove",
        initialPreviewAsData: true,
        dropZoneEnabled: false,
        required: true,
        allowedFileTypes: ['image'],
        minImageWidth: 941,
        minImageHeight: 480,
        maxImageWidth: 941,
        maxImageHeight: 480,
        maxFileSize: 512,
        showRemove: false,
        @if(isset($blog) && $blog->image!=NULL)
            initialPreview: [
                "{{asset($blog->image)}}",
            ],
            initialPreviewConfig: [
                {caption: "{{last(explode('/',$blog->image))}}", width: "120px",
                    key: "{{'Blog/image/'.$blog->id.'/webp_image' }}",}
            ]
        @endif
    });

    $("#video_thumbnail_image").fileinput({
        'theme': 'explorer-fas',
        validateInitialCount: true,
        overwriteInitial: false,
        autoReplace: true,
        layoutTemplates: {actionDelete: ''},
        initialPreviewShowDelete: false,
        initialPreviewAsData: true,
        dropZoneEnabled: false,
        required: false,
        allowedFileTypes: ['image'],
        minImageWidth: 941,
        minImageHeight: 480,
        maxImageWidth: 941,
        maxImageHeight: 480,
        maxFileSize: 512,
        showRemove: false,
        @if(isset($blog) && $blog->video_thumbnail_image!=NULL)
        initialPreview: ["{{asset($blog->video_thumbnail_image)}}",],
        initialPreviewConfig: [{
            caption: "{{last(explode('/',$blog->video_thumbnail_image))}}",
            width: "120px",
            key: "{{'Blog/video_thumbnail_image/'.$blog->id.'/video_thumbnail_webp_image' }}",}]
        @endif
    });

    $("#banner_image").fileinput({
        'theme': 'explorer-fas',
        validateInitialCount: true,
        overwriteInitial: false,
        autoReplace: true,
        initialPreviewShowDelete: false,
        initialPreviewAsData: true,
        dropZoneEnabled: false,
        required: false,
        allowedFileTypes: ['image'],
        minImageWidth: 1920,
        minImageHeight: 500,
        maxImageWidth: 1920,
        maxImageHeight: 500,
        maxFileSize: 512,
        showRemove: true,
        @if(isset($blog) && $blog->banner_image!=NULL)
            initialPreview: ["{{asset($blog->banner_image)}}"],
            initialPreviewConfig: [{
                caption: "{{last(explode('/',$blog->banner_image))}}",
                width: "120px",
                key: "{{'Blog/banner/'.$blog->id.'/banner_webp_image' }}",}]
        @endif
    });

});
</script>
@endsection
