@extends('app.layouts.main')
@section('content')
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1><i class="nav-icon fas fa-user-shield"></i> {{$adminData->role}} - Profile</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item">
                                <a href="{{url(sitePrefix().'/dashboard')}}">Home</a>
                            </li>
                            @if(isset($title))
                                <li class="breadcrumb-item">
                                    <a href="{{url(sitePrefix().'/administration')}}">Admin list</a>
                                </li>
                            @endif
                            <li class="breadcrumb-item active">{{$adminData->role}} - Profile</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        <section class="content">
            <div class="container-fluid">
                @if (session('success'))
                    <div class="alert alert-success" user_type="alert">
                        <button type="button" class="close" data-dismiss="alert">×</button>
                        {{ session('success') }}
                    </div>
                @elseif(session('error'))
                    <div class="alert alert-danger" user_type="alert">
                        <button type="button" class="close" data-dismiss="alert">×</button>
                        {{ session('error') }}
                    </div>
                @endif
                <form role="form" id="formWizard" class="form--wizard" enctype="multipart/form-data" method="post">
                    {{csrf_field()}}
                    <div class="card card-info">
                        <div class="card-header">
                            <h3 class="card-title">Basic Information</h3>
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label for="name">Name*</label>
                                    <input type="text" class="form-control required" name="name" placeholder="Name"
                                           id="name" value="{{ old('name', @$adminData->name) }}">
                                    <div class="help-block with-errors" id="name_error"></div>
                                    @error('name')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                    @enderror
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="login_email_id">Email*</label>
                                    <input type="email" name="email_id" id="login_email_id" placeholder="Email ID"
                                           class="form-control required" autocomplete="off"
                                           value="{{ old('email_id', @$adminData->email) }}">
                                    <div class="help-block with-errors" id="login_email_id_error"></div>
                                    @error('email_id')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                    @enderror
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label for="phone_number">Phone Number</label>
                                    <input type="number" class="form-control required" id="phone_number"
                                           name="phone_number" placeholder="Phone Number"
                                           value="{{ old('phone_number', @$adminData->phone_number) }}">
                                    <div class="help-block with-errors" id="phone_number_error"></div>
                                    @error('phone_number')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                    @enderror
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="image_meta_tag"> Profile Image Attribute</label>
                                    <input type="text" name="image_meta_tag" id="image_meta_tag"
                                           placeholder="Alt='Image Attribute'" class="form-control placeholder-cls" autocomplete="off"
                                           value="{{ old('image_meta_tag',@$adminData->image_meta_tag) }}">
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label for="profile_image">Profile Image</label>
                                    <div class="file-loading">
                                        <input id="profile_image" name="profile_image" type="file" accept="image/*">
                                    </div>
                                    <span class="caption_note">Note: Image dimension must be 300 X 300 PX and Size must be less than 512 KB</span>
                                    @error('profile_image')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                    @enderror
                                </div>

                            </div>
                        </div>
                    </div>
                    <div class="card card-success">
                        <div class="card-header">
                            <h3 class="card-title">Authentication Credentials</h3>
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label for="username">Username*</label>
                                    <input type="email" class="form-control required" id="username" name="username"
                                           placeholder="Username" readonly
                                           value="{{ old('username', @$adminData->username) }}">
                                    <div class="help-block with-errors" id="username_error"></div>
                                    @error('username')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <input type="submit" name="btn_save" value="Submit"
                                   class="btn btn-primary pull-left submitBtn">
                            <button type="reset" class="btn btn-default">Cancel</button>
                            <img class="animation__shake loadingImg" src="{{url('app/dist/img/loading.gif')}}"
                                 style="display:none;">
                        </div>
                    </div>
                </form>
            </div>
        </section>
    </div>
    <script type="text/javascript">
        $(document).ready(function () {
            $("#profile_image").fileinput({
                'theme': 'explorer-fas',
                validateInitialCount: true,
                overwriteInitial: false,
                autoReplace: true,
                initialPreviewShowDelete: false,
                layoutTemplates: {actionDelete: ''},
                removeLabel: "Remove",
                initialPreviewAsData: true,
                dropZoneEnabled: false,
                allowedFileTypes: ['image'],
                required: false,
                minImageWidth: 300,
                minImageHeight: 300,
                maxImageWidth: 300,
                maxImageHeight: 300,
                maxFileSize: 512,
                showRemove: false,
                @if(isset($adminData) && $adminData->profile_image!=NULL)
                initialPreview: ["{{asset($adminData->profile_image)}}",],
                initialPreviewConfig: [{
                    caption: "{{ last(explode('/',$adminData->profile_image))}}",
                    width: "120px",
                    key: "{{ ($adminData->profile_image!=NULL)?'1':'0'}}"
                }]
                @endif
            });

        });
    </script>
@endsection
