<?php include('assets/includes/header.php') ?>


<div>
<style>
    .hero-section {
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        background: linear-gradient(to right, #f8f9fa 50%, #f1f3f5 50%);
        padding: 3rem 0;
        min-height: 100vh;
        display: flex;
        align-items: center;
    }
    .hero-content h1 {
        font-weight: 800;
        font-size: 3rem;
        color: #2c3e50;
        margin-bottom: 1.5rem;
        line-height: 1.2;
    }
    .hero-content h1 span { color: #ED7625; }
    .hero-content p {
        font-size: 1.2rem;
        color: #555;
        margin-bottom: 2rem;
        line-height: 1.6;
    }
    .hero-content p span { font-weight: 700; color: #ED7625; }
    .buttonsets {
        display: flex;
        gap: 20px;
        margin-top: 2rem;
        flex-wrap: wrap;
    }
    .btn-custom {
        background: #ED7625;
        color: white;
        border: none;
        padding: 12px 25px;
        border-radius: 8px;
        font-weight: 600;
        display: flex;
        align-items: center;
        gap: 10px;
        transition: all 0.3s;
    }
    .btn-custom:hover {
        background: #d1661d;
        transform: translateY(-2px);
        box-shadow: 0 4px 8px rgba(0,0,0,0.1);
    }
    .btn-whatsapp { background: #25D366; }
    .btn-whatsapp:hover { background: #128C7E; }
    .service-cards {
        display: flex;
        gap: 20px;
        justify-content: flex-end;
        height: 380px;
        align-items: center;
    }
    .service-card {
        position: relative;
        width: 180px;
        height: 250px;
        border-radius: 12px;
        overflow: hidden;
        box-shadow: 0 10px 20px rgba(0,0,0,0.1);
        transition: all 0.5s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        cursor: pointer;
        flex-shrink: 0;
    }
    .service-card.active { width: 220px; height: 320px; }
    .service-card img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        transition: transform 0.5s ease;
    }
    .service-card:hover img { transform: scale(1.05); }
    .service-card span {
        position: absolute;
        bottom: 0; left: 0; right: 0;
        background: linear-gradient(transparent, rgba(0,0,0,0.8));
        color: white; padding: 15px 10px 10px;
        font-weight: 600; font-size: 1.1rem;
    }
    .service-card a {
        position: absolute;
        bottom: 10px; right: 10px;
        color: white; background: #ED7625;
        width: 40px; height: 40px; border-radius: 50%;
        display: flex; align-items: center; justify-content: center;
        text-decoration: none; transition: all 0.3s;
    }
    .service-card a:hover { background: #ff8933; transform: scale(1.1); }
    @media (max-width: 992px) {
        .hero-section { background: #f8f9fa; text-align: center; padding: 2rem 0; }
        .hero-content h1 { font-size: 2.2rem; }
        .service-cards { justify-content: center; margin-top: 2rem; flex-wrap: wrap; height: auto; }
        .buttonsets { justify-content: center; }
        .btn-custom { width: 100%; max-width: 300px; justify-content: center; }
    }
    @media (max-width: 768px) {
        .service-cards { flex-direction: column; align-items: center; }
        .service-card { width: 280px; }
        .service-card.active { width: 300px; height: 280px; }
    }
    @media (max-width: 576px) {
        .service-card { width: 260px; height: 220px; }
        .service-card.active { width: 280px; height: 240px; }
        .buttonsets { flex-direction: column; align-items: center; }
    }
</style>

<div class="hero-section">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6 col-md-12 hero-content">
                <h1><span>Maid or Nanny </span><br> Hire or Get Visa </h1>
                <p><span>Mountain Gate</span> is Your One Stop Center to Find & Hire Full Time Live-In Maids and Nannies in Dubai, UAE.</p>
                <div class="buttonsets">
                    <button class="btn btn-custom" onclick="alert('Callback request modal placeholder!')">
                        <i class="fas fa-phone-alt"></i> Request a Callback
                    </button>
                    <a href="https://api.whatsapp.com/send/?phone=97142666652" target="_blank" class="btn btn-custom btn-whatsapp">
                        <i class="fab fa-whatsapp"></i> WhatsApp Us
                    </a>
                </div>
            </div>
            <div class="col-lg-6 col-md-12">
                <div class="service-cards">
                    <div class="service-card active" id="card1" onmouseover="activateCard(1)">
                        <img src="https://images.unsplash.com/photo-1587512281607-060b67bd5c8a?auto=format&fit=crop&w=500&q=80" alt="Recruitment">
                        <span>Recruitment</span>
                        <a href="#"><i class="fas fa-arrow-right"></i></a>
                    </div>
                    <div class="service-card" id="card2" onmouseover="activateCard(2)">
                        <img src="https://images.unsplash.com/photo-1568992687947-868a62a9f521?auto=format&fit=crop&w=500&q=80" alt="Full-Time Live-In">
                        <span>Full-Time Live-In</span>
                        <a href="#"><i class="fas fa-arrow-right"></i></a>
                    </div>
                    <div class="service-card" id="card3" onmouseover="activateCard(3)">
                        <img src="https://images.unsplash.com/photo-1519985178571-ea1d1a6c9c2b?auto=format&fit=crop&w=500&q=80" alt="Visa Services">
                        <span>Visa Services</span>
                        <a href="#"><i class="fas fa-arrow-right"></i></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    function activateCard(cardNumber) {
        document.querySelectorAll('.service-card').forEach(card => {
            card.classList.remove('active');
        });
        document.getElementById('card' + cardNumber).classList.add('active');
    }
    document.querySelectorAll('.service-card').forEach(card => {
        card.addEventListener('mouseleave', function() {
            setTimeout(function() {
                const activeCards = document.querySelectorAll('.service-card.active');
                if (activeCards.length === 0) {
                    document.getElementById('card1').classList.add('active');
                }
            }, 1000);
        });
    });
</script>
</div>

<!--message section -->
    <section class="messageUs_Home">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="message_box">
                        <div class="row">
                            <div class="col-12">
                                <h3>Enquire Now</h3>
                            </div>
                            <form action="">
                                <div class="row">
                                    <div class="col-lg-4 col-6">
                                        <div class="form-group">
                                            <label for="">Full Name</label>
                                            <img src="assets/images/icon-user.png" alt="">
                                            <input type="text" class="form-control" placeholder="Full Name">
                                        </div>
                                    </div>
                                    <div class="col-lg-4 col-6">
                                        <div class="form-group">
                                            <label for="">Email Address</label>
                                            <img src="assets/images/icon-email.png" alt="">
                                            <input type="text" class="form-control" placeholder="Email Address">
                                        </div>
                                    </div>
                                    <div class="col-lg-4 col-12">
                                        <div class="form-group">
                                            <label for="">Phone Number</label>
                                            <img src="assets/images/icon-phone.png" alt="">
                                            <input type="text" class="form-control" placeholder="+1 000 000 00">
                                        </div>
                                    </div>
                                    <div class="col-lg-8">
                                        <div class="form-group">
                                            <label for="">Message</label>
                                            <img src="assets/images/icon-pen.png" alt="">
                                            <input type="text" class="form-control" placeholder="Say Something">
                                        </div>
                                    </div>
                                    <div class="col-lg-4 d-flex ">
                                        <div class="form-group d-flex align-items-end">
                                            <button type="submit" class="primary_btn ">Submit</button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<!--message section -->


<!--why choose us section-->
    <section class="Why_ChooseUs">
        <div class="container container_left">
            <div class="row">
                <div class="col-lg-6 col-md-12 Why_ChooseUs_left">
                    <div class="All_main_Headings d-block d-lg-none">
                        <h6 class="sub_heading">WHY CHOOSE US</h6>
                        <h3 class="main_heading">Why Choose Us For Your  <br> Maid Needs</h3>
                    </div>
                    <div class="img1">
                        <picture>
                            <img src="assets/images/maidabout.jpg" alt="">
                        </picture>
                    </div>
                    <div class="img2">
                        <picture>
                            <img src="assets/images/maidabout2.jpg" alt="">
                        </picture>
                    </div>
                </div>
                <div class="col-lg-6 col-md-12 Why_ChooseUs_right">
                    <div>
                        <div class="All_main_Headings d-none d-lg-block">
                            <h6 class="sub_heading">WHY CHOOSE US</h6>
                            <h3 class="main_heading">Why Choose Us For Your <br> Maid Needs</h3>
                        </div>
                        <p>At Tadbeer Mountain Gate L.L.C, we provide trusted and licensed domestic workers to meet the unique needs of every household. As an authorized Tadbeer service center under MOHRE, we ensure all our workers are carefully vetted, trained, and legally registered, giving you peace of mind and a safe, professional service.</p>
                        <p>Our team is committed to excellence, offering comprehensive support from placement to ongoing assistance. With transparent fees, full compliance with UAE labor laws, and a replacement guarantee, we make hiring domestic workers simple, reliable, and hassle-free—so you can focus on what truly matters at home.                        <a href="about.php" class="primary_btn">Know More</a>
                    </div>
                </div>
            </div>
        </div>
    </section>
<!--why choose us section-->


<!--key features section -->
    <section class="key_features">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="all_key_box">
                        <div class="key_box">
                            <h2>24 <span>X</span> 7</h2>
                            <h5>Support</h5>
                        </div>
                        <div class="key_box">
                            <h2>Experienced</h2>
                            <h5>Maids</h5>
                        </div>
                        <div class="key_box">
                            <h2>100 +</h2>
                            <h5>Total Staff</h5>
                        </div>
                        <div class="key_box">
                            <h2>World wide</h2>
                            <h5>Service</h5>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<!--key features section -->


<!--our services section-->
    <section class="our_services">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="All_main_Headings All_main_Headings_center">
                        <h6 class="sub_heading">WHY CHOOSE US</h6>
                        <h3 class="main_heading">Our Services</h3>
                    </div>
                    <div class="our_services_slider">
                        <div class="service_box">
                            <div class="img_top">
                                <picture>
                                    <img src="assets/images/services1.png" alt="">
                                </picture>
                            </div>
                            <div class="card_body">
                                <p>We denounce with righteous indig onto nation and dislike men who are so beguiled and demo data.</p>
                                <div class="list_box">
                                    <h4>Nanny/Baby Sitter</h4>
                                    <p>Lorem Ipsum</p>
                                    <h6>Professional Team</h6>
                                </div>
                            </div>
                        </div>
                        <div class="service_box">
                            <div class="img_top">
                                <picture>
                                    <img src="assets/images/service2.png" alt="">
                                </picture>
                            </div>
                            <div class="card_body">
                                <p>We denounce with righteous indig onto nation and dislike men who are so beguiled and demo data.</p>
                                <div class="list_box">
                                    <h4>Nanny/Baby Sitter</h4>
                                    <p>Lorem Ipsum</p>
                                    <h6>Professional Team</h6>
                                </div>
                            </div>
                        </div>
                        <div class="service_box">
                            <div class="img_top">
                                <picture>
                                    <img src="assets/images/services3.png" alt="">
                                </picture>
                            </div>
                            <div class="card_body">
                                <p>We denounce with righteous indig onto nation and dislike men who are so beguiled and demo data.</p>
                                <div class="list_box">
                                    <h4>Nanny/Baby Sitter</h4>
                                    <p>Lorem Ipsum</p>
                                    <h6>Professional Team</h6>
                                </div>
                            </div>
                        </div>
                        <div class="service_box">
                            <div class="img_top">
                                <picture>
                                    <img src="assets/images/services4.png" alt="">
                                </picture>
                            </div>
                            <div class="card_body">
                                <p>We denounce with righteous indig onto nation and dislike men who are so beguiled and demo data.</p>
                                <div class="list_box">
                                    <h4>Nanny/Baby Sitter</h4>
                                    <p>Lorem Ipsum</p>
                                    <h6>Professional Team</h6>
                                </div>
                            </div>
                        </div>
                        <div class="service_box">
                            <div class="img_top">
                                <picture>
                                    <img src="assets/images/services1.png" alt="">
                                </picture>
                            </div>
                            <div class="card_body">
                                <p>We denounce with righteous indig onto nation and dislike men who are so beguiled and demo data.</p>
                                <div class="list_box">
                                    <h4>Nanny/Baby Sitter</h4>
                                    <p>Lorem Ipsum</p>
                                    <h6>Professional Team</h6>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<!--our services section-->


<!--our team section -->
    <section class="our_team">
        <div class="container">
            <div class="row">
                <div class="col-lg-4 our_team_left">
                   <div>
                       <div class="All_main_Headings">
                           <h6 class="sub_heading">TEAM MEMBERS</h6>
                           <h3 class="main_heading">Meet Our Team of Expert Staff</h3>
                       </div>
                       <p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's.</p>
                       <a href="javascript:void(0)" class="primary_btn">Explore More</a>
                   </div>
                </div>
                <div class="col-lg-8 our_team_right">
                    <div class="our_team_slider">
                        <div class="team_box">
                            <div class="profile">
                                <div class="card_top">
                                    <picture>
                                        <img src="assets/images/team1.png" alt="">
                                    </picture>
                                </div>
                                <div class="naming">
                                    <h6>Joeylene Rivera</h6>
                                    <p>Driver, Care Taker</p>
                                </div>
                            </div>
                            <div class="card_body">
                                <ul>
                                    <li>Speaks some Arabic</li>
                                    <li>Worked for 8 years in Qatar and Saudi Arabia</li>
                                </ul>
                                <a href="javascript:void(0)">employee@gmail.com</a>
                            </div>
                        </div>
                        <div class="team_box">
                            <div class="profile">
                                <div class="card_top">
                                    <picture>
                                        <img src="assets/images/team2.png" alt="">
                                    </picture>
                                </div>
                                <div class="naming">
                                    <h6>Joeylene Rivera</h6>
                                    <p>Driver, Care Taker</p>
                                </div>
                            </div>
                            <div class="card_body">
                                <ul>
                                    <li>Speaks some Arabic</li>
                                    <li>Worked for 8 years in Qatar and Saudi Arabia</li>
                                </ul>
                                <a href="javascript:void(0)">employee@gmail.com</a>
                            </div>
                        </div>
                        <div class="team_box">
                            <div class="profile">
                                <div class="card_top">
                                    <picture>
                                        <img src="assets/images/team1.png" alt="">
                                    </picture>
                                </div>
                                <div class="naming">
                                    <h6>Joeylene Rivera</h6>
                                    <p>Driver, Care Taker</p>
                                </div>
                            </div>
                            <div class="card_body">
                                <ul>
                                    <li>Speaks some Arabic</li>
                                    <li>Worked for 8 years in Qatar and Saudi Arabia</li>
                                </ul>
                                <a href="javascript:void(0)">employee@gmail.com</a>
                            </div>
                        </div>
                        <div class="team_box">
                            <div class="profile">
                                <div class="card_top">
                                    <picture>
                                        <img src="assets/images/team1.png" alt="">
                                    </picture>
                                </div>
                                <div class="naming">
                                    <h6>Joeylene Rivera</h6>
                                    <p>Driver, Care Taker</p>
                                </div>
                            </div>
                            <div class="card_body">
                                <ul>
                                    <li>Speaks some Arabic</li>
                                    <li>Worked for 8 years in Qatar and Saudi Arabia</li>
                                </ul>
                                <a href="javascript:void(0)">employee@gmail.com</a>
                            </div>
                        </div>
                        <div class="team_box">
                            <div class="profile">
                                <div class="card_top">
                                    <picture>
                                        <img src="assets/images/team1.png" alt="">
                                    </picture>
                                </div>
                                <div class="naming">
                                    <h6>Joeylene Rivera</h6>
                                    <p>Driver, Care Taker</p>
                                </div>
                            </div>
                            <div class="card_body">
                                <ul>
                                    <li>Speaks some Arabic</li>
                                    <li>Worked for 8 years in Qatar and Saudi Arabia</li>
                                </ul>
                                <a href="javascript:void(0)">employee@gmail.com</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<!--our team section -->


<!--testimonials section -->
    <section class="testimonials">
        <div class="container">
            <div class="row">
                <div class="col-md-12 testimonailbefore">
                    <div class="All_main_Headings All_main_Headings_center">
                        <h6 class="sub_heading">TESTIMONIALS</h6>
                        <h3 class="main_heading">What Our Clients Say!</h3>
                    </div>
                    <div class="testimonial_slider">
                        <div class="testimonial_box">
                            <div class="rater">
                                <div class="rater_img">
                                    <picture>
                                        <img src="assets/images/team2.png" alt="">
                                    </picture>
                                </div>
                                <div class="rater_name">
                                    <h6>Leo</h6>
                                    <p>Lead Designer</p>
                                </div>
                                <div class="rater_rate">
                                    <div class="my-rating-readonly" data-rating="4"></div>
                                </div>
                            </div>
                            <div class="rated_contents">
                                <h6>It was a very good experience</h6>
                                <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Cursus nibh mauris, nec turpis orci lectus maecenas. Suspendisse sed magna eget nibh in turpis. Consequat duis diam lacus arcu.Cursus nibh mauris, nec turpis orci lectus maecenas. Suspendisse sed magna eget nibh in turpis. Consequat duis diam lacus arcu.</p>
                            </div>
                        </div>
                        <div class="testimonial_box">
                            <div class="rater">
                                <div class="rater_img">
                                    <picture>
                                        <img src="assets/images/team2.png" alt="">
                                    </picture>
                                </div>
                                <div class="rater_name">
                                    <h6>Leo</h6>
                                    <p>Lead Designer</p>
                                </div>
                                <div class="rater_rate">
                                    <div class="my-rating-readonly" data-rating="4"></div>
                                </div>
                            </div>
                            <div class="rated_contents">
                                <h6>It was a very good experience</h6>
                                <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Cursus nibh mauris, nec turpis orci lectus maecenas. Suspendisse sed magna eget nibh in turpis. Consequat duis diam lacus arcu.</p>
                            </div>
                        </div>
                        <div class="testimonial_box">
                            <div class="rater">
                                <div class="rater_img">
                                    <picture>
                                        <img src="assets/images/team2.png" alt="">
                                    </picture>
                                </div>
                                <div class="rater_name">
                                    <h6>Leo</h6>
                                    <p>Lead Designer</p>
                                </div>
                                <div class="rater_rate">
                                    <div class="my-rating-readonly" data-rating="4"></div>
                                </div>
                            </div>
                            <div class="rated_contents">
                                <h6>It was a very good experience</h6>
                                <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Cursus nibh mauris, nec turpis orci lectus maecenas. Suspendisse sed magna eget nibh in turpis. Consequat duis diam lacus arcu.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<!--testimonials section -->


<!--Blogs section -->
    <section class="blogs">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="All_main_Headings All_main_Headings_center">
                        <h6 class="sub_heading">OUR BLOG</h6>
                        <h3 class="main_heading">Step By Step Guides to <br> Clean Smarter</h3>
                    </div>
                    <div class="all_blogs_slider">
                        <div class="blog_card">
                            <div class="card_top">
                                <picture>
                                    <img src="assets/images/blog1.png" alt="">
                                </picture>
                            </div>
                            <div class="card_body">
                                <h6>08.08.2021</h6>
                                <h4>Lorem Ipsum is simply dummy text</h4>
                                <p>Lorem Ipsum is simply dummy text of the printing and typesetting industry  text of the printing and typesetting industry  text of the printing and typesetting industry</p>
                                <a href="javascript:void(0)">Read More</a>
                            </div>
                        </div>
                        <div class="blog_card">
                            <div class="card_top">
                                <picture>
                                    <img src="assets/images/services1.png" alt="">
                                </picture>
                            </div>
                            <div class="card_body">
                                <h6>08.08.2021</h6>
                                <h4>Lorem Ipsum is simply dummy text</h4>
                                <p>Lorem Ipsum is simply dummy text of the printing and typesetting industry  text of the printing and typesetting industry  text of the printing and typesetting industry</p>
                                <a href="javascript:void(0)">Read More</a>
                            </div>
                        </div>
                        <div class="blog_card">
                            <div class="card_top">
                                <picture>
                                    <img src="assets/images/services3.png" alt="">
                                </picture>
                            </div>
                            <div class="card_body">
                                <h6>08.08.2021</h6>
                                <h4>Lorem Ipsum is simply dummy text</h4>
                                <p>Lorem Ipsum is simply dummy text of the printing and typesetting industry  text of the printing and typesetting industry  text of the printing and typesetting industry</p>
                                <a href="javascript:void(0)">Read More</a>
                            </div>
                        </div>
                        <div class="blog_card">
                            <div class="card_top">
                                <picture>
                                    <img src="assets/images/services4.png" alt="">
                                </picture>
                            </div>
                            <div class="card_body">
                                <h6>08.08.2021</h6>
                                <h4>Lorem Ipsum is simply dummy text</h4>
                                <p>Lorem Ipsum is simply dummy text of the printing and typesetting industry  text of the printing and typesetting industry  text of the printing and typesetting industry</p>
                                <a href="javascript:void(0)">Read More</a>
                            </div>
                        </div>
                        <div class="blog_card">
                            <div class="card_top">
                                <picture>
                                    <img src="assets/images/blog1.png" alt="">
                                </picture>
                            </div>
                            <div class="card_body">
                                <h6>08.08.2021</h6>
                                <h4>Lorem Ipsum is simply dummy text</h4>
                                <p>Lorem Ipsum is simply dummy text of the printing and typesetting industry  text of the printing and typesetting industry  text of the printing and typesetting industry</p>
                                <a href="javascript:void(0)">Read More</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<!--Blogs section -->

	<script src="https://www.housekeepingco.com/js/v2/jquery.min.js?v=1758353381"></script>
	<script async src="https://www.housekeepingco.com/js/v2/bootstrap.bundle.min.js?v=1758353381"></script>

	




<!-- Start Schema Code -->
	<script type="application/ld+json">
    {
		"@context": "http://schema.org",
		"@type": "Organization",
		"name": "Mountain Gate",
		"description": "The Mountain Gate was established in 2011, and pioneered the way ahead for industry change in the domestic workers service and commercial cleaning industry.",
		"logo": "https://www.housekeepingco.com/images/HKC-Logo.png",
		"url": "https://www.housekeepingco.com/",
		"telephone": "+971 4706 0100",
		"sameAs": ["https://www.linkedin.com/company/housekeepingco/","https://www.facebook.com/housekeepingcompany/","https://www.youtube.com/housekeepingco","https://www.instagram.com/tadbeer_housekeepingco/"],
		"address": {
			"@type": "PostalAddress",
			"streetAddress": "Mountain Gate, Showroom No # 4, Indigo Sky Building - Sheikh Zayed Road - Umm Al Sheif - Dubai",
			"addressLocality": "Dubai",
			"postalCode": "10281",
			"addressCountry": "United Arab Emirates"
		}
	}
</script>
<!-- End Schema Code -->
<script src="https://www.housekeepingco.com/js/jquery-validation/dist/jquery.validate.min.js?v=1"></script>

<script async>
	$.validator.setDefaults({errorPlacement:function(t,e){e.parent(".input-group").length||e.parents(".iti").length?t.insertAfter(e.parent()):e.hasClass("summernote")?t.insertAfter(e.siblings(".note-editor")):e.parent(".dropify-wrapper").length?t.insertAfter(e.parent()):e.parent(".question").length?($(e).parent().addClass("question-error"),$(e).attr("data-toggle","tooltip").attr("title","this field is required")):e.data("select2")?e.parent("td").length?e.parent("td").append(t):e.closest(".form-group").length&&($(e).parents().hasClass("form-horizontal")?e.closest("div"):e.parent(".form-group")).append(t):t.insertAfter(e)}}),$.validator.addMethod("uae_number",function(t,e,r){return!!t.match(/^(?:0)?(?:50|52|55|56|54|58|2|3|4|6|7|9)\d{7}$/m)},"Please enter a valid UAE Number"),$.validator.addMethod("international_number",function(t,e,r){return!!t.match(/^[0-9]+$/)},"Please enter a valid contact number");
</script>
	<script>
		$('#opensidebar').on('click', function() {
			setTimeout(() => {
				$('#navbarScrollingDropdown_2').dropdown('show');
			}, 100);
		})
	</script>
<script async>
$(document).ready(function(){$(".set").on("mouseenter",function(){$(".set").removeClass("active"),$(this).addClass("active")}),$(document).on("input","input[type='tel']",function(e){var t;$(this).hasClass("allow-decimals")?((t=$(this)).val(t.val().replace(/[^0-9\.]/g,"")),46==e.which&&-1==t.val().indexOf(".")||!(e.which<48||57<e.which)||e.preventDefault()):this.value=this.value.replace(/\D/g,"")}),$("#user-nav-toggler").length&&$("body").on("click","#user-nav-toggler button",function(){$(".user-profile").slideToggle("fast")}),document.getElementById("preferred_date").addEventListener("change",function(){const e=new Date(this.value),t=new Date,n=document.getElementById("preferred_time");if(e.toDateString()===t.toDateString()){var r=t.getHours(),o=t.getMinutes();const a=new Date(t.getTime());a.setHours(r),a.setMinutes(o),n.min=a.toTimeString().slice(0,5)}else n.min="08:15";n.max="19:45"}),$("#quickconsultationForm").validate({rules:{name:{required:!0},phone:{uae_number:!0,required:!0},preferred_date:{required:!0},preferred_time:{required:!0}},submitHandler:function(e){e=new FormData(e);$.ajax({type:"POST",url:"https://www.housekeepingco.com/recruitment/recruitment-free-consultation",data:e,contentType:!1,processData:!1,beforeSend:function(){},success:function(e){"Validation-Errors"==e.status?(jsonError=[],$.each(e.errors,function(n,e){$.each(e,function(e,t){jsonError[n]=t})}),_validator.showErrors(jsonError)):"Success"==e.status&&($("#quickconsultationForm")[0].reset(),$("#consolationModal").modal("hide"),window.location.href="https://www.housekeepingco.com/enquiry/enquiry-thank-you")},error:function(e,t,n){alert("Error Code: "+e.status+". "+n+". Please contact Admin.")}})}})});
</script>

<?php include('assets/includes/footer.php') ?>
