<?php

namespace Database\Seeders;

use App\Models\Maid;
use Illuminate\Database\Seeder;

class MaidSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        for ($i = 1; $i <= 20; $i++) {
            Maid::insert([
                [
                    'name_en' => 'maid' . $i,
                    'name_ar' => 'maid' . $i . ' AR',
                    'email' => 'maid' . $i . '@target.com',
                    'dob' => rand(1980, 2002) . '-' . rand(1, 12) . '-' . rand(1, 28),
                    'country_id' => rand(1, 3),
                    'experience_year' => rand(0, 30),
                    'experience_month' => rand(1, 11),
                    'created_at' => now(),
                    'updated_at' => now(),
                ]
            ]);
        }
    }
}
