<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMaidsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('maids', function (Blueprint $table) {
            $table->id();

            $table->string('name_en');
            $table->string('name_ar');
            $table->string('maid_id')->nullable();
            $table->string('email')->unique();
            $table->date('dob');
            $table->integer('country_id');
            $table->integer('experience_year')->nullable();
            $table->integer('experience_month')->nullable();
            $table->string('video_url')->nullable();
            $table->string('image')->nullable();
            $table->string('image_webp')->nullable();
            $table->string('image_attribute')->nullable();
            $table->enum('display_to_home', ['Yes', 'No'])->default('No');

            $table->enum('status', ['Active', 'Inactive'])->default('Active');

            $table->timestamps();
            $table->softdeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('maids');
    }
}
