<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEnquiryFormsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('enquiry_forms', function (Blueprint $table) {
            $table->id();
            $table->enum('type',['main_enquiry', 'service_enquiry','contact_page'])->default('contact_page');
            $table->string('name');
            $table->string('email');
            $table->string('phone');
            $table->longText('message');
            $table->string('company')->nullable();
            $table->string('subject')->nullable();
            $table->integer('service_id')->default(0);
            $table->longText('reply')->nullable();
            $table->timestamp('reply_date')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('enquiry_forms');
    }
}
