<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateContactsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('contacts', function (Blueprint $table) {
            $table->id();
            $table->text('logo')->nullable();
            $table->text('webp_logo')->nullable();
            $table->text('logo_meta_tag')->nullable();
            $table->string('email_id')->nullable();
            $table->string('alternate_email_id')->nullable();
            $table->string('email_recepient')->nullable();
            $table->string('whatsapp_number')->nullable();
            $table->string('phone_number')->nullable();
            $table->string('alternate_phone_number')->nullable();
            $table->text('address')->nullable();
            $table->text('google_map')->nullable();
            $table->string('facebook_url')->nullable();
            $table->string('instagram_url')->nullable();
            $table->string('twitter_url')->nullable();
            $table->string('linkedin_url')->nullable();
            $table->string('contact_form_title')->nullable();
            $table->string('contact_form_button_text')->nullable();
            $table->string('partners_address_title')->nullable();
            $table->text('footer_logo')->nullable();
            $table->text('footer_webp_logo')->nullable();
            $table->text('footer_logo_meta_tag')->nullable();
            $table->longText('footer_content')->nullable();
            $table->longText('terms_conditions')->nullable();
            $table->longText('privacy_policy')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('contacts');
    }
}
