<?php

namespace App\Http\Controllers\app;

use App\Http\Controllers\Controller;
use App\Models\ExtraTag;
use App\Models\MetaTag;
use Illuminate\Http\Request;

class TagController extends Controller
{
    public function __construct()
    {
        $this->middleware('is_verify_email');
    }

    public function tag($type)
    {
        $type = trim(ucfirst($type));
        $key = "Update";
        $title_name = $type == 'About' ? 'About' : $type;
        $title = "Update '" . $title_name . "'";
        $tag = MetaTag::where('page_name',$type)->first();
        return view('app.tags.tags_form',compact('key','title','tag','type'));
    }

    public function tag_store(Request $request)
    {
        $type_array = array('Home','About','Maids','Blog','Services','Visa-services','Contact','Privacy','Terms');
        if(in_array($request->page_name,$type_array)){
            $validatedData = $request->validate([
                'page_name' => 'required|min:2',
            ]);
            if($request->id==0){
                $tag = new MetaTag;
            }else{
                $tag = MetaTag::find($request->id);
                $tag->updated_at = date('Y-m-d h:i:s');
            }
            $tag->page_name = $validatedData['page_name'];
            $tag->meta_title = ($request->meta_title)?$request->meta_title:'';
            $tag->meta_description = ($request->meta_description)?$request->meta_description:'';
            $tag->meta_keyword = ($request->meta_keyword)?$request->meta_keyword:'';
            $tag->other_meta_tag = isset($request->other_meta_tag)?$request->other_meta_tag:'';
            if($tag->save()){
                session()->flash('success', 'Tag content '.$request->page_name.' has been updated successfully');
                return redirect(sitePrefix().'tag/'.strtolower($request->page_name));
            }else{
                return back()->with('error', 'Error while updating the tag content');
            }
        }else{
            abort(403, 'You are requested type '.$request->page_name.' does not exist');
        }
    }


}
