<?php

namespace App\Http\Controllers\app;

use App\Http\Controllers\Controller;
use App\Models\HomeHeading;
use App\Models\MaidService;
use App\Models\Service;
use App\Models\ServiceDetailsPageHeading;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

class ServiceController extends Controller
{
    public function __construct()
    {
        $this->middleware('is_verify_email');
    }

    public function service()
    {
        $title = "Service List";
        $serviceList = Service::latest()->get();
        $type = 'service';
        $home_heading = HomeHeading::type('service')->first();

        return view('app.services.list', compact('serviceList', 'title', 'type','home_heading'));
    }

    public function service_create()
    {
        $key = "Create";
        $title = "Create Service";
        $type = "service";
        return view('app.services.form', compact('key', 'title', 'type'));
    }

    public function service_store(Request $request)
    {
        $validatedData = $request->validate([
            'title_en' => 'required|min:2|max:255|unique:services,title_en,NULL,id,deleted_at,NULL',
            'title_ar' => 'required|min:2|max:255',
            'description_en' => 'required',
            'description_ar' => 'required',
            'image' => 'image|mimes:jpeg,png,jpg|max:512',
        ]);
        $service = new Service;
        if ($request->hasFile('image')) {
            $service->image_webp = uploadWebpImage($request->image, 'uploads/service/image/webp/', $request->title_en);
            $service->image = uploadFile($request->image, 'uploads/service/image/', $request->title_en);
        }
        $sort_order = Service::latest('sort_order')->first();
        if ($sort_order) {
            $sort_number = ($sort_order->sort_order + 1);
        } else {
            $sort_number = 1;
        }
        $service->sort_order = $sort_number;

        $service->title_en = $request->title_en ?? '';
        $service->title_ar = $request->title_ar ?? '';
        $service->description_en = $request->description_en ?? '';
        $service->description_ar = $request->description_ar ?? '';
        $service->alternate_description_en = $request->alternate_description_en ?? '';
        $service->alternate_description_ar = $request->alternate_description_ar ?? '';
        $service->image_attribute = $request->image_attribute ?? '';
        if ($service->save()) {
            session()->flash('success', "Service '" . $service->title_en . "' has been added successfully");
            return redirect(sitePrefix() . 'service');
        } else {
            return back()->withInput($request->input())->withErrors("Error while updating the service");
        }
    }

    public function service_edit(Request $request, $id)
    {
        $key = "Update";
        $title = "Update Service";
        $service = Service::find($id);
        if ($service) {
            $type = "service";
            return view('app.services.form', compact('key', 'title', 'service', 'type'));
        } else {
            return view('web.error.404');
        }

    }

    public function service_update(Request $request, $id)
    {
        $service = Service::find($id);
        $validatedData = $request->validate([
            'title_en' => 'required|min:2|max:255|unique:services,title_en,' . $id . ',id,deleted_at,NULL',
            'title_ar' => 'required|min:2|max:255',
            'description_en' => 'required',
            'description_ar' => 'required',
            'image' => 'image|mimes:jpeg,png,jpg|max:512',
        ]);
        if ($request->hasFile('image')) {
            deleteFile($service, 'image');
            deleteFile($service, 'image_webp');
            $service->image_webp = uploadWebpImage($request->image, 'uploads/service/image/webp/', $request->title_en);
            $service->image = uploadFile($request->image, 'uploads/service/image/', $request->title_en);
        }
        $service->title_en = $request->title_en ?? '';
        $service->title_ar = $request->title_ar ?? '';
        $service->description_en = $request->description_en ?? '';
        $service->description_ar = $request->description_ar ?? '';
        $service->alternate_description_en = $request->alternate_description_en ?? '';
        $service->alternate_description_ar = $request->alternate_description_ar ?? '';
        $service->image_attribute = $request->image_attribute ?? '';
        $service->updated_at = now();
        if ($service->save()) {
            session()->flash('success', "Service '" . $service->title_en . "' has been updated successfully");
            return redirect(sitePrefix() . 'service');
        } else {
            return back()->withInput($request->input())->withErrors("Error while updating the service");
        }
    }

    public function service_delete(Request $request)
    {
        if (isset($request->id) && $request->id != null) {
            $service = Service::find($request->id);
            if ($service) {
                $maid = MaidService::where('service_id', $request->id)->count();
                if ($maid > 0) {
                    return response()->json(['status' => false, 'message' => 'Maids with Service "' . $service->title_en . '" exist']);
                }else{
                    deleteFile($service, 'image');
                    deleteFile($service, 'image_webp');
                    if ($service->delete()) {
                        echo(json_encode(array('status' => true)));
                    } else {
                        echo(json_encode(array('status' => false, 'message' => 'Some error occurred,please try after sometime')));
                    }
                }

            } else {
                echo(json_encode(array('status' => false, 'message' => 'Model class not found')));
            }
        } else {
            echo(json_encode(array('status' => false, 'message' => 'Empty value submitted')));
        }
    }
}
