<?php

namespace App\Http\Controllers\app;

use App\Http\Controllers\Controller;
use App\Models\Country;
use App\Models\Maid;
use App\Models\Service;
use App\Models\SkillSet;
use App\Models\TeamPage;
use Illuminate\Http\Request;

class MaidController extends Controller
{
    public function __construct()
    {
        $this->middleware('is_verify_email');
    }

    public function team()
    {
        $title = "Home Team ";
        $team = TeamPage::first();
        return view('app.team.team_page', compact('title', 'team'));
    }

    public function team_store(Request $request)
    {
        $validatedData = $request->validate([
            'title_en' => 'required|min:2|max:230',
            'title_ar' => 'required|min:2|max:230',
            'sub_title_en' => 'required|min:2|max:230',
            'sub_title_ar' => 'required|min:2|max:230',
            'description_en' => 'required',
            'description_ar' => 'required',
            'button_txt_en' => 'nullable|min:2|max:230',
            'button_txt_ar' => 'nullable|min:2|max:230',
            'button_url' => 'nullable|min:2|max:230',
        ]);

        if ($request->id == 0) {
            $team = new TeamPage;
        } else {
            $team = TeamPage::find($request->id);
            $team->updated_at = now();
        }
        $team->title_en = $validatedData['title_en'];
        $team->title_ar = $validatedData['title_ar'];
        $team->sub_title_en = $validatedData['sub_title_en'];
        $team->sub_title_ar = $validatedData['sub_title_ar'];
        $team->description_en = $validatedData['description_en'];
        $team->description_ar = $validatedData['description_ar'];

        $team->button_txt_en = $validatedData['button_txt_en'];
        $team->button_txt_ar = $validatedData['button_txt_ar'];
        $team->button_url = $validatedData['button_url'];

        if ($team->save()) {
            session()->flash('success', "Team Page has been updated successfully");
            return redirect(sitePrefix() . 'team');
        } else {
            return back()->with('error', 'Error while creating the Team Page');
        }
    }

    public function maid()
    {
        $title = "Maid List";
        $maidList = Maid::latest()->get();
        $type = 'maid';
        return view('app.maid.list', compact('maidList', 'title', 'type'));
    }

    public function maid_create()
    {
        $key = "Create";
        $title = "Create Maid";
        $type = "maid";
        $countries = Country::active()->get(['id', 'nationality_en']);
        $services = Service::active()->get(['id', 'title_en']);
        $skillSets = SkillSet::active()->get(['id', 'title_en']);
        return view('app.maid.form', compact('key', 'title', 'type', 'countries', 'services', 'skillSets'));
    }

    public function maid_store(Request $request)
    {
        $request->validate([
            'name_en' => 'required|min:2|max:255',
            'name_ar' => 'required|min:2|max:255',
//            'maid_id' => 'required|unique:maids,maid_id,NULL,id,deleted_at,NULL',
            'email' => 'required|email|min:2|max:70',
            'dob' => 'required|date',
            'nationality' => 'required',
            'image' => 'required|image|mimes:jpeg,png,jpg|max:512',
        ]);
        $maid = new Maid;
        if ($request->hasFile('image')) {
            $maid->image_webp = uploadWebpImage($request->image, 'uploads/maid/webp/', $request->name_en);
            $maid->image = uploadFile($request->image, 'uploads/maid/', $request->name_en);
        }

        $maid->name_en = $request->name_en ?? '';
        $maid->name_ar = $request->name_ar ?? '';
        $maid->maid_id = generateMaidId();
        $maid->email = $request->email ?? '';
        $maid->dob = $request->dob ?? '';
        $maid->country_id = $request->nationality ?? '';
        $maid->experience_year = $request->experience_year ?? 0;
        $maid->experience_month = $request->experience_month ??0;
        $maid->video_url = $request->video_url ?? '';
        $maid->image_attribute = $request->image_attribute ?? '';
        if ($maid->save()) {
            $maid->services()->sync($request->services);
            $maid->skill_sets()->sync($request->skill_sets);
            session()->flash('success', "Maid '" . $maid->name_en . "' has been added successfully");
            return redirect(sitePrefix() . 'team/maid');
        } else {
            return back()->withInput($request->input())->withErrors("Error while updating the maid");
        }
    }

    public function maid_edit(Request $request, $id)
    {
        $key = "Update";
        $title = "Update Maid";
        $maid = Maid::find($id);
        if ($maid) {
            $type = "maid";
            $countries = Country::active()->get(['id', 'nationality_en']);
            $services = Service::active()->get(['id', 'title_en']);
            $skillSets = SkillSet::active()->get(['id', 'title_en']);
            return view('app.maid.form', compact('key', 'title', 'maid', 'type', 'countries', 'services', 'skillSets'));
        } else {
            return view('web.error.404');
        }

    }

    public function maid_update(Request $request, $id)
    {
        $maid = Maid::find($id);
        $request->validate([
            'name_en' => 'required|min:2|max:255',
            'name_ar' => 'required|min:2|max:255',
//            'maid_id' => 'required|unique:maids,maid_id,' . $id . ',id,deleted_at,NULL',
            'email' => 'required|email|min:2|max:70',
            'dob' => 'required|date',
            'nationality' => 'required',
            'image' => 'image|mimes:jpeg,png,jpg|max:512',
        ]);
        if ($request->hasFile('image')) {
            deleteFile($maid, 'image');
            deleteFile($maid, 'image_webp');
            $maid->image_webp = uploadWebpImage($request->image, 'uploads/maid/webp/', $request->name_en);
            $maid->image = uploadFile($request->image, 'uploads/maid/', $request->name_en);
        }
        $maid->name_en = $request->name_en ?? '';
        $maid->name_ar = $request->name_ar ?? '';
//        $maid->maid_id = $request->maid_id ?? '';
        $maid->email = $request->email ?? '';
        $maid->dob = $request->dob ?? '';
        $maid->country_id = $request->nationality ?? '';
        $maid->experience_year = $request->experience_year ?? '';
        $maid->experience_month = $request->experience_month ?? '';
        $maid->video_url = $request->video_url ?? '';
        $maid->image_attribute = $request->image_attribute ?? '';
        $maid->updated_at = now();
        if ($maid->save()) {
            $maid->services()->sync($request->services);
            $maid->skill_sets()->sync($request->skill_sets);
            session()->flash('success', "Maid '" . $maid->name_en . "' has been updated successfully");
            return redirect(sitePrefix() . 'team/maid');
        } else {
            return back()->withInput($request->input())->withErrors("Error while updating the maid");
        }
    }

    public function delete_maid(Request $request)
    {
        if (isset($request->id) && $request->id != null) {
            $maid = Maid::find($request->id);
            if ($maid) {
                deleteFile($maid, 'image');
                deleteFile($maid, 'image_webp');
                if ($maid->delete()) {
                    echo(json_encode(array('status' => true)));
                } else {
                    echo(json_encode(array('status' => false, 'message' => 'Some error occurred,please try after sometime')));
                }
            } else {
                echo(json_encode(array('status' => false, 'message' => 'Model class not found')));
            }
        } else {
            echo(json_encode(array('status' => false, 'message' => 'Empty value submitted')));
        }
    }
}
