<?php

namespace App\Http\Controllers\app;

use App\Http\Controllers\Controller;
use App\Models\HomeBanner;
use App\Models\HomeHeading;
use App\Models\HomeMediaHeading;
use App\Models\HomeServiceHeading;
use App\Models\HomeTestimonialHeading;
use App\Models\Testimonial;
use App\Models\KeyFeature;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Str;

class HomeController extends Controller
{
    public function __construct()
    {
        $this->middleware('is_verify_email');
    }

    public function dashboard()
    {
        $title = "Dashboard";
        return view('app.landing', compact('title'));
    }

    public function slider_list()
    {
        $title = "Slider List";
        $sliderList = HomeBanner::get();
        return view('app.home.slider.slider_list', compact('sliderList', 'title'));
    }

    public function slider_create()
    {
        $key = "Create";
        $title = "Create Slider";
        return view('app.home.slider.slider_form', compact('key', 'title'));
    }

    public function slider_store(Request $request)
    {
        $validatedData = $request->validate([
            'title_en'=>'required|min:2|max:230',
            'title_ar'=>'required|min:2|max:230',
            'description_en'=>'required|min:2|max:230',
            'description_ar'=>'required|min:2|max:230',
            'button_txt_en'=>'required|min:2|max:230',
            'button_txt_ar'=>'required|min:2|max:230',
            'button_url'=>'required|min:2|max:230',
//            'image' => 'required|image|mimes:jpeg,png,jpg',
            'image_meta_tag' => 'required|min:5',
            'show_enquiry'=>'required',

        ]);
        $slider = new HomeBanner;
        if ($request->hasFile('image')) {
            $slider->image_webp = uploadWebpImage($request->image, 'uploads/home/slider/webp_image/', 'home-slider');
            $slider->image = uploadFile($request->image, 'uploads/home/slider/image/', 'home-slider');
        }

        $sort_order = HomeBanner::orderBy('sort_order', 'DESC')->first();
        if ($sort_order) {
            $sort_number = ($sort_order->sort_order + 1);
        } else {
            $sort_number = 1;
        }
        $slider->title_en = $request->title_en ?? '';
        $slider->title_ar = $request->title_ar ?? '';
        $slider->description_en = $request->description_en ?? '';
        $slider->description_ar = $request->description_ar ?? '';
        $slider->button_txt_en = $request->button_txt_en ?? '';
        $slider->button_txt_ar = $request->button_txt_ar ?? '';
        $slider->image_meta_tag = $validatedData['image_meta_tag'];
        $slider->button_url = $request->button_url??'';
        $slider->show_enquiry = $request->show_enquiry??'Yes';

        $slider->sort_order = $sort_number;
        if ($slider->save()) {
            session()->flash('success', "'Slider' has been added successfully");
            return redirect(sitePrefix().'home/slider');
        } else {
            return back()->withInput($request->input())->withErrors("Error while updating the content");
        }
    }

    public function slider_edit(Request $request, $id)
    {
        $key = "Update";
        $title = "Update Banner";
        $slider = HomeBanner::find($id);
        if ($slider) {
            return view('app.home.slider.slider_form',
                compact('key', 'slider', 'title'));
        } else {
            return view('app.errors.404');
        }
    }

    public function slider_update(Request $request, $id)
    {
//        dd($request->all());
        $slider = HomeBanner::find($id);
        $validatedData = $request->validate([
            'title_en'=>'required|min:2|max:230',
            'title_ar'=>'required|min:2|max:230',
            'description_en'=>'required|min:2|max:230',
            'description_ar'=>'required|min:2|max:230',
            'button_txt_en'=>'required|min:2|max:230',
            'button_txt_ar'=>'required|min:2|max:230',
            'button_url'=>'required|min:2|max:230',
//            'image' => 'required|image|mimes:jpeg,png,jpg',
            'image_meta_tag' => 'required|min:5',
            'show_enquiry'=>'required',

        ]);

        if ($request->hasFile('image')) {
            if (File::exists(public_path($slider->image))) {
                File::delete(public_path($slider->image));
            }
            if (File::exists(public_path($slider->image_webp))) {
                File::delete(public_path($slider->image_webp));
            }
            $slider->image_webp = uploadWebpImage($request->image, 'uploads/home/slider/webp_image/', 'home-slider');
            $slider->image = uploadFile($request->image, 'uploads/home/slider/image/', 'home-slider');
        }

        $slider->title_en = $request->title_en ?? '';
        $slider->title_ar = $request->title_ar ?? '';
        $slider->description_en = $request->description_en ?? '';
        $slider->description_ar = $request->description_ar ?? '';
        $slider->button_txt_en = $request->button_txt_en ?? '';
        $slider->button_txt_ar = $request->button_txt_ar ?? '';
       $slider->image_meta_tag = $validatedData['image_meta_tag'];
        $slider->button_url = $request->button_url??'';
        $slider->show_enquiry = $request->show_enquiry??'Yes';
        $slider->updated_at = date('Y-m-d h:i:s');
        if ($slider->save()) {
            session()->flash('success', "'Slider' has been updated successfully");
            return redirect(sitePrefix().'home/slider');
        } else {
            return back()->withInput($request->input())->withErrors("Error while updating the content");
        }
    }

    public function delete_slider(Request $request)
    {
        if (isset($request->id) && $request->id != NULL) {
            $slider = HomeBanner::find($request->id);
            if ($slider) {
                $slider->sort_order = null;
                $slider->save();
                if (File::exists($slider->desktop_image)) {
                    File::delete($slider->desktop_image);
                }
                if (File::exists($slider->desktop_webp_image)) {
                    File::delete($slider->desktop_webp_image);
                }
                if (File::exists($slider->mobile_image)) {
                    File::delete($slider->mobile_image);
                }
                if (File::exists($slider->mobile_webp_image)) {
                    File::delete($slider->mobile_webp_image);
                }
                $deleted = $slider->delete();
                if ($deleted == true) {
                    return response()->json(['status' => true]);
                } else {
                    return response()->json(['status' => false, 'message' => 'Some error occurred,please try after sometime']);
                }
            } else {
                return response()->json(['status' => false, 'message' => 'Model class not found']);
            }
        } else {
            return response()->json(['status' => false, 'message' => 'Empty value submitted']);
        }
    }


    public function keyfeature()
    {
        $title = "Key Feature List";
        $keyfeatureList = KeyFeature::get();
        return view('app.home.keyfeature.list',compact('keyfeatureList','title'));
    }

    public function keyfeature_create()
    {
        $key = "Add";
        $title = "Add Key Feature";
        return view('app.home.keyfeature.form',compact('key','title'));
    }

    public function keyfeature_store(Request $request)
    {
//        dd($request->all());
        $validatedData = $request->validate([
            'title_en'=>'required|min:2|max:225',
            'title_ar'=>'required|min:2|max:225',
            'sub_title_en'=>'required|min:2|max:225',
            'sub_title_ar'=>'required|min:2|max:225',
        ]);
        $keyfeature = new KeyFeature();
        $keyfeature->title_en = $validatedData['title_en'];
        $keyfeature->title_ar = $validatedData['title_ar'];
        $keyfeature->sub_title_en = $validatedData['sub_title_en'];
        $keyfeature->sub_title_ar = $validatedData['sub_title_ar'];

        $sort_order = KeyFeature::orderBy('sort_order', 'DESC')->first();
        if ($sort_order) {
            $sort_number = ($sort_order->sort_order + 1);
        } else {
            $sort_number = 1;
        }
        $keyfeature->sort_order = $sort_number;
        if($keyfeature->save()){
            session()->flash('success', 'Key Feature has been added successfully');
            return redirect(sitePrefix().'home/key-feature');
        }else{
            return back()->withInput($request->input())->withErrors("Error while updating the content");
        }
    }

    public function keyfeature_edit(Request $request, $id)
    {
        $key = "Update";
        $title = "Update Key Feature";
        $keyfeature = KeyFeature::find($id);
        if($keyfeature){
            return view('app.home.keyfeature.form', compact('keyfeature','title','key'));
        }else{
            return view('app/errors/404');
        }
    }

    public function keyfeature_update(Request $request, $id)
    {
        $keyfeature =  KeyFeature::find($id);
        $validatedData = $request->validate([
            'title_en'=>'required|min:2|max:225',
            'title_ar'=>'required|min:2|max:225',
            'sub_title_en'=>'required|min:2|max:225',
            'sub_title_ar'=>'required|min:2|max:225',
        ]);
        $keyfeature->title_en = $validatedData['title_en'];
        $keyfeature->title_ar = $validatedData['title_ar'];
        $keyfeature->sub_title_en = $validatedData['sub_title_en'];
        $keyfeature->sub_title_ar = $validatedData['sub_title_ar'];

        $keyfeature->updated_at = date('Y-m-d h:i:s');
        if($keyfeature->save()){
            session()->flash('success', 'Key Feature has been updated successfully');
            return redirect(sitePrefix().'home/key-feature');
        }else{
            return back()->withInput($request->input())->withErrors("Error while updating the content");
        }
    }

    public function delete_keyfeature(Request $request){
        if(isset($request->id) && $request->id!=NULL){
            $keyfeature = KeyFeature::find($request->id);
            if($keyfeature){
                DB::beginTransaction();
                $deleted = $keyfeature->delete();
                if($deleted==true){
                    DB::commit();
                    echo(json_encode(array('status'=>true)));
                }else{
                    echo(json_encode(array('status'=>false,'message'=>'Some error occured,please try after sometime')));
                }
            }else{
                DB::rollBack();
                echo(json_encode(array('status'=>false,'message'=>'Model class not found')));
            }
        }else{
            echo(json_encode(array('status'=>false,'message'=>'Empty value submitted')));
        }
    }



    public function testimonial()
    {
        $title = "Testimonial List";
        $testimonialList = Testimonial::get();
        $home_heading = HomeHeading::type('testimonial')->first();

        return view('app.home.testimonial.list',compact('testimonialList','title','home_heading'));
    }

    public function testimonial_create()
    {
        $key = "Add";
        $title = "Add Testimonial";
        return view('app.home.testimonial.form',compact('key','title'));
    }

    public function testimonial_store(Request $request)
    {
        $validatedData = $request->validate([
            'name_en'=>'required|min:2|max:60',
            'name_ar'=>'required|min:2|max:60',
            'designation_en'=>'min:2|max:225',
            'designation_ar'=>'min:2|max:225',
            'title_en'=>'required|min:2|max:225',
            'title_ar'=>'required|min:2|max:225',
            'message_en'=>'required|min:2',
            'message_ar'=>'required|min:2|',
            'review_type'=>'required',
            'image' => 'image|mimes:jpeg,png,jpg|max:512',
        ]);

        $testimonial = new Testimonial;
        if ($request->hasFile('image')) {
            $testimonial->webp_image = uploadWebpImage($request->image, 'uploads/testimonial/webp_image/', $request->name_en);
            $testimonial->image = uploadFile($request->image, 'uploads/testimonial/image/', $request->name_ar);
        }
        $testimonial->name_en=$validatedData['name_en'];
        $testimonial->name_ar=$validatedData['name_ar'];
        $testimonial->designation_en=$validatedData['designation_en'];
        $testimonial->designation_ar=$validatedData['designation_ar'];
        $testimonial->title_en=$validatedData['title_en'];
        $testimonial->title_ar=$validatedData['title_ar'];
        $testimonial->message_en=$validatedData['message_en'];
        $testimonial->message_ar=$validatedData['message_ar'];
        $testimonial->rating=$request->rating??0;
        $testimonial->review_type=$request->review_type??'Normal';
        $testimonial->image_attribute = $request->image_meta_tag??'';
        $sort_order = Testimonial::orderBy('sort_order', 'DESC')->first();
        if ($sort_order) {
            $sort_number = ($sort_order->sort_order + 1);
        } else {
            $sort_number = 1;
        }
        $testimonial->sort_order = $sort_number;
        if($testimonial->save()){
            session()->flash('success', 'Testimonial has been added successfully');
            return redirect(sitePrefix().'home/testimonial');
        }else{
            return back()->withInput($request->input())->withErrors("Error while updating the content");
        }
    }

    public function testimonial_edit(Request $request, $id)
    {
        $key = "Update";
        $title = "Update Testimonial";
        $testimonial = Testimonial::find($id);
        if($testimonial){
            return view('app.home.testimonial.form', compact('testimonial','title','key'));
        }else{
            return view('app/errors/404');
        }
    }

    public function testimonial_update(Request $request, $id)
    {
        $testimonial =  Testimonial::find($id);
        $validatedData = $request->validate([
            'name_en'=>'required|min:2|max:60',
            'name_ar'=>'required|min:2|max:60',
            'designation_en'=>'min:2|max:225',
            'designation_ar'=>'min:2|max:225',
            'title_en'=>'required|min:2|max:225',
            'title_ar'=>'required|min:2|max:225',
            'message_en'=>'required|min:2',
            'message_ar'=>'required|min:2|',
            'review_type'=>'required',
            'image' => 'image|mimes:jpeg,png,jpg|max:512',
        ]);

        if ($request->hasFile('image')) {
            if (File::exists(public_path($testimonial->image))) {
                File::delete(public_path($testimonial->image));
            }
            if (File::exists(public_path($testimonial->webp_image))) {
                File::delete(public_path($testimonial->webp_image));
            }
            $testimonial->webp_image = uploadWebpImage($request->image, 'uploads/testimonial/webp_image/', $request->name_en);
            $testimonial->image = uploadFile($request->image, 'uploads/testimonial/image/', $request->name_en);
        }
        $testimonial->name_en=$validatedData['name_en'];
        $testimonial->name_ar=$validatedData['name_ar'];
        $testimonial->designation_en=$validatedData['designation_en'];
        $testimonial->designation_ar=$validatedData['designation_ar'];
        $testimonial->title_en=$validatedData['title_en'];
        $testimonial->title_ar=$validatedData['title_ar'];
        $testimonial->message_en=$validatedData['message_en'];
        $testimonial->message_ar=$validatedData['message_ar'];
        $testimonial->rating=$request->rating??0;
        $testimonial->review_type=$request->review_type??'Normal';
        $testimonial->image_attribute = $request->image_meta_tag??'';
        $testimonial->updated_at = date('Y-m-d h:i:s');
        if($testimonial->save()){
            session()->flash('success', 'Testimonial has been updated successfully');
            return redirect(sitePrefix().'home/testimonial');
        }else{
            return back()->withInput($request->input())->withErrors("Error while updating the content");
        }
    }

    public function delete_testimonial(Request $request){
        if(isset($request->id) && $request->id!=NULL){
            $testimonial = Testimonial::find($request->id);
            if($testimonial){
                $image = $testimonial->image;
                $webp_image = $testimonial->webp_image;
                DB::beginTransaction();
                $deleted = $testimonial->delete();
                if($deleted==true){
                    DB::commit();
                    echo(json_encode(array('status'=>true)));
                }else{
                    echo(json_encode(array('status'=>false,'message'=>'Some error occured,please try after sometime')));
                }
            }else{
                DB::rollBack();
                echo(json_encode(array('status'=>false,'message'=>'Model class not found')));
            }
        }else{
            echo(json_encode(array('status'=>false,'message'=>'Empty value submitted')));
        }
    }

    public function sort_order(Request $request)
    {
        if (isset($request->id) && $request->id != NULL) {
            $table = $request->table;
            $appPrefix = 'App';
            $model = $appPrefix . '\\Models\\' . $table;
            if ($request->extra != NULL) {
                $sortOrder = $model::where([['sort_order', '=', $request->sort_order], [$request->extra, '=', $request->extra_key], ['id', '!=', $request->id]])->count();
            } else {
                $sortOrder = $model::where([['sort_order', '=', $request->sort_order], ['id', '!=', $request->id]])->count();
            }
            if ($sortOrder) {
                return response()->json(['status' => false, 'message' => 'Sort order "' . $request->sort_order . '" has been already taken']);
            } else {
                $data = $model::find($request->id);
                $data->sort_order = $request->sort_order;
                if ($data->save()) {
                    return response()->json(['status' => true, 'message' => 'Sort order updated successfully']);
                } else {
                    return response()->json(['status' => false, 'message' => 'Error while updating the sort order']);
                }
            }
        } else {
            return response()->json(['status' => false, 'message' => 'Empty value submitted']);
        }
    }

    public function status_change(Request $request)
    {
        $table = $request->table;
        $state = $request->state;
        $primary_key = $request->primary_key;
        if ($state == 'true') {
            $status = "Active";
        } else {
            $status = "Inactive";
        }
        $appPrefix = 'App';
        $model = $appPrefix . '\\Models\\' . $table;
        $data = $model::find($primary_key);
        $data->status = $status;

        if ($data->save()) {
            echo(json_encode(array('status'=>true,'message'=>'Status has been changed succesfully')));
        } else {
            echo(json_encode(array('status'=>false,'message'=>'Error while changing the status')));
        }
    }

    public function home_service_heading()
    {
        $key = "Update";
        $title = "Home Service Heading";
        $homeHeading = HomeServiceHeading::first();
        return view('app.home.service_heading_form',compact('key','title','homeHeading'));
    }

    public function home_service_heading_store(Request $request)
    {
        $validatedData = $request->validate([
            'title' => 'required|min:2|max:255',
        ]);

        if($request->id==0){
            $home_service_heading = new HomeServiceHeading;
        }else{
            $home_service_heading = HomeServiceHeading::find($request->id);
            $home_service_heading->updated_at = date('Y-m-d h:i:s');
        }
        $home_service_heading->title = $request->title ?? '';
        $home_service_heading->sub_title = $request->sub_title ?? '';
        $home_service_heading->button_text = $request->button_text ?? '';
        $home_service_heading->button_url = $request->button_url ?? '';
        if($home_service_heading->save()){
            session()->flash('success', 'Home-service heading has been updated successfully');
            return redirect(sitePrefix().'home/service-heading');
        }else{
            return back()->with('error', 'Error while updating the home-service heading content');
        }
    }

    public function home_testimonial_heading()
    {
        $key = "Update";
        $title = "Home Testimonial Heading";
        $homeHeading = HomeTestimonialHeading::first();
        return view('app.home.testimonial_heading_form',compact('key','title','homeHeading'));
    }

    public function home_testimonial_heading_store(Request $request)
    {
        $validatedData = $request->validate([
            'title' => 'required|min:2|max:255',
            'sub_title' => 'required|min:2|max:255',
        ]);

        if($request->id==0){
            $home_testimonial_heading = new HomeTestimonialHeading;
        }else{
            $home_testimonial_heading = HomeTestimonialHeading::find($request->id);
            $home_testimonial_heading->updated_at = date('Y-m-d h:i:s');
        }
        $home_testimonial_heading->title = $request->title ?? '';
        $home_testimonial_heading->sub_title = $request->sub_title ?? '';
        if($home_testimonial_heading->save()){
            session()->flash('success', 'Home-testimonial heading has been updated successfully');
            return redirect(sitePrefix().'home/testimonial-heading');
        }else{
            return back()->with('error', 'Error while updating the home-service heading content');
        }
    }

    public function home_media_heading()
    {
        $key = "Update";
        $title = "Home Media Heading";
        $homeHeading = HomeMediaHeading::first();
        return view('app.home.media_heading_form',compact('key','title','homeHeading'));
    }

    public function home_media_heading_store(Request $request)
    {
        $validatedData = $request->validate([
            'title' => 'required|min:2|max:255',
            'sub_title' => 'required|min:2|max:255',
            'description' => 'required|min:2|max:255',
        ]);

        if($request->id==0){
            $home_media_heading = new HomeMediaHeading;
        }else{
            $home_media_heading = HomeMediaHeading::find($request->id);
            $home_media_heading->updated_at = date('Y-m-d h:i:s');
        }
        $home_media_heading->title = $request->title ?? '';
        $home_media_heading->sub_title = $request->sub_title ?? '';
        $home_media_heading->description = $request->description ?? '';
        if($home_media_heading->save()){
            session()->flash('success', 'Home-media heading has been updated successfully');
            return redirect(sitePrefix().'home/media-heading');
        }else{
            return back()->with('error', 'Error while updating the home-service heading content');
        }
    }

    public function delete_file(Request $request)
    {
        $filetype = explode('/', $request->type);
        $table = $filetype[0];
        $field = $filetype[1];
        $id = $filetype[2];
        $webp_field = isset($filetype[3]) ? $filetype[3] : '';
        $model = 'App\\Models\\' . $table;
        $data = $model::find($id);
        if ($data) {
            if (File::exists(public_path($data->$field))) {
                File::delete(public_path($data->$field));
            }
            if($webp_field != ''){
                if (File::exists(public_path($data->$webp_field))) {
                    File::delete(public_path($data->$webp_field));
                }
                $data->$webp_field = NULL;
            }
            $data->$field = NULL;
            if ($data->save()) {
                return response()->json(['status' => true, 'message' => 'File has been removed']);
            } else {
                return response()->json(['status' => false, 'message' => 'Unable to remove the file']);
            }
        } else {
            return response()->json(['status' => false, 'message' => 'Unable to find the file']);
        }
    }


    public function update_home_heading(Request $request)
    {
        if (isset($request->type)) {
                $home_heading = HomeHeading::type($request->type)->first();
            if (!$home_heading) {
                $home_heading = new HomeHeading;
            }
            $home_heading->type = $request->type;
            $home_heading->title_en = $request->home_title_en;
            $home_heading->title_ar = $request->home_title_ar;
            $home_heading->sub_title_en = $request->home_sub_title_en;
            $home_heading->sub_title_ar = $request->home_sub_title_ar;
            if ($home_heading->save()) {
                return response()->json(['status' => true, 'message' => 'Home heading for ' . $request->type . ' saved successfully']);
            } else {
                return response()->json(['status' => false, 'message' => 'Error while saving Home heading']);
            }
        } else {
            return response()->json(['status' => false, 'message' => 'Empty value submitted']);
        }
    }


    public function display_to_home(Request $request)
    {
        $table = $request->table;
        $state = $request->state;
        $primary_key = $request->id;
        $field = $request->field;
        if ($state == 'true') {
            $status = "Yes";
        } else {
            $status = "No";
        }
        $model = 'App\\Models\\' . $table;
        $data = $model::find($primary_key);
        if ($data != NULL) {
            $data->$field = $status;
            if ($data->save()) {
                return response()->json(['status' => true, 'message' => Str::title(Str::replace('_', ' ', $field)) . ' status has been changed']);
            } else {
                return response()->json(['status' => false, 'message' => 'Error while changing the display to home option']);
            }
        } else {
            return response()->json(['status' => false, 'message' => 'Error! Data not found']);
        }
    }


}
