<?php

namespace App\Http\Controllers\app;

use App\Http\Controllers\Controller;
use App\Models\Enquiry;
use App\Models\Newsletter;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
class EnquiryController extends Controller
{
    //

    public function enquiry_list()
    {
        // dd($type);
        $title = "Enquiry List";
        $enquiryList = Enquiry::where('type','!=','booking')->orderBy('id', 'desc')->get();
        return view('app.enquiry.list', compact('enquiryList', 'title'));

    }

    public function enquiry_view($id)
    {
        $title = "View Request";
        $enquiry = Enquiry::find($id);
        return view('app.enquiry.view', compact('enquiry', 'title'));

    }


    public function delete_enquiry(Request $request)
    {
        if (isset($request->id) && $request->id != null) {
            $contact = Enquiry::find($request->id);
            if ($contact) {
                $deleted = $contact->delete();
                if ($deleted == true) {
                    echo (json_encode(array('status' => true)));
                } else {
                    echo (json_encode(array('status' => false, 'message' => 'Some error occured,please try after sometime')));
                }
            } else {
                echo (json_encode(array('status' => false, 'message' => 'Model class not found')));
            }
        } else {
            echo (json_encode(array('status' => false, 'message' => 'Empty value submitted')));
        }
    }


    public function reply_to_enquiry(Request $request)
    {
        if (isset($request->replay) && $request->replay != null) {
            //    dd($request->all());
            $contact = Enquiry::find($request->id);
            if ($contact) {
                DB::beginTransaction();
                $contact->reply = $request->replay;
                $contact->reply_date = date('Y-m-d h:i:s');
                if ($contact->save()) {
                    if (SendContactReply($contact)) {
                        DB::commit();
                        echo (json_encode(array('status' => true, 'message' => 'Replay saved successfully')));
                    } else {
                        DB::rollBack();
                        echo (json_encode(array('status' => false, 'message' => 'Some error occured,please try after sometime')));
                    }
                } else {
                    DB::rollBack();
                    echo (json_encode(array('status' => false, 'message' => 'Some error occured,please try after sometime')));
                }
            } else {
                echo (json_encode(array('status' => false, 'message' => 'Model class not found')));
            }
        } else {
            echo (json_encode(array('status' => false, 'message' => 'Empty value submitted')));
        }
    }


    public function delete_multi_enquiry(Request $request)
    {
        if (isset($request->id) && $request->id != null) {
            $contactArray = explode(',', $request->id);
            $successArray = array();
            foreach ($contactArray as $con) {
                $contact = Enquiry::find($con);
                $deleted = $contact->delete();
                if ($deleted == true) {
                    $successArray[] = '1';
                }
            }
            if ($successArray) {
                echo (json_encode(array('status' => true)));
            }
        } else {
            echo (json_encode(array('status' => false, 'message' => 'Empty value submitted')));
        }
    }



    public function booking_list($type)
    {

        $title = "Enquiry List";
        if($type=='maid'){
            $enquiryList = Enquiry::whereNotNull('maid_id')->orderBy('id', 'desc')->get();
        }else{
            $enquiryList = Enquiry::whereNotNull('visa_service_id')->orderBy('id', 'desc')->get();

        }
        return view('app.booking.list', compact('enquiryList', 'title','type'));

    }

    public function booking_view($type,$id)
    {
//        dd($type,$id);
        $title = "View Request";
        $enquiry = Enquiry::find($id);
        return view('app.booking.view', compact('enquiry', 'title','type'));

    }

    public function newsletter()
    {
        $title = "Newsletter Subscribers";
        $newsletterList = Newsletter::latest('id')->get();
        return view('app.newsletter.list', compact('newsletterList', 'title'));

    }

    public function delete_multi_newsletter(Request $request)
    {
        if (isset($request->id) && $request->id != null) {
            $newsletterArray = explode(',', $request->id);
            $successArray = array();
            foreach ($newsletterArray as $item_id) {
                $newsletter = Newsletter::find($item_id);
                $deleted = $newsletter->delete();
                if ($deleted == true) {
                    $successArray[] = '1';
                }
            }
            if ($successArray) {
                return response()->json(['status' => true]);
            } else {
                return response()->json([
                    'status' => false,
                    'message' => 'Some error occurred while deleting elements.,please try after sometime'
                ]);
            }
        } else {
            return response()->json(['status' => false, 'message' => 'Empty value submitted']);
        }
    }

    public function delete_newsletter(Request $request)
    {
        if (isset($request->id) && $request->id != null) {
            $newsletter = Newsletter::find($request->id);
            if ($newsletter) {
                $deleted = $newsletter->delete();
                if ($deleted == true) {
                    return response()->json(['status' => true]);
                } else {
                    return response()->json([
                        'status' => false,
                        'message' => 'Some error occurred,please try after sometime'
                    ]);
                }
            } else {
                return response()->json(['status' => false, 'message' => 'Model class not found']);
            }
        } else {
            return response()->json(['status' => false, 'message' => 'Empty value submitted']);
        }
    }


}
