<?php

namespace App\Http\Controllers\app;

use App\Http\Controllers\Controller;
use App\Models\Banner;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

class BannerController extends Controller
{
    public function __construct()
    {
        $this->middleware('is_verify_email');
    }

    public function banner($type)
    {
        $type = trim(ucfirst($type));
        $key = "Update";
        $title = "Update " . $type . ' Banner';
        $banner = Banner::where('type', $type)->first();
        return view('app.banner.banner_form', compact('key', 'title', 'banner', 'type'));
    }

    public function banner_store(Request $request)
    {
        $type_array = array('About', 'Blog', 'Maids', 'Services', 'Visa-services', 'Contact', 'Privacy', 'Terms');
        if (in_array($request->type, $type_array)) {
            if ($request->id == 0) {
                $banner = new Banner;
                $validatedData = $request->validate([
                    'type' => 'required',
                    'banner_title_en' => 'required|min:2|max:255',
                    'banner_title_ar' => 'required|min:2|max:255',
//                    'image' => 'required|image|mimes:jpeg,png,jpg|max:512',
                    'banner_attribute' => 'min:2'
                ]);
            } else {
                $validatedData = $request->validate([
                    'type' => 'required',
                    'banner_title_en' => 'required|min:2|max:255',
                    'banner_title_ar' => 'required|min:2|max:255',
//                    'image' => 'image|mimes:jpeg,png,jpg|max:512',
                    'banner_attribute' => 'min:2'
                ]);
                $banner = Banner::find($request->id);
                $banner->updated_at = now();
            }

            if ($request->hasFile('image')) {
                if (File::exists($banner->image)) {
                    File::delete($banner->image);
                }
                if (File::exists($banner->image_webp)) {
                    File::delete($banner->image_webp);
                }
                $banner->image_webp = uploadWebpImage($request->image,
                    'uploads/webp_banner/' . strtolower($request->type) . '/webp_banner/', strtolower($request->type));
                $banner->image = uploadFile($request->image,
                    'uploads/banner/' . strtolower($request->type) . '/banner/', strtolower($request->type));
            }
            $banner->banner_title_en = $validatedData['banner_title_en'];
            $banner->banner_title_ar = $validatedData['banner_title_ar'];
            $banner->type = $validatedData['type'];
            $banner->banner_attribute = $validatedData['banner_attribute'];

            if ($banner->save()) {
                session()->flash('success', $request->type . ' banner has been updated successfully');
                return redirect(sitePrefix() . 'banner/' . strtolower($request->type));
            } else {
                return back()->with('error', 'Error while updating the ' . $request->type);
            }
        } else {
            abort(403, 'You are requested type ' . $request->type . ' does not exist');
        }
    }

    public function banner_delete(Request $request)
    {
        if ($request->type) {
            $typeData = explode('/', $request->type);
            $type = $typeData[0];
            $banner_webp = $typeData[1];
            $banner = Banner::where('type', $type)->first();
            $removalFile = $banner->$banner_webp;
            $banner->$banner_webp = NULL;
            if ($banner->save()) {
                if (File::exists($banner->banner)) {
                    File::delete($banner->banner);
                }
                if (File::exists($banner->webp_banner)) {
                    File::delete($banner->webp_banner);
                }
                if (File::exists($banner->mobile_banner)) {
                    File::delete($banner->mobile_banner);
                }
                if (File::exists($banner->mobile_webp_banner)) {
                    File::delete($banner->mobile_webp_banner);
                }
                return response()->json([
                    'status' => true,
                    'success' => 'File has been removed'
                ]);
            } else {
                return response()->json([
                    'status' => false,
                    'success' => 'Unable to remove the file'
                ]);
            }
        } else {
            return response()->json([
                'status' => false,
                'success' => 'Unable to find the file'
            ]);
        }
    }
}
