<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1><i class="nav-icon fas fa-user-shield"></i> Manage <?php echo e($title); ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item">
                                <a href="<?php echo e(url(sitePrefix().'dashboard')); ?>">
                                    Home
                                </a>
                            </li>
                            <li class="breadcrumb-item active"><?php echo e($title); ?></li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <?php if(session('success')): ?>
                            <div class="alert alert-success" role="alert">
                                <button type="button" class="close" data-dismiss="alert">×</button>
                                <?php echo e(session('success')); ?>

                            </div>
                        <?php elseif(session('error')): ?>
                            <div class="alert alert-danger" role="alert">
                                <button type="button" class="close" data-dismiss="alert">×</button>
                                <?php echo e(session('error')); ?>

                            </div>
                        <?php endif; ?>
                        <div class="card card-success card-outline">
                            <div class="box-header" style="height:50px;">
                                <div class="box-tools" style="margin-top: 8px;">
                                    <div class="col-sm-12">
                                        <div class="actions delete_btn" style="display: none;">
                                            <input type="hidden" name="ids" id="ids">
                                            <a href="javascript:void(0);" id="delete_multiple_item_btn"
                                               class="btn btn-danger" data-url="/enquiry/newsletter/delete-multiple">
                                                <i class="fa fa-trash"></i> Delete</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card-body">
                                <table class="table table-bordered table-hover dataTable">
                                    <thead>
                                    <tr>
                                        <th># <input type="checkbox" class="mt-2 ml-3" name="check_all" id="check_all">
                                        </th>
                                        <th>Email</th>
                                        <th>Status</th>
                                        <th>Created Date</th>
                                        <th>Delete</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $newsletterList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $newsletter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($loop->iteration); ?>

                                                <input type="checkbox" class="single_box mt-2 ml-3"
                                                       name="single_box" id="<?php echo e($newsletter->id); ?>" readonly
                                                       value="<?php echo e($newsletter->id); ?>"></td>
                                            <td><?php echo e($newsletter->email); ?></td>
                                            <td>
                                                <label class="switch">
                                                    <input type="checkbox" class="status_check"
                                                           data-url="/status-change" data-table="Newsletter"
                                                           data-field="status" data-pk="<?php echo e($newsletter->id); ?>"
                                                        <?php echo e(($newsletter->status=="Active")?'checked':''); ?>>
                                                    <span class="slider"></span>
                                                </label>
                                            </td>
                                            <td><?php echo e(date("d-M-Y", strtotime($newsletter->created_at))); ?></td>
                                            <td>
                                                <a href="#" class="btn btn-danger mr-2 delete_entry tooltips"
                                                   title="Delete Newsletter" data-url="enquiry/newsletter/delete"
                                                   data-id="<?php echo e($newsletter->id); ?>"><i class="fas fa-trash"></i></a>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('app.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mgtaxhwf/visa.mgtadbeer.com/resources/views/app/newsletter/list.blade.php ENDPATH**/ ?>