

<?php $__env->startSection('content'); ?>
<div class="other-services-page">

  <!-- Hero Section -->
  <section class="services-hero py-5">
    <div class="container">
      <div class="row align-items-center">
        <div class="col-lg-6">
          <div class="hero-content">
            <h1 class="hero-title">Other Services</h1>
            <p class="hero-subtitle">Explore our additional professional services, designed to support your domestic worker visa process and overall convenience.</p>
            <p class="hero-description">
              <strong>Mountain Gate Tadbeer Visa Services</strong> offers complete solutions for domestic worker visas including application, renewal, cancellation, Emirates ID processing, and more. Our professional team ensures a smooth and Fast experience from start to finish.
            </p>
            <div class="hero-actions">
              <a href="https://wa.me/97152666654" class="btn btn-whatsapp">
                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" fill="currentColor" viewBox="0 0 16 16">
                  <path d="M13.601 2.326A7.854 7.854 0 0 0 7.994 0C3.627 0 .068 3.558.064 7.926c0 1.399.366 2.76 1.057 3.965L0 16l4.204-1.102a7.933 7.933 0 0 0 3.79.965h.004c4.368 0 7.926-3.558 7.93-7.93A7.898 7.898 0 0 0 13.6 2.326zM7.994 14.521a6.573 6.573 0 0 1-3.356-.92l-.24-.144-2.494.654.666-2.433-.156-.251a6.56 6.56 0 0 1-1.007-3.505c0-3.626 2.957-6.584 6.591-6.584a6.56 6.56 0 0 1 4.66 1.931 6.557 6.557 0 0 1 1.928 4.66c-.004 3.639-2.961 6.592-6.592 6.592zm3.615-4.934c-.197-.099-1.17-.578-1.353-.646-.182-.065-.315-.099-.445.099-.133.197-.513.646-.627.775-.114.133-.229.148-.423.05-.197-.1-.836-.308-1.592-.985-.59-.525-.985-1.175-1.103-1.372-.114-.198-.011-.304.088-.403.087-.088.197-.232.296-.346.1-.114.133-.198.198-.33.065-.134.034-.248-.015-.347-.05-.099-.445-1.076-.612-1.47-.16-.389-.323-.335-.445-.34-.114-.007-.247-.007-.38-.007a.729.729 0 0 0-.529.247c-.182.198-.691.677-.691 1.654 0 .977.71 1.916.81 2.049.098.133 1.394 2.132 3.383 2.992.47.205.84.326 1.129.418.475.152.904.129 1.246.08.38-.058 1.171-.48 1.338-.943.164-.464.164-.86.114-.943-.049-.084-.182-.133-.38-.232z"/>
                </svg>
                WhatsApp
              </a>
              <a href="http://visa.mgtadbeer.com/visa-service" class="btn btn-primary">Learn More</a>
            </div>
          </div>
        </div>
        <div class="col-lg-6">
          <div class="hero-image">
            <img src="https://royalvisa.ae/wp-content/uploads/2024/03/Getting_Help_with_Your_UAE_Visa_Application_Visa_Services_Available.jpg"
                 class="img-fluid" alt="Other Services Hero">
          </div>
        </div>
      </div>
    </div>
  </section>

  <!-- Services Flip Cards Section -->
  <section class="services-flip-cards py-5">
    <div class="container">
      <div class="section-header text-center mb-5">
        <h2 class="section-title">Other Services</h2>
        <div class="title-underline"></div>
        <p class="section-subtitle">Comprehensive visa and support services for your domestic workers</p>
      </div>

      <div class="flip-cards-grid">
        <?php
          $cards = [
            [
              'title'=>'New Visa Application',
              'icon'=>'<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 16 16"><path d="M0 4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V4zm2-1a1 1 0 0 0-1 1v1h14V4a1 1 0 0 0-1-1H2zm13 4H1v5a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V7z"/><path d="M2 10a1 1 0 0 1 1-1h1a1 1 0 0 1 1 1v1a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1v-1z"/></svg>',
              'desc'=>'We help you process a new domestic worker visa with complete support from entry permits to Emirates ID.',
              'color'=>'#2E86DE'
            ],
            [
              'title'=>'Visa Renewal',
              'icon'=>'<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 16 16"><path fill-rule="evenodd" d="M8 3a5 5 0 1 0 4.546 2.914.5.5 0 0 1 .908-.417A6 6 0 1 1 8 2v1z"/><path d="M8 4.466V.534a.25.25 0 0 1 .41-.192l2.36 1.966c.12.1.12.284 0 .384L8.41 4.658A.25.25 0 0 1 8 4.466z"/></svg>',
              'desc'=>'Easily renew your domestic worker\'s visa and avoid fines with our fast and reliable renewal service.',
              'color'=>'#28a745'
            ],
            [
              'title'=>'Visa Cancellation',
              'icon'=>'<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 16 16"><path d="M2.5 1a1 1 0 0 0-1 1v1a1 1 0 0 0 1 1H3v9a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2V4h.5a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1H10a1 1 0 0 0-1-1H7a1 1 0 0 0-1 1H2.5zm3 4a.5.5 0 0 1 .5.5v7a.5.5 0 0 1-1 0v-7a.5.5 0 0 1 .5-.5zM8 5a.5.5 0 0 1 .5.5v7a.5.5 0 0 1-1 0v-7A.5.5 0 0 1 8 5zm3 .5v7a.5.5 0 0 1-1 0v-7a.5.5 0 0 1 1 0z"/></svg>',
              'desc'=>'Smooth and hassle-free cancellation process whether inside or outside the UAE.',
              'color'=>'#dc3545'
            ],
            [
              'title'=>'Medical Fitness Test',
              'icon'=>'<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 16 16"><path d="M8 5a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3zm4 3a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3zM5.5 7a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm.5 6a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3z"/><path d="M16 8c0 3.15-1.866 2.585-3.567 2.07C11.42 9.763 10.465 9.473 10 10c-.603.683-.475 1.819-.351 2.92C9.826 14.495 9.996 16 8 16a8 8 0 1 1 8-8zm-8 7c.611 0 .654-.171.655-.176.078-.146.124-.464.07-1.119-.014-.168-.037-.37-.061-.591-.052-.464-.112-1.005-.118-1.462-.01-.707.083-1.61.704-2.314.369-.417.845-.578 1.272-.618.404-.038.812.026 1.16.104.343.077.702.186 1.025.284l.028.008c.346.105.658.199.953.266.653.148.904.083.991.024C14.717 9.38 15 9.161 15 8a7 7 0 1 0-7 7z"/></svg>',
              'desc'=>'Quick and efficient medical fitness test arrangements with fast results in 48 hours.',
              'color'=>'#17a2b8'
            ],
            [
              'title'=>'Emirates ID',
              'icon'=>'<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 16 16"><path d="M3 14s-1 0-1-1 1-4 6-4 6 3 6 4-1 1-1 1H3zm5-6a3 3 0 1 0 0-6 3 3 0 0 0 0 6z"/></svg>',
              'desc'=>'Full support for Emirates ID typing, biometrics, and issuance during your visa process.',
              'color'=>'#6f42c1'
            ],
            [
              'title'=>'Medical Insurance',
              'icon'=>'<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 16 16"><path d="M8 5a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3zm4 3a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3zM5.5 7a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm.5 6a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3z"/><path d="M16 8c0 3.15-1.866 2.585-3.567 2.07C11.42 9.763 10.465 9.473 10 10c-.603.683-.475 1.819-.351 2.92C9.826 14.495 9.996 16 8 16a8 8 0 1 1 8-8zm-8 7c.611 0 .654-.171.655-.176.078-.146.124-.464.07-1.119-.014-.168-.037-.37-.061-.591-.052-.464-.112-1.005-.118-1.462-.01-.707.083-1.61.704-2.314.369-.417.845-.578 1.272-.618.404-.038.812.026 1.16.104.343.077.702.186 1.025.284l.028.008c.346.105.658.199.953.266.653.148.904.083.991.024C14.717 9.38 15 9.161 15 8a7 7 0 1 0-7 7z"/></svg>',
              'desc'=>'Affordable and comprehensive health insurance plans as per UAE law requirements.',
              'color'=>'#20c997'
            ],
            [
              'title'=>'Employment Contract',
              'icon'=>'<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 16 16"><path d="M14.5 3a.5.5 0 0 1 .5.5v9a.5.5 0 0 1-.5.5h-13a.5.5 0 0 1-.5-.5v-9a.5.5 0 0 1 .5-.5h13zm-13-1A1.5 1.5 0 0 0 0 3.5v9A1.5 1.5 0 0 0 1.5 14h13a1.5 1.5 0 0 0 1.5-1.5v-9A1.5 1.5 0 0 0 14.5 2h-13z"/><path d="M3 5.5a.5.5 0 0 1 .5-.5h9a.5.5 0 0 1 0 1h-9a.5.5 0 0 1-.5-.5zM3 8a.5.5 0 0 1 .5-.5h9a.5.5 0 0 1 0 1h-9A.5.5 0 0 1 3 8zm0 2.5a.5.5 0 0 1 .5-.5h6a.5.5 0 0 1 0 1h-6a.5.5 0 0 1-.5-.5z"/></svg>',
              'desc'=>'Secure employment contracts drafted and registered with MOHRE for complete legal protection.',
              'color'=>'#fd7e14'
            ],
            [
              'title'=>'WPS Salary Account',
              'icon'=>'<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 16 16"><path d="M0 4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V4zm2.5 1a.5.5 0 0 0-.5.5v1a.5.5 0 0 0 .5.5h2a.5.5 0 0 0 .5-.5v-1a.5.5 0 0 0-.5-.5h-2zm3 0a.5.5 0 0 0-.5.5v1a.5.5 0 0 0 .5.5h1a.5.5 0 0 0 .5-.5v-1a.5.5 0 0 0-.5-.5h-1zm-3 3a.5.5 0 0 0-.5.5v1a.5.5 0 0 0 .5.5h1a.5.5 0 0 0 .5-.5v-1a.5.5 0 0 0-.5-.5h-1zm3 0a.5.5 0 0 0-.5.5v1a.5.5 0 0 0 .5.5h1a.5.5 0 0 0 .5-.5v-1a.5.5 0 0 0-.5-.5h-1zm-3 3a.5.5 0 0 0-.5.5v1a.5.5 0 0 0 .5.5h1a.5.5 0 0 0 .5-.5v-1a.5.5 0 0 0-.5-.5h-1zm3 0a.5.5 0 0 0-.5.5v1a.5.5 0 0 0 .5.5h1a.5.5 0 0 0 .5-.5v-1a.5.5 0 0 0-.5-.5h-1z"/></svg>',
              'desc'=>'Get WPS-compliant bank accounts and salary management with full transparency.',
              'color'=>'#e83e8c'
            ],
            [
              'title'=>'Opening Sponsor File',
              'icon'=>'<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 16 16"><path d="M.54 3.87.5 3a2 2 0 0 1 2-2h3.672a2 2 0 0 1 1.414.586l.828.828A2 2 0 0 0 9.828 3h3.982a2 2 0 0 1 1.992 2.181l-.637 7A2 2 0 0 1 13.174 14H2.826a2 2 0 0 1-1.991-1.819l-.637-7a1.99 1.99 0 0 1 .342-1.31zM2.19 4a1 1 0 0 0-.996 1.09l.637 7a1 1 0 0 0 .995.91h10.348a1 1 0 0 0 .995-.91l.637-7A1 1 0 0 0 13.81 4H2.19zm4.69-1.707A1 1 0 0 0 6.172 2H2.5a1 1 0 0 0-1 .981l.006.139C1.72 3.042 1.95 3 2.19 3h5.396l-.707-.707z"/></svg>',
              'desc'=>'We handle all sponsor file opening procedures with MOHRE and immigration offices.',
              'color'=>'#6c757d'
            ]
          ];
        ?>

        <?php $__currentLoopData = $cards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $card): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <div class="flip-card">
            <div class="flip-card-inner">
              <!-- Front of Card -->
              <div class="flip-card-front" style="background: linear-gradient(135deg, <?php echo e($card['color']); ?>15, <?php echo e($card['color']); ?>08); border: 2px solid <?php echo e($card['color']); ?>20;">
                <div class="card-icon" style="color: <?php echo e($card['color']); ?>;">
                  <?php echo $card['icon']; ?>

                </div>
                <h3 class="card-title"><?php echo e($card['title']); ?></h3>
                <div class="flip-hint">
                  <span>Click to learn more</span>
                  <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                    <path fill-rule="evenodd" d="M1 8a.5.5 0 0 1 .5-.5h11.793l-3.147-3.146a.5.5 0 0 1 .708-.708l4 4a.5.5 0 0 1 0 .708l-4 4a.5.5 0 0 1-.708-.708L13.293 8.5H1.5A.5.5 0 0 1 1 8z"/>
                  </svg>
                </div>
              </div>
              
              <!-- Back of Card -->
              <div class="flip-card-back" style="background: linear-gradient(135deg, <?php echo e($card['color']); ?>, <?php echo e($card['color']); ?>dd);">
                <h3 class="back-title"><?php echo e($card['title']); ?></h3>
                <p class="back-description"><?php echo e($card['desc']); ?></p>
                <div class="back-icon" style="color: <?php echo e($card['color']); ?>;">
                  <?php echo $card['icon']; ?>

                </div>
                <div class="back-cta">
                  <span>Get Started</span>
                  <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                    <path fill-rule="evenodd" d="M1 8a.5.5 0 0 1 .5-.5h11.793l-3.147-3.146a.5.5 0 0 1 .708-.708l4 4a.5.5 0 0 1 0 .708l-4 4a.5.5 0 0 1-.708-.708L13.293 8.5H1.5A.5.5 0 0 1 1 8z"/>
                  </svg>
                </div>
              </div>
            </div>
          </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </div>
    </div>
  </section>

</div>

<style>
  /* Global Variables */
  :root {
    --primary-blue: #2E86DE;
    --primary-dark-blue: #0a3d91;
    --primary-light-blue: #4A90E2;
    --accent-green: #25D366;
    --text-dark: #333333;
    --text-light: #555555;
    --bg-light: #f8f9fa;
    --white: #ffffff;
    --shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
    --shadow-hover: 0 15px 40px rgba(0, 0, 0, 0.12);
  }

  /* Hero Section */
.services-hero {
  background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
  padding: 80px 0;
}

.hero-title {
  font-size: 3rem;
  font-weight: 700;
  color: var(--primary-dark-blue);
  margin-bottom: 1.5rem;
  line-height: 1.2;
}

.hero-subtitle {
  font-size: 1.25rem;
  color: var(--text-light);
  margin-bottom: 1.5rem;
  line-height: 1.6;
}

.hero-description {
  font-size: 1.1rem;
  color: var(--text-dark);
  line-height: 1.7;
  margin-bottom: 2rem;
  text-align: justify; /* added */
}

  .hero-actions {
    display: flex;
    gap: 15px;
    flex-wrap: wrap;
  }

  .btn {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    padding: 12px 24px;
    border-radius: 8px;
    font-weight: 600;
    text-decoration: none;
    transition: all 0.3s ease;
    border: 2px solid transparent;
    gap: 8px;
  }

  .btn-whatsapp {
    background: var(--accent-green);
    color: var(--white);
  }

  .btn-whatsapp:hover {
    background: var(--white);
    color: var(--accent-green);
    border-color: var(--accent-green);
    transform: translateY(-2px);
    box-shadow: 0 6px 15px rgba(37, 211, 102, 0.3);
  }

  .btn-primary {
    background: var(--primary-blue);
    color: var(--white);
  }

  .btn-primary:hover {
    background: var(--white);
    color: var(--primary-blue);
    border-color: var(--primary-blue);
    transform: translateY(-2px);
    box-shadow: 0 6px 15px rgba(46, 134, 222, 0.3);
  }

  .hero-image {
    border-radius: 20px;
    overflow: hidden;
    box-shadow: var(--shadow);
    transition: all 0.4s ease;
  }

  .hero-image:hover {
    transform: translateY(-10px);
    box-shadow: var(--shadow-hover);
  }

  .hero-image img {
    width: 100%;
    height: auto;
    display: block;
  }

  /* Flip Cards Section */
  .services-flip-cards {
    background: var(--white);
    padding: 80px 0;
  }

  .section-header {
    margin-bottom: 4rem;
  }

  .section-title {
    font-size: 2.5rem;
    font-weight: 700;
    color: var(--primary-dark-blue);
    margin-bottom: 1rem;
  }

  .title-underline {
    width: 80px;
    height: 4px;
    background: var(--primary-blue);
    margin: 0 auto 1.5rem;
    border-radius: 2px;
  }

  .section-subtitle {
    font-size: 1.2rem;
    color: var(--text-light);
    max-width: 600px;
    margin: 0 auto;
  }

  .flip-cards-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(320px, 1fr));
    gap: 30px;
    perspective: 1000px;
  }

  /* Flip Card Styles */
  .flip-card {
    height: 280px;
    perspective: 1000px;
    cursor: pointer;
  }

  .flip-card-inner {
    position: relative;
    width: 100%;
    height: 100%;
    transition: transform 0.7s;
    transform-style: preserve-3d;
    border-radius: 16px;
    box-shadow: var(--shadow);
  }

  .flip-card:hover .flip-card-inner {
    transform: rotateY(180deg);
  }

  .flip-card-front,
  .flip-card-back {
    position: absolute;
    width: 100%;
    height: 100%;
    backface-visibility: hidden;
    border-radius: 16px;
    padding: 30px 25px;
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    text-align: center;
  }

  /* Front Card Styles */
  .flip-card-front {
    background: var(--white);
  }

  .card-icon {
    width: 70px;
    height: 70px;
    border-radius: 16px;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-bottom: 20px;
    transition: all 0.3s ease;
  }

  .card-icon svg {
    width: 32px;
    height: 32px;
  }

  .card-title {
    font-size: 1.4rem;
    font-weight: 600;
    color: var(--primary-dark-blue);
    margin-bottom: 15px;
    line-height: 1.3;
  }

  .flip-hint {
    display: flex;
    align-items: center;
    gap: 8px;
    color: var(--text-light);
    font-size: 0.9rem;
    margin-top: auto;
    opacity: 0.7;
    transition: all 0.3s ease;
  }

  .flip-card-front:hover .flip-hint {
    opacity: 1;
    transform: translateY(-2px);
  }

  /* Back Card Styles */
  .flip-card-back {
    color: var(--white);
    transform: rotateY(180deg);
    position: relative;
    overflow: hidden;
  }

  .back-title {
    font-size: 1.4rem;
    font-weight: 600;
    margin-bottom: 15px;
    color: var(--white);
  }

  .back-description {
    font-size: 1rem;
    line-height: 1.6;
    margin-bottom: 20px;
    color: rgba(255, 255, 255, 0.9);
  }

  .back-icon {
    position: absolute;
    bottom: 20px;
    right: 20px;
    opacity: 0.2;
    width: 60px;
    height: 60px;
    display: flex;
    align-items: center;
    justify-content: center;
  }

  .back-icon svg {
    width: 40px;
    height: 40px;
  }

  .back-cta {
    display: flex;
    align-items: center;
    gap: 8px;
    font-weight: 600;
    font-size: 1rem;
    color: var(--white);
    margin-top: auto;
    padding: 10px 20px;
    border: 2px solid rgba(255, 255, 255, 0.3);
    border-radius: 8px;
    transition: all 0.3s ease;
  }

  .back-cta:hover {
    background: rgba(255, 255, 255, 0.1);
    border-color: rgba(255, 255, 255, 0.5);
    transform: translateY(-2px);
  }

  /* Responsive Design */
  @media (max-width: 1200px) {
    .flip-cards-grid {
      grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    }
  }

  @media (max-width: 768px) {
    .services-hero {
      padding: 60px 0;
    }
    
    .hero-title {
      font-size: 2.2rem;
    }
    
    .hero-subtitle {
      font-size: 1.1rem;
    }
    
    .section-title {
      font-size: 2rem;
    }
    
    .flip-cards-grid {
      grid-template-columns: 1fr;
      gap: 20px;
    }
    
    .flip-card {
      height: 260px;
    }
    
    .hero-actions {
      flex-direction: column;
      align-items: flex-start;
    }
    
    .btn {
      width: 100%;
      max-width: 250px;
    }
  }

  @media (max-width: 576px) {
    .hero-title {
      font-size: 1.8rem;
    }
    
    .section-title {
      font-size: 1.6rem;
    }
    
    .flip-card-front,
    .flip-card-back {
      padding: 25px 20px;
    }
    
    .flip-cards-grid {
      grid-template-columns: 1fr;
    }
    
    .card-title,
    .back-title {
      font-size: 1.2rem;
    }
  }

  /* Touch device support */
  @media (hover: none) {
    .flip-card-inner {
      transition: transform 0.5s;
    }
    
    .flip-card:active .flip-card-inner {
      transform: rotateY(180deg);
    }
  }
</style>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('web.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mgtaxhwf/visa.mgtadbeer.com/resources/views/web/services.blade.php ENDPATH**/ ?>