<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1><i class="nav-icon fas fa-user-shield"></i> <?php echo e($title); ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="<?php echo e(url(sitePrefix().'dashboard')); ?>">Home</a></li>
                            <li class="breadcrumb-item active"><?php echo e($title); ?></li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        <section class="content">
            <div class="container-fluid">
                <?php if($errors->any()): ?>
                    <div class="alert alert-danger">
                        <ul>
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>
                <?php if(session('success')): ?>
                    <div class="alert alert-success" role="alert">
                        <button type="button" class="close" data-dismiss="alert">×</button>
                        <?php echo e(session('success')); ?>

                    </div>
                <?php elseif(session('error')): ?>
                    <div class="alert alert-danger" role="alert">
                        <button type="button" class="close" data-dismiss="alert">×</button>
                        <?php echo e(session('error')); ?>

                    </div>
                <?php endif; ?>
                <form role="form" id="formWizard" class="form--wizard" enctype="multipart/form-data" method="post">
                    <?php echo e(csrf_field()); ?>

                    <div class="card card-info">
                        <div class="card-header">
                            <h3 class="card-title">Site Information Form</h3>
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label for="brand_name">Brand Name(English)*</label>
                                    <input type="text" name="brand_name_en" id="brand_name_en"
                                           class="form-control required" placeholder="Brand Name English"
                                           maxlength="230"
                                           value="<?php echo e(!empty($siteInformation)?$siteInformation->brand_name_en:''); ?>">
                                    <div class="help-block with-errors" id="brand_name_en_error"></div>
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="brand_name">Brand Name Arabic*</label>
                                    <input type="text" name="brand_name_ar" id="brand_name_ar"
                                           class="form-control required" placeholder="Brand Name Arabic" maxlength="230"
                                           value="<?php echo e(!empty($siteInformation)?$siteInformation->brand_name_ar:''); ?>">
                                    <div class="help-block with-errors" id="brand_name_ar_error"></div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label for="logo"> Logo*</label>
                                    <div class="file-loading">
                                        <input id="logo" name="logo" type="file" accept="image/*">
                                    </div>
                                    <span class="caption_note">Note: Image dimension must be 215 X 96 PX and Size must be less than 512 KB</span>

                                </div>
                                <div class="form-group col-md-6">
                                    <label for="logo_meta_tag"> Logo Attribute *</label>
                                    <input type="text" id="logo_attribute" name="logo_attribute"
                                           class="form-control required placeholder-cls"
                                           placeholder="Alt='Logo Attribute'"
                                           maxlength="230"
                                           value="<?php echo e(!empty($siteInformation)?$siteInformation->logo_attribute:''); ?>">
                                    <div class="help-block with-errors" id="logo_attribute_error"></div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label for="logo">Tadbeer Logo*</label>
                                    <div class="file-loading">
                                        <input id="tadbeer_logo" name="tadbeer_logo" type="file" accept="image/*">
                                    </div>
                                    <span class="caption_note">Note: Image dimension must be 57 X 75 PX and Size must be less than 512 KB</span>

                                </div>
                                <div class="form-group col-md-6">
                                    <label for="logo_meta_tag">Tadbeer Logo Attribute *</label>
                                    <input type="text" id="tadbeer_logo_attribute" name="tadbeer_logo_attribute"
                                           class="form-control required placeholder-cls"
                                           placeholder="Alt='Logo Attribute'"
                                           maxlength="230"
                                           value="<?php echo e(!empty($siteInformation)?$siteInformation->tadbeer_logo_attribute:''); ?>">
                                    <div class="help-block with-errors" id="tadbeer_logo_attribute_error"></div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label for="copyright_en">Copyright Text(English)*</label>
                                    <input type="text" name="copyright_en" id="copyright_en"
                                           class="form-control required" maxlength="230"
                                           placeholder="Copyright Text(English)"
                                           value="<?php echo e(!empty($siteInformation)?$siteInformation->copyright_en:''); ?>">
                                    <div class="help-block with-errors" id="copyright_en_error"></div>
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="copyright_ar">Copyright Text(Arabic)*</label>
                                    <input type="text" name="copyright_ar" id="copyright_ar"
                                           class="form-control required" maxlength="230"
                                           placeholder="Copyright Text(Arabic)"
                                           value="<?php echo e(!empty($siteInformation)?$siteInformation->copyright_ar:''); ?>">
                                    <div class="help-block with-errors" id="copyright_ar_error"></div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label for="privacy_policy">Privacy Policy (English)</label>
                                    <textarea name="privacy_policy_en" id="privacy_policy_en"
                                              placeholder="Privacy Policy English"
                                              class="form-control tinyeditor" autocomplete="off">
                                        <?php echo e(!empty($siteInformation)?$siteInformation->privacy_policy_en:''); ?></textarea>
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="privacy_policy">Privacy Policy (Arabic)</label>
                                    <textarea name="privacy_policy_ar" id="privacy_policy_ar"
                                              placeholder="Privacy Policy Arabic"
                                              class="form-control tinyeditor" autocomplete="off">
                                        <?php echo e(!empty($siteInformation)?$siteInformation->privacy_policy_ar:''); ?></textarea>
                                </div>
                            </div>
                            <div class="form-row">

                                <div class="form-group col-md-6">
                                    <label for="terms_and_conditions">Terms & Conditions (English)</label>
                                    <textarea name="terms_and_conditions_en" id="terms_and_conditions_en"
                                              placeholder="Terms & Conditions English" class="form-control tinyeditor"
                                              autocomplete="off">
                                        <?php echo e(!empty($siteInformation)?$siteInformation->terms_and_conditions_en:''); ?></textarea>
                                </div>

                                <div class="form-group col-md-6">
                                    <label for="terms_and_conditions">Terms & Conditions (Arabic)</label>
                                    <textarea name="terms_and_conditions_ar" id="terms_and_conditions_ar"
                                              placeholder="Terms & Conditions Arabic" class="form-control tinyeditor"
                                              autocomplete="off">
                                        <?php echo e(!empty($siteInformation)?$siteInformation->terms_and_conditions_ar:''); ?></textarea>
                                </div>
                            </div>

                        </div>
                        <div class="card-footer">
                            <input type="submit" name="btn_save" value="Submit"
                                   class="btn btn-primary pull-left submitBtn">
                            <button type="reset" class="btn btn-default">Reset</button>
                            <input type="hidden" name="id" id="id"
                                   value="<?php echo e(!empty($siteInformation)?$siteInformation->id:'0'); ?>">
                        </div>
                    </div>
                </form>
            </div>
        </section>
    </div>


    <script type="text/javascript">
        $(document).ready(function () {
            $("#logo").fileinput({
                'theme': 'explorer-fas',
                validateInitialCount: true,
                overwriteInitial: false,
                autoReplace: true,
                layoutTemplates: {actionDelete: ''},
                removeLabel: "Remove",
                initialPreviewAsData: true,
                dropZoneEnabled: false,
                required: true,
                allowedFileTypes: ['image'],
                minImageWidth: 215,
                minImageHeight: 96,
                maxImageWidth: 215,
                maxImageHeight: 96,
                maxFileSize: 512,
                showRemove: false,
                <?php if(!empty($siteInformation) && $siteInformation->logo!=NULL): ?>
                initialPreview: ["<?php echo e(asset($siteInformation->logo)); ?>",],
                initialPreviewConfig: [{
                    caption: "<?php echo e(($siteInformation->logo!=NULL)?last(explode('/',$siteInformation->logo)):''); ?>",
                    width: "120px"
                }]
                <?php endif; ?>
            });
            $("#tadbeer_logo").fileinput({
                'theme': 'explorer-fas',
                validateInitialCount: true,
                overwriteInitial: false,
                autoReplace: true,
                layoutTemplates: {actionDelete: ''},
                removeLabel: "Remove",
                initialPreviewAsData: true,
                dropZoneEnabled: false,
                required: true,
                allowedFileTypes: ['image'],
                minImageWidth: 57,
                minImageHeight: 75,
                maxImageWidth: 57,
                maxImageHeight: 75,
                maxFileSize: 512,
                showRemove: false,
                <?php if(!empty($siteInformation) && $siteInformation->tadbeer_logo!=NULL): ?>
                initialPreview: ["<?php echo e(asset($siteInformation->tadbeer_logo)); ?>",],
                initialPreviewConfig: [{
                    caption: "<?php echo e(($siteInformation->tadbeer_logo!=NULL)?last(explode('/',$siteInformation->tadbeer_logo)):''); ?>",
                    width: "120px"
                }]
                <?php endif; ?>
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('app.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp1\htdocs\mgt\resources\views/app/site_information/form.blade.php ENDPATH**/ ?>