<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1><i class="nav-icon fas fa-user-shield"></i> Manage Maids</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="<?php echo e(url(sitePrefix().'dashboard')); ?>">Home</a>
                            </li>
                            <li class="breadcrumb-item active">Maids</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <?php if(session('success')): ?>
                            <div class="alert alert-success" role="alert">
                                <button type="button" class="close" data-dismiss="alert">×</button>
                                <?php echo e(session('success')); ?>

                            </div>
                        <?php elseif(session('error')): ?>
                            <div class="alert alert-danger" role="alert">
                                <button type="button" class="close" data-dismiss="alert">×</button>
                                <?php echo e(session('error')); ?>

                            </div>
                        <?php endif; ?>
                        <div class="card card-success card-outline">
                            <div class="card-header">
                                <a href="<?php echo e(url(sitePrefix().'team/maid/create')); ?>"
                                   class="btn btn-success pull-right">Add Maid <i
                                        class="fa fa-plus-circle pull-right mt-1 ml-2"></i></a>
                            </div>
                            <div class="card-body">
                                <table class="table table-bordered table-hover dataTable">
                                    <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Name</th>
                                        <th>Nationality</th>
                                        <th>Display To Home </th>
                                        <th>Status</th>
                                        <th>Created Date</th>
                                        <th class="not-sortable">Actions</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $maidList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $maid): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($loop->iteration); ?></td>
                                            <td><?php echo e($maid->name_en); ?></td>
                                            <td><?php echo e(@$maid->country->nationality_en); ?></td>

                                            <td>
                                                <label class="switch">
                                                    <input type="checkbox" class="bool_status"
                                                           data-url='display-to-home' data-table="Maid"
                                                           data-id="<?php echo e($maid->id); ?>" data-field="display_to_home"
                                                        <?php echo e(($maid->display_to_home == "Yes")?'checked':''); ?>>
                                                    <span class="slider"></span>
                                                </label>
                                            </td>
                                            <td>
                                                <label class="switch">
                                                    <input id="switch-state" type="checkbox" class="status_check"
                                                           data-size="mini" data-url="/status-change"
                                                           data-table="Maid" data-field="status"
                                                           data-pk="<?php echo e($maid->id); ?>"
                                                        <?php echo e(($maid->status=="Active")?'checked':''); ?>>
                                                    <span class="slider"></span>
                                                </label>
                                            </td>
                                            <td><?php echo e(date("d-M-Y", strtotime($maid->created_at))); ?></td>
                                            <td class="text-right py-0 align-middle">
                                                <div class="btn-group btn-group-sm">
                                                    <a href="<?php echo e(url(sitePrefix().'team/maid/edit/'.$maid->id)); ?>"
                                                       class="btn btn-success mr-2 tooltips" title="Edit Maid"><i
                                                            class="fas fa-edit"></i></a>
                                                    <a href="#" class="btn btn-danger mr-2 delete_entry tooltips"
                                                       title="Delete Maid" data-url="team/maid/delete"
                                                       data-id="<?php echo e($maid->id); ?>"><i class="fas fa-trash"></i></a>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('app.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\MAMP\htdocs\mgt\resources\views/app/maid/list.blade.php ENDPATH**/ ?>