<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1><i class="nav-icon fas fa-user-shield"></i> Visa Service Page</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="<?php echo e(url(sitePrefix().'dashboard')); ?>">Home</a></li>
                            <li class="breadcrumb-item active">Visa Service</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        <section class="content">
            <div class="container-fluid">
                <?php if(session('success')): ?>
                    <div class="alert alert-success" role="alert">
                        <button type="button" class="close" data-dismiss="alert">×</button>
                        <?php echo e(session('success')); ?>

                    </div>
                <?php elseif(session('error')): ?>
                    <div class="alert alert-danger" role="alert">
                        <button type="button" class="close" data-dismiss="alert">×</button>
                        <?php echo e(session('error')); ?>

                    </div>
                <?php endif; ?>
                <?php if($errors->any()): ?>
                    <div class="alert alert-danger">
                        <ul>
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>
                <form role="form" id="formWizard" class="form--wizard" enctype="multipart/form-data" method="post">
                    <?php echo e(csrf_field()); ?>

                    <div class="card card-info">
                        <div class="card-header">
                            <h3 class="card-title">Visa Service Form</h3>
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label> Title(English)*</label>
                                    <input type="text" name="title_en" id="title_en" placeholder="Title(English)"
                                           class="form-control required" autocomplete="off"
                                           value="<?php echo e(old('title_en',isset($visaservice)?$visaservice->title_en:'')); ?>"
                                           maxlength="255">
                                    <div class="help-block with-errors" id="title_en_error"></div>
                                    <?php $__errorArgs = ['title_en'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="form-group col-md-6">
                                    <label> Title(Arabic)*</label>
                                    <input type="text" name="title_ar" id="title_ar" placeholder="Title(Arabic)"
                                           class="form-control required" autocomplete="off"
                                           value="<?php echo e(old('title_ar',isset($visaservice)?$visaservice->title_ar:'')); ?>"
                                           maxlength="255">
                                    <div class="help-block with-errors" id="title_ar_error"></div>
                                    <?php $__errorArgs = ['title_ar'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="form-group col-md-6">
                                    <label> Sub Title(English)</label>
                                    <input type="text" name="sub_title_en" id="sub_title_en"
                                           placeholder="Sub Title(English)"
                                           class="form-control" autocomplete="off"
                                           value="<?php echo e(old('sub_title_en',isset($visaservice)?$visaservice->sub_title_en:'')); ?>"
                                           maxlength="255">
                                    <div class="help-block with-errors" id="sub_title_en_error"></div>
                                </div>
                                <div class="form-group col-md-6">
                                    <label> Sub Title(Arabic)</label>
                                    <input type="text" name="sub_title_ar" id="sub_title_ar"
                                           placeholder="Sub Title(Arabic)"
                                           class="form-control" autocomplete="off"
                                           value="<?php echo e(old('sub_title_ar',isset($visaservice)?$visaservice->sub_title_ar:'')); ?>"
                                           maxlength="255">
                                    <div class="help-block with-errors" id="sub_title_ar_error"></div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label> Description(English)*</label>
                                    <textarea name="description_en" id="description_en"
                                              class="form-control tinyeditor required"
                                              placeholder="Description(English)"
                                    ><?php echo e(old('description_en',isset($visaservice)?$visaservice->description_en:'')); ?></textarea>
                                    <div class="help-block with-errors" id="description_en_error"></div>
                                    <?php $__errorArgs = ['description_en'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="form-group col-md-6">
                                    <label> Description(Arabic)*</label>
                                    <textarea name="description_ar" id="description_ar"
                                              class="form-control tinyeditor required"
                                              placeholder="Description(Arabic)"
                                    ><?php echo e(old('description_ar',isset($visaservice)?$visaservice->description_ar:'')); ?></textarea>
                                    <div class="help-block with-errors" id="description_ar_error"></div>
                                    <?php $__errorArgs = ['description_ar'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="form-row">
                                <div class="form-group col-md-4">
                                    <label> First Image*</label>
                                    <div class="file-loading">
                                        <input id="first_image" name="first_image" type="file" accept="image/*">
                                    </div>
                                    <span class="caption_note">Note: Image dimension must be 662 X 607 PX and Size must be less than 512 KB</span>
                                    <?php $__errorArgs = ['first_image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="form-group col-md-4">
                                    <label> Second Image*</label>
                                    <div class="file-loading">
                                        <input id="second_image" name="second_image" type="file" accept="image/*">
                                    </div>
                                    <span class="caption_note">Note: Image dimension must be 400 X 470 PX and Size must be less than 512 KB</span>
                                    <?php $__errorArgs = ['second_image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="form-group col-md-4">
                                    <label> Image Attribute *</label>
                                    <input type="text" class="form-control placeholder-cls required"
                                           id="image_attribute"
                                           name="image_attribute" placeholder="Alt='Home Image Attribute'"
                                           value="<?php echo e(old('image_attribute',isset($visaservice)?$visaservice->image_attribute:'')); ?>"
                                           maxlength="255">
                                    <?php $__errorArgs = ['image_attribute'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                        </div>
                        <div class="card-footer">
                            <input type="hidden" name="id" id="id" value="<?php echo e(isset($visaservice)?$visaservice->id:'0'); ?>">
                            <input type="submit" name="btn_save" value="Submit"
                                   class="btn btn-primary pull-left submitBtn">
                        </div>
                    </div>
                </form>
            </div>
        </section>
    </div>
    <script type="text/javascript">
        $(document).ready(function () {
            $("#first_image").fileinput({
                'theme': 'explorer-fas',
                validateInitialCount: true,
                overwriteInitial: false,
                autoReplace: true,
                layoutTemplates: {actionDelete: ''},
                removeLabel: "Remove",
                initialPreviewAsData: true,
                dropZoneEnabled: false,
                required: true,
                allowedFileTypes: ['image'],
                minImageWidth: 662,
                minImageHeight: 607,
                maxImageWidth: 662,
                maxImageHeight: 607,
                maxFileSize: 512,
                showRemove: false,
                <?php if(isset($visaservice) && $visaservice->first_image!=NULL): ?>
                initialPreview: [
                    "<?php echo e(asset($visaservice->first_image)); ?>",
                ],
                initialPreviewConfig: [
                    {caption: "<?php echo ($visaservice->first_image!=NULL)?$visaservice->title_en:''; ?>", width: "120px"}
                ]
                <?php endif; ?>
            });
            $("#second_image").fileinput({
                'theme': 'explorer-fas',
                validateInitialCount: true,
                overwriteInitial: false,
                autoReplace: true,
                layoutTemplates: {actionDelete: ''},
                removeLabel: "Remove",
                initialPreviewAsData: true,
                dropZoneEnabled: false,
                required: true,
                allowedFileTypes: ['image'],
                minImageWidth: 400,
                minImageHeight: 470,
                maxImageWidth: 400,
                maxImageHeight: 470,
                maxFileSize: 512,
                showRemove: false,
                <?php if(isset($visaservice) && $visaservice->second_image!=NULL): ?>
                initialPreview: [
                    "<?php echo e(asset($visaservice->second_image)); ?>",
                ],
                initialPreviewConfig: [
                    {caption: "<?php echo ($visaservice->second_image!=NULL)?$visaservice->title_en:''; ?>", width: "120px"}
                ]
                <?php endif; ?>
            });


        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('app.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp1\htdocs\mgt\resources\views/app/visa_service/visa_service_page.blade.php ENDPATH**/ ?>