<!doctype html>
<html lang="<?php echo e(defaultLanguage()); ?>">
  <?php
  date_default_timezone_set('Asia/Dubai');
  ?>
    
<head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

<!-- Google tag (gtag.js) --> <script async src="https://www.googletagmanager.com/gtag/js?id=AW-10829273572"></script> <script> window.dataLayer = window.dataLayer || []; function gtag(){dataLayer.push(arguments);} gtag('js', new Date()); gtag('config', 'AW-10829273572'); </script>

    
    
    <link rel="preload" href="https://www.housekeepingco.com/fonts/v2/mona_sans/Mona-Sans-Regular.woff" as="font" type="font/woff" crossorigin>

    <link rel="preload" as="image" href="/public/hero.webp" type="image/webp">
<link rel="preload" as="image" href="/public/control.webp" type="image/webp">

    <!-- Google tag (gtag.js) -->
    <link rel="preload" href="/fonts/Poppins-Regular.ttf" as="font" type="font/ttf" crossorigin>
<link rel="preload" href="/fonts/Poppins-Light.ttf" as="font" type="font/ttf" crossorigin>

<script async src="https://www.googletagmanager.com/gtag/js?id=AW-10829273572">
</script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'AW-10829273572');
</script>
    <meta name="google-site-verification" content="GJTH_xDJZ8yXvyMF0zpj0oeUBm8I2gIo94goCPKxqik" />
    
    <!-- Basic Meta -->
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="robots" content="index, follow">

<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Mountain Gate L.L.C - Visa & Maids Services in Dubai">
<meta name="twitter:description" content="Hire full-time live-in maids, nannies, and process visas easily with Mountain Gate L.L.C in Dubai.">
<meta name="twitter:image" content="/public/logo.webp">
<meta name="twitter:site" content="@MountainGate">
<meta name="twitter:creator" content="@MountainGate">


<!-- SEO Meta -->
<title><?php echo e($pageTitle ?? 'Mountain Gate L.L.C - Visa & Maids Services in Dubai'); ?></title>
<meta name="description" content="<?php echo e($pageDescription ?? 'Find and hire full-time live-in maids, nannies, and process visas easily with Mountain Gate L.L.C in Dubai.'); ?>">
<meta name="keywords" content="Dubai maids, hire maids Dubai, visa services Dubai, nanny services Dubai, domestic helpers UAE, Mountain Gate L.L.C">

<!-- Open Graph (Facebook, LinkedIn, WhatsApp, etc.) -->
<meta property="og:title" content="<?php echo e($pageTitle ?? 'Mountain Gate L.L.C - Visa & Maids Services in Dubai'); ?>">
<meta property="og:description" content="<?php echo e($pageDescription ?? 'Find and hire full-time live-in maids, nannies, and process visas easily with Mountain Gate L.L.C in Dubai.'); ?>">
<meta property="og:image" content="<?php echo e($pageImage ?? asset('public/logo.webp')); ?>">
<meta property="og:url" content="<?php echo e($canonicalUrl ?? url()->current()); ?>">
<meta property="og:type" content="website">
<meta property="og:site_name" content="Mountain Gate L.L.C">
<meta property="og:locale" content="en_AE">


<!-- Schema / Structured Data (JSON-LD) -->
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Organization",
  "name": "Mountain Gate L.L.C",
  "url": "<?php echo e(url('/')); ?>",
  "logo": "<?php echo e(asset('/public/logo.webp')); ?>",
  "sameAs": [
    "https://www.facebook.com/mgtadbeer",
    "https://www.linkedin.com/company/mgtadbeer",
    "https://twitter.com/MountainGate"
  ],
  "contactPoint": {
    "@type": "ContactPoint",
    "telephone": "+97144018888",
    "contactType": "customer service",
    "areaServed": "AE"
  }
}
</script>


    
        <link rel="icon" type="/public/logo.webp" href="/public/logo.webp">


    <meta charset="UTF-8">
    <meta name="viewport"content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="title" content="<?php echo isset($meta_data)?$meta_data->meta_title:''; ?>">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>"/>
    <title><?php echo e(langString($siteInformation,'brand_name')); ?>

        - <?php echo isset($meta_data)?$meta_data->meta_title:''; ?></title>
    <?php echo isset($meta_data)?$meta_data->other_meta_tag:''; ?>

    <?php echo isset($siteInformation)?$siteInformation->header_tag:''; ?>

<link rel="canonical" href="https://visa.mgtadbeer.com/home" />

	<meta name="author" content="Uzair Mehbub">
<!-- Favicon -->
<link rel="icon" type="image/x-icon" href="<?php echo e(asset($siteInformation->logo) ?? asset('public/logo.webp')); ?>">

<!-- Bootstrap CSS (core layout) -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css">

<!-- Font Awesome (icons) -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">

<!-- Animate.css (for subtle animations, optional, can remove if not used) -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">

<!-- Star rating (if you have review stars on the site) -->
<link rel="stylesheet" href="<?php echo e(asset('web/css/star-rating-svg.css')); ?>">

<!-- Select2 (only if you have advanced select dropdowns) -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css">

<!-- SweetAlert2 (for alerts/pop-ups) -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/10.15.6/sweetalert2.min.css">

<!-- Main custom styles -->
<link rel="stylesheet" href="<?php echo e(asset('web/css/style.css')); ?>">
	<script type="text/javascript">
    var base_url = "<?php echo e(url('/')); ?>";
    var logo = base_url + "/public/logo.webp";
    var tadbeer_logo = base_url + "/public/logo.webp"; // or another file if you have a separate tadbeer logo
    var waitText = "<?php echo staticLangString($websiteLanguages,'title.wait_text'); ?>";
    var servicePlaceholder = "<?php echo staticLangString($websiteLanguages,'placeholder.service'); ?>";
</script>
<script src="/js/main.js" defer></script>
<script src="/js/vendor.js" defer></script>

     <script type="application/ld+json">
  {
    "@context": "https://schema.org",
    "@type": "LocalBusiness",
    "name": "Mountain Gate L.L.C",
    "telephone": "+97144018888",
    "address": {
      "@type": "PostalAddress",
      "streetAddress": "Port Saeed, Near Green House",
      "addressLocality": "Dubai",
      "postalCode": "XXXXX",
      "addressCountry": "AE"
    },
    "url": "https://mgtadbeer.com"
  }
  </script>
  <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "LocalBusiness",
  "name": "Mountain Gate L.L.C",
  "image": "/public/logo.webp",
  "telephone": "+97144018888",
  "address": {
    "@type": "PostalAddress",
    "streetAddress": "Port Saeed, Near Green House",
    "addressLocality": "Dubai",
    "addressCountry": "AE"
  },
  "url": "https://maids.mgtadbeer.com",
  "openingHours": "Mo-Sa 08:00-20:00",
  "sameAs": [
    "https://www.facebook.com/p/Tadbeer-Mountain-GATE-DEIRA-100086494462764/",
    "https://www.youtube.com/@tadbeerMG",
    "https://www.instagram.com/tadbeergate/"
  ]
}
</script>


<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Service",
  "serviceType": "Housemaid & Nanny Hiring",
  "provider": {
    "@type": "LocalBusiness",
    "name": "Mountain Gate L.L.C",
    "image": "/public/logo.webp",
    "telephone": "+97144018888",
    "address": {
      "@type": "PostalAddress",
      "streetAddress": "Port Saeed, Near Green House",
      "addressLocality": "Dubai",
      "addressCountry": "AE"
    },
    "url": "https://maids.mgtadbeer.com"
  },
  "description": "Hire fully trained live-in maids, nannies, and domestic helpers in Dubai. We offer same-day hire, company & family sponsorship.",
  "areaServed": {
    "@type": "City",
    "name": "Dubai"
  }
}
</script>
<!-- LocalBusiness Schema -->
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "LocalBusiness",
  "name": "Mountain Gate L.L.C",
  "image": "/logo.webp",
  "telephone": "+97144018888",
  "address": {
    "@type": "PostalAddress",
    "streetAddress": "Port Saeed, Near Green House",
    "addressLocality": "Dubai",
    "addressCountry": "AE"
  },
  "url": "https://visa.mgtadbeer.com",
  "openingHours": "Mo-Sa 08:00-20:00",
  "sameAs": [
    "https://www.facebook.com/p/Tadbeer-Mountain-GATE-DEIRA-100086494462764/",
    "https://www.youtube.com/@tadbeerMG",
    "https://www.instagram.com/tadbeergate/"
  ]
}
</script>

<!-- Service Schema -->
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Service",
  "serviceType": "UAE Visa Processing",
  "provider": {
    "@type": "LocalBusiness",
    "name": "Mountain Gate L.L.C",
    "image": "/logo.webp",
    "telephone": "+97144018888",
    "address": {
      "@type": "PostalAddress",
      "streetAddress": "Port Saeed, Near Green House",
      "addressLocality": "Dubai",
      "addressCountry": "AE"
    },
    "url": "https://visa.mgtadbeer.com"
  },
  "description": "We handle UAE visa processing, approvals, and sponsorships for individuals and families in Dubai.",
  "areaServed": {
    "@type": "City",
    "name": "Dubai"
  }
}
</script>

<!-- Breadcrumb Schema -->
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "BreadcrumbList",
  "itemListElement": [
    {
      "@type": "ListItem",
      "position": 1,
      "name": "Home",
      "item": "https://visa.mgtadbeer.com/"
    },
    {
      "@type": "ListItem",
      "position": 2,
      "name": "Visa Services",
      "item": "https://visa.mgtadbeer.com/services"
    },
    {
      "@type": "ListItem",
      "position": 3,
      "name": "Apply for Visa",
      "item": "https://visa.mgtadbeer.com/apply-visa"
    }
  ]
}
</script>

<!-- SEO Core -->
<meta name="title" content="Mountain Gate Center | Tadbeer Approved Visa & Maid Services in Dubai">
<meta name="description" content="Mountain Gate Center (Tadbeer) offers professional visa processing, maid hiring, and domestic worker services in Dubai. MOHRE approved, fast, and reliable. Contact us today for monthly packages and visa support.">
<meta name="keywords" content="Tadbeer, Mountain Gate Center, maid visa Dubai, visa services UAE, MOHRE approved center, domestic worker visa UAE, maid service Dubai, nanny agency Dubai, housekeeper Dubai, full-time live-in maid, expat sponsor maid, Emirati sponsor maid, Tadbeer Dubai, Tadbeer services, monthly maid package">
<!-- Open Graph / Facebook -->
<meta property="og:url" content="https://visa.mgtadbeer.com" />
<meta property="og:title" content="Mountain Gate Center | Visa & Tadbeer Services in Dubai" />
<meta property="og:description" content="Get your maid or domestic worker visa easily with Mountain Gate Center. MOHRE-approved Tadbeer services in Dubai. Fast processing & trusted support.">
<meta property="og:type" content="website">
<meta property="og:image" content="https://visa.mgtadbeer.com/public/images/mountain-gate-og.jpg">

<!-- Twitter Card -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Mountain Gate Center | Visa & Maid Services in Dubai">
<meta name="twitter:description" content="Tadbeer-approved visa and maid services in Dubai. Apply today with Mountain Gate Center for fast, reliable domestic worker visa processing.">
<meta name="twitter:image" content="https://visa.mgtadbeer.com/public/images/mountain-gate-og.jpg">

<!-- CSRF Token (Laravel / Security) -->
<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

<!-- Local Business Schema -->
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "GovernmentOffice",
  "name": "Mountain Gate Center",
  "alternateName": "Tadbeer - Mountain Gate Center",
  "url": "https://visa.mgtadbeer.com",
  "image": "https://visa.mgtadbeer.com/public/images/mountain-gate-og.jpg",
  "telephone": "+97144018888",
  "email": "info@mgtadbeer.com",
  "address": {
    "@type": "PostalAddress",
    "streetAddress": "Port Saeed, Dubai, United Arab Emirates",
    "addressLocality": "Dubai",
    "addressCountry": "UAE"
  },
  "openingHours": "Mo-Su 08:00-20:00",
  "priceRange": "$$",
  "areaServed": "Dubai, UAE",

  ],
  "serviceType": [
    "Maid Visa Services",
    "Domestic Worker Visa Services",
    "Monthly Maid Packages",
    "Tadbeer Services",
    "Visa Typing and Processing"
  ]
}
</script>

  
</head>
<body>


<?php echo $siteInformation->body_tag??''; ?>

<section class="top_header">
  <div class="container">
    <div class="row">
      <div class="col-md-12">
        <div class="top_header_contents" style="display:flex; justify-content:space-between; align-items:center; flex-wrap:wrap; gap:15px;">

          <!-- Left: Logo + Initials -->
          <div class="Top_contents_left" style="display:flex; align-items:center; gap:10px;">
            <a href="https://mgtadbeer.com">
              <img src="<?php echo e(asset('public/logo.webp')); ?>" alt="Company Logo" class="company-logo" style="max-height:50px; width:auto; object-fit:contain; animation: flipLogo 3s linear infinite;">
            </a>
            <span class="company-initials" style="font-size:1.8rem; font-weight:800; font-family:'Poppins', sans-serif; color:#0A3D91; letter-spacing:1px; text-transform:uppercase;">MGT</span>
          </div>

          <!-- Right: Contact Buttons -->
          <div class="Top_contents_right top-header-contact">
            <ul style="display:flex; gap:8px; margin:0; padding:0; list-style:none; flex-wrap:wrap; align-items:stretch;">

              <!-- Timing (popup on click) -->
              <li>
                <div class="contact-card timing-card";">
                  <i class="fa-regular fa-clock"></i>
                  <span>Timing: 7:30AM - 12:00AM / 7 Days</span>
                </div>
              </li>

              <!-- Location -->
              <li>
                <a href="https://maps.app.goo.gl/EyaBYmtD2ceGeskm7" target="_blank" class="contact-card">
                  <i class="fa-solid fa-location-dot"></i>
                  <span>Our Location</span>
                </a>
              </li>

              <!-- Email -->
     <!--         <?php if($siteInformation->email): ?>
              <li>
                <a href="mailto:<?php echo e(@$siteInformation->email); ?>" class="contact-card">
                  <i class="fa-solid fa-envelope"></i>
                  <span>Email Us</span>
                </a>
              </li>
              <?php endif; ?> -->

              <!-- Phone -->
              <?php if($siteInformation->phone): ?>
              <li>
                <a href="tel:<?php echo e(@$siteInformation->phone); ?>" class="contact-card">
                  <i class="fa-solid fa-phone"></i>
                  <span>Call Us: 044018888</span>
                </a>
              </li>
              <?php endif; ?>

            </ul>
          </div>

        </div>
      </div>
    </div>
  </div>

  <style>
    @keyframes  flipLogo {0%{transform:rotateY(0deg);}50%{transform:rotateY(180deg);}100%{transform:rotateY(360deg);} }

    /* Compact Contact Buttons - Icon + Text in same line, no border */
    .top-header-contact .contact-card {
      display:flex;
      align-items:center;
      gap:5px;
      background:#f8f9fa;
      color:#0a3d91;
      border:none;
      border-radius:6px;
      padding:6px 12px;
      text-decoration:none;
      transition: all 0.25s ease;
      height:40px; /* uniform height */
      font-size:0.85rem;
      cursor:pointer;
      box-sizing:border-box;
      min-width:90px;
      justify-content:center;
    }

    .top-header-contact .contact-card:hover {
      background:#0a3d91;
      color:#fff;
      transform: translateY(-1px);
      box-shadow:0 3px 6px rgba(0,0,0,0.1);
    }

    .top-header-contact .contact-card i {
      font-size:16px;
      transition: all 0.25s ease;
    }

    .top-header-contact .whatsapp-card i {
      color:#25D366;
    }

    .top-header-contact .contact-card span {
      font-weight:600;
      font-size:12px;
      text-align:center;
    }

    .top-header-contact ul li { display:flex; }
  </style>
</section>


<style>
/* --- Top Header Scoped CSS --- */
.top_header {
    width: 100%;
    background: #f4f9ff; /* soft light blue */
    padding: 8px 0;
    font-family: 'Segoe UI', sans-serif;
    box-shadow: none;
}

.top_header_contents {
    display: flex;
    justify-content: space-between;
    align-items: center;
    flex-wrap: wrap;
}

.Top_contents_left img {
    max-height: 50px;
}

.Top_contents_right ul {
    display: flex;
    align-items: center;
    list-style: none;
    margin: 0;
    padding: 0;
    gap: 25px;
}

.Top_contents_right ul li {
    display: flex;
    align-items: center;
    gap: 8px;
}

.Top_contents_right ul li a {
    display: flex;
    align-items: center;
    text-decoration: none;
    color: #0A3D91; /* deep blue text */
    gap: 8px;
    transition: color 0.3s ease;
}

.Top_contents_right ul li a:hover {
    color: #4361ee; /* lighter blue hover */
}

.Top_contents_right ul li a .connect_us h6 {
    margin: 0;
    font-size: 12px;
    font-weight: 600;
    color: #2D68C4; /* royal blue highlight */
}

.Top_contents_right ul li a .connect_us p {
    margin: 0;
    font-size: 12px;
    color: #555;
}

.Top_contents_right ul li select.form-select {
    border-radius: 18px;
    padding: 4px 10px;
    font-size: 13px;
    border: 1px solid #2D68C4;
    background: #fff;
    cursor: pointer;
    transition: border-color 0.3s ease, box-shadow 0.3s ease;
}

.Top_contents_right ul li select.form-select:focus {
    outline: none;
    border-color: #4361ee;
    box-shadow: 0 0 5px rgba(67, 97, 238, 0.3);
}

/* --- Mobile: Hide Top Header --- */
@media (max-width: 991px) {
    .top_header {
        display: none !important;
    }
}
</style>

<header>
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <nav class="navbar navbar-expand-lg navbar-light">
                    <div class="container-fluid">
                        <div class="collapse navbar-collapse" id="navbarSupportedContent">
                            <ul class="navbar-nav mb-2 mb-lg-0">
                                <li class="nav-item">
                                    <a class="nav-link <?php echo e(Request::is('/')?'active':''); ?>" aria-current="page"
                                       href="<?php echo e(url('/')); ?>"><?php echo e(staticLangString($websiteLanguages,'menu.home')); ?></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link <?php echo e(Request::is('about-us')?'active':''); ?>"
                                       href="<?php echo e(url('about-us')); ?>"><?php echo e(staticLangString($websiteLanguages,'menu.about')); ?></a>
                                </li>

                                <li class="nav-item">
                                <a class="nav-link <?php echo e(Request::is('visa-service') ? 'active' : ''); ?>"
                                href="<?php echo e(url('visa-service')); ?>">Visa Services</a>
                                </li>


<li class="nav-item">
    <a class="nav-link <?php echo e(Request::is('services') ? 'active' : ''); ?>" href="<?php echo e(url('services')); ?>">
        Other Services
    </a>
</li>

                                

                                
                                <li class="nav-item">
                                    <a class="nav-link"
                                       href="<?php echo e(url('contact-us')); ?>"><?php echo e(staticLangString($websiteLanguages,'menu.contact')); ?></a>
                                </li>
                            </ul>
                        </div>
                        <div class="mobile_right_section">
                            <div class="navbar_right_contents ">
                
                                </div>
<a href="#" class="primary_btn clear-form" data-bs-toggle="modal" data-bs-target="#EnquiryModal">
    Request Callback
    <style>
        .primary_btn.clear-form {
            background-color: #0a3d91;     /* dark blue background */
            color: #fff;                   /* white text */
            border: 2px solid #0a3d91;
            padding: 10px 25px;
            border-radius: 6px;
            font-weight: 600;
            text-decoration: none;
            display: inline-block;
            transition: all 0.3s ease;
        }

        .primary_btn.clear-form:hover {
            background-color: #fff;        /* invert colors */
            color: #0a3d91;
            border-color: #0a3d91;
            transform: translateY(-2px);
        }
    </style>
</a>

</div>
<button class="navbar-toggler" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasExample" 
        aria-controls="offcanvasExample" aria-label="Toggle navigation">
  <span class="navbar-toggler-icon"></span>
</button>


                        </div>

                    </div>
                </nav>
            </div>
        </div>
    </div>
</header>
<style>
/* Sticky Header */
header {
  position: sticky;
  top: 0;
  width: 100%;
  z-index: 9999;
  background-color: #fff; /* fallback background */
  transition: all 0.3s ease;
  box-shadow: 0 0 0 rgba(0,0,0,0); /* no shadow initially */
}

/* Shrink effect on scroll */
header.scrolled {
  padding: 5px 0; /* reduce vertical padding */
  box-shadow: 0 4px 12px rgba(0,0,0,0.1);
}

/* Navbar styling */
.navbar-nav .nav-link {
  color: #0a3d91;
  font-weight: 500;
  transition: color 0.3s ease;
}

.navbar-nav .nav-link.active,
.navbar-nav .nav-link:hover {
  color: #ffcc00;
}

/* Request Callback Button */
.primary_btn.clear-form {
  background-color: #0a3d91;
  color: #fff;
  border: 2px solid #0a3d91;
  padding: 10px 25px;
  border-radius: 6px;
  font-weight: 600;
  text-decoration: none;
  display: inline-block;
  transition: all 0.3s ease;
}

.primary_btn.clear-form:hover {
  background-color: #fff;
  color: #0a3d91;
  border-color: #0a3d91;
  transform: translateY(-2px);
}

/* Optional: Shrink the button slightly on scroll */
header.scrolled .primary_btn.clear-form {
  padding: 7px 20px;
  font-size: 0.9rem;
}
</style>

<script>
// Add scroll listener to toggle "scrolled" class
window.addEventListener('scroll', () => {
  const header = document.querySelector('header');
  if (window.scrollY > 50) {
    header.classList.add('scrolled');
  } else {
    header.classList.remove('scrolled');
  }
});
</script>

<div class="offcanvas offcanvas-start" data-bs-backdrop="false" tabindex="-1" id="offcanvasExample" aria-labelledby="offcanvasExampleLabel">
    <div class="offcanvas-header">
        <h5 class="offcanvas-title" id="offcanvasExampleLabel">MG TADBEER</h5>
        <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body">
        <ul class="navbar-nav mb-2 mb-lg-0">
            <li class="nav-item">
                <a class="nav-link <?php echo e(Request::is('/')?'active':''); ?>" aria-current="page"
                   href="<?php echo e(url('/')); ?>"><?php echo e(staticLangString($websiteLanguages,'menu.home')); ?></a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo e(Request::is('about-us')?'active':''); ?>"
                   href="<?php echo e(url('about-us')); ?>"><?php echo e(staticLangString($websiteLanguages,'menu.about')); ?></a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo e(Request::is('visa-service') ? 'active' : ''); ?>"
                   href="<?php echo e(url('visa-service')); ?>">Visa Services</a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo e(Request::is('services') ? 'active' : ''); ?>" href="<?php echo e(url('services')); ?>">
                    Other Services
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo e(Request::is('contact-us')?'active':''); ?>"
                   href="<?php echo e(url('contact-us')); ?>"><?php echo e(staticLangString($websiteLanguages,'menu.contact')); ?> Us</a>
            </li>
        </ul>
    </div>
</div>



<div class="modal fade enquiry_modal" id="EnquiryModal" tabindex="-1" aria-labelledby="exampleModalLabel"
     aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content" style="position:relative;">
            <div class="modal-header" style="background:#0a3d91;">
                <h5 class="modal-title" id="exampleModalLabel" style="color:white">
                    Request Callback & Quick Consultation
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>

                <style>
                    .btn-close {
                        width: 36px;
                        height: 36px;
                        border: 1px solid #0a3d91;
                        border-radius: 50%;
                        background-color: #fff;
                        color: #0a3d91;
                        font-size: 18px;
                        display: flex;
                        align-items: center;
                        justify-content: center;
                        transition: all 0.3s ease;
                    }
                    .btn-close:hover {
                        background-color: #0a3d91;
                        color: #fff;
                        transform: translateY(-2px);
                    }
                    .btn-close:focus {
                        box-shadow: none;
                        outline: none;
                    }
                </style>

            </div>

            <div class="modal-body">
                <form id="serviceEnquiryForm" action="">
                    <input type="hidden" id="type" name="type" value="services">

                    <div class="form-group">
                        <label>Full Name</label>
                        <input type="text" name="name" id="name" class="form-control"
                               placeholder="Name*">
                    </div>

                    <div class="form-group" style="display:none;">
                        <label>Email</label>
                        <input type="email" name="email" id="email" class="form-control"
                               value="Email@example.com" readonly hidden>
                    </div>

                    <div class="form-group">
                        <label>Mobile</label>
                        <input type="tel" name="phone" id="phone" class="form-control"
                               value="+971" placeholder="Phone*">
                    </div>

                    <div class="form-group">
                        <label>Preferred Date</label>
                        <input type="date" name="preferrddate" id="preferrddate" class="form-control"
                               value="<?php echo e(date('Y-m-d')); ?>">
                    </div>

                    <div class="form-group">
                        <label>Preferred Time</label>
                        <input type="time" name="preferrdtime" id="preferrdtime" class="form-control"
                               value="<?php echo e(date('H:i')); ?>">
                    </div>

                    <div class="form-group">
                        <textarea class="form-control" name="message" id="message" rows="4"
                                  readonly>I need a Callback</textarea>
                    </div>

                    <button type="submit" data-url="/enquiry"
                            class="primary_btn d-block form_submit_btn m-auto"
                            style="background:#0a3d91;color:#fff;border:none;padding:10px 25px;border-radius:6px;">
                        Submit
                    </button>
                </form>

                <!-- TOAST -->
                <div id="toastMsg" 
                     style="position: fixed; top: 20px; right: 20px; background: #28a745; color:#fff;
                            padding:12px 20px; border-radius:6px; display:none; z-index:9999;">
                    Message sent! We will contact you shortly.
                </div>

                <script>
                document.getElementById('serviceEnquiryForm').addEventListener('submit', function(e){
                    e.preventDefault();

                    const name = document.getElementById('name').value.trim();
                    const phone = document.getElementById('phone').value.trim();
                    const email = document.getElementById('email').value;
                    const message = document.getElementById('message').value;
                    const preferrddate = document.getElementById('preferrddate').value;
                    const preferrdtime = document.getElementById('preferrdtime').value;

                    if(!name || !phone){
                        alert('Please fill all required fields.');
                        return;
                    }

                    // ---- AJAX SUBMIT ----
                    fetch('/enquiry', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                        },
                        body: JSON.stringify({
                            name, phone, email, message,
                            preferrddate, preferrdtime, type: "services"
                        })
                    })
                    .then(res => res.json())
                    .then(data => {
                        document.getElementById('toastMsg').style.display = 'block';
                        setTimeout(() => {
                            document.getElementById('toastMsg').style.display = 'none';
                        }, 3000);

                        document.getElementById('serviceEnquiryForm').reset();
                        document.getElementById('phone').value = '+971';
                        document.getElementById('message').value = 'I need a Callback';
                    })
                    .catch(err => alert("Something went wrong"));
                });
                </script>

            </div>
        </div>
    </div>
</div>

<?php echo $__env->yieldContent('content'); ?>


<footer style="background-color:#0a3d91; color:#fff; font-family:Arial,sans-serif; padding:50px 20px; width:100%; box-sizing:border-box;">
  <div style="max-width:1200px; margin:0 auto;">
    
    <!-- Newsletter Section -->
    <div style="display:flex; flex-wrap:wrap; justify-content:space-between; align-items:center; gap:20px; border-bottom:1px solid rgba(255,255,255,0.3); padding-bottom:30px;">
      <div style="flex:1; min-width:250px;">
        <h5 style="margin:0 0 10px 0; font-size:20px; font-weight:bold; color:#fff;"><?php echo e(staticLangString($websiteLanguages,'title.news_letter')); ?></h5>
        <p style="margin:0; font-size:14px; line-height:1.6; color:#f0f0f0;"><?php echo e(staticLangString($websiteLanguages,'title.news_letter_description')); ?></p>
      </div>
      <div style="flex:1; min-width:250px;">
        <form action="" id="newsLetterForm" style="display:flex; flex-wrap:wrap; gap:10px;">
          <input type="email" name="email" class="newsLetterForm" id="email"
                 placeholder="<?php echo e(staticLangString($websiteLanguages,'placeholder.newletter_email')); ?>"
                 style="flex:1; padding:12px 15px; border:none; border-radius:6px; font-size:14px; color:#0a3d91;">
          <button type="submit" data-url="/newsletter"
                  style="background-color:#ffcc00; color:#0a3d91; border:none; padding:12px 25px; border-radius:6px; font-weight:bold; cursor:pointer; transition:all 0.3s ease;">
            <?php echo e(staticLangString($websiteLanguages,'title.subscribe')); ?>

          </button>
        </form>
      </div>
    </div>

    <!-- Links & Info Section -->
    <div style="display:flex; flex-wrap:wrap; justify-content:space-between; gap:30px; padding:30px 0;">
      
      <!-- Quick Links -->
      <div style="flex:1; min-width:180px;">
        <h6 style="margin-bottom:15px; font-weight:bold; color:#fff;"><?php echo e(staticLangString($websiteLanguages,'title.quick_links')); ?></h6>
        <ul style="list-style:none; padding:0; margin:0; font-size:14px; line-height:2;">
          <li><a href="<?php echo e(url('/')); ?>" style="color:#ffeb3b; text-decoration:none; transition:color 0.3s;"><?php echo e(staticLangString($websiteLanguages,'menu.home')); ?></a></li>
          <li><a href="<?php echo e(url('about-us')); ?>" style="color:#ffeb3b; text-decoration:none; transition:color 0.3s;"><?php echo e(staticLangString($websiteLanguages,'menu.about')); ?></a></li>
          <li><a href="<?php echo e(url('blogs')); ?>" style="color:#ffeb3b; text-decoration:none; transition:color 0.3s;"><?php echo e(staticLangString($websiteLanguages,'menu.blog')); ?></a></li>
          <li><a href="<?php echo e(url('contact-us')); ?>" style="color:#ffeb3b; text-decoration:none; transition:color 0.3s;"><?php echo e(staticLangString($websiteLanguages,'menu.contact')); ?></a></li>
        </ul>
      </div>

      <!-- Company Info & Social -->
      <div style="flex:1; min-width:250px;">
        <h6 style="margin-bottom:15px; font-weight:bold; color:#fff;">About Mountain Gate</h6>
        <p style="font-size:14px; line-height:1.6; margin:0 0 20px 0; color:#f0f0f0;">
          Mountain Gate Center for Domestic Workers provides professional recruitment and training services to ensure a safe, skilled, and reliable domestic workforce. Serving Dubai and the GCC since 2018.
        </p>

        <!-- Social Icons -->
        <div style="margin-top:10px;">
          <ul style="display:flex; gap:12px; padding:0; margin:0; list-style:none; justify-content:flex-start;">
            <li>
              <a href="https://www.facebook.com/tadbeermg.dxb" target="_blank" style="display:flex; align-items:center; justify-content:center; width:40px; height:40px; background:#1877F2; color:#fff; border-radius:50%; transition:all 0.3s; text-decoration:none; font-size:18px;" aria-label="Facebook"><i class="fab fa-facebook-f"></i></a>
            </li>
            <li>
              <a href="https://www.youtube.com/channel/UC6nWzA1EJPgrO7tdXmjSIbw" target="_blank" style="display:flex; align-items:center; justify-content:center; width:40px; height:40px; background:#FF0000; color:#fff; border-radius:50%; transition:all 0.3s; text-decoration:none; font-size:18px;" aria-label="YouTube"><i class="fab fa-youtube"></i></a>
            </li>
            <li>
              <a href="https://www.tiktok.com/@tadbeermountaingate" target="_blank" style="display:flex; align-items:center; justify-content:center; width:40px; height:40px; background:#000; color:#fff; border-radius:50%; transition:all 0.3s; text-decoration:none; font-size:18px;" aria-label="TikTok"><i class="fab fa-tiktok"></i></a>
            </li>
            <li>
              <a href="https://www.instagram.com/tadbeergate/" target="_blank" style="display:flex; align-items:center; justify-content:center; width:40px; height:40px; background:#E4405F; color:#fff; border-radius:50%; transition:all 0.3s; text-decoration:none; font-size:18px;" aria-label="Instagram"><i class="fab fa-instagram"></i></a>
            </li>
            <li>
              <a href="https://www.snapchat.com/add/tadbeergate" target="_blank" style="display:flex; align-items:center; justify-content:center; width:40px; height:40px; background:#FFFC00; color:#000; border-radius:50%; transition:all 0.3s; text-decoration:none; font-size:18px;" aria-label="Snapchat"><i class="fab fa-snapchat-ghost"></i></a>
            </li>
            <li>
              <a href="https://x.com/tadbeergat21549" target="_blank" style="display:flex; align-items:center; justify-content:center; width:40px; height:40px; background:#1DA1F2; color:#fff; border-radius:50%; transition:all 0.3s; text-decoration:none; font-size:18px;" aria-label="X"><i class="fab fa-x-twitter"></i></a>
            </li>
          </ul>
        </div>
      </div>

      <!-- Contact Info -->
      <div style="flex:1; min-width:200px;">
        <h6 style="margin-bottom:15px; font-weight:bold; color:#fff;"><?php echo e(staticLangString($websiteLanguages,'title.contact_info')); ?></h6>
        <ul style="list-style:none; padding:0; margin:0; font-size:14px; line-height:2;">
          <li>
            <a href="tel:044018888" style="color:#f0f0f0; text-decoration:none; display:flex; align-items:center; transition:color 0.3s;">04 401 8888</a>
          </li>
          <li>
            <a href="mailto:<?php echo e(@$siteInformation->email); ?>" style="color:#f0f0f0; text-decoration:none; display:flex; align-items:center; gap:8px; transition:color 0.3s;">
              <svg width="18" height="15" viewBox="0 0 18 15" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M15.666 0.833496H2.33268C1.41602 0.833496 0.674349 1.5835 0.674349 2.50016L0.666016 12.5002C0.666016 13.4168 1.41602 14.1668 2.33268 14.1668H15.666C16.5827 14.1668 17.3327 13.4168 17.3327 12.5002V2.50016C17.3327 1.5835 16.5827 0.833496 15.666 0.833496ZM15.3327 4.37516L9.44102 8.0585C9.17435 8.22516 8.82435 8.22516 8.55768 8.0585L2.66602 4.37516C2.58246 4.32826 2.50928 4.26488 2.45092 4.18887C2.39256 4.11287 2.35023 4.02581 2.3265 3.93297C2.30276 3.84013 2.2981 3.74344 2.31281 3.64875C2.32752 3.55406 2.3613 3.46334 2.41208 3.38208C2.46287 3.30082 2.52962 3.23071 2.60829 3.17599C2.68696 3.12127 2.77591 3.08309 2.86976 3.06374C2.96362 3.0444 4.06042 3.0443 4.15431 3.06345C4.2482 3.0826 4.33724 3.12061 4.41602 3.17516L8.99935 6.66683L14.5827 3.17516C14.6615 3.12061 14.7505 3.0826 14.8444 3.06345C14.9383 3.0443 15.0351 3.0444 15.1289 3.06374C15.2228 3.08309 15.3117 3.12127 15.3904 3.17599C15.4691 3.23071 15.5358 3.30082 15.5866 3.38208C15.6374 3.46334 15.6712 3.55406 15.6859 3.64875C15.7006 3.74344 15.6959 3.84013 15.6722 3.93297C15.6485 4.02581 15.6061 4.11287 15.5478 4.18887C15.4894 4.26488 15.4162 4.32826 15.3327 4.37516Z" fill="#fff"/>
              </svg>
              <span><?php echo e(@$siteInformation->email); ?></span>
            </a>
          </li>
        </ul>
      </div>

    </div>

    <!-- Footer Bottom -->
    <div style="border-top:1px solid rgba(255,255,255,0.3); padding-top:20px; display:flex; justify-content:center; flex-wrap:wrap; gap:5px; font-size:13px; text-align:center; color:#fff;">
      <span>© 2018-2025 Mountain Gate Center For Domestic Workers. All rights reserved.</span>
      <span>|</span>
      <a href="<?php echo e(url('terms-and-conditions')); ?>" style="color:#ffeb3b; text-decoration:none; transition:color 0.3s;">Terms Of Service</a>
      <span>|</span>
      <a href="<?php echo e(url('privacy-policy')); ?>" style="color:#ffeb3b; text-decoration:none; transition:color 0.3s;">Privacy Policy</a>
    </div>
  </div>

  <!-- Social Icon Hover Script -->
  <script>
    document.querySelectorAll('ul li a').forEach(a => {
      a.addEventListener('mouseenter', () => {
        a.style.transform = 'scale(1.15)';
        a.style.boxShadow = '0 4px 15px rgba(0,0,0,0.25)';
      });
      a.addEventListener('mouseleave', () => {
        a.style.transform = 'scale(1)';
        a.style.boxShadow = 'none';
      });
    });
  </script>
</footer>

<!-- Include Font Awesome -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css"/>

<!-- Floating Buttons -->
<div id="floating-icons" style="position: fixed; bottom: 100px; right: 20px; display: flex; flex-direction: column; gap: 15px; z-index: 999;">

    <!-- Call -->
    <a href="tel:+97144018888" style="display: flex; align-items: center; justify-content: center; width: 50px; height: 50px; background-color: #007bff; color: #fff; border-radius: 50%; box-shadow: none; font-size: 24px; text-decoration: none; transition: all 0.3s ease;">
        <i class="fas fa-phone"></i>
    </a>

    <!-- WhatsApp -->
    <a href="https://api.whatsapp.com/send/?phone=97144018888" target="_blank" style="display: flex; align-items: center; justify-content: center; width: 50px; height: 50px; background-color: #25D366; color: #fff; border-radius: 50%; box-shadow: none; font-size: 24px; text-decoration: none; transition: all 0.3s ease;">
        <i class="fab fa-whatsapp"></i>
    </a>

    <!-- Location -->
    <a href="https://maps.app.goo.gl/PGG6qLyZZTFj6fL49" target="_blank" style="display: flex; align-items: center; justify-content: center; width: 50px; height: 50px; background-color: #FF5722; color: #fff; border-radius: 50%; box-shadow: none; font-size: 24px; text-decoration: none; transition: all 0.3s ease;">
        <i class="fas fa-map-marker-alt"></i>
    </a>

</div>

<!-- JS for hover lift effect -->
<script>
    const icons = document.querySelectorAll('#floating-icons a');
    icons.forEach(icon => {
        icon.addEventListener('mouseenter', () => icon.style.transform = 'translateY(-5px)');
        icon.addEventListener('mouseleave', () => icon.style.transform = 'translateY(0)');
    });
</script>




<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.4.1/jquery.fancybox.min.js"></script>
<script src="<?php echo e(asset('web/js/jquery.star-rating-svg.js')); ?>"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xzoom/1.0.15/xzoom.min.js"></script>
<script src="<?php echo e(asset('web/vendor/xzoom/js/setup.js')); ?>"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/10.15.6/sweetalert2.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.full.min.js"></script>
<script src="<?php echo e(asset('web/js/form-select2_new.js')); ?>"></script>
<script src="<?php echo e(asset('web/js/scripts.min.js')); ?>"></script>
<script src="<?php echo e(asset('web/js/custom.min.js')); ?>"></script>



</body>
</html>
<?php /**PATH /home/mgtaxhwf/visa.mgtadbeer.com/resources/views/web/layouts/main.blade.php ENDPATH**/ ?>