

<?php $__env->startSection('content'); ?>

<!-- Contact Page Start -->
<section class="contact-page py-5">
    <div class="container">
        <!-- Header Section -->
        <div class="contact-header text-center mb-5">

            <h1 class="contact-title">Get in Touch with Mountain Gate L.L.C</h1>
            <p class="contact-subtitle">We are here to assist you. Reach out to us via phone, email, or visit us at our location.</p>
        </div>

        <!-- Contact Cards Grid -->
        <div class="contact-cards-grid">
            <!-- Location Card -->
            <div class="contact-card">
                <div class="card-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 16 16">
                        <path d="M8 16s6-5.686 6-10A6 6 0 0 0 2 6c0 4.314 6 10 6 10zm0-7a3 3 0 1 1 0-6 3 3 0 0 1 0 6z"/>
                    </svg>
                </div>
                <h3 class="card-title">Our Location</h3>
                <p class="card-text">Mountain Gate L.L.C</p>
                <a href="https://maps.app.goo.gl/8URoysKezTdCuXsi8" target="_blank" class="card-button">
                    <span>View Map</span>
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                        <path fill-rule="evenodd" d="M1 8a.5.5 0 0 1 .5-.5h11.793l-3.147-3.146a.5.5 0 0 1 .708-.708l4 4a.5.5 0 0 1 0 .708l-4 4a.5.5 0 0 1-.708-.708L13.293 8.5H1.5A.5.5 0 0 1 1 8z"/>
                    </svg>
                </a>
            </div>

            <!-- Phone Card -->
            <div class="contact-card">
                <div class="card-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 16 16">
                        <path d="M3.654 1.328a.678.678 0 0 0-1.015-.063L1.605 2.3c-.483.484-.661 1.169-.45 1.77a17.568 17.568 0 0 0 4.168 6.608 17.569 17.569 0 0 0 6.608 4.168c.601.211 1.286.033 1.77-.45l1.034-1.034a.678.678 0 0 0-.063-1.015l-2.307-1.794a.678.678 0 0 0-.58-.122l-2.19.547a1.745 1.745 0 0 1-1.657-.459L5.482 8.062a1.745 1.745 0 0 1-.46-1.657l.548-2.19a.678.678 0 0 0-.122-.58L3.654 1.328zM1.884.511a1.745 1.745 0 0 1 2.612.163L6.29 2.98c.329.423.445.974.315 1.494l-.547 2.19a.678.678 0 0 0 .178.643l2.457 2.457a.678.678 0 0 0 .644.178l2.189-.547a1.745 1.745 0 0 1 1.494.315l2.306 1.794c.829.645.905 1.87.163 2.611l-1.034 1.034c-.74.74-1.846 1.065-2.877.702a18.634 18.634 0 0 1-7.01-4.42 18.634 18.634 0 0 1-4.42-7.009c-.362-1.03-.037-2.137.703-2.877L1.885.511z"/>
                    </svg>
                </div>
                <h3 class="card-title">Call Us</h3>
                <p class="card-text">044018888</p>
                <a href="tel:044018888" class="card-button">
                    <span>Call Now</span>
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                        <path fill-rule="evenodd" d="M1 8a.5.5 0 0 1 .5-.5h11.793l-3.147-3.146a.5.5 0 0 1 .708-.708l4 4a.5.5 0 0 1 0 .708l-4 4a.5.5 0 0 1-.708-.708L13.293 8.5H1.5A.5.5 0 0 1 1 8z"/>
                    </svg>
                </a>
            </div>

            <!-- Email Card -->
            <div class="contact-card">
                <div class="card-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 16 16">
                        <path d="M0 4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V4Zm2-1a1 1 0 0 0-1 1v.217l7 4.2 7-4.2V4a1 1 0 0 0-1-1H2Zm13 2.383-4.708 2.825L15 11.105V5.383Zm-.034 6.876-5.64-3.471L8 9.583l-1.326-.795-5.64 3.47A1 1 0 0 0 2 13h12a1 1 0 0 0 .966-.741ZM1 11.105l4.708-2.897L1 5.383v5.722Z"/>
                    </svg>
                </div>
                <h3 class="card-title">Email Us</h3>
                <p class="card-text">info@mgtadbeer.com</p>
                <a href="mailto:info@mgtadbeer.com" class="card-button">
                    <span>Send Email</span>
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                        <path fill-rule="evenodd" d="M1 8a.5.5 0 0 1 .5-.5h11.793l-3.147-3.146a.5.5 0 0 1 .708-.708l4 4a.5.5 0 0 1 0 .708l-4 4a.5.5 0 0 1-.708-.708L13.293 8.5H1.5A.5.5 0 0 1 1 8z"/>
                    </svg>
                </a>
            </div>
        </div>

        <!-- Map Section -->
        <div class="map-section">
            <div class="map-container">
                <iframe
                    src="https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d14433.403428328851!2d55.340698!3d25.2587802!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3e5f5cdc1bfad9d1%3A0x899394451fb42e80!2z2YXYsdmD2LIg2KrYr9io2YrYsSDZhdin2YjZhtiq2YrZhiDYrNmK2Ko!5e0!3m2!1sar!2sae!4v1758959444997!5m2!1sar!2sae"
                    width="100%" height="450" style="border:0;" allowfullscreen="" loading="lazy"
                    referrerpolicy="no-referrer-when-downgrade"></iframe>
                <div class="map-overlay">
                    <div class="map-info">
                        <h4>Visit Our Office</h4>
                        <p>Mountain Gate L.L.C</p>
                        <a href="https://maps.app.goo.gl/8URoysKezTdCuXsi8" target="_blank" class="map-direction-btn">
                            Get Directions
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                <path fill-rule="evenodd" d="M1 8a.5.5 0 0 1 .5-.5h11.793l-3.147-3.146a.5.5 0 0 1 .708-.708l4 4a.5.5 0 0 1 0 .708l-4 4a.5.5 0 0 1-.708-.708L13.293 8.5H1.5A.5.5 0 0 1 1 8z"/>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Contact Form Section -->
        <div class="contact-form-section">
            <div class="form-header text-center">
                <div class="header-badge">
                    <span class="badge-text">Send a Message</span>
                </div>
                <h2 class="form-title">We'd Love to Hear From You</h2>
                <p class="form-subtitle">Fill out the form below and we'll get back to you as soon as possible</p>
            </div>
            
            <div class="form-container">
                <?php echo $__env->make('web.includes.enquire_now',['type'=>'Contact'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div>
    </div>
</section>

<style>
    /* Global Variables */
    :root {
        --primary-blue: #2E86DE;
        --primary-dark-blue: #0a3d91;
        --primary-light-blue: #4A90E2;
        --accent-orange: #ED7625;
        --text-dark: #333333;
        --text-light: #555555;
        --bg-light: #f8f9fa;
        --white: #ffffff;
        --shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
        --shadow-hover: 0 15px 40px rgba(0, 0, 0, 0.12);
    }

    /* Contact Page Styles */
    .contact-page {
        background: var(--white);
        font-family: 'Poppins', system-ui, Arial, sans-serif;
    }

    /* Header Section */
    .contact-header {
        padding: 0 20px;
    }

    .header-badge {
        display: inline-block;
        margin-bottom: 1rem;
    }

    .badge-text {
        background: linear-gradient(135deg, var(--primary-blue), var(--primary-dark-blue));
        color: var(--white);
        padding: 8px 20px;
        border-radius: 50px;
        font-size: 14px;
        font-weight: 600;
        letter-spacing: 1px;
        text-transform: uppercase;
    }

    .contact-title {
        font-size: 3rem;
        font-weight: 700;
        color: var(--primary-dark-blue);
        margin-bottom: 1rem;
        line-height: 1.2;
    }

    .contact-subtitle {
        font-size: 1.2rem;
        color: var(--text-light);
        max-width: 600px;
        margin: 0 auto;
        line-height: 1.6;
    }

    /* Contact Cards Grid */
    .contact-cards-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 30px;
        margin: 4rem 0;
    }

    .contact-card {
        background: var(--white);
        border-radius: 20px;
        padding: 40px 30px;
        text-align: center;
        box-shadow: var(--shadow);
        transition: all 0.4s ease;
        border: 1px solid rgba(46, 134, 222, 0.1);
        position: relative;
        overflow: hidden;
    }

    .contact-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 4px;
        background: linear-gradient(135deg, var(--primary-blue), var(--primary-dark-blue));
        transform: scaleX(0);
        transition: transform 0.4s ease;
    }

    .contact-card:hover {
        transform: translateY(-10px);
        box-shadow: var(--shadow-hover);
    }

    .contact-card:hover::before {
        transform: scaleX(1);
    }

    .card-icon {
        width: 80px;
        height: 80px;
        background: linear-gradient(135deg, var(--primary-blue), var(--primary-dark-blue));
        border-radius: 20px;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto 25px;
        color: var(--white);
        transition: all 0.3s ease;
    }

    .contact-card:hover .card-icon {
        transform: scale(1.1) rotate(5deg);
    }

    .card-icon svg {
        width: 32px;
        height: 32px;
    }

    .card-title {
        font-size: 1.5rem;
        font-weight: 600;
        color: var(--primary-dark-blue);
        margin-bottom: 15px;
    }

    .card-text {
        color: var(--text-light);
        font-size: 1.1rem;
        margin-bottom: 25px;
        line-height: 1.6;
    }

    .card-button {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        background: var(--primary-blue);
        color: var(--white);
        padding: 12px 24px;
        border-radius: 10px;
        text-decoration: none;
        font-weight: 600;
        transition: all 0.3s ease;
        border: 2px solid transparent;
    }

    .card-button:hover {
        background: var(--white);
        color: var(--primary-blue);
        border-color: var(--primary-blue);
        transform: translateY(-2px);
        box-shadow: 0 6px 15px rgba(46, 134, 222, 0.3);
    }

    /* Map Section */
    .map-section {
        margin: 4rem 0;
    }

    .map-container {
        position: relative;
        border-radius: 20px;
        overflow: hidden;
        box-shadow: var(--shadow);
        height: 450px;
    }

    .map-container iframe {
        width: 100%;
        height: 100%;
        border: none;
    }

    .map-overlay {
        position: absolute;
        top: 30px;
        right: 30px;
        background: var(--white);
        padding: 25px;
        border-radius: 15px;
        box-shadow: var(--shadow);
        max-width: 250px;
    }

    .map-info h4 {
        color: var(--primary-dark-blue);
        margin-bottom: 10px;
        font-weight: 600;
    }

    .map-info p {
        color: var(--text-light);
        margin-bottom: 15px;
    }

    .map-direction-btn {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        background: var(--primary-blue);
        color: var(--white);
        padding: 10px 20px;
        border-radius: 8px;
        text-decoration: none;
        font-weight: 600;
        font-size: 0.9rem;
        transition: all 0.3s ease;
    }

    .map-direction-btn:hover {
        background: var(--primary-dark-blue);
        transform: translateY(-2px);
        color: var(--white);
    }

    /* Contact Form Section */
    .contact-form-section {
        background: var(--bg-light);
        padding: 60px 40px;
        border-radius: 20px;
        margin: 4rem 0;
    }

    .form-header {
        margin-bottom: 3rem;
    }

    .form-title {
        font-size: 2.5rem;
        font-weight: 700;
        color: var(--primary-dark-blue);
        margin-bottom: 1rem;
    }

    .form-subtitle {
        font-size: 1.1rem;
        color: var(--text-light);
        max-width: 500px;
        margin: 0 auto;
    }

    .form-container {
        max-width: 600px;
        margin: 0 auto;
    }

    /* Responsive Design */
    @media (max-width: 1200px) {
        .contact-cards-grid {
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
        }
    }

    @media (max-width: 768px) {
        .contact-title {
            font-size: 2.2rem;
        }
        
        .form-title {
            font-size: 2rem;
        }
        
        .contact-cards-grid {
            grid-template-columns: 1fr;
            gap: 20px;
        }
        
        .contact-card {
            padding: 30px 20px;
        }
        
        .map-overlay {
            position: relative;
            top: 0;
            right: 0;
            max-width: 100%;
            margin-top: 20px;
        }
        
        .contact-form-section {
            padding: 40px 20px;
        }
    }

    @media (max-width: 576px) {
        .contact-title {
            font-size: 1.8rem;
        }
        
        .form-title {
            font-size: 1.6rem;
        }
        
        .contact-header,
        .form-header {
            padding: 0 10px;
        }
        
        .card-icon {
            width: 60px;
            height: 60px;
        }
        
        .card-icon svg {
            width: 24px;
            height: 24px;
        }
    }
</style>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('web.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mgtaxhwf/visa.mgtadbeer.com/resources/views/web/contact_us.blade.php ENDPATH**/ ?>