<?php

use App\Http\Controllers\app\AboutController;
use App\Http\Controllers\app\AdminController;
use App\Http\Controllers\app\auth\LoginController;
use App\Http\Controllers\app\BannerController;
use App\Http\Controllers\app\BlogController;
use App\Http\Controllers\app\ContactController;
use App\Http\Controllers\app\CountryController;
use App\Http\Controllers\app\HomeController;
use App\Http\Controllers\app\ServiceController;
use App\Http\Controllers\app\SkillSetController;
use App\Http\Controllers\app\TagController;
use App\Http\Controllers\app\MaidController;
use App\Http\Controllers\app\VisaServiceController;
use App\Http\Controllers\app\SiteInformationController;
use App\Http\Controllers\app\EnquiryController;

use App\Http\Controllers\web\HomeController as WebHome;
use Illuminate\Foundation\Auth\EmailVerificationRequest;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', [WebHome::class, 'home']);
Route::get('home', [WebHome::class, 'home']);
Route::get('about-us', [WebHome::class, 'about']);
Route::get('/blogs', [WebHome::class, 'blog']);
Route::post('blog-load-more', [WebHome::class, 'blogLoadMore']);
Route::post('maid-load-more', [WebHome::class, 'maidLoadMore']);

Route::get('/blog/{short_ulr}', [WebHome::class, 'blog_detail']);
Route::get('/maids', [WebHome::class, 'maids']);
Route::get('/maid/{maid_id}', [WebHome::class, 'maid_detail']);

Route::get('/services', [WebHome::class, 'services']);
Route::get('/visa-service', [WebHome::class, 'visa_service']);
Route::post('loadMore', [WebHome::class, 'loadMore']);
Route::get('/contact-us', [WebHome::class, 'contact_us']);
Route::post('/enquiry-form-submit', [WebHome::class, 'enquiry_store']);
Route::get('/terms-and-conditions', [WebHome::class, 'terms_and_conditions']);
Route::get('/privacy-policy', [WebHome::class, 'privacy_policy']);
Route::post('newsletter', [WebHome::class, 'newsletter']);
Route::post('enquiry', [WebHome::class, 'enquiry']);
Route::post('filter-maids', [WebHome::class, 'filter_maids']);
/********************* Common Functions *******************/
Route::post('set-language', [WebHome::class, 'set_language']);

Route::group(['prefix' => 'dashboard'], function () {
    Route::get('/', [LoginController::class, 'showLoginForm'])->middleware('guest')->name('login');
    Route::post('/', [LoginController::class, 'login']);
    Route::post('forgot-password', [LoginController::class, 'forgot_password']);
    Route::get('reset-password/{token}', [LoginController::class, 'reset_password']);
    Route::post('reset-password', [LoginController::class, 'reset_password_store']);
    Route::post('reset-password-store', [LoginController::class, 'reset_password_store']);
    Route::get('administration/account/verify/{token}', [LoginController::class, 'verifyAccount'])->name('user.verify');

});

Route::group(['prefix' => 'dashboard', 'middleware' => 'auth'], function () {
    Route::get('dashboard', [HomeController::class, 'dashboard']);
    Route::post('home-heading', [HomeController::class, 'update_home_heading']);

    /************************** Admin starts *****************************/

    Route::group(['prefix' => 'administration'], function () {
        Route::get('/', [AdminController::class, 'list']);
        Route::get('create', [AdminController::class, 'create']);
        Route::post('create', [AdminController::class, 'store']);
        Route::get('edit/{id}', [AdminController::class, 'edit']);
        Route::get('view/{id}', [AdminController::class, 'view']);
        Route::post('edit/{id}', [AdminController::class, 'update']);
        Route::post('delete/', [AdminController::class, 'delete_admin']);
        Route::group(['prefix' => 'reset_password'], function () {
            Route::get('/{id}', [AdminController::class, 'reset_password']);
            Route::post('/{id}', [AdminController::class, 'reset_password_store']);
        });

        Route::get('profile', [AdminController::class, 'profile']);
        Route::post('profile', [AdminController::class, 'profile_store']);

    });

    /************************** Admin ends ********************************/


    /************************ Blog starts ************************************/

    Route::group(['prefix' => 'blog'], function () {
        Route::get('/', [BlogController::class, 'list']);
        Route::get('create', [BlogController::class, 'create']);
        Route::post('create', [BlogController::class, 'store']);
        Route::get('edit/{id}', [BlogController::class, 'edit']);
        Route::post('edit/{id}', [BlogController::class, 'update']);
        Route::post('delete', [BlogController::class, 'delete']);
    });

    /************************ Blog ends ************************************/

    /************************ Country starts *************************************/

    Route::group(['prefix' => 'country'], function () {
        Route::get('/', [CountryController::class, 'country']);
        Route::get('create/', [CountryController::class, 'country_create']);
        Route::post('create/', [CountryController::class, 'country_store']);
        Route::get('edit/{id}', [CountryController::class, 'country_edit']);
        Route::post('edit/{id}', [CountryController::class, 'country_update']);
        Route::post('delete/', [CountryController::class, 'country_delete']);
    });

    /************************ Country ends *************************************/


    /************************** Home starts *******************************/

    Route::group(['prefix' => 'home'], function () {

        Route::post('sort_order', [HomeController::class, 'sort_order']);

        Route::group(['prefix' => 'slider'], function () {
            Route::get('/', [HomeController::class, 'slider_list']);
            Route::get('create', [HomeController::class, 'slider_create']);
            Route::post('create', [HomeController::class, 'slider_store']);
            Route::get('edit/{id}', [HomeController::class, 'slider_edit']);
            Route::post('edit/{id}', [HomeController::class, 'slider_update']);
            Route::post('delete', [HomeController::class, 'delete_slider']);
        });

        Route::group(['prefix' => 'key-feature'], function () {
            Route::get('/', [HomeController::class, 'keyfeature']);
            Route::get('create', [HomeController::class, 'keyfeature_create']);
            Route::post('create', [HomeController::class, 'keyfeature_store']);
            Route::get('edit/{id}', [HomeController::class, 'keyfeature_edit']);
            Route::post('edit/{id}', [HomeController::class, 'keyfeature_update']);
            Route::post('delete', [HomeController::class, 'delete_keyfeature']);
        });

        Route::get('/about-us', [AboutController::class, 'home_about_us']);
        Route::post('/about-us', [AboutController::class, 'home_about_us_store']);

        Route::get('/contact-us', [ContactController::class, 'home_contact_us']);
        Route::post('/contact-us', [ContactController::class, 'home_contact_us_store']);

        Route::group(['prefix' => 'testimonial'], function () {
            Route::get('/', [HomeController::class, 'testimonial']);
            Route::get('create', [HomeController::class, 'testimonial_create']);
            Route::post('create', [HomeController::class, 'testimonial_store']);
            Route::get('edit/{id}', [HomeController::class, 'testimonial_edit']);
            Route::post('edit/{id}', [HomeController::class, 'testimonial_update']);
            Route::post('delete', [HomeController::class, 'delete_testimonial']);
        });
    });

    Route::post('status-change', [HomeController::class, 'status_change']);
    Route::post('display-to-home', [HomeController::class, 'display_to_home']);

    Route::post('delete-file', [HomeController::class, 'delete_file']);

    /************************ Home ends ************************************/

    /************************ About starts ************************************/

    Route::group(['prefix' => 'about-us'], function () {
        Route::get('/', [AboutController::class, 'about_us']);
        Route::post('/', [AboutController::class, 'about_us_store']);
    });

    /************************ About ends ************************************/

    /************************ Team/Maid Starts ************************************/
    Route::group(['prefix' => 'team'], function () {
        Route::get('/', [MaidController::class, 'team']);
        Route::post('/', [MaidController::class, 'team_store']);

        Route::group(['prefix' => 'maid'], function () {
            Route::get('/', [MaidController::class, 'maid']);
            Route::get('create/', [MaidController::class, 'maid_create']);
            Route::post('create/', [MaidController::class, 'maid_store']);
            Route::get('edit/{id}', [MaidController::class, 'maid_edit']);
            Route::post('edit/{id}', [MaidController::class, 'maid_update']);
            Route::get('view/{id}', [MaidController::class, 'maid_view']);
            Route::post('delete', [MaidController::class, 'delete_maid']);
        });
    });

    /************************ Maid ends ************************************/

    /************************ Service starts *************************************/
    Route::group(['prefix' => 'service'], function () {
        Route::get('/', [ServiceController::class, 'service']);
        Route::get('create/', [ServiceController::class, 'service_create']);
        Route::post('create/', [ServiceController::class, 'service_store']);
        Route::get('edit/{id}', [ServiceController::class, 'service_edit']);
        Route::post('edit/{id}', [ServiceController::class, 'service_update']);
        Route::post('delete/', [ServiceController::class, 'service_delete']);
    });
    /************************ Service ends *************************************/

    /************************ SkillSet starts *************************************/
    Route::group(['prefix' => 'skill-set'], function () {
        Route::get('/', [SkillSetController::class, 'skill_set']);
        Route::get('create/', [SkillSetController::class, 'skill_set_create']);
        Route::post('create/', [SkillSetController::class, 'skill_set_store']);
        Route::get('edit/{id}', [SkillSetController::class, 'skill_set_edit']);
        Route::post('edit/{id}', [SkillSetController::class, 'skill_set_update']);
        Route::post('delete/', [SkillSetController::class, 'skill_set_delete']);
    });
    /************************ SkillSet ends *************************************/

    /************************Visa service Starts ************************************/
    Route::group(['prefix' => 'visa-service'], function () {
        Route::get('/', [VisaServiceController::class, 'visa_service']);
        Route::post('/', [VisaServiceController::class, 'visa_service_store']);
        Route::group(['prefix' => 'service'], function () {
            Route::get('/', [VisaServiceController::class, 'service']);
            Route::get('create/', [VisaServiceController::class, 'service_create']);
            Route::post('create/', [VisaServiceController::class, 'service_store']);
            Route::get('edit/{id}', [VisaServiceController::class, 'service_edit']);
            Route::post('edit/{id}', [VisaServiceController::class, 'service_update']);
            Route::get('view/{id}', [VisaServiceController::class, 'service_view']);
            Route::post('delete', [VisaServiceController::class, 'delete_service']);
        });
    });

    /************************ Visa SErvie ends ************************************/


    /************************ Banner starts *************************************/

    Route::prefix('banner')->group(function () {
        Route::get('/{type}', [BannerController::class, 'banner']);
        Route::post('{type}', [BannerController::class, 'banner_store']);
    });

    /************************ Banner ends *************************************/

    /***************************** Meta Tags Starts ***********************************/

    Route::group(['prefix' => 'tag'], function () {
        Route::get('/{type}/', [TagController::class, 'tag']);
        Route::post('/{type}/', [TagController::class, 'tag_store']);
    });

    Route::group(['prefix' => 'other-meta-tag'], function () {
        Route::get('/', [SiteInformationController::class, 'other_meta_tag']);
        Route::post('/', [SiteInformationController::class, 'other_meta_tag_store']);
    });

    /*************************** Meta Tags Ends **************************************/

    /***************************** Site Information Starts ***********************/

    Route::group(['prefix' => 'contact'], function () {

        Route::get('/', [ContactController::class, 'contact']);
        Route::post('/', [ContactController::class, 'contact_store']);

    });

    Route::group(['prefix' => 'site-information'], function () {
        Route::get('/', [SiteInformationController::class, 'site_information']);
        Route::post('/', [SiteInformationController::class, 'site_information_store']);
    });

    /*************************** Site Information Ends **************************************/


    Route::prefix('enquiry')->group(function () {
//        Route::get('/', [EnquiryController::class, 'enquiry_list']);
//        Route::get('view/{id}', [EnquiryController::class, 'enquiry_view']);
//        Route::post('reply', [EnquiryController::class, 'reply_to_enquiry']);
//        Route::post('delete', [EnquiryController::class, 'delete_enquiry']);
//        Route::post('delete-multiple', [EnquiryController::class, 'delete_multi_enquiry']);

        Route::post('reply', [EnquiryController::class, 'reply_to_enquiry']);

        Route::prefix('enquire-now')->group(function () {
            Route::get('/', [EnquiryController::class, 'enquiry_list']);
            Route::get('view/{id}', [EnquiryController::class, 'enquiry_view']);
            Route::post('delete', [EnquiryController::class, 'delete_enquiry']);
            Route::post('delete-multiple', [EnquiryController::class, 'delete_multi_enquiry']);
        });

        Route::prefix('newsletter')->group(function () {
            Route::get('/', [EnquiryController::class, 'newsletter']);
            Route::post('delete', [EnquiryController::class, 'delete_newsletter']);
            Route::post('delete-multiple', [EnquiryController::class, 'delete_multi_newsletter']);
        });
    });


    Route::prefix('book-now')->group(function () {
        Route::get('/{enquiry_type}', [EnquiryController::class, 'booking_list']);
        Route::get('{type}/view/{id}', [EnquiryController::class, 'booking_view']);

    });


    Route::get('logout', [LoginController::class, 'logout'])->name('logout');
});

