@extends('web.layouts.main')
@section('content')

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>2-Year Maid Visa | Mountain Gate - Professional Visa Services UAE</title>
  <meta name="description" content="Professional 2-Year Maid Visa services in UAE. Fast processing, flexible payment options with Tamara. Complete visa sponsorship and support services.">
  
  <!-- Preload critical resources -->
  <link rel="preload" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" as="style">
  <link rel="preload" href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" as="style">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">

  <style>
    :root {
      --primary: #0a3d91;
      --primary-light: #1a5ad9;
      --primary-lighter: #e8f0ff;
      --accent: #25d366;
      --accent-dark: #1da851;
      --text-dark: #1a1a1a;
      --text-light: #5a5a5a;
      --bg-light: #f8faff;
      --bg-gradient: linear-gradient(135deg, #f8faff 0%, #e8f0ff 100%);
      --white: #ffffff;
      --shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
      --shadow-hover: 0 8px 25px rgba(0, 0, 0, 0.15);
      --radius: 16px;
      --transition: all 0.3s ease;
    }

    /* Reset and base styles */
    * { 
      box-sizing: border-box;
      margin: 0;
      padding: 0;
    }

    body {
      font-family: "Inter", "Segoe UI", Arial, sans-serif;
      color: var(--text-dark);
      background: var(--bg-gradient);
      line-height: 1.6;
      overflow-x: hidden;
    }

    section { 
      padding: 70px 8%; 
    }

    h1, h2, h3, h4 { 
      color: var(--primary); 
      margin-bottom: 10px; 
      font-weight: 700; 
    }

    /* ===== ENHANCED HERO SECTION ===== */
    .hero-container {
      width: 100%;
      background: var(--white);
      padding: 40px 20px;
      box-sizing: border-box;
    }

    .hero-content {
      display: flex;
      flex-wrap: wrap;
      gap: 30px;
      justify-content: space-between;
      align-items: flex-start;
      max-width: 1300px;
      margin: auto;
    }

    .hero-main {
      flex: 1 1 58%;
      font-family: "Inter", "Segoe UI", sans-serif;
      color: #333;
    }

    .hero-main h1 { 
      font-size: clamp(2rem, 5vw, 2.5rem);
      margin-bottom: 10px; 
      background: linear-gradient(135deg, var(--primary) 0%, var(--primary-light) 100%);
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
      background-clip: text;
      line-height: 1.2;
    }
    
    .hero-main p { 
      font-size: clamp(1rem, 2vw, 1.1rem); 
      color: var(--text-light);
      margin-bottom: 25px; 
      max-width: 550px; 
    }

    /* Enhanced Visa Offer Section */
    .visa-offer {
      display: flex;
      align-items: center;
      justify-content: space-between;
      gap: 25px;
      background: rgba(255, 255, 255, 0.95);
      border-radius: 16px;
      padding: 25px 30px;
      box-shadow: var(--shadow);
      backdrop-filter: blur(10px);
      margin: 25px 0;
      flex-wrap: wrap;
      border: 1px solid var(--primary-lighter);
      transition: var(--transition);
    }

    .visa-offer:hover {
      transform: translateY(-2px);
      box-shadow: var(--shadow-hover);
    }

    .visa-details {
      flex: 1;
      min-width: 250px;
    }

    .visa-highlight {
      font-size: clamp(1.3rem, 3vw, 1.5rem);
      font-weight: 700;
      line-height: 1.4;
      margin-bottom: 15px;
      color: var(--primary);
    }

    .feature-item {
      font-size: 1rem;
      color: var(--text-dark);
      margin-bottom: 8px;
      font-weight: 500;
      display: flex;
      align-items: center;
      gap: 8px;
    }

    .feature-item::before {
      content: "✓";
      color: var(--accent);
      font-weight: bold;
    }

    .price-highlight {
      background: transparent !important;
      text-align: left;
      color: var(--primary) !important;
      margin-bottom: 15px;
    }

    .price-highlight strong { 
      font-size: clamp(2.5rem, 5vw, 4rem); 
      font-weight: 800;
      display: block;
      line-height: 1;
    }

    .installment-plan {
      background: var(--primary-lighter);
      padding: 20px;
      border-radius: 12px;
      margin-top: 15px;
      border-left: 4px solid var(--primary);
      transition: var(--transition);
    }

    .installment-plan:hover {
      transform: translateX(5px);
    }

    .installment-plan h4 {
      margin-bottom: 10px;
      color: var(--primary);
      font-size: 1.2rem;
      display: flex;
      align-items: center;
      gap: 8px;
    }

    .installment-plan ul {
      margin-left: 20px;
      color: var(--text-dark);
    }

    .installment-plan li {
      margin-bottom: 5px;
      position: relative;
      padding-left: 5px;
    }

    .visa-logos {
      display: flex;
      flex-direction: column;
      align-items: center;
      justify-content: center;
      gap: 15px;
      flex-shrink: 0;
    }

    .visa-logos img {
      height: 80px;
      width: auto;
      filter: drop-shadow(0 2px 5px rgba(0, 0, 0, 0.1));
      transition: transform 0.3s ease;
    }

    .visa-logos img:hover {
      transform: scale(1.05);
    }

    /* Enhanced CTA Buttons */
    .hero-actions {
      margin-top: 20px;
      display: flex;
      gap: 12px;
      flex-wrap: wrap;
    }

    .action-btn {
      text-decoration: none;
      display: inline-flex;
      align-items: center;
      justify-content: center;
      padding: 14px 24px;
      border-radius: 30px;
      font-size: 16px;
      font-weight: 600;
      text-align: center;
      box-shadow: var(--shadow);
      transition: var(--transition);
      color: var(--white);
      gap: 8px;
      cursor: pointer;
      flex: 1;
      min-width: 200px;
      border: none;
    }

    .btn-process { 
      background: var(--primary-light); 
    }
    
    .btn-process:hover { 
      background: var(--primary);
      transform: translateY(-2px); 
      box-shadow: var(--shadow-hover);
    }
    
    .btn-call { 
      background: var(--primary); 
    }
    
    .btn-call:hover { 
      background: var(--primary-light);
      transform: translateY(-2px); 
      box-shadow: var(--shadow-hover);
    }
    
    .btn-whatsapp {
      background: var(--accent);
    }

    .btn-whatsapp:hover {
      background: var(--accent-dark);
      transform: translateY(-2px);
      box-shadow: var(--shadow-hover);
    }

    /* Enhanced Services List */
    .services-summary {
      margin-top: 30px;
      background: var(--white);
      border-radius: var(--radius);
      padding: 25px;
      box-shadow: var(--shadow);
      border: 1px solid var(--primary-lighter);
      transition: var(--transition);
    }

    .services-summary:hover {
      transform: translateY(-2px);
    }

    .services-summary h3 {
      font-size: 1.3rem;
      margin-bottom: 15px;
      color: var(--primary);
      display: flex;
      align-items: center;
      gap: 8px;
    }

    .services-grid {
      display: grid;
      grid-template-columns: 1fr 1fr;
      gap: 20px;
    }

    .services-list {
      list-style: none;
      padding: 0;
      margin: 0;
    }

    .services-list li {
      padding: 8px 0;
      border-bottom: 1px solid var(--primary-lighter);
      font-size: 15px;
      color: var(--text-dark);
      position: relative;
      padding-left: 20px;
      transition: var(--transition);
    }

    .services-list li:hover {
      color: var(--primary);
      padding-left: 25px;
    }

    .services-list li:before {
      content: '✓';
      position: absolute;
      left: 0;
      color: var(--accent);
      font-weight: bold;
    }

    .services-list li:last-child {
      border-bottom: none;
    }

    /* ===== ENQUIRY FORM SECTION (UNTOUCHED) ===== */
    .hero-form {
      flex: 1 1 38%;
      display: flex;
      justify-content: center;
    }

    .form-container {
      width: 100%;
      max-width: 500px;
      background: #fff !important;
      border: 2px solid #0a3d91 !important;
      border-radius: 12px !important;
      padding: 25px !important;
      box-shadow: 0 6px 16px rgba(0,0,0,0.08) !important;
      position: relative;
    }

    /* ===== ENHANCED PACKAGE DETAILS ===== */
    .package-details {
      background: var(--bg-light);
      padding: 80px 8%;
    }

    .container {
      max-width: 1200px;
      margin: 0 auto;
    }

    .package-details h2 {
      text-align: center;
      font-size: clamp(1.8rem, 4vw, 2.5rem);
      margin-bottom: 50px;
      color: var(--primary);
    }

    .package-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
      gap: 25px;
      margin-bottom: 50px;
    }

    .package-item {
      background: var(--white);
      padding: 30px 25px;
      border-radius: var(--radius);
      text-align: center;
      transition: var(--transition);
      border: 1px solid var(--primary-lighter);
      box-shadow: var(--shadow);
      display: flex;
      flex-direction: column;
      align-items: center;
    }

    .package-item:hover {
      transform: translateY(-5px);
      box-shadow: var(--shadow-hover);
    }

    .package-icon {
      width: 70px;
      height: 70px;
      background: var(--primary);
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      margin: 0 auto 20px;
      font-size: 28px;
      color: var(--white);
      transition: var(--transition);
    }

    .package-item:hover .package-icon {
      background: var(--primary-light);
      transform: scale(1.1);
    }

    .package-item h4 {
      font-size: 1.2rem;
      margin-bottom: 15px;
      color: var(--primary);
      font-weight: 600;
    }

    .package-item p {
      color: var(--text-light);
      font-size: 14px;
      line-height: 1.5;
    }

    /* ===== ENHANCED DOCUMENTS SECTION ===== */
    .documents-obligations {
      background: var(--white);
      padding: 80px 8%;
    }

    .docs-obligations-wrapper {
      display: grid;
      grid-template-columns: 1fr 1fr;
      gap: 50px;
      align-items: start;
      max-width: 1200px;
      margin: 0 auto;
    }

    .docs-section h2,
    .obligations-section h2 {
      font-size: clamp(1.5rem, 3vw, 2rem);
      margin-bottom: 30px;
      color: var(--primary);
      text-align: center;
    }

    .doc-category {
      margin-bottom: 30px;
      background: var(--bg-light);
      padding: 25px;
      border-radius: var(--radius);
      border: 1px solid var(--primary-lighter);
      transition: var(--transition);
    }

    .doc-category:hover {
      transform: translateX(5px);
      box-shadow: var(--shadow);
    }

    .doc-category h3 {
      font-size: 1.2rem;
      margin-bottom: 15px;
      color: var(--primary);
      border-bottom: 2px solid var(--primary-lighter);
      padding-bottom: 8px;
    }

    .doc-list {
      list-style: none;
      padding: 0;
      margin: 0;
    }

    .doc-list li {
      display: flex;
      align-items: center;
      padding: 10px 0;
      font-size: 15px;
      color: var(--text-dark);
      border-bottom: 1px solid var(--primary-lighter);
      transition: var(--transition);
    }

    .doc-list li:hover {
      color: var(--primary);
      padding-left: 5px;
    }

    .doc-list li:last-child {
      border-bottom: none;
    }

    .doc-list li i {
      color: var(--primary);
      margin-right: 12px;
      width: 20px;
      text-align: center;
    }

    .obligations-grid {
      display: grid;
      grid-template-columns: 1fr;
      gap: 15px;
    }

    .obligation-item {
      display: flex;
      align-items: center;
      background: var(--bg-light);
      padding: 18px 20px;
      border-radius: 12px;
      border: 1px solid var(--primary-lighter);
      transition: var(--transition);
    }

    .obligation-item:hover {
      transform: translateX(5px);
      box-shadow: var(--shadow);
      background: var(--white);
    }

    .obligation-icon {
      width: 45px;
      height: 45px;
      background: var(--primary);
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      margin-right: 15px;
      font-size: 18px;
      color: var(--white);
      flex-shrink: 0;
      transition: var(--transition);
    }

    .obligation-item:hover .obligation-icon {
      background: var(--primary-light);
      transform: scale(1.1);
    }

    .obligation-item span {
      font-size: 15px;
      font-weight: 500;
      color: var(--text-dark);
    }

    /* ===== ENHANCED FEATURES SECTION ===== */
    .features {
      background: var(--white);
      padding: 80px 8%;
    }

    .features h2 {
      text-align: center;
      font-size: clamp(1.8rem, 4vw, 2.5rem);
      margin-bottom: 50px;
    }

    .features-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
      gap: 30px;
      max-width: 1200px;
      margin: 0 auto;
    }

    .feature-card {
      background: var(--bg-light);
      padding: 40px 30px;
      border-radius: var(--radius);
      text-align: center;
      transition: var(--transition);
      border: 1px solid var(--primary-lighter);
      display: flex;
      flex-direction: column;
      align-items: center;
    }

    .feature-card:hover {
      transform: translateY(-5px);
      box-shadow: var(--shadow);
    }

    .feature-icon {
      width: 80px;
      height: 80px;
      background: var(--primary);
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      margin: 0 auto 20px;
      font-size: 32px;
      color: var(--white);
      transition: var(--transition);
    }

    .feature-card:hover .feature-icon {
      background: var(--primary-light);
      transform: scale(1.1);
    }

    .feature-card h3 {
      font-size: 1.4rem;
      margin-bottom: 15px;
    }

    .feature-card p {
      color: var(--text-light);
      line-height: 1.6;
    }

    /* ===== TOAST NOTIFICATION ===== */
    .toast {
      position: fixed;
      top: 20px;
      right: -400px;
      background: var(--primary);
      color: white;
      padding: 15px 25px;
      border-radius: 8px;
      box-shadow: var(--shadow-hover);
      font-weight: 600;
      transition: all 0.6s ease;
      z-index: 9999;
    }

    /* ===== RESPONSIVE DESIGN ===== */
    @media (max-width: 1024px) {
      .docs-obligations-wrapper {
        grid-template-columns: 1fr;
        gap: 40px;
      }
      
      .services-grid {
        grid-template-columns: 1fr;
      }
    }

    @media (max-width: 768px) {
      section {
        padding: 50px 5%;
      }

      .hero-container {
        padding: 30px 15px;
      }

      .hero-content {
        gap: 20px;
      }

      .visa-offer {
        flex-direction: column;
        text-align: center;
        padding: 20px;
      }

      .visa-logos {
        flex-direction: row;
        justify-content: center;
      }

      .hero-actions {
        flex-direction: column;
      }

      .action-btn {
        width: 100%;
      }

      .package-details {
        padding: 50px 5%;
      }

      .package-grid {
        grid-template-columns: 1fr;
        gap: 20px;
      }

      .documents-obligations {
        padding: 50px 5%;
      }

      .features {
        padding: 50px 5%;
      }

      .features-grid {
        grid-template-columns: 1fr;
      }
    }

    @media (max-width: 480px) {
      section {
        padding: 30px 4%;
      }

      .hero-container {
        padding: 20px 10px;
      }

      .package-item,
      .feature-card {
        padding: 25px 20px;
      }

      .doc-category {
        padding: 20px;
      }
    }

    /* ===== ANIMATIONS ===== */
    @keyframes fadeInUp {
      from {
        opacity: 0;
        transform: translateY(30px);
      }
      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    .fade-in {
      animation: fadeInUp 0.6s ease-out;
    }

    /* ===== ACCESSIBILITY ===== */
    @media (prefers-reduced-motion: reduce) {
      * {
        animation-duration: 0.01ms !important;
        animation-iteration-count: 1 !important;
        transition-duration: 0.01ms !important;
      }
    }

    /* Focus styles for accessibility */
    .action-btn:focus,
    .package-item:focus {
      outline: 2px solid var(--primary);
      outline-offset: 2px;
    }
  </style>
</head>

<body>
  <!-- Hero Section -->
<!-- Hero Section -->
<section class="hero-container" style="display:flex; flex-wrap:wrap; gap:30px; padding:40px; justify-content:flex-start;">
  <div class="hero-content" style="display:flex; flex-wrap:wrap; gap:30px; width:100%; justify-content:flex-start; align-items:flex-start;">

    <!-- Left Content Section -->
    <div class="hero-main fade-in" style="flex:1 1 600px; min-width:320px; display:flex; flex-direction:column; gap:24px; align-items:flex-start; text-align:left;">

      <h1 style="font-size:32px; color:#0a3d91; margin:0;">Professional 2-Year Maid Visa Services</h1>
      <p style="font-size:16px; color:#0a3d91; margin:0;">At Mountain Gate, we simplify the entire domestic visa process — from paperwork to final stamping — ensuring comfort, clarity, and peace of mind.</p>

      <!-- Visa Offer Block -->
      <div class="visa-offer fade-in" style="background:#fff; color:#0a3d91; padding:20px; border-radius:8px; border:1px solid #d6ddeb; width:100%; display:flex; flex-direction:column; align-items:flex-start; text-align:left;">
        <div class="visa-details" style="display:flex; flex-direction:column; gap:10px; align-items:flex-start; text-align:left;">
          <div class="visa-highlight" style="font-weight:bold; font-size:18px;">2-Year Maid's Visa</div>
          <div class="feature-item">Full Sponsorship & Fast-Track Process</div>
          <div class="feature-item">Dedicated PRO Officer & Complete Support</div>

          <div class="price-highlight" style="font-size:20px; font-weight:bold;">
            <strong>AED 7,700</strong>
            <p style="margin:0; font-size:14px;">+VAT 5%</p>
          </div>

          <!-- Installment Plan + Tamara -->
          <div class="installment-plan" style="margin-top:10px; display:flex; flex-direction:column; gap:12px; align-items:flex-start; text-align:left;">
            <h4 style="margin:0;">📅 Flexible Installment Plan</h4>

            <!-- Tamara Badge -->
            <div style="display:flex; align-items:center; gap:10px; background:#f9fafc; padding:10px 14px; border-radius:8px; border:1px solid #d6ddeb; width:fit-content;">
              <!-- ✅ Using fallback logo that loads -->
              <img src="https://upload.wikimedia.org/wikipedia/commons/5/5e/Tamara_logo.png"
                   onerror="this.src='https://mgtadbeer.com/tamara.png';"
                   alt="Tamara Logo"
                   style="width:65px; height:auto; display:block; border-radius:6px;" loading="lazy">
              <div style="display:flex; flex-direction:column; align-items:flex-start; line-height:1.3; text-align:left;">
                <span style="font-weight:bold; color:#0a3d91;">Tamara</span>
                <span style="font-weight:bold; color:#0a3d91;"></span>
                <a href="https://www.visa.mgtadbeer.com/terms-and-conditions" 
                   target="_blank" 
                   style="font-size:12px; color:#000; text-decoration:underline;">
                   Terms & Conditions Apply
                </a>
              </div>
            </div>
          </div>
        </div>
      </div>

      <!-- CTA Buttons -->
      <div class="hero-actions" style="display:flex; flex-wrap:wrap; gap:10px; margin-top:10px;">
        <a href="https://visa.mgtadbeer.com/public/process.html" style="background:#ffcc00; color:#0a3d91; padding:10px 15px; border-radius:5px; text-decoration:none; font-weight:bold;">
          <i class="fas fa-list-alt"></i> Visa Process
        </a>
        <a href="tel:+97144018888" style="background:#0a3d91; color:#fff; padding:10px 15px; border-radius:5px; text-decoration:none; font-weight:bold;">
          <i class="fas fa-phone"></i> Call Us
        </a>
        <a href="https://wa.me/97144018888" target="_blank" rel="noopener noreferrer" style="background:#25D366; color:#fff; padding:10px 15px; border-radius:5px; text-decoration:none; font-weight:bold;">
          <i class="fab fa-whatsapp"></i> WhatsApp
        </a>
      </div>

      <!-- Services Summary -->
      <div class="services-summary fade-in" style="margin-top:20px;">
        <div class="services-grid" style="display:flex; gap:30px; flex-wrap:wrap;">
          <div>
            <h3 style="font-size:18px; color:#0a3d91;"><i class="fas fa-check-circle"></i> Included Services</h3>
            <ul style="list-style:none; padding:0; color:#0a3d91;">
              <li>Entry Permit & Change of Status</li>
              <li>Medical Fitness Test</li>
              <li>Emirates ID Processing</li>
              <li>Employment Contract</li>
              <li>WPS Salary System</li>
              <li>Visa Stamping</li>
            </ul>
          </div>
          <div>
<h3 style="font-size:18px; color:#ff4d4d !important;">
  <i class="fas fa-times-circle"></i> Not Included
</h3>
          <ul style="list-style:none !important; padding:0 !important; color:#ff4d4d !important;">
  <li style="color:#ff4d4d !important;">ILOE Insurance</li>
  <li style="color:#ff4d4d !important;">Visa Cancellation</li>
  <li style="color:#ff4d4d !important;">Hepatitis B Vaccine</li>
  <li style="color:#ff4d4d !important;">Overstay Fine (if applicable)</li>
</ul>

          </div>
        </div>
      </div>
    </div>

    <!-- Right Form Section -->
<!-- Right Form Section -->
<div
  style="
    flex: 1 1 320px;
    min-width: 280px;
    display: flex;
    justify-content: center;
    align-items: flex-start;
    padding: 20px;
    position: sticky;
    top: 100px;
  "
>
  <div
    style="
      width: 100%;
      max-width: 520px;
      background: #fff;
      border-radius: 16px;
      box-shadow: 0 12px 32px rgba(0, 0, 0, 0.08);
      border: 1px solid #e0e7f1;
      transition: all 0.3s ease;
    "
  >
    <div
      style="
        width: 100%;
        background: #fff;
        padding: 24px 28px;
        border-radius: 12px;
        box-shadow: 0 4px 10px rgba(0, 0, 0, 0.05);
        transition: all 0.3s ease-in-out;
        display: flex;
        flex-direction: column;
        gap: 16px;
      "
    >
      @include('web.includes.enquire_now',['type'=>'Visa Service'])
    </div>
  </div>
</div>

<!-- Responsive behavior: disable sticky on mobile -->
<style>
  @media (max-width: 991px) {
    div[style*="position: sticky"] {
      position: static !important;
      top: auto !important;
    }
  }
</style>

  </div>
</section>


</div>

  <!-- All Services Section -->
  <section class="package-details">
    <div class="container">
      <h2>Complete Visa & Support Services</h2>
      
      <div class="package-grid">
        <!-- Service Items -->
        <div class="package-item fade-in">
          <div class="package-icon">
            <i class="fas fa-id-card"></i>
          </div>
          <h4>Company Provided Employee Visa</h4>
          <p>Complete visa processing under our company sponsorship with full legal compliance</p>
        </div>

        <div class="package-item fade-in">
          <div class="package-icon">
            <i class="fas fa-shield-alt"></i>
          </div>
          <h4>WPS Salary System</h4>
          <p>Secure salary processing through government-approved WPS system</p>
        </div>

        <div class="package-item fade-in">
          <div class="package-icon">
            <i class="fas fa-fingerprint"></i>
          </div>
          <h4>Emirates ID</h4>
          <p>Official Emirates ID card processing, biometrics, and issuance</p>
        </div>

        <div class="package-item fade-in">
          <div class="package-icon">
            <i class="fas fa-handshake"></i>
          </div>
          <h4>HR Conflict Resolution</h4>
          <p>Professional HR support and mediation for any workplace issues</p>
        </div>

        <div class="package-item fade-in">
          <div class="package-icon">
            <i class="fas fa-search"></i>
          </div>
          <h4>Visa Tracker Access</h4>
          <p>Real-time tracking of your visa application status with updates</p>
        </div>

        <div class="package-item fade-in">
          <div class="package-icon">
            <i class="fas fa-calendar-check"></i>
          </div>
          <h4>30 Days Settling Program</h4>
          <p>Comprehensive support during the first month of employment</p>
        </div>
      </div>
    </div>
  </section>

  <!-- Documents & Obligations Section -->
  <section class="documents-obligations">
    <div class="container">
      <div class="docs-obligations-wrapper">
        <!-- Documents Required -->
        <div class="docs-section fade-in">
          <h2>📋 Required Documents</h2>
          
          <div class="doc-category">
            <h3>For Sponsor</h3>
            <ul class="doc-list">
              <li><i class="fas fa-passport"></i> Passport Copy (Colour)</li>
              <li><i class="fas fa-id-card"></i> Emirates ID Copy</li>
            </ul>
          </div>

          <div class="doc-category">
            <h3>For Domestic Worker</h3>
            <ul class="doc-list">
              <li><i class="fas fa-passport"></i> Passport Copy (Minimum 6 months validity)</li>
              <li><i class="fas fa-camera"></i> Passport Size Photo (White Background)</li>
              <li><i class="fas fa-file-alt"></i> Current Visa Copy or Cancellation Paper</li>
              <li><i class="fas fa-certificate"></i> Police Clearance (Specific Countries)</li>
              <li><i class="fas fa-id-badge"></i> National ID (Pakistani Nationals)</li>
            </ul>
          </div>
        </div>

        <!-- Client's Obligations -->
<!-- Client's Obligations -->
<div class="obligations-section fade-in">
  <h2>🤝 Employer Responsibilities</h2>
  
  <div class="obligations-grid">
    <!-- Accommodation & Meals -->
    <div class="obligation-item">
      <div class="obligation-icon">
        <i class="fas fa-home"></i>
      </div>
      <span>Decent Accommodation + 3 Nutritious Meals Daily</span>
    </div>
    
    <!-- Hygiene & Connectivity -->
    <div class="obligation-item">
      <div class="obligation-icon">
        <i class="fas fa-soap"></i>
      </div>
      <span>Toiletries, Sanitary Products & Free Wi-Fi</span>
    </div>
    
    <!-- Working Hours & Sleep -->
    <div class="obligation-item">
      <div class="obligation-icon">
        <i class="fas fa-clock"></i>
      </div>
      <span>Max 12 Hours Duty + 8 Hours Uninterrupted Sleep</span>
    </div>
    
    <!-- Rest & Compensation -->
    <div class="obligation-item">
      <div class="obligation-icon">
        <i class="fas fa-calendar-day"></i>
      </div>
      <span>1 Weekly Day Off + Leave Salary & End of Service Benefits</span>
    </div>
    
    <!-- Travel -->
    <div class="obligation-item">
      <div class="obligation-icon">
        <i class="fas fa-plane"></i>
      </div>
      <span>Return Flight Ticket</span>
    </div>
  </div>
</div>

  </section>

  <!-- Features Section -->
<section class="features" style="padding: 80px 0; text-align: center; background: #f9f9f9;">
  <h2 style="font-size: 2.2rem; color: #0a3d91; margin-bottom: 40px;">Why Choose Mountain Gate?</h2>
  
  <div class="features-grid" style="display: flex; flex-wrap: wrap; gap: 30px; justify-content: center;">
    
    <!-- Feature 1 -->
    <div class="feature-card fade-in" style="background: #fff; border-radius: 16px; padding: 30px 20px; width: 280px; box-shadow: 0 10px 30px rgba(0,0,0,0.08); transition: transform 0.3s ease, box-shadow 0.3s ease; cursor: pointer;">
      <div class="feature-icon" style="font-size: 2.5rem; color: #f5a623; margin-bottom: 20px;">
        <i class="fas fa-bolt"></i>
      </div>
      <h3 style="font-size: 1.2rem; color: #0a3d91; margin-bottom: 12px; font-weight: 600;">Fast Processing</h3>
      <p style="font-size: 0.95rem; color: #555; line-height: 1.5;">Complete visa processing within 7-10 working days with dedicated PRO officers and priority handling.</p>
    </div>
    
    <!-- Feature 2 -->
    <div class="feature-card fade-in" style="background: #fff; border-radius: 16px; padding: 30px 20px; width: 280px; box-shadow: 0 10px 30px rgba(0,0,0,0.08); transition: transform 0.3s ease, box-shadow 0.3s ease; cursor: pointer;">
      <div class="feature-icon" style="font-size: 2.5rem; color: #28a745; margin-bottom: 20px;">
        <i class="fas fa-gavel"></i>
      </div>
      <h3 style="font-size: 1.2rem; color: #0a3d91; margin-bottom: 12px; font-weight: 600;">100% Legal Compliance</h3>
      <p style="font-size: 0.95rem; color: #555; line-height: 1.5;">All services fully compliant with UAE immigration laws and regulations. Licensed and authorized processing.</p>
    </div>
    
    <!-- Feature 3 -->
    <div class="feature-card fade-in" style="background: #fff; border-radius: 16px; padding: 30px 20px; width: 280px; box-shadow: 0 10px 30px rgba(0,0,0,0.08); transition: transform 0.3s ease, box-shadow 0.3s ease; cursor: pointer;">
      <div class="feature-icon" style="font-size: 2.5rem; color: #007bff; margin-bottom: 20px;">
        <i class="fas fa-headset"></i>
      </div>
      <h3 style="font-size: 1.2rem; color: #0a3d91; margin-bottom: 12px; font-weight: 600;">24/7 Customer Support</h3>
      <p style="font-size: 0.95rem; color: #555; line-height: 1.5;">Round-the-clock multilingual support to answer your questions and provide real-time application updates.</p>
    </div>
    
  </div>
</section>

<!-- Hover Effect for Cards -->
<style>
  .feature-card:hover {
    transform: translateY(-8px) scale(1.03);
    box-shadow: 0 20px 40px rgba(0,0,0,0.15);
  }

  @media (max-width: 768px) {
    .features-grid {
      flex-direction: column;
      align-items: center;
    }
    .feature-card {
      width: 90%;
    }
  }
</style>


  <script>
    // Enhanced toast notification
    function showSuccessToast() {
      const toast = document.getElementById('successToast');
      toast.style.right = '20px';
      setTimeout(() => {
        toast.style.right = '-400px';
      }, 3000);
    }

    // Form submission handler for the included form
    document.addEventListener('DOMContentLoaded', () => {
      const form = document.querySelector('.message_box form');
      if (form) {
        form.addEventListener('submit', (e) => {
          e.preventDefault();
          showSuccessToast();
          setTimeout(() => form.reset(), 500);
        });
      }

      // Smooth scroll for anchor links
      document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
          e.preventDefault();
          const target = document.querySelector(this.getAttribute('href'));
          if (target) {
            target.scrollIntoView({
              behavior: 'smooth',
              block: 'start'
            });
          }
        });
      });

      // Add click animation to buttons
      document.querySelectorAll('.action-btn').forEach(button => {
        button.addEventListener('click', function() {
          this.style.transform = 'scale(0.95)';
          setTimeout(() => {
            this.style.transform = '';
          }, 150);
        });
      });

      // Intersection Observer for scroll animations
      const observerOptions = {
        threshold: 0.1,
        rootMargin: '0px 0px -50px 0px'
      };

      const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
          if (entry.isIntersecting) {
            entry.target.classList.add('fade-in');
          }
        });
      }, observerOptions);

      // Observe all sections for animation
      document.querySelectorAll('section').forEach(section => {
        observer.observe(section);
      });
    });

    // Lazy loading for images
    document.addEventListener('DOMContentLoaded', function() {
      const lazyImages = [].slice.call(document.querySelectorAll('img[loading="lazy"]'));
      
      if ('IntersectionObserver' in window) {
        const lazyImageObserver = new IntersectionObserver(function(entries, observer) {
          entries.forEach(function(entry) {
            if (entry.isIntersecting) {
              const lazyImage = entry.target;
              lazyImage.src = lazyImage.dataset.src;
              lazyImageObserver.unobserve(lazyImage);
            }
          });
        });

        lazyImages.forEach(function(lazyImage) {
          lazyImageObserver.observe(lazyImage);
        });
      }
    });
  </script>
</body>
</html>

@endsection