@extends('web.layouts.main') 
@section('content') 

<html lang="en">
 <head>
  <style>@view-transition { navigation: auto; }</style>
  <script src="/_sdk/data_sdk.js" type="text/javascript"></script>
  <script src="https://cdn.tailwindcss.com" type="text/javascript"></script>
 </head>
 <body>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Dubai's #1 Domestic Worker Visa Service | Mountain Gate L.L.C</title>
  <meta name="description" content="Get your domestic worker visa processed in 24-48 hours. MOHRE-licensed service with 100% money-back guarantee. Trusted by 25,000+ families in Dubai.">
  <script src="/_sdk/element_sdk.js"></script>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&amp;display=swap" rel="stylesheet">
  <style>
        :root {
            --primary-color: #0a3d91;
            --primary-dark: #051f4a;
            --primary-light: #1e5bb8;
            --accent-color: #00d4ff;
            --accent-dark: #0099cc;
            --success-color: #00ff88;
            --warning-color: #ff6b35;
            --text-primary: #0f172a;
            --text-secondary: #475569;
            --text-light: #94a3b8;
            --bg-primary: #ffffff;
            --bg-secondary: #f8fafc;
            --bg-tertiary: #f1f5f9;
            --bg-dark: #0f172a;
            --border-color: #e2e8f0;
            --glass-bg: rgba(255, 255, 255, 0.1);
            --glass-border: rgba(255, 255, 255, 0.2);
            --shadow-sm: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
            --shadow-md: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
            --shadow-lg: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
            --shadow-xl: 0 20px 25px -5px rgba(0, 0, 0, 0.1);
            --shadow-2xl: 0 25px 50px -12px rgba(0, 0, 0, 0.25);
            --shadow-glow: 0 0 40px rgba(0, 212, 255, 0.3);
            --gradient-primary: linear-gradient(135deg, #0a3d91 0%, #1e5bb8 50%, #00d4ff 100%);
            --gradient-accent: linear-gradient(135deg, #00d4ff 0%, #0099cc 100%);
            --gradient-success: linear-gradient(135deg, #00ff88 0%, #00cc6a 100%);
        }

        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }

        html {
            height: 100%;
            scroll-behavior: smooth;
        }

        body {
            box-sizing: border-box;
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            line-height: 1.6;
            color: var(--text-primary);
            background: var(--bg-primary);
            min-height: 100%;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 24px;
        }

        .container-wide {
            max-width: 1400px;
            margin: 0 auto;
            padding: 0 24px;
        }

        /* Skip link for accessibility */
        .skip-link {
            position: absolute;
            top: -40px;
            left: 6px;
            background: var(--primary-color);
            color: white;
            padding: 8px 16px;
            text-decoration: none;
            z-index: 9999;
            border-radius: 8px;
            font-weight: 600;
            transition: all 0.3s ease;
        }

        .skip-link:focus {
            top: 6px;
        }

        /* Urgent Banner */
        .urgent-banner {
            background: linear-gradient(135deg, #dc2626 0%, #b91c1c 100%);
            color: white;
            text-align: center;
            padding: 16px 0;
            font-weight: 700;
            font-size: 15px;
            position: relative;
            overflow: hidden;
            box-shadow: var(--shadow-md);
        }

        .urgent-banner::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
            animation: shine 3s infinite;
        }

        @keyframes shine {
            0% { left: -100%; }
            100% { left: 100%; }
        }

        .urgent-text {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 12px;
            font-size: 16px;
        }

        .pulse-dot {
            width: 10px;
            height: 10px;
            background: #fff;
            border-radius: 50%;
            animation: pulse 1.5s infinite;
        }

        @keyframes pulse {
            0%, 100% { opacity: 1; transform: scale(1); }
            50% { opacity: 0.7; transform: scale(1.3); }
        }

        /* Hero Section - Optimized */
        .hero-section {
            background: var(--gradient-primary);
            padding: 60px 0 80px;
            position: relative;
            overflow: hidden;
            min-height: 90vh;
            display: flex;
            align-items: center;
        }

        .hero-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: 
                radial-gradient(circle at 20% 80%, rgba(0, 212, 255, 0.12) 0%, transparent 60%),
                radial-gradient(circle at 80% 20%, rgba(0, 255, 136, 0.08) 0%, transparent 60%);
            will-change: transform;
            animation: backgroundFloat 25s ease-in-out infinite;
        }

        @keyframes backgroundFloat {
            0%, 100% { transform: translateY(0px) scale(1); }
            50% { transform: translateY(-15px) scale(1.02); }
        }

        .hero-content {
            display: grid;
            grid-template-columns: 1.2fr 0.8fr;
            gap: 60px;
            align-items: center;
            position: relative;
            z-index: 2;
            max-width: 1400px;
            margin: 0 auto;
        }

        .hero-left {
            color: white;
        }

        .hero-badge {
            display: inline-flex;
            align-items: center;
            gap: 10px;
            background: rgba(255, 255, 255, 0.15);
            backdrop-filter: blur(20px);
            padding: 12px 24px;
            border-radius: 50px;
            font-size: 15px;
            font-weight: 700;
            margin-bottom: 32px;
            border: 1px solid rgba(255, 255, 255, 0.2);
            box-shadow: var(--shadow-lg);
        }

        .hero-title {
            font-size: clamp(2.8rem, 5.5vw, 4.5rem);
            font-weight: 900;
            margin-bottom: 20px;
            line-height: 1.15;
            letter-spacing: -0.02em;
        }

        .hero-title .highlight {
            color: var(--accent-color);
            text-shadow: 0 2px 4px rgba(0,0,0,0.2);
        }

        .hero-subtitle {
            font-size: 1.5rem;
            font-weight: 700;
            margin-bottom: 16px;
            opacity: 0.95;
            color: rgba(255, 255, 255, 0.9);
        }

        .hero-description {
            font-size: 1.1rem;
            margin-bottom: 36px;
            opacity: 0.9;
            line-height: 1.6;
            color: rgba(255, 255, 255, 0.85);
            max-width: 90%;
        }

        .hero-buttons {
            display: flex;
            gap: 20px;
            flex-wrap: wrap;
            margin-bottom: 40px;
        }

        .btn {
            display: inline-flex;
            align-items: center;
            gap: 10px;
            padding: 18px 36px;
            border-radius: 50px;
            text-decoration: none;
            font-weight: 700;
            font-size: 16px;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            border: none;
            cursor: pointer;
            position: relative;
            overflow: hidden;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            box-shadow: var(--shadow-lg);
            white-space: nowrap;
        }

        .btn-primary {
            background: var(--gradient-accent);
            color: white;
            font-weight: 800;
            position: relative;
            overflow: hidden;
        }

        .btn-primary::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.3), transparent);
            transition: left 0.6s ease;
        }

        .btn-primary:hover {
            transform: translateY(-4px);
            box-shadow: var(--shadow-glow);
            background: var(--gradient-accent);
        }

        .btn-primary:hover::before {
            left: 100%;
        }

        .btn-secondary {
            background: rgba(255, 255, 255, 0.15);
            color: white;
            border: 2px solid rgba(255, 255, 255, 0.3);
            backdrop-filter: blur(20px);
        }

        .btn-secondary:hover {
            background: rgba(255, 255, 255, 0.25);
            transform: translateY(-3px);
            box-shadow: 0 12px 30px rgba(255, 255, 255, 0.2);
        }

        .hero-guarantees {
            display: flex;
            gap: 40px;
            flex-wrap: wrap;
        }

        .guarantee-item {
            display: flex;
            align-items: center;
            gap: 12px;
            font-size: 15px;
            font-weight: 700;
        }

        .guarantee-icon {
            width: 24px;
            height: 24px;
            background: var(--success-color);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 14px;
            box-shadow: var(--shadow-md);
        }

        .hero-right {
            position: relative;
            display: flex;
            justify-content: center;
        }

        .hero-image-container {
            position: relative;
            width: 100%;
            max-width: 550px;
        }

        .hero-image {
            width: 100%;
            height: auto;
            border-radius: 32px;
            box-shadow: 0 30px 80px rgba(0, 0, 0, 0.4);
            transition: transform 0.4s ease;
            border: 4px solid rgba(255, 255, 255, 0.1);
        }

        .hero-image:hover {
            transform: scale(1.02) rotate(1deg);
        }

        .floating-card {
            position: absolute;
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(30px);
            padding: 28px;
            border-radius: 24px;
            box-shadow: var(--shadow-2xl);
            border: 1px solid rgba(255, 255, 255, 0.3);
            animation: floatingCard 6s ease-in-out infinite;
        }

        @keyframes floatingCard {
            0%, 100% { transform: translateY(0px) rotate(0deg); }
            50% { transform: translateY(-15px) rotate(2deg); }
        }

        .floating-card-1 {
            top: 30px;
            right: -30px;
            width: 200px;
        }

        .floating-card-2 {
            bottom: 50px;
            left: -40px;
            width: 220px;
        }

        .card-stat {
            font-size: 2.5rem;
            font-weight: 900;
            color: var(--primary-color);
            margin-bottom: 8px;
            line-height: 1;
        }

        .card-label {
            font-size: 14px;
            color: var(--text-secondary);
            font-weight: 600;
        }

        /* Trust Indicators */
        .trust-section {
            background: white;
            padding: 80px 0;
            border-bottom: 1px solid var(--border-color);
        }

        .trust-content {
            text-align: center;
        }

        .trust-title {
            font-size: 1.2rem;
            color: var(--text-secondary);
            margin-bottom: 40px;
            font-weight: 600;
        }

        .trust-logos {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 60px;
            flex-wrap: wrap;
        }

        .trust-logo {
            display: flex;
            align-items: center;
            gap: 16px;
            font-weight: 700;
            color: var(--text-primary);
            font-size: 17px;
            transition: all 0.3s ease;
        }

        .trust-logo:hover {
            transform: translateY(-2px);
        }

        .trust-icon {
            width: 48px;
            height: 48px;
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-light) 100%);
            border-radius: 16px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            box-shadow: var(--shadow-md);
        }

        /* Services Section - Optimized */
        .services-section {
            padding: 60px 0;
            background: linear-gradient(135deg, var(--bg-secondary) 0%, rgba(248, 250, 252, 0.9) 100%);
        }

        .section-header {
            text-align: center;
            margin-bottom: 50px;
        }

        .section-badge {
            display: inline-block;
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-light) 100%);
            color: white;
            padding: 10px 24px;
            border-radius: 50px;
            font-size: 14px;
            font-weight: 700;
            margin-bottom: 20px;
            box-shadow: var(--shadow-md);
        }

        .section-title {
            font-size: clamp(2.2rem, 4.5vw, 3.5rem);
            font-weight: 900;
            color: var(--text-primary);
            margin-bottom: 20px;
            letter-spacing: -0.02em;
        }

        .section-subtitle {
            font-size: 1.2rem;
            color: var(--text-secondary);
            max-width: 700px;
            margin: 0 auto;
            line-height: 1.5;
        }

        .services-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(520px, 1fr));
            gap: 40px;
            max-width: 1200px;
            margin: 0 auto;
        }

        .service-card {
            background: rgba(255, 255, 255, 0.98);
            backdrop-filter: blur(15px);
            border-radius: 20px;
            padding: 40px;
            box-shadow: var(--shadow-lg);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            border: 1px solid rgba(255, 255, 255, 0.4);
            position: relative;
            overflow: hidden;
            height: fit-content;
        }

        .service-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: var(--gradient-accent);
        }

        .service-card::after {
            content: '';
            position: absolute;
            top: -30%;
            left: -30%;
            width: 160%;
            height: 160%;
            background: radial-gradient(circle, rgba(0, 212, 255, 0.04) 0%, transparent 70%);
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .service-card:hover {
            transform: translateY(-8px) scale(1.01);
            box-shadow: var(--shadow-xl), 0 0 25px rgba(0, 212, 255, 0.15);
        }

        .service-card:hover::after {
            opacity: 1;
        }

        .service-header {
            display: flex;
            align-items: center;
            gap: 24px;
            margin-bottom: 30px;
        }

        .service-icon {
            width: 70px;
            height: 70px;
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-light) 100%);
            border-radius: 18px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            flex-shrink: 0;
            box-shadow: var(--shadow-md);
        }

        .service-title {
            font-size: 1.8rem;
            font-weight: 900;
            color: var(--text-primary);
            margin: 0;
            line-height: 1.3;
        }

        .service-price {
            background: var(--gradient-accent);
            color: white;
            padding: 14px 28px;
            border-radius: 50px;
            font-weight: 800;
            font-size: 18px;
            margin-bottom: 30px;
            display: inline-flex;
            align-items: center;
            gap: 10px;
            box-shadow: var(--shadow-md);
            position: relative;
            z-index: 2;
        }

        .service-price::before {
            content: '💎';
            font-size: 18px;
        }

        .service-features {
            list-style: none;
            padding: 0;
            margin: 0 0 35px 0;
        }

        .service-features li {
            padding: 15px 0;
            position: relative;
            padding-left: 40px;
            color: var(--text-secondary);
            line-height: 1.5;
            font-size: 15px;
            border-bottom: 1px solid var(--bg-tertiary);
            font-weight: 500;
        }

        .service-features li:last-child {
            border-bottom: none;
        }

        .service-features li::before {
            content: "✓";
            position: absolute;
            left: 0;
            top: 15px;
            color: var(--success-color);
            font-weight: bold;
            font-size: 18px;
            width: 26px;
            height: 26px;
            background: rgba(16, 185, 129, 0.1);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .service-cta {
            display: flex;
            gap: 16px;
            flex-wrap: wrap;
        }

        .btn-service {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-light) 100%);
            color: white;
            padding: 18px 36px;
            border-radius: 50px;
            text-decoration: none;
            font-weight: 700;
            font-size: 17px;
            transition: all 0.3s ease;
            border: none;
            cursor: pointer;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            box-shadow: var(--shadow-md);
        }

        .btn-service:hover {
            transform: translateY(-3px);
            box-shadow: var(--shadow-lg);
        }

        .btn-service.secondary {
            background: transparent;
            color: var(--primary-color);
            border: 2px solid var(--primary-color);
        }

        .btn-service.secondary:hover {
            background: var(--primary-color);
            color: white;
        }

        /* Process Section - Optimized */
        .process-section {
            padding: 60px 0;
            background: white;
        }

        .process-steps {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 40px;
            margin-top: 60px;
            max-width: 1200px;
            margin-left: auto;
            margin-right: auto;
        }

        .process-step {
            text-align: center;
            position: relative;
        }

        .step-number {
            width: 70px;
            height: 70px;
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-light) 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 2rem;
            font-weight: 900;
            margin: 0 auto 30px;
            position: relative;
            z-index: 2;
            box-shadow: var(--shadow-md);
        }

        .step-number::after {
            content: '';
            position: absolute;
            top: 50%;
            left: 100%;
            width: 120px;
            height: 3px;
            background: linear-gradient(90deg, var(--primary-color), transparent);
            transform: translateY(-50%);
            z-index: 1;
        }

        .process-step:last-child .step-number::after {
            display: none;
        }

        .step-title {
            font-size: 1.75rem;
            font-weight: 800;
            color: var(--text-primary);
            margin-bottom: 20px;
        }

        .step-description {
            color: var(--text-secondary);
            line-height: 1.7;
            font-size: 17px;
        }

        /* Guarantee Section - Optimized */
        .guarantee-section {
            background: var(--gradient-success);
            padding: 70px 0;
            color: white;
            text-align: center;
            position: relative;
            overflow: hidden;
        }

        .guarantee-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: radial-gradient(circle at 30% 70%, rgba(255, 255, 255, 0.08) 0%, transparent 50%);
            animation: patternMove 25s linear infinite;
        }

        @keyframes patternMove {
            0% { transform: translateX(0) translateY(0) scale(1); }
            100% { transform: translateX(15px) translateY(15px) scale(1.05); }
        }

        .guarantee-content {
            max-width: 800px;
            margin: 0 auto;
            position: relative;
            z-index: 2;
        }

        .guarantee-icon-large {
            width: 90px;
            height: 90px;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 30px;
            font-size: 3rem;
            box-shadow: var(--shadow-md);
        }

        .guarantee-title {
            font-size: clamp(2.5rem, 4vw, 3rem);
            font-weight: 900;
            margin-bottom: 20px;
        }

        .guarantee-subtitle {
            font-size: 1.2rem;
            margin-bottom: 35px;
            opacity: 0.9;
            max-width: 600px;
            margin-left: auto;
            margin-right: auto;
        }

        .guarantee-features {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 40px;
            margin-top: 60px;
        }

        .guarantee-feature {
            display: flex;
            align-items: center;
            gap: 20px;
            justify-content: center;
        }

        .guarantee-feature-icon {
            width: 48px;
            height: 48px;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
        }

        /* Stats Section */
        .stats-section {
            background: var(--text-primary);
            padding: 100px 0;
            color: white;
        }

        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 60px;
        }

        .stat-item {
            text-align: center;
        }

        .stat-number {
            font-size: 4.5rem;
            font-weight: 900;
            color: var(--accent-color);
            margin-bottom: 20px;
            line-height: 1;
        }

        .stat-label {
            font-size: 1.3rem;
            opacity: 0.9;
            font-weight: 600;
        }

        /* Testimonials Section - Optimized */
        .testimonials-section {
            padding: 60px 0;
            background: var(--bg-secondary);
        }

        .testimonials-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(400px, 1fr));
            gap: 35px;
            margin-top: 60px;
            max-width: 1200px;
            margin-left: auto;
            margin-right: auto;
        }

        .testimonial-card {
            background: rgba(255, 255, 255, 0.98);
            backdrop-filter: blur(15px);
            border-radius: 20px;
            padding: 35px;
            box-shadow: var(--shadow-lg);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            border: 1px solid rgba(255, 255, 255, 0.4);
            overflow: hidden;
            height: fit-content;
        }

        .testimonial-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 3px;
            background: var(--gradient-accent);
        }

        .testimonial-card:hover {
            transform: translateY(-6px) scale(1.01);
            box-shadow: var(--shadow-xl), 0 0 20px rgba(0, 212, 255, 0.15);
        }

        .testimonial-stars {
            display: flex;
            gap: 6px;
            margin-bottom: 30px;
        }

        .star {
            color: var(--accent-color);
            font-size: 28px;
        }

        .testimonial-text {
            font-size: 17px;
            line-height: 1.8;
            color: var(--text-secondary);
            margin-bottom: 40px;
            font-style: italic;
            position: relative;
        }

        .testimonial-text::before {
            content: '"';
            position: absolute;
            top: -30px;
            left: -30px;
            font-size: 80px;
            color: var(--primary-color);
            opacity: 0.2;
            font-family: serif;
        }

        .testimonial-author {
            display: flex;
            align-items: center;
            gap: 24px;
        }

        .author-avatar {
            width: 70px;
            height: 70px;
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-light) 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: 800;
            font-size: 24px;
            box-shadow: var(--shadow-md);
        }

        .author-name {
            font-weight: 700;
            color: var(--text-primary);
            margin-bottom: 6px;
            font-size: 20px;
        }

        .author-title {
            font-size: 15px;
            color: var(--text-secondary);
        }

        /* CTA Section - Optimized */
        .cta-section {
            background: var(--gradient-primary);
            padding: 80px 0;
            color: white;
            text-align: center;
            position: relative;
            overflow: hidden;
        }

        .cta-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: 
                radial-gradient(circle at 25% 75%, rgba(0, 212, 255, 0.12) 0%, transparent 60%),
                radial-gradient(circle at 75% 25%, rgba(0, 255, 136, 0.08) 0%, transparent 60%);
            animation: circuitGlow 20s ease-in-out infinite;
        }

        @keyframes circuitGlow {
            0%, 100% { opacity: 0.8; }
            50% { opacity: 1; }
        }

        .cta-content {
            position: relative;
            z-index: 2;
            max-width: 800px;
            margin: 0 auto;
        }

        .cta-title {
            font-size: clamp(2.5rem, 4.5vw, 3.5rem);
            font-weight: 900;
            margin-bottom: 24px;
            line-height: 1.2;
        }

        .cta-subtitle {
            font-size: 1.3rem;
            margin-bottom: 45px;
            opacity: 0.9;
            max-width: 600px;
            margin-left: auto;
            margin-right: auto;
        }

        .cta-buttons {
            display: flex;
            gap: 32px;
            justify-content: center;
            flex-wrap: wrap;
            margin-bottom: 50px;
        }

        .btn-cta-primary {
            background: linear-gradient(45deg, var(--accent-color), var(--accent-dark));
            color: var(--text-primary);
            padding: 24px 48px;
            border-radius: 50px;
            text-decoration: none;
            font-weight: 800;
            font-size: 20px;
            transition: all 0.3s ease;
            text-transform: uppercase;
            letter-spacing: 1px;
            box-shadow: var(--shadow-xl);
        }

        .btn-cta-primary:hover {
            transform: translateY(-4px);
            box-shadow: 0 20px 50px rgba(255, 215, 0, 0.4);
        }

        .btn-whatsapp {
            background: #25d366;
            color: white;
            padding: 24px 48px;
            border-radius: 50px;
            text-decoration: none;
            font-weight: 700;
            font-size: 20px;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            gap: 16px;
            box-shadow: var(--shadow-xl);
        }

        .btn-whatsapp:hover {
            background: #128c7e;
            transform: translateY(-4px);
            box-shadow: 0 20px 50px rgba(37, 211, 102, 0.4);
        }

        .cta-guarantee {
            font-size: 18px;
            opacity: 0.9;
            font-weight: 600;
        }

        /* Contact Section - Optimized */
        .contact-section {
            padding: 70px 0;
            background: white;
        }

        .contact-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(320px, 1fr));
            gap: 35px;
            margin-top: 60px;
            max-width: 1000px;
            margin-left: auto;
            margin-right: auto;
        }

        .contact-card {
            background: rgba(255, 255, 255, 0.98);
            backdrop-filter: blur(15px);
            padding: 35px;
            border-radius: 20px;
            text-align: center;
            box-shadow: var(--shadow-lg);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            border: 1px solid rgba(255, 255, 255, 0.4);
            text-decoration: none;
            color: inherit;
            position: relative;
            overflow: hidden;
            height: fit-content;
        }

        .contact-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 3px;
            background: var(--gradient-accent);
        }

        .contact-card:hover {
            transform: translateY(-8px) scale(1.02);
            box-shadow: var(--shadow-xl), 0 0 20px rgba(0, 212, 255, 0.15);
            color: inherit;
        }

        .contact-icon {
            width: 90px;
            height: 90px;
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-light) 100%);
            border-radius: 24px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            margin: 0 auto 32px;
            box-shadow: var(--shadow-lg);
        }

        .whatsapp-icon {
            background: linear-gradient(135deg, #25d366 0%, #128c7e 100%);
        }

        .contact-title {
            font-size: 1.75rem;
            font-weight: 800;
            color: var(--text-primary);
            margin-bottom: 12px;
        }

        .contact-info {
            font-size: 1.2rem;
            color: var(--primary-color);
            font-weight: 700;
            margin-bottom: 20px;
        }

        .contact-description {
            color: var(--text-secondary);
            line-height: 1.6;
            font-size: 16px;
        }

        /* Modal Styles */
        .modal {
            display: none;
            position: fixed;
            z-index: 9999;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.8);
            backdrop-filter: blur(8px);
        }

        .modal.show {
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .modal-content {
            background: white;
            padding: 60px;
            border-radius: 32px;
            width: 90%;
            max-width: 700px;
            position: relative;
            animation: modalSlideIn 0.4s ease;
            max-height: 90%;
            overflow-y: auto;
            box-shadow: var(--shadow-2xl);
        }

        @keyframes modalSlideIn {
            from {
                opacity: 0;
                transform: translateY(-50px) scale(0.9);
            }
            to {
                opacity: 1;
                transform: translateY(0) scale(1);
            }
        }

        .modal-close {
            position: absolute;
            top: 24px;
            right: 30px;
            background: none;
            border: none;
            font-size: 36px;
            cursor: pointer;
            color: var(--text-light);
            width: 60px;
            height: 60px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 50%;
            transition: all 0.3s ease;
        }

        .modal-close:hover {
            background: var(--bg-tertiary);
            color: var(--text-primary);
        }

        .modal-title {
            font-size: 2.5rem;
            font-weight: 900;
            margin-bottom: 40px;
            color: var(--text-primary);
            text-align: center;
        }

        .form-group {
            margin-bottom: 32px;
        }

        .form-group label {
            display: block;
            margin-bottom: 12px;
            font-weight: 700;
            color: var(--text-primary);
            font-size: 17px;
        }

        .form-group input,
        .form-group textarea,
        .form-group select {
            width: 100%;
            padding: 20px 24px;
            border: 2px solid var(--border-color);
            border-radius: 16px;
            font-size: 17px;
            transition: all 0.3s ease;
            font-family: inherit;
            background: var(--bg-secondary);
        }

        .form-group input:focus,
        .form-group textarea:focus,
        .form-group select:focus {
            outline: none;
            border-color: var(--primary-color);
            box-shadow: 0 0 0 4px rgba(10, 61, 145, 0.1);
            background: white;
        }

        .btn-submit {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-light) 100%);
            color: white;
            padding: 22px 48px;
            border: none;
            border-radius: 50px;
            font-size: 20px;
            font-weight: 700;
            cursor: pointer;
            width: 100%;
            transition: all 0.3s ease;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            box-shadow: var(--shadow-lg);
        }

        .btn-submit:hover {
            transform: translateY(-3px);
            box-shadow: var(--shadow-xl);
        }

        /* Responsive Design - Optimized */
        @media (max-width: 1200px) {
            .hero-content {
                gap: 50px;
            }
            
            .services-grid {
                grid-template-columns: 1fr;
                max-width: 600px;
            }
        }

        @media (max-width: 1024px) {
            .hero-content {
                grid-template-columns: 1fr;
                gap: 40px;
                text-align: center;
            }

            .floating-card-1,
            .floating-card-2 {
                display: none;
            }

            .hero-section {
                padding: 50px 0 60px;
            }
        }

        @media (max-width: 768px) {
            .container {
                padding: 0 20px;
            }

            .hero-section {
                min-height: auto;
                padding: 40px 0 50px;
            }

            .service-card {
                padding: 30px;
            }

            .hero-buttons {
                justify-content: center;
                gap: 16px;
            }

            .cta-buttons {
                flex-direction: column;
                align-items: center;
                gap: 20px;
            }

            .btn-whatsapp {
                justify-content: center;
            }

            .testimonials-grid,
            .process-steps {
                grid-template-columns: 1fr;
            }

            .step-number::after {
                display: none;
            }

            .modal-content {
                margin: 20px;
                padding: 30px;
            }

            .trust-logos {
                gap: 30px;
            }

            .services-section,
            .process-section,
            .testimonials-section,
            .contact-section {
                padding: 50px 0;
            }

            .guarantee-section,
            .cta-section {
                padding: 60px 0;
            }
        }

        @media (max-width: 480px) {
            .container {
                padding: 0 16px;
            }

            .hero-title {
                font-size: 2.5rem;
            }

            .section-title {
                font-size: 2rem;
            }

            .btn {
                padding: 18px 32px;
                font-size: 15px;
            }

            .service-card {
                padding: 30px;
            }

            .urgent-text {
                font-size: 14px;
                gap: 8px;
            }

            .services-grid {
                grid-template-columns: 1fr;
            }

            .service-card {
                min-width: auto;
            }
        }

        /* Performance optimizations */
        .hero-image,
        .service-card,
        .testimonial-card {
            will-change: transform;
        }

        /* Accessibility improvements */
        @media (prefers-reduced-motion: reduce) {
            *,
            *::before,
            *::after {
                animation-duration: 0.01ms !important;
                animation-iteration-count: 1 !important;
                transition-duration: 0.01ms !important;
            }
        }

        /* Focus styles for better accessibility */
        .btn:focus,
        .contact-card:focus,
        .service-card:focus {
            outline: 3px solid var(--primary-color);
            outline-offset: 2px;
        }

        /* High contrast mode support */
        @media (prefers-contrast: high) {
            .hero-section {
                background: #000;
                color: #fff;
            }
            
            .btn-primary {
                background: #fff;
                color: #000;
                border: 2px solid #000;
            }
        }
    </style> <a href="#main-content" class="skip-link">Skip to main content</a> <!-- Urgent Banner -->
  <div class="urgent-banner">
   <div class="container">
    <div class="urgent-text"><span class="pulse-dot"></span> <span>🔥 LIMITED TIME: Get Your Visa Processed in 24 Hours - Call Now!</span> <span class="pulse-dot"></span>
    </div>
   </div>
  </div>
  <main id="main-content"><!-- Hero Section -->
   <section class="hero-section" role="banner" aria-labelledby="hero-title">
    <div class="container">
     <div class="hero-content">
      <div class="hero-left">
       <div class="hero-badge">
        <svg width="20" height="20" viewbox="0 0 24 24" fill="currentColor" aria-hidden="true"><path d="M12,17.27L18.18,21L16.54,13.97L22,9.24L14.81,8.62L12,2L9.19,8.62L2,9.24L7.46,13.97L5.82,21L12,17.27Z" />
        </svg> #1 MOHRE Licensed Agency
       </div>
       <h1 class="hero-title" id="hero-title"><span class="highlight" id="hero-title-text">Dubai's #1 Domestic Worker Visa Service</span></h1>
       <div class="hero-subtitle" id="hero-subtitle-text">
        Fast, Legal &amp; Hassle-Free Processing
       </div>
       <p class="hero-description" id="hero-description-text">Get your maid or nanny visa processed in 24-48 hours with our MOHRE-licensed service. <strong><span id="company-name-hero">Mountain Gate L.L.C</span></strong> - Trusted by 25,000+ families across Dubai.</p>
       <div class="hero-buttons"><button class="btn btn-primary" onclick="openModal()" id="cta-button">
         <svg width="24" height="24" viewbox="0 0 24 24" fill="currentColor" aria-hidden="true"><path d="M9,11H15L13,9H11V6H13V8H15V6A2,2 0 0,0 13,4H11A2,2 0 0,0 9,6V9H7L9,11M11,14H13V18H11V14M12,2A10,10 0 0,1 22,12A10,10 0 0,1 12,22A10,10 0 0,1 2,12A10,10 0 0,1 12,2Z" />
         </svg><span id="cta-button-text">Get Visa Now</span> </button> <button class="btn btn-secondary" onclick="openWhatsApp()" aria-label="Contact us on WhatsApp">
         <svg width="24" height="24" viewbox="0 0 24 24" fill="currentColor" aria-hidden="true"><path d="M17.472,14.382c-0.297-0.149-1.758-0.867-2.03-0.967c-0.273-0.099-0.471-0.148-0.67,0.15c-0.197,0.297-0.767,0.966-0.94,1.164c-0.173,0.199-0.347,0.223-0.644,0.075c-0.297-0.15-1.255-0.463-2.39-1.475c-0.883-0.788-1.48-1.761-1.653-2.059c-0.173-0.297-0.018-0.458,0.13-0.606c0.134-0.133,0.298-0.347,0.446-0.52c0.149-0.174,0.198-0.298,0.298-0.497c0.099-0.198,0.05-0.371-0.025-0.52C10.612,9.420,9.53,7.14,9.5,6.199c-0.031-0.95-0.218-0.820-0.218-0.820S8.755,5.328,8.17,5.328c-0.584,0-1.009,0.436-1.009,1.065c0,0.629,0.425,1.186,0.486,1.267c0.061,0.081,0.946,1.445,2.291,2.025c0.32,0.138,0.571,0.221,0.766,0.283c0.322,0.102,0.615,0.088,0.847,0.053c0.258-0.038,0.799-0.327,0.911-0.642c0.112-0.314,0.112-0.584,0.078-0.642C17.608,14.476,17.527,14.441,17.472,14.382z" />
         </svg> WhatsApp Now </button>
       </div>
       <div class="hero-guarantees">
        <div class="guarantee-item">
         <div class="guarantee-icon">
          ✓
         </div><span id="guarantee-text">100% Money Back Guarantee</span>
        </div>
        <div class="guarantee-item">
         <div class="guarantee-icon">
          ⚡
         </div><span>24-48 Hour Processing</span>
        </div>
        <div class="guarantee-item">
         <div class="guarantee-icon">
          🏆
         </div><span>MOHRE Licensed</span>
        </div>
       </div>
      </div>
      <div class="hero-right">
       <div class="hero-image-container"><img src="https://images.unsplash.com/photo-1560472354-b33ff0c44a43?ixlib=rb-4.0.3&amp;ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&amp;auto=format&amp;fit=crop&amp;w=1926&amp;q=80" alt="Professional domestic worker visa services in Dubai" class="hero-image" loading="eager" onerror="this.style.display='none';">
        <div class="floating-card floating-card-1">
         <div class="card-stat">
          25K+
         </div>
         <div class="card-label">
          Happy Families
         </div>
        </div>
        <div class="floating-card floating-card-2">
         <div class="card-stat">
          24hrs
         </div>
         <div class="card-label">
          Fast Processing
         </div>
        </div>
       </div>
      </div>
     </div>
    </div>
   </section><!-- Trust Indicators -->
   <section class="trust-section">
    <div class="container">
     <div class="trust-content">
      <h2 class="trust-title">Trusted &amp; Certified By</h2>
      <div class="trust-logos">
       <div class="trust-logo">
        <div class="trust-icon">
         <svg width="28" height="28" viewbox="0 0 24 24" fill="currentColor"><path d="M12,1C12,1 12,1 12,1C7.03,1 3,5.03 3,10V11C3,16.55 6.84,21.74 12,23C17.16,21.74 21,16.55 21,11V10C21,5.03 16.97,1 12,1Z" />
         </svg>
        </div> MOHRE Licensed
       </div>
       <div class="trust-logo">
        <div class="trust-icon">
         <svg width="28" height="28" viewbox="0 0 24 24" fill="currentColor"><path d="M12,17.27L18.18,21L16.54,13.97L22,9.24L14.81,8.62L12,2L9.19,8.62L2,9.24L7.46,13.97L5.82,21L12,17.27Z" />
         </svg>
        </div> 5-Star Rated
       </div>
       <div class="trust-logo">
        <div class="trust-icon">
         <svg width="28" height="28" viewbox="0 0 24 24" fill="currentColor"><path d="M9,11H15L13,9H11V6H13V8H15V6A2,2 0 0,0 13,4H11A2,2 0 0,0 9,6V9H7L9,11M11,14H13V18H11V14Z" />
         </svg>
        </div> ISO Certified
       </div>
       <div class="trust-logo">
        <div class="trust-icon">
         <svg width="28" height="28" viewbox="0 0 24 24" fill="currentColor"><path d="M12,3L1,9L12,15L21,9V16H23V9M5,13.18V17.18L12,21L19,17.18V13.18L12,17L5,13.18Z" />
         </svg>
        </div> Dubai Municipality
       </div>
      </div>
     </div>
    </div>
   </section><!-- Services Section -->
   <section class="services-section" aria-labelledby="services-title">
    <div class="container">
     <div class="section-header">
      <div class="section-badge">
       Our Services
      </div>
      <h2 class="section-title" id="services-title">Choose Your Visa Package</h2>
      <p class="section-subtitle">Fast, reliable, and legally compliant visa processing for all sponsor types</p>
     </div>
     <div class="services-grid"><!-- GCC Sponsor Package -->
      <article class="service-card">
       <div class="service-header">
        <div class="service-icon" aria-hidden="true">
         <svg width="48" height="48" viewbox="0 0 24 24" fill="currentColor"><path d="M12 2C13.1 2 14 2.9 14 4C14 5.1 13.1 6 12 6C10.9 6 10 5.1 10 4C10 2.9 10.9 2 12 2ZM21 9V7L15 1L13.5 2.5L16.17 5.17L10.5 10.84L11.92 12.25L15.41 8.76L17.84 11.19L15 14.03V16.17L21 10.17V12L15 18L13.5 16.5L16.17 13.83L12.75 10.41L11.34 11.82L7.85 8.33L5.42 10.76L8.26 13.6H6.12L0.12 7.6L2.12 5.6L8.12 11.6H10.26L7.42 8.76L12 4.18L21 9Z" />
         </svg>
        </div>
        <h3 class="service-title" id="service-title-1">Emirati &amp; GCC Sponsors</h3>
       </div>
       <div class="service-price">
        Starting from AED 2,500
       </div>
       <ul class="service-features">
        <li>Government Typing &amp; Documentation</li>
        <li>Visa Entry &amp; Renewal Processing</li>
        <li>Medical Fitness &amp; Emirates ID</li>
        <li>Employment Contract &amp; WPS Setup</li>
        <li>Labor Card &amp; Work Permit</li>
        <li>24-48 Hour Express Processing</li>
        <li>Free Consultation &amp; Support</li>
        <li>Money Back Guarantee</li>
       </ul>
       <div class="service-cta"><button class="btn-service" onclick="openModal()" aria-label="Get quote for GCC sponsor services">Get Started Now</button> <button class="btn-service secondary" onclick="openWhatsApp()" aria-label="WhatsApp for GCC services">WhatsApp Quote</button>
       </div>
      </article><!-- Expat Sponsor Package -->
      <article class="service-card">
       <div class="service-header">
        <div class="service-icon" aria-hidden="true">
         <svg width="48" height="48" viewbox="0 0 24 24" fill="currentColor"><path d="M12,3L1,9L12,15L21,9V16H23V9M5,13.18V17.18L12,21L19,17.18V13.18L12,17L5,13.18Z" />
         </svg>
        </div>
        <h3 class="service-title" id="service-title-2">Expat Sponsors</h3>
       </div>
       <div class="service-price">
        Starting from AED 3,200
       </div>
       <ul class="service-features">
        <li>Specialized Expat Documentation</li>
        <li>Salary Certificate Processing</li>
        <li>Tenancy Contract Verification</li>
        <li>Medical &amp; Emirates ID Support</li>
        <li>Legal Compliance Assurance</li>
        <li>Priority Processing Available</li>
        <li>Dedicated Account Manager</li>
        <li>100% Success Guarantee</li>
       </ul>
       <div class="service-cta"><button class="btn-service" onclick="openModal()" aria-label="Get quote for Expat sponsor services">Get Started Now</button> <button class="btn-service secondary" onclick="openWhatsApp()" aria-label="WhatsApp for Expat services">WhatsApp Quote</button>
       </div>
      </article>
     </div>
    </div>
   </section><!-- Process Section -->
   <section class="process-section" aria-labelledby="process-title">
    <div class="container">
     <div class="section-header">
      <div class="section-badge">
       Simple Process
      </div>
      <h2 class="section-title" id="process-title">How It Works</h2>
      <p class="section-subtitle">Get your domestic worker visa in just 4 simple steps</p>
     </div>
     <div class="process-steps">
      <div class="process-step">
       <div class="step-number">
        1
       </div>
       <h3 class="step-title">Submit Documents</h3>
       <p class="step-description">Send us your required documents via WhatsApp or visit our office. We'll verify everything within 2 hours.</p>
      </div>
      <div class="process-step">
       <div class="step-number">
        2
       </div>
       <h3 class="step-title">Processing Begins</h3>
       <p class="step-description">Our MOHRE-licensed team starts processing your application immediately with government authorities.</p>
      </div>
      <div class="process-step">
       <div class="step-number">
        3
       </div>
       <h3 class="step-title">Real-Time Updates</h3>
       <p class="step-description">Track your application status in real-time. We keep you informed at every step of the process.</p>
      </div>
      <div class="process-step">
       <div class="step-number">
        4
       </div>
       <h3 class="step-title">Visa Ready</h3>
       <p class="step-description">Receive your approved visa within 24-48 hours. We handle delivery or you can collect from our office.</p>
      </div>
     </div>
    </div>
   </section><!-- Guarantee Section -->
   <section class="guarantee-section" aria-labelledby="guarantee-title">
    <div class="container">
     <div class="guarantee-content">
      <div class="guarantee-icon-large">
       🛡️
      </div>
      <h2 class="guarantee-title" id="guarantee-title">Our Iron-Clad Guarantee</h2>
      <p class="guarantee-subtitle">We're so confident in our service, we offer a 100% money-back guarantee if we don't deliver on our promises.</p>
      <div class="guarantee-features">
       <div class="guarantee-feature">
        <div class="guarantee-feature-icon">
         ⚡
        </div><span>24-48 Hour Processing or Full Refund</span>
       </div>
       <div class="guarantee-feature">
        <div class="guarantee-feature-icon">
         ✅
        </div><span>100% Legal Compliance Guaranteed</span>
       </div>
       <div class="guarantee-feature">
        <div class="guarantee-feature-icon">
         🔒
        </div><span>Secure Document Handling</span>
       </div>
       <div class="guarantee-feature">
        <div class="guarantee-feature-icon">
         📞
        </div><span>24/7 Customer Support</span>
       </div>
      </div>
     </div>
    </div>
   </section><!-- Stats Section -->
   <section class="stats-section" aria-labelledby="stats-title">
    <div class="container">
     <div class="stats-grid">
      <div class="stat-item">
       <div class="stat-number">
        25,000+
       </div>
       <div class="stat-label">
        Visas Processed
       </div>
      </div>
      <div class="stat-item">
       <div class="stat-number">
        99.8%
       </div>
       <div class="stat-label">
        Success Rate
       </div>
      </div>
      <div class="stat-item">
       <div class="stat-number">
        24hrs
       </div>
       <div class="stat-label">
        Average Processing
       </div>
      </div>
      <div class="stat-item">
       <div class="stat-number">
        6+
       </div>
       <div class="stat-label">
        Years Experience
       </div>
      </div>
     </div>
    </div>
   </section><!-- Testimonials Section -->
   <section class="testimonials-section" aria-labelledby="testimonials-title">
    <div class="container">
     <div class="section-header">
      <div class="section-badge">
       Client Reviews
      </div>
      <h2 class="section-title" id="testimonials-title">What Our Clients Say</h2>
      <p class="section-subtitle">Real experiences from satisfied customers across Dubai</p>
     </div>
     <div class="testimonials-grid">
      <article class="testimonial-card">
       <div class="testimonial-stars" aria-label="5 star rating"><span class="star">★</span> <span class="star">★</span> <span class="star">★</span> <span class="star">★</span> <span class="star">★</span>
       </div>
       <p class="testimonial-text">Absolutely amazing service! They processed my maid's visa in just 20 hours. The team was professional, responsive, and handled everything perfectly. Highly recommend Mountain Gate for anyone needing domestic worker visas in Dubai.</p>
       <div class="testimonial-author">
        <div class="author-avatar">
         S
        </div>
        <div>
         <div class="author-name">
          Sarah Al-Mansouri
         </div>
         <div class="author-title">
          Dubai Marina Resident
         </div>
        </div>
       </div>
      </article>
      <article class="testimonial-card">
       <div class="testimonial-stars" aria-label="5 star rating"><span class="star">★</span> <span class="star">★</span> <span class="star">★</span> <span class="star">★</span> <span class="star">★</span>
       </div>
       <p class="testimonial-text">As an expat, I was worried about the visa process complexity. Mountain Gate made it incredibly simple. They guided me through every step and delivered exactly as promised. Worth every dirham!</p>
       <div class="testimonial-author">
        <div class="author-avatar">
         M
        </div>
        <div>
         <div class="author-name">
          Michael Johnson
         </div>
         <div class="author-title">
          British Expat, JLT
         </div>
        </div>
       </div>
      </article>
      <article class="testimonial-card">
       <div class="testimonial-stars" aria-label="5 star rating"><span class="star">★</span> <span class="star">★</span> <span class="star">★</span> <span class="star">★</span> <span class="star">★</span>
       </div>
       <p class="testimonial-text">قدّمت الموظفة صالحة أداءً ممتازًا في تخليص المعاملة، حيث أظهرت سرعة في الإنجاز ودقّة في تنفيذ جميع المتطلبات دون أي تأخير. تعاملت باحترافية عالية، وقدّمت تعاونًا كاملًا ساعد في إنجاز المعاملة بسهولة وسلاسة.</p>
       <div class="testimonial-author">
        <div class="author-avatar">
         أ
        </div>
        <div>
         <div class="author-name">
          أحمد الحمايدة
         </div>
         <div class="author-title">
          مقيم في دبي
         </div>
        </div>
       </div>
      </article>
     </div>
    </div>
   </section><!-- CTA Section -->
   <section class="cta-section" aria-labelledby="cta-title">
    <div class="container">
     <div class="cta-content">
      <h2 class="cta-title" id="cta-title">Ready to Get Your Visa?</h2>
      <p class="cta-subtitle">Join 25,000+ satisfied customers. Get your domestic worker visa processed in 24-48 hours!</p>
      <div class="cta-buttons"><button class="btn-cta-primary" onclick="openModal()"> Start Your Application </button> <a href="#" class="btn-whatsapp" onclick="openWhatsApp(); return false;">
        <svg width="28" height="28" viewbox="0 0 24 24" fill="currentColor"><path d="M17.472,14.382c-0.297-0.149-1.758-0.867-2.03-0.967c-0.273-0.099-0.471-0.148-0.67,0.15c-0.197,0.297-0.767,0.966-0.94,1.164c-0.173,0.199-0.347,0.223-0.644,0.075c-0.297-0.15-1.255-0.463-2.39-1.475c-0.883-0.788-1.48-1.761-1.653-2.059c-0.173-0.297-0.018-0.458,0.13-0.606c0.134-0.133,0.298-0.347,0.446-0.52c0.149-0.174,0.198-0.298,0.298-0.497c0.099-0.198,0.05-0.371-0.025-0.52C10.612,9.420,9.53,7.14,9.5,6.199c-0.031-0.95-0.218-0.820-0.218-0.820S8.755,5.328,8.17,5.328c-0.584,0-1.009,0.436-1.009,1.065c0,0.629,0.425,1.186,0.486,1.267c0.061,0.081,0.946,1.445,2.291,2.025c0.32,0.138,0.571,0.221,0.766,0.283c0.322,0.102,0.615,0.088,0.847,0.053c0.258-0.038,0.799-0.327,0.911-0.642c0.112-0.314,0.112-0.584,0.078-0.642C17.608,14.476,17.527,14.441,17.472,14.382z" />
        </svg> WhatsApp Us Now </a>
      </div>
      <p class="cta-guarantee">🛡️ 100% Money Back Guarantee • ⚡ 24-48 Hour Processing • 🏆 MOHRE Licensed</p>
     </div>
    </div>
   </section><!-- Contact Section -->
   <section class="contact-section" aria-labelledby="contact-title">
    <div class="container">
     <div class="section-header">
      <h2 class="section-title" id="contact-title">Get In Touch</h2>
      <p class="section-subtitle">Multiple ways to reach our expert team</p>
     </div>
     <div class="contact-grid"><a href="#" class="contact-card" onclick="openWhatsApp(); return false;" aria-label="Contact us on WhatsApp">
       <div class="contact-icon whatsapp-icon">
        <svg width="36" height="36" viewbox="0 0 24 24" fill="currentColor"><path d="M17.472,14.382c-0.297-0.149-1.758-0.867-2.03-0.967c-0.273-0.099-0.471-0.148-0.67,0.15c-0.197,0.297-0.767,0.966-0.94,1.164c-0.173,0.199-0.347,0.223-0.644,0.075c-0.297-0.15-1.255-0.463-2.39-1.475c-0.883-0.788-1.48-1.761-1.653-2.059c-0.173-0.297-0.018-0.458,0.13-0.606c0.134-0.133,0.298-0.347,0.446-0.52c0.149-0.174,0.198-0.298,0.298-0.497c0.099-0.198,0.05-0.371-0.025-0.52C10.612,9.420,9.53,7.14,9.5,6.199c-0.031-0.95-0.218-0.820-0.218-0.820S8.755,5.328,8.17,5.328c-0.584,0-1.009,0.436-1.009,1.065c0,0.629,0.425,1.186,0.486,1.267c0.061,0.081,0.946,1.445,2.291,2.025c0.32,0.138,0.571,0.221,0.766,0.283c0.322,0.102,0.615,0.088,0.847,0.053c0.258-0.038,0.799-0.327,0.911-0.642c0.112-0.314,0.112-0.584,0.078-0.642C17.608,14.476,17.527,14.441,17.472,14.382z" />
        </svg>
       </div>
       <div class="contact-title">
        WhatsApp
       </div>
       <div class="contact-info" id="whatsapp-display">
        +971 50 123 4567
       </div>
       <div class="contact-description">
        Instant response &amp; quick quotes
       </div></a> <a href="#" class="contact-card" id="phone-card" aria-label="Call us">
       <div class="contact-icon">
        <svg width="36" height="36" viewbox="0 0 24 24" fill="currentColor"><path d="M6.62,10.79C8.06,13.62 10.38,15.94 13.21,17.38L15.41,15.18C15.69,14.9 16.08,14.82 16.43,14.93C17.55,15.3 18.75,15.5 20,15.5A1,1 0 0,1 21,16.5V20A1,1 0 0,1 20,21A17,17 0 0,1 3,4A1,1 0 0,1 4,3H7.5A1,1 0 0,1 8.5,4C8.5,5.25 8.7,6.45 9.07,7.57C9.18,7.92 9.1,8.31 8.82,8.59L6.62,10.79Z" />
        </svg>
       </div>
       <div class="contact-title">
        Phone
       </div>
       <div class="contact-info" id="phone-display">
        +971 4 401 8888
       </div>
       <div class="contact-description">
        Speak to our visa experts
       </div></a> <a href="#" class="contact-card" id="email-card" target="_blank" rel="noopener noreferrer" aria-label="Send us an email">
       <div class="contact-icon">
        <svg width="36" height="36" viewbox="0 0 24 24" fill="currentColor"><path d="M20,8L12,13L4,8V6L12,11L20,6M20,4H4C2.89,4 2,4.89 2,6V18A2,2 0 0,0 4,20H20A2,2 0 0,0 22,18V6C22,4.89 21.1,4 20,4Z" />
        </svg>
       </div>
       <div class="contact-title">
        Email
       </div>
       <div class="contact-info" id="email-display">
        info@mgtadbeer.com
       </div>
       <div class="contact-description">
        Detailed inquiries &amp; documentation
       </div></a>
     </div>
    </div>
   </section>
  </main><!-- Contact Modal -->
  <div id="enquiry-modal" class="modal" role="dialog" aria-labelledby="modal-title" aria-hidden="true">
   <div class="modal-content"><button class="modal-close" onclick="closeModal()" aria-label="Close modal">×</button>
    <h2 class="modal-title" id="modal-title">Get Your Visa Quote</h2>
    <form id="visa-form" onsubmit="handleFormSubmit(event)" novalidate>
     <div class="form-group"><label for="name">Full Name *</label> <input type="text" id="name" name="name" required aria-required="true" placeholder="Enter your full name">
     </div>
     <div class="form-group"><label for="phone">Phone Number *</label> <input type="tel" id="phone" name="phone" required aria-required="true" placeholder="+971 50 123 4567">
     </div>
     <div class="form-group"><label for="email">Email Address</label> <input type="email" id="email" name="email" placeholder="your.email@example.com">
     </div>
     <div class="form-group"><label for="sponsor-type">Sponsor Type *</label> <select id="sponsor-type" name="sponsor_type" required aria-required="true"> <option value="">Select your sponsor type</option> <option value="emirati_gcc">Emirati &amp; GCC Sponsor</option> <option value="expat">Expat Sponsor</option> <option value="not_sure">Not Sure</option> </select>
     </div>
     <div class="form-group"><label for="worker-type">Worker Type *</label> <select id="worker-type" name="worker_type" required aria-required="true"> <option value="">Select worker type</option> <option value="maid">Housemaid</option> <option value="nanny">Nanny</option> <option value="cook">Cook</option> <option value="driver">Driver</option> <option value="other">Other</option> </select>
     </div>
     <div class="form-group"><label for="urgency">Processing Speed</label> <select id="urgency" name="urgency"> <option value="standard">Standard (24-48 hours)</option> <option value="express">Express (12-24 hours)</option> <option value="urgent">Urgent (Same day)</option> </select>
     </div>
     <div class="form-group"><label for="message">Additional Requirements</label> <textarea id="message" name="message" rows="4" placeholder="Tell us about any specific requirements or questions..."></textarea>
     </div><button type="submit" class="btn-submit">Get My Quote Now</button>
    </form>
   </div>
  </div>
  <script>
        // Default configuration
        const defaultConfig = {
            company_name: "Mountain Gate L.L.C",
            hero_title: "Dubai's #1 Domestic Worker Visa Service",
            hero_subtitle: "Fast, Legal & Hassle-Free Processing",
            hero_description: "Get your maid or nanny visa processed in 24-48 hours with our MOHRE-licensed service",
            cta_button_text: "Get Visa Now",
            service_title_1: "Emirati & GCC Sponsors",
            service_title_2: "Expat Sponsors",
            guarantee_text: "100% Money Back Guarantee",
            whatsapp_number: "971501234567",
            phone_number: "+971 4 401 8888",
            email_address: "info@mgtadbeer.com"
        };

        // Performance optimizations
        let isModalOpen = false;
        let formSubmitted = false;

        // Modal functions with accessibility improvements
        function openModal() {
            const modal = document.getElementById('enquiry-modal');
            modal.classList.add('show');
            modal.setAttribute('aria-hidden', 'false');
            isModalOpen = true;
            
            // Focus management
            const firstInput = modal.querySelector('input');
            if (firstInput) {
                setTimeout(() => firstInput.focus(), 100);
            }
            
            // Prevent body scroll
            document.body.style.overflow = 'hidden';
        }

        function closeModal() {
            const modal = document.getElementById('enquiry-modal');
            modal.classList.remove('show');
            modal.setAttribute('aria-hidden', 'true');
            isModalOpen = false;
            
            // Restore body scroll
            document.body.style.overflow = '';
            
            // Reset form if not submitted
            if (!formSubmitted) {
                document.getElementById('visa-form').reset();
            }
        }

        // WhatsApp functions with error handling
        function openWhatsApp() {
            try {
                const phoneNumber = window.elementSdk?.config?.whatsapp_number || defaultConfig.whatsapp_number;
                const message = encodeURIComponent("Hello! I'm interested in your domestic worker visa services. Can you please provide me with more information?");
                const url = `https://api.whatsapp.com/send?phone=${phoneNumber}&text=${message}`;
                window.open(url, '_blank', 'noopener,noreferrer');
            } catch (error) {
                console.error('Error opening WhatsApp:', error);
            }
        }

        // Enhanced form submission with validation
        function handleFormSubmit(event) {
            event.preventDefault();
            
            const form = event.target;
            const formData = new FormData(form);
            const data = Object.fromEntries(formData);
            
            // Basic validation
            if (!data.name || !data.phone || !data.sponsor_type || !data.worker_type) {
                showFormError('Please fill in all required fields.');
                return;
            }
            
            // Phone validation
            const phoneRegex = /^[\+]?[0-9\s\-\(\)]{7,}$/;
            if (!phoneRegex.test(data.phone)) {
                showFormError('Please enter a valid phone number.');
                return;
            }
            
            // Email validation (if provided)
            if (data.email) {
                const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
                if (!emailRegex.test(data.email)) {
                    showFormError('Please enter a valid email address.');
                    return;
                }
            }
            
            formSubmitted = true;
            showSuccessMessage();
        }

        function showFormError(message) {
            // Create or update error message
            let errorDiv = document.querySelector('.form-error');
            if (!errorDiv) {
                errorDiv = document.createElement('div');
                errorDiv.className = 'form-error';
                errorDiv.style.cssText = 'color: #dc2626; background: #fef2f2; padding: 20px; border-radius: 16px; margin-bottom: 32px; font-size: 17px; font-weight: 600; border: 1px solid #fecaca;';
                document.querySelector('#visa-form').prepend(errorDiv);
            }
            errorDiv.textContent = message;
            errorDiv.scrollIntoView({ behavior: 'smooth', block: 'nearest' });
        }

        function showSuccessMessage() {
            const modal = document.querySelector('.modal-content');
            modal.innerHTML = `
                <button class="modal-close" onclick="closeModal()" aria-label="Close modal">&times;</button>
                <div style="text-align: center; padding: 60px 40px;">
                    <div style="font-size: 100px; margin-bottom: 40px;" aria-hidden="true">🎉</div>
                    <h2 style="color: var(--text-primary); margin-bottom: 24px; font-size: 2.5rem; font-weight: 900;">Quote Request Submitted!</h2>
                    <p style="color: var(--text-secondary); margin-bottom: 40px; line-height: 1.7; font-size: 20px;">Thank you for choosing Mountain Gate! Our visa experts will contact you within 30 minutes with a personalized quote and next steps.</p>
                    <div style="background: #f0f9ff; padding: 24px; border-radius: 16px; margin-bottom: 40px; border: 1px solid #bae6fd;">
                        <p style="color: var(--primary-color); margin: 0; font-weight: 700; font-size: 18px;">⚡ Expected Response Time: 15-30 minutes</p>
                    </div>
                    <button onclick="closeModal()" class="btn-submit">Close</button>
                </div>
            `;
        }

        // Enhanced keyboard navigation
        document.addEventListener('keydown', function(event) {
            if (event.key === 'Escape' && isModalOpen) {
                closeModal();
            }
        });

        // Click outside to close modal
        window.addEventListener('click', function(event) {
            const modal = document.getElementById('enquiry-modal');
            if (event.target === modal && isModalOpen) {
                closeModal();
            }
        });

        // Update contact information
        function updateContactInfo() {
            try {
                const config = window.elementSdk?.config || defaultConfig;
                
                // Update WhatsApp
                const whatsappDisplay = document.getElementById('whatsapp-display');
                if (whatsappDisplay) {
                    const whatsappNum = config.whatsapp_number || defaultConfig.whatsapp_number;
                    whatsappDisplay.textContent = `+${whatsappNum}`;
                }
                
                // Update Phone
                const phoneDisplay = document.getElementById('phone-display');
                const phoneCard = document.getElementById('phone-card');
                if (phoneDisplay && phoneCard) {
                    const phoneNum = config.phone_number || defaultConfig.phone_number;
                    phoneDisplay.textContent = phoneNum;
                    phoneCard.href = `tel:${phoneNum}`;
                }
                
                // Update Email
                const emailDisplay = document.getElementById('email-display');
                const emailCard = document.getElementById('email-card');
                if (emailDisplay && emailCard) {
                    const email = config.email_address || defaultConfig.email_address;
                    emailDisplay.textContent = email;
                    emailCard.href = `mailto:${email}`;
                }
            } catch (error) {
                console.error('Error updating contact info:', error);
            }
        }

        // Element SDK configuration
        async function onConfigChange(config) {
            try {
                // Update company name
                const companyName = config.company_name || defaultConfig.company_name;
                const companyElements = document.querySelectorAll('#company-name-hero');
                companyElements.forEach(el => {
                    if (el) el.textContent = companyName;
                });

                // Update hero content
                const heroTitleEl = document.getElementById('hero-title-text');
                const heroSubtitleEl = document.getElementById('hero-subtitle-text');
                const heroDescEl = document.getElementById('hero-description-text');
                const ctaButtonEl = document.getElementById('cta-button-text');
                
                if (heroTitleEl) heroTitleEl.textContent = config.hero_title || defaultConfig.hero_title;
                if (heroSubtitleEl) heroSubtitleEl.textContent = config.hero_subtitle || defaultConfig.hero_subtitle;
                if (heroDescEl) {
                    const description = config.hero_description || defaultConfig.hero_description;
                    heroDescEl.innerHTML = `${description}. <strong><span>${companyName}</span></strong> - Trusted by 25,000+ families across Dubai.`;
                }
                if (ctaButtonEl) ctaButtonEl.textContent = config.cta_button_text || defaultConfig.cta_button_text;

                // Update service titles
                const serviceTitleEl1 = document.getElementById('service-title-1');
                const serviceTitleEl2 = document.getElementById('service-title-2');
                if (serviceTitleEl1) serviceTitleEl1.textContent = config.service_title_1 || defaultConfig.service_title_1;
                if (serviceTitleEl2) serviceTitleEl2.textContent = config.service_title_2 || defaultConfig.service_title_2;

                // Update guarantee text
                const guaranteeEl = document.getElementById('guarantee-text');
                if (guaranteeEl) guaranteeEl.textContent = config.guarantee_text || defaultConfig.guarantee_text;

                // Update contact information
                updateContactInfo();
            } catch (error) {
                console.error('Error in onConfigChange:', error);
            }
        }

        function mapToCapabilities(config) {
            return {
                recolorables: [],
                borderables: [],
                fontEditable: undefined,
                fontSizeable: undefined
            };
        }

        function mapToEditPanelValues(config) {
            return new Map([
                ["company_name", config.company_name || defaultConfig.company_name],
                ["hero_title", config.hero_title || defaultConfig.hero_title],
                ["hero_subtitle", config.hero_subtitle || defaultConfig.hero_subtitle],
                ["hero_description", config.hero_description || defaultConfig.hero_description],
                ["cta_button_text", config.cta_button_text || defaultConfig.cta_button_text],
                ["service_title_1", config.service_title_1 || defaultConfig.service_title_1],
                ["service_title_2", config.service_title_2 || defaultConfig.service_title_2],
                ["guarantee_text", config.guarantee_text || defaultConfig.guarantee_text],
                ["whatsapp_number", config.whatsapp_number || defaultConfig.whatsapp_number],
                ["phone_number", config.phone_number || defaultConfig.phone_number],
                ["email_address", config.email_address || defaultConfig.email_address]
            ]);
        }

        // Initialize Element SDK with error handling
        if (window.elementSdk) {
            try {
                window.elementSdk.init({
                    defaultConfig,
                    onConfigChange,
                    mapToCapabilities,
                    mapToEditPanelValues
                });
            } catch (error) {
                console.error('Error initializing Element SDK:', error);
            }
        }

        // Initialize on page load
        document.addEventListener('DOMContentLoaded', function() {
            updateContactInfo();
            
            // Lazy load images for better performance
            if ('IntersectionObserver' in window) {
                const imageObserver = new IntersectionObserver((entries, observer) => {
                    entries.forEach(entry => {
                        if (entry.isIntersecting) {
                            const img = entry.target;
                            if (img.dataset.src) {
                                img.src = img.dataset.src;
                                img.removeAttribute('data-src');
                            }
                            observer.unobserve(img);
                        }
                    });
                });

                document.querySelectorAll('img[data-src]').forEach(img => {
                    imageObserver.observe(img);
                });
            }
        });
    </script> 
 <script>(function(){function c(){var b=a.contentDocument||a.contentWindow.document;if(b){var d=b.createElement('script');d.innerHTML="window.__CF$cv$params={r:'99fdb054f3159793',t:'MTc2MzM2NjM2Ny4wMDAwMDA='};var a=document.createElement('script');a.nonce='';a.src='/cdn-cgi/challenge-platform/scripts/jsd/main.js';document.getElementsByTagName('head')[0].appendChild(a);";b.getElementsByTagName('head')[0].appendChild(d)}}if(document.body){var a=document.createElement('iframe');a.height=1;a.width=1;a.style.position='absolute';a.style.top=0;a.style.left=0;a.style.border='none';a.style.visibility='hidden';document.body.appendChild(a);if('loading'!==document.readyState)c();else if(window.addEventListener)document.addEventListener('DOMContentLoaded',c);else{var e=document.onreadystatechange||function(){};document.onreadystatechange=function(b){e(b);'loading'!==document.readyState&&(document.onreadystatechange=e,c())}}}})();</script></body>
</html>
@endsection