
@foreach($blogs as $blog)
    <div class="col-xl-3  col-md-4 col-sm-6 d-flex">
        <div class="blog_card">
            <div class="card_top">

                @if($blog && $blog->image!=NULL && File::exists(public_path($blog->image)))
                    {!! printImage($blog,'image','webp_image','image_meta_tag') !!}
                @else
                    <picture>
                        <img src="{{asset('web/images/blog1.png')}}" alt="">
                    </picture>
                @endif
            </div>
            <div class="card_body">
                <h6>{{date('d.m.Y',strtotime($blog->posted_date))}}</h6>
                <h4>{!! langString(@$blog,'title') !!}</h4>
                {!! langString(@$blog,'list_description') !!}
                <a href="{{url('blog/'.$blog->short_url)}}">{{ staticLangString($websiteLanguages,'title.read_more') }}</a>
            </div>
        </div>
    </div>
    @if($loop->last)
        <div class="appendHere_{{$offset}}"></div>
    @endif
@endforeach

<input type="hidden" id="totalBlogs" name="total_blogs" value="{{$totalBlog}}">
<input type="hidden" id="blog_loading_offset" name="blog_loading_offset" value="{{$offset}}">
<input type="hidden" id="blog_loading_limit" name="blog_loading_limit" value="{{$loading_limit}}">

@if($totalBlog>$offset)
    <div class="col-12 d-flex justify-content-center mt-3 more-section-{{$offset}}">
        <a href="#" class="primary_btn load-more-button">{{ staticLangString($websiteLanguages,'title.load_more') }}</a>
    </div>
@endif
