@extends('web.layouts.main')

@section('content')

    <!--inner banners -->
    <section class="inner_banner">
        <div class="background_img">
            {!! printImage($blog,'banner_image','banner_webp_image','banner_attribute') !!}
        </div>
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="caption">
                        <h1>{{ langString($blog,'banner_title') }}</h1>
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{url('/')}}">{{ staticLangString($websiteLanguages,'menu.home') }}</a></li>
                                <li class="breadcrumb-item active"><a href="{{url('blogs')}}">Blog</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Blog Details</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--inner banners -->


    <!--Blog Details section Start-->

    <section class="blog_destails_section">
        <div class="container">
            <div class="row align-items-start">
                <div class="col-lg-8 pe-lg-5">
                    <div class="blog_details_left">
                        <div class="All_main_Headings">
                            <h6 class="sub_heading">{{ langString($blog,'sub_title') }}</h6>
                            <h3 class="main_heading">{{ langString($blog,'title') }}</h3>
                        </div>
                        <h6>{{date('d.m.Y',strtotime($blog->posted_date))}}
                            <span>{{ langString($blog,'written_by') }}</span></h6>
                        {!! langString($blog,'list_description') !!}

                        {!! printImage($blog,'image','webp_image','image_meta_tag','img-fluid') !!}

                        {!! langString($blog,'description') !!}

                        <div class="video-area aos-init aos-animate" data-aos="fade-up">
                            <a href="https://youtu.be/JsnzZF0_13I" data-fancybox="group">
                                {!! printImage($blog,'video_thumbnail_image','video_thumbnail_webp_image','video_meta_tag','img-fluid') !!}
                                @if($blog->video_url)
                                    <button type="button" class="video-btn"><img
                                            src="{{asset('web/images/svg/play.svg')}}" alt=""></button>
                                @endif
                            </a>
                        </div>
                        {!! langString($blog,'alternate_description') !!}

                        <div class="share_navigation">
                            <div class="share">
                                <a href="{{'https://www.facebook.com/sharer/sharer.php?u='.Request::fullUrl() }}" target="_blank"><i class="fa-brands fa-facebook"></i></a>
                                <a href="{{'https://www.linkedin.com/shareArticle?mini=true&url='.Request::fullUrl() }}" target="_blank"><i class="fa-brands fa-linkedin"></i></a>
                                <a href="{{'https://twitter.com/intent/tweet/?url='.Request::fullUrl() }}" target="_blank"><i class="fa-brands fa-twitter"></i></a>
                                <a href="{{'https://wa.me/?text='.Request::fullUrl()}}" target="_blank"><i class="fa-brands fa-whatsapp"></i></a>
                            </div>
                            <div class="navigation">
                                @if($previousItem)
                                    <a href="{{url('blog/'.$previousItem->short_url)}}" class="primary_btn">{{ staticLangString($websiteLanguages,'title.previous') }}</a>
                                @endif
                                @if($nextItem)
                                    <a href="{{url('blog/'.$nextItem->short_url)}}" class="secondary_btn">{{ staticLangString($websiteLanguages,'title.next') }}</a>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>

                @if($recentBlogs->isNotEmpty())
                <div class="col-lg-4 sticky-lg-top sticky-lg-top-110">
                    <div class="blog_list_wrapper">
                        <h4>{{ staticLangString($websiteLanguages,'title.recent_blog') }}</h4>
                        <ul>

                            @foreach($recentBlogs as $recent)
                            <li>

                                {!! printImage($recent,'image','webp_image','image_meta_tag','img-fluid') !!}

                                <h4>
                                    {{ langString($recent,'title') }}
                                </h4>
                                <h6>{{date('d.m.Y',strtotime($recent->posted_date))}}<span>{{ langString($recent,'written_by') }}</span></h6>
                                <a href="{{url('blog/'.$recent->short_url)}}">Read More</a>
                            </li>
                            @endforeach

                        </ul>
                    </div>
                </div>
                @endif
            </div>
        </div>
    </section>

    <!--Blog Details section End-->

@endsection
