@extends('web.layouts.main')

@section('content')

<!-- About Section -->
<section class="about-section py-5">
  <div class="container">
    <div class="row align-items-center">
      
      <!-- Content Column -->
      <div class="col-lg-6 order-2 order-lg-1">
  <div class="about-content">
    <h2 class="section-title">About Mountain Gate Tadbeer (MG)</h2>
    <p class="lead-text">
      Founded in 2018, Mountain Gate L.L.C. is Dubai’s leading provider of full-time maids and nannies, specialising in live-in domestic help for families.
    </p>
    <p class="lead-text">
      In 2021, we opened the largest residential training centre for newly onboarded maids in Dubai, offering UK Level 3 standard training with interactive American simulator baby dolls and caregiving tools.
    </p>
    <p class="lead-text">
      Our Nanny Program ensures all candidates are qualified to provide professional childcare services, while our full-time maid services are highly sought after by expat communities in Dubai and the UAE.
    </p>
    <p class="highlight-text">
      We take pride in our well-trained, skilled domestic workers and employees who uphold our core values of <strong>diversity, integrity, honesty, teamwork, and excellence</strong>.
    </p>
  </div>
</div>

      
      <!-- Images Column -->
      <div class="col-lg-6 order-1 order-lg-2">
        <div class="about-images">
          <div class="image-stack">
            <div class="main-image">
              <img src="https://royalvisa.ae/wp-content/uploads/2024/03/Getting_Help_with_Your_UAE_Visa_Application_Visa_Services_Available.jpg" 
                   alt="Visa Application Services" class="img-fluid">
            </div>
            <div class="secondary-image">
              <img src="https://3.imimg.com/data3/PG/NW/MY-11945651/wp-content-uploads-2014-08-passport-and-visa-300x213-250x250.png" 
                   alt="Passport and Visa" class="img-fluid">
            </div>
          </div>
        </div>
      </div>
      
    </div>
  </div>
</section>

<!-- What We Do Section -->
<section class="services-section py-5 bg-light">
  <div class="container">
    <div class="row align-items-center">
      
      <!-- Images Column -->
      <div class="col-lg-6">
        <div class="services-image">
          <div class="image-card">
            <img src="https://manasty.ae/wp-content/uploads/2025/03/image_fx_-44.png" 
                 alt="Domestic Worker Services" class="img-fluid">
          </div>
        </div>
      </div>
      
      <!-- Content Column -->
      <div class="col-lg-6">
        <div class="services-content">
          <h2 class="section-title">What We Do</h2>
          <p class="lead-text">
            MG Tadbeer, licensed under the Ministry of Human Resources and Emiratization, provides a one-stop solution for recruiting, supplying, and training domestic workers across multiple areas. We are also licensed to provide typing services for Domestic Worker visas, medical typing, Emirates ID typing, and Health Insurance.
          </p>
          
          <div class="services-grid">
            @php
              $services = ['Maid','Babysitter/Nanny','Housekeeper','Driver','Cook','Private Nurse','Gardener','Farmer','Domestic Laborer','Family Chauffeur'];
            @endphp
            @foreach($services as $service)
              <div class="service-item">
                <div class="service-icon">
                  <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                    <path d="M10.97 4.97a.75.75 0 0 1 1.07 1.05l-3.99 4.99a.75.75 0 0 1-1.08.02L4.324 8.384a.75.75 0 1 1 1.06-1.06l2.094 2.093 3.473-4.425a.267.267 0 0 1 .02-.022z"/>
                  </svg>
                </div>
                <span>{{ $service }}</span>
              </div>
            @endforeach
          </div>
          
          <div class="cta-button">
            <a href="http://visa.mgtadbeer.com/services" class="btn btn-primary">
              Explore Our Services
            </a>
          </div>
        </div>
      </div>
      
    </div>
  </div>
</section>

<!-- Mission & Vision Section -->
<section class="mission-section py-5">
  <div class="container">
    <div class="row align-items-center">
      
      <!-- Content Column -->
      <div class="col-lg-6">
        <div class="mission-content">
          <h2 class="section-title">Mission & Vision</h2>
          <p class="lead-text">
            Our mission is to be the industry leader by providing our clients with the best information, recommendations, and assistance concerning domestic worker hiring and labor supply. We develop superior strategies to ensure sustainable competitive advantages, continuous growth, and customer satisfaction.
          </p>
          <div class="values-section">
            <h3 class="values-title">Our Values</h3>
            <div class="values-grid">
              <div class="value-item">
                <div class="value-icon">
                  <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 16 16">
                    <path d="M3 14s-1 0-1-1 1-4 6-4 6 3 6 4-1 1-1 1H3zm5-6a3 3 0 1 0 0-6 3 3 0 0 0 0 6z"/>
                  </svg>
                </div>
                <span>Reliable Advisors</span>
              </div>
              <div class="value-item">
                <div class="value-icon">
                  <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 16 16">
                    <path d="M8 16A8 8 0 1 0 8 0a8 8 0 0 0 0 16zm.93-9.412-1 4.705c-.07.34.029.533.304.533.194 0 .487-.07.686-.246l-.088.416c-.287.346-.92.598-1.465.598-.703 0-1.002-.422-.808-1.319l.738-3.468c.064-.293.006-.399-.287-.47l-.451-.081.082-.381 2.29-.287zM8 5.5a1 1 0 1 1 0-2 1 1 0 0 1 0 2z"/>
                  </svg>
                </div>
                <span>Excellence</span>
              </div>
              <div class="value-item">
                <div class="value-icon">
                  <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 16 16">
                    <path d="M2 2a2 2 0 0 1 2-2h8a2 2 0 0 1 2 2v13.5a.5.5 0 0 1-.777.416L8 13.101l-5.223 2.815A.5.5 0 0 1 2 15.5V2zm2-1a1 1 0 0 0-1 1v12.566l4.723-2.482a.5.5 0 0 1 .554 0L13 14.566V2a1 1 0 0 0-1-1H4z"/>
                  </svg>
                </div>
                <span>Perfection</span>
              </div>
              <div class="value-item">
                <div class="value-icon">
                  <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 16 16">
                    <path d="M8 16a2 2 0 0 0 2-2H6a2 2 0 0 0 2 2zM8 1.918l-.797.161A4.002 4.002 0 0 0 4 6c0 .628-.134 2.197-.459 3.742-.16.767-.376 1.566-.663 2.258h10.244c-.287-.692-.502-1.49-.663-2.258C12.134 8.197 12 6.628 12 6a4.002 4.002 0 0 0-3.203-3.92L8 1.917zM14.22 12c.223.447.481.801.78 1H1c.299-.199.557-.553.78-1C2.68 10.2 3 6.88 3 6c0-2.42 1.72-4.44 4.005-4.901a1 1 0 1 1 1.99 0A5.002 5.002 0 0 1 13 6c0 .88.32 4.2 1.22 6z"/>
                  </svg>
                </div>
                <span>Customer Satisfaction</span>
              </div>
            </div>
          </div>
        </div>
      </div>
      
      <!-- Image Column -->
      <div class="col-lg-6">
        <div class="mission-image">
          <div class="image-card">
            <img src="https://img.freepik.com/free-photo/group-people-working-together-office_1157-31007.jpg" 
                 alt="Mission & Vision" class="img-fluid">
          </div>
        </div>
      </div>
      
    </div>
  </div>
</section>

<style>
  /* Global Styles */
  :root {
    --primary-blue: #2E86DE;
    --primary-dark-blue: #0a3d91;
    --primary-light-blue: #4A90E2;
    --accent-orange: #ED7625;
    --text-dark: #333333;
    --text-light: #555555;
    --bg-light: #f8f9fa;
    --white: #ffffff;
    --shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
    --shadow-hover: 0 15px 40px rgba(0, 0, 0, 0.12);
  }
  
  .section-title {
    font-size: 2.5rem;
    font-weight: 700;
    color: var(--primary-dark-blue);
    margin-bottom: 1.5rem;
    position: relative;
  }
  
  .section-title:after {
    content: '';
    position: absolute;
    width: 80px;
    height: 4px;
    background: var(--primary-blue);
    bottom: -10px;
    left: 0;
    border-radius: 2px;
  }
  
  .lead-text {
    font-size: 1.1rem;
    line-height: 1.7;
    color: var(--text-light);
    margin-bottom: 1.5rem;
  }
  
  .highlight-text {
    font-size: 1.1rem;
    line-height: 1.7;
    color: var(--text-dark);
    background: rgba(46, 134, 222, 0.05);
    padding: 1.5rem;
    border-radius: 10px;
    border-left: 4px solid var(--primary-blue);
  }
  
  /* About Section */
  .about-section {
    background: var(--white);
  }
  
  .about-images {
    position: relative;
    padding: 0 20px;
  }
  
  .image-stack {
    position: relative;
    max-width: 500px;
    margin: 0 auto;
  }
  
  .main-image {
    border-radius: 20px;
    overflow: hidden;
    box-shadow: var(--shadow);
    transition: all 0.4s ease;
  }
  
  .main-image:hover {
    transform: translateY(-10px);
    box-shadow: var(--shadow-hover);
  }
  
  .main-image img {
    width: 100%;
    height: 350px;
    object-fit: cover;
    transition: transform 0.5s ease;
  }
  
  .main-image:hover img {
    transform: scale(1.05);
  }
  
  .secondary-image {
    position: absolute;
    bottom: -30px;
    right: -30px;
    width: 200px;
    height: 150px;
    border-radius: 15px;
    overflow: hidden;
    box-shadow: var(--shadow);
    border: 5px solid var(--white);
    z-index: 2;
    transition: all 0.4s ease;
  }
  
  .secondary-image:hover {
    transform: translateY(-5px) rotate(3deg);
    box-shadow: var(--shadow-hover);
  }
  
  .secondary-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
  }
  
  /* Services Section */
  .services-section {
    background: var(--bg-light);
  }
  
  .services-image {
    padding: 0 20px;
  }
  
  .image-card {
    border-radius: 20px;
    overflow: hidden;
    box-shadow: var(--shadow);
    transition: all 0.4s ease;
  }
  
  .image-card:hover {
    transform: translateY(-10px);
    box-shadow: var(--shadow-hover);
  }
  
  .image-card img {
    width: 100%;
    height: 400px;
    object-fit: cover;
    transition: transform 0.5s ease;
  }
  
  .image-card:hover img {
    transform: scale(1.05);
  }
  
  .services-grid {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 15px;
    margin: 2rem 0;
  }
  
  .service-item {
    display: flex;
    align-items: center;
    background: var(--white);
    padding: 12px 15px;
    border-radius: 10px;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
    transition: all 0.3s ease;
  }
  
  .service-item:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
    background: rgba(46, 134, 222, 0.05);
  }
  
  .service-icon {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 24px;
    height: 24px;
    background: var(--primary-blue);
    color: var(--white);
    border-radius: 50%;
    margin-right: 10px;
    flex-shrink: 0;
  }
  
  .service-icon svg {
    width: 12px;
    height: 12px;
  }
  
  .cta-button {
    margin-top: 2rem;
  }
  
  .btn-primary {
    background: var(--primary-blue);
    color: var(--white);
    border: 2px solid var(--primary-blue);
    padding: 12px 30px;
    border-radius: 8px;
    font-weight: 600;
    text-decoration: none;
    display: inline-block;
    transition: all 0.3s ease;
    box-shadow: 0 4px 15px rgba(46, 134, 222, 0.2);
  }
  
  .btn-primary:hover {
    background: var(--white);
    color: var(--primary-blue);
    transform: translateY(-3px);
    box-shadow: 0 8px 20px rgba(46, 134, 222, 0.3);
  }
  
  /* Mission Section */
  .mission-section {
    background: var(--white);
  }
  
  .values-section {
    margin-top: 2rem;
  }
  
  .values-title {
    font-size: 1.5rem;
    font-weight: 600;
    color: var(--primary-dark-blue);
    margin-bottom: 1.5rem;
  }
  
  .values-grid {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 15px;
  }
  
  .value-item {
    display: flex;
    align-items: center;
    background: var(--bg-light);
    padding: 15px;
    border-radius: 10px;
    transition: all 0.3s ease;
  }
  
  .value-item:hover {
    transform: translateY(-5px);
    box-shadow: var(--shadow);
    background: rgba(46, 134, 222, 0.05);
  }
  
  .value-icon {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 40px;
    height: 40px;
    background: var(--primary-blue);
    color: var(--white);
    border-radius: 10px;
    margin-right: 15px;
    flex-shrink: 0;
  }
  
  .value-icon svg {
    width: 18px;
    height: 18px;
  }
  
  /* Responsive Styles */
  @media (max-width: 991px) {
    .section-title {
      font-size: 2rem;
    }
    
    .secondary-image {
      width: 150px;
      height: 120px;
      bottom: -20px;
      right: -20px;
    }
    
    .services-grid,
    .values-grid {
      grid-template-columns: 1fr;
    }
  }
  
  @media (max-width: 767px) {
    .section-title {
      font-size: 1.8rem;
      text-align: center;
    }
    
    .section-title:after {
      left: 50%;
      transform: translateX(-50%);
    }
    
    .about-images,
    .services-image {
      padding: 0;
      margin-bottom: 2rem;
    }
    
    .secondary-image {
      position: relative;
      bottom: 0;
      right: 0;
      width: 100%;
      height: 150px;
      margin-top: 20px;
    }
    
    .image-card img,
    .main-image img {
      height: 250px;
    }
  }
</style>

@endsection