@extends('app.layouts.main')
@section('content')
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1><i class="nav-icon fas fa-user-shield"></i> Visa Service Page</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{url(sitePrefix().'dashboard')}}">Home</a></li>
                            <li class="breadcrumb-item active">Visa Service</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        <section class="content">
            <div class="container-fluid">
                @if (session('success'))
                    <div class="alert alert-success" role="alert">
                        <button type="button" class="close" data-dismiss="alert">×</button>
                        {{ session('success') }}
                    </div>
                @elseif(session('error'))
                    <div class="alert alert-danger" role="alert">
                        <button type="button" class="close" data-dismiss="alert">×</button>
                        {{ session('error') }}
                    </div>
                @endif
                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
                <form role="form" id="formWizard" class="form--wizard" enctype="multipart/form-data" method="post">
                    {{csrf_field()}}
                    <div class="card card-info">
                        <div class="card-header">
                            <h3 class="card-title">Visa Service Form</h3>
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label> Title(English)*</label>
                                    <input type="text" name="title_en" id="title_en" placeholder="Title(English)"
                                           class="form-control required" autocomplete="off"
                                           value="{{ old('title_en',isset($visaservice)?$visaservice->title_en:'') }}"
                                           maxlength="255">
                                    <div class="help-block with-errors" id="title_en_error"></div>
                                    @error('title_en')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group col-md-6">
                                    <label> Title(Arabic)*</label>
                                    <input type="text" name="title_ar" id="title_ar" placeholder="Title(Arabic)"
                                           class="form-control required" autocomplete="off"
                                           value="{{ old('title_ar',isset($visaservice)?$visaservice->title_ar:'') }}"
                                           maxlength="255">
                                    <div class="help-block with-errors" id="title_ar_error"></div>
                                    @error('title_ar')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group col-md-6">
                                    <label> Sub Title(English)</label>
                                    <input type="text" name="sub_title_en" id="sub_title_en"
                                           placeholder="Sub Title(English)"
                                           class="form-control" autocomplete="off"
                                           value="{{ old('sub_title_en',isset($visaservice)?$visaservice->sub_title_en:'') }}"
                                           maxlength="255">
                                    <div class="help-block with-errors" id="sub_title_en_error"></div>
                                </div>
                                <div class="form-group col-md-6">
                                    <label> Sub Title(Arabic)</label>
                                    <input type="text" name="sub_title_ar" id="sub_title_ar"
                                           placeholder="Sub Title(Arabic)"
                                           class="form-control" autocomplete="off"
                                           value="{{ old('sub_title_ar',isset($visaservice)?$visaservice->sub_title_ar:'') }}"
                                           maxlength="255">
                                    <div class="help-block with-errors" id="sub_title_ar_error"></div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label> Description(English)*</label>
                                    <textarea name="description_en" id="description_en"
                                              class="form-control tinyeditor required"
                                              placeholder="Description(English)"
                                    >{{ old('description_en',isset($visaservice)?$visaservice->description_en:'') }}</textarea>
                                    <div class="help-block with-errors" id="description_en_error"></div>
                                    @error('description_en')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group col-md-6">
                                    <label> Description(Arabic)*</label>
                                    <textarea name="description_ar" id="description_ar"
                                              class="form-control tinyeditor required"
                                              placeholder="Description(Arabic)"
                                    >{{ old('description_ar',isset($visaservice)?$visaservice->description_ar:'') }}</textarea>
                                    <div class="help-block with-errors" id="description_ar_error"></div>
                                    @error('description_ar')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="form-row">
                                <div class="form-group col-md-4">
                                    <label> First Image*</label>
                                    <div class="file-loading">
                                        <input id="first_image" name="first_image" type="file" accept="image/*">
                                    </div>
                                    <span class="caption_note">Note: Image dimension must be 662 X 607 PX and Size must be less than 512 KB</span>
                                    @error('first_image')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group col-md-4">
                                    <label> Second Image*</label>
                                    <div class="file-loading">
                                        <input id="second_image" name="second_image" type="file" accept="image/*">
                                    </div>
                                    <span class="caption_note">Note: Image dimension must be 400 X 470 PX and Size must be less than 512 KB</span>
                                    @error('second_image')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group col-md-4">
                                    <label> Image Attribute *</label>
                                    <input type="text" class="form-control placeholder-cls required"
                                           id="image_attribute"
                                           name="image_attribute" placeholder="Alt='Home Image Attribute'"
                                           value="{{ old('image_attribute',isset($visaservice)?$visaservice->image_attribute:'') }}"
                                           maxlength="255">
                                    @error('image_attribute')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                        </div>
                        <div class="card-footer">
                            <input type="hidden" name="id" id="id" value="{{isset($visaservice)?$visaservice->id:'0'}}">
                            <input type="submit" name="btn_save" value="Submit"
                                   class="btn btn-primary pull-left submitBtn">
                        </div>
                    </div>
                </form>
            </div>
        </section>
    </div>
    <script type="text/javascript">
        $(document).ready(function () {
            $("#first_image").fileinput({
                'theme': 'explorer-fas',
                validateInitialCount: true,
                overwriteInitial: false,
                autoReplace: true,
                layoutTemplates: {actionDelete: ''},
                removeLabel: "Remove",
                initialPreviewAsData: true,
                dropZoneEnabled: false,
                required: true,
                allowedFileTypes: ['image'],
                minImageWidth: 662,
                minImageHeight: 607,
                maxImageWidth: 662,
                maxImageHeight: 607,
                maxFileSize: 512,
                showRemove: false,
                @if(isset($visaservice) && $visaservice->first_image!=NULL)
                initialPreview: [
                    "{{asset($visaservice->first_image)}}",
                ],
                initialPreviewConfig: [
                    {caption: "{!! ($visaservice->first_image!=NULL)?$visaservice->title_en:'';!!}", width: "120px"}
                ]
                @endif
            });
            $("#second_image").fileinput({
                'theme': 'explorer-fas',
                validateInitialCount: true,
                overwriteInitial: false,
                autoReplace: true,
                layoutTemplates: {actionDelete: ''},
                removeLabel: "Remove",
                initialPreviewAsData: true,
                dropZoneEnabled: false,
                required: true,
                allowedFileTypes: ['image'],
                minImageWidth: 400,
                minImageHeight: 470,
                maxImageWidth: 400,
                maxImageHeight: 470,
                maxFileSize: 512,
                showRemove: false,
                @if(isset($visaservice) && $visaservice->second_image!=NULL)
                initialPreview: [
                    "{{asset($visaservice->second_image)}}",
                ],
                initialPreviewConfig: [
                    {caption: "{!! ($visaservice->second_image!=NULL)?$visaservice->title_en:'';!!}", width: "120px"}
                ]
                @endif
            });


        });
    </script>
@endsection
