@extends('app.layouts.main')
@section('content')
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1><i class="nav-icon fas fa-user-shield"></i> {{$title}}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{url(sitePrefix().'dashboard')}}">Home</a>
                            </li>
                            <li class="breadcrumb-item"><a href="{{url(sitePrefix().'team/maid')}}">Maids</a>
                            </li>
                            <li class="breadcrumb-item active">{{$title}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        <section class="content">
            <div class="container-fluid">
                <form role="form" id="formWizard" class="form--wizard" enctype="multipart/form-data" method="post">
                    {{csrf_field()}}
                    <div class="card card-info">
                        <div class="card-header">
                            <h3 class="card-title">Maids Form</h3>
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                    <i class="fas fa-minus"></i>
                                </button>

                            </div>
                        </div>
                        <div class="card-body">
                            @if (session('success'))
                                <div class="alert alert-success" role="alert">
                                    <button type="button" class="close" data-dismiss="alert">×</button>
                                    {{ session('success') }}
                                </div>
                            @elseif(session('error'))
                                <div class="alert alert-danger" role="alert">
                                    <button type="button" class="close" data-dismiss="alert">×</button>
                                    {{ session('error') }}
                                </div>
                            @endif
                            @if ($errors->any())
                                <div class="alert alert-danger">
                                    <ul>
                                        @foreach ($errors->all() as $error)
                                            <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label> Name (English)*</label>
                                    <input type="text" name="name_en" id="name_en" placeholder="Name English"
                                           class="form-control required" autocomplete="off"
                                           value="{{ isset($maid)?$maid->name_en:'' }}">
                                    <div class="help-block with-errors" id="name_en_error"></div>
                                    @error('name_en')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group col-md-6">
                                    <label> Name (Arabic)*</label>
                                    <input type="text" name="name_ar" id="name_ar" placeholder="Name Arabic"
                                           class="form-control required" autocomplete="off"
                                           value="{{ isset($maid)?$maid->name_ar:'' }}">
                                    <div class="help-block with-errors" id="name_ar_error"></div>
                                    @error('name_ar')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="form-row">

{{--                                <div class="form-group col-md-4">--}}
{{--                                    <label> Maid Id*</label>--}}
{{--                                    <input type="text" name="maid_id" id="maid_id" placeholder="Maid ID"--}}
{{--                                           class="form-control required" autocomplete="off"--}}
{{--                                           value="{{ isset($maid)?$maid->maid_id:'' }}">--}}
{{--                                    <div class="help-block with-errors" id="maid_id_error"></div>--}}
{{--                                    @error('maid_id')--}}
{{--                                    <div class="invalid-feedback">{{ $message }}</div>--}}
{{--                                    @enderror--}}
{{--                                </div>--}}

                                <div class="form-group col-md-6">
                                    <label> Email*</label>
                                    <input type="email" name="email" id="email" placeholder="Email"
                                           class="form-control required" autocomplete="off" maxlength="70"
                                           value="{{ old('email',isset($maid)?$maid->email:'') }}">
                                    <div class="help-block with-errors" id="email_error"></div>
                                    @error('email')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group col-md-6">
                                    <label> Date of Birth*</label>
                                    <input type="date" name="dob" id="dob" placeholder="Date of Birth"
                                           class="form-control required" autocomplete="off"
                                           value="{{ old('dob',isset($maid)?$maid->dob:'') }}">
                                    <div class="help-block with-errors" id="dob_error"></div>
                                    @error('dob')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label> Experience(years)</label>
                                    <input type="number" name="experience_year" id="experience_year"
                                           placeholder="Experience(years)" class="form-control"
                                           autocomplete="off" min="0" max="50" maxlength="2"
                                           value="{{ old('experience_year',isset($maid)?$maid->experience_year:'') }}">
                                    <div class="help-block with-errors" id="experience_year_error"></div>
                                    @error('experience_year')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group col-md-6">
                                    <label> Experience(months)</label>
                                    <input type="number" name="experience_month" id="experience_month"
                                           placeholder="Experience(months)" class="form-control"
                                           autocomplete="off" min="0" max="11" maxlength="2"
                                           value="{{ old('experience_month',isset($maid)?$maid->experience_month:'') }}">
                                    <div class="help-block with-errors" id="experience_month_error"></div>
                                    @error('experience_month')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label for="nationality">Nationality*</label>
                                    <select class="form-control required" name="nationality" id="nationality">
                                        <option value="">Select Nationality</option>
                                        @foreach($countries AS $nationality)
                                            <option value="{{ $nationality->id }}"
                                                {{ (old("nationality", @$maid->country_id) == $nationality->id)? "selected" : "" }}>
                                                {{ $nationality->nationality_en }}</option>
                                        @endforeach
                                    </select>
                                    <div class="help-block with-errors" id="nationality_error"></div>
                                    @error('nationality')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                    @enderror
                                </div>
                                <div class="form-group col-md-6">
                                    <label> Video URL</label>
                                    <input type="text" name="video_url" id="video_url"
                                           placeholder="Video URL" class="form-control"
                                           autocomplete="off" maxlength="200"
                                           value="{{ old('video_url',isset($maid)?$maid->video_url:'') }}">
                                    @error('video_url')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label> Image*</label>
                                    <div class="file-loading">
                                        <input id="image" name="image" type="file" accept="image/*">
                                    </div>
                                    <span class="caption_note">Note: Image dimension must be 300 x 300 PX and Size must be less than 512 KB</span>
                                    @error('image')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group col-md-6">
                                    <label> Image Attribute</label>
                                    <input type="text" name="image_attribute" id="image_attribute"
                                           placeholder="Alt='Banner Attribute'"
                                           class="form-control placeholder-cls" autocomplete="off" maxlength="255"
                                           value="{{ old('image_attribute',isset($maid)?$maid->image_attribute:'') }}">
                                </div>
                            </div>
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label for="services">Services*</label>
                                        <select class="form-control select2 required" name="services[]" id="services"
                                                multiple>
                                            <option value="">Select Services</option>
                                            @foreach($services AS $service)
                                                <option value="{{ $service->id }}">{{ $service->title_en }}</option>
                                            @endforeach
                                        </select>
                                        <div class="help-block with-errors" id="services_error"></div>
                                        @error('services')
                                        <div class="invalid-feedback">
                                            {{ $message }}
                                        </div>
                                        @enderror
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label for="skill_sets">Skill Sets*</label>
                                        <select class="form-control select2 required" name="skill_sets[]"
                                                id="skill_sets"
                                                multiple>
                                            <option value="">Select Skill Sets</option>
                                            @foreach($skillSets AS $skill_set)
                                                <option value="{{ $skill_set->id }}">{{ $skill_set->title_en }}</option>
                                            @endforeach
                                        </select>
                                        <div class="help-block with-errors" id="skill_sets_error"></div>
                                        @error('skill_sets')
                                        <div class="invalid-feedback">
                                            {{ $message }}
                                        </div>
                                        @enderror
                                    </div>
                                </div>
                        </div>
                        <div class="card-footer">
                            <input type="submit" name="btn_save" value="Submit"
                                   class="btn btn-primary pull-left submitBtn">
                            <button type="reset" class="btn btn-default">Cancel</button>
                        </div>
                    </div>
                </form>
            </div>
        </section>
    </div>
    <script type="text/javascript">
        $(document).ready(function () {
            $("#image").fileinput({
                'theme': 'explorer-fas',
                validateInitialCount: true,
                overwriteInitial: false,
                autoReplace: true,
                layoutTemplates: {actionDelete: ''},
                initialPreviewShowDelete: false,
                removeLabel: "Remove",
                initialPreviewAsData: true,
                dropZoneEnabled: false,
                required: true,
                allowedFileTypes: ['image'],
                minImageWidth: 300,
                minImageHeight: 300,
                maxImageWidth: 300,
                maxImageHeight: 300,
                maxFileSize: 512,
                showRemove: false,
                @if(isset($maid) && $maid->image!=NULL)
                initialPreview: ["{{asset($maid->image)}}",],
                initialPreviewConfig: [{caption: "{{last(explode('/',$maid->image))}}", width: "120px",}]
                @endif
            });
        });
        @if(@$maid)
        $('#services').val({!! $maid->services()->pluck('service_id') !!}).trigger('change');
        @endif

        @if(@$maid)
        $('#skill_sets').val({!! $maid->skill_sets()->pluck('skill_set_id') !!}).trigger('change');
        @endif
    </script>
@endsection
