@extends('app.layouts.main')
@section('content')
<div class="content-wrapper">
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1><i class="nav-icon fas fa-user-shield"></i> {{$title}}</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                      <li class="breadcrumb-item"><a href="{{url(sitePrefix().'dashboard')}}">Home</a></li>
                      <li class="breadcrumb-item"><a href="{{url(sitePrefix().'home/testimonial')}}">Testimonials List</a></li>
                      <li class="breadcrumb-item active">{{$title}}</li>
                    </ol>
                </div>
            </div>
        </div>
    </section>
    <section class="content">
        <div class="container-fluid">
            <form role="form" id="formWizard" class="form--wizard" enctype="multipart/form-data"method="post">
                {{csrf_field()}}
                <div class="card card-info">
                  <div class="card-header">
                    <h3 class="card-title">Basic Informations</h3>
                    <div class="card-tools">
                      <button type="button" class="btn btn-tool" data-card-widget="collapse">
                        <i class="fas fa-minus"></i>
                      </button>
                      </button>
                    </div>
                  </div>
                  <div class="card-body">
                    @if (session('success'))
                      <div class="alert alert-success" role="alert">
                          <button type="button" class="close" data-dismiss="alert">×</button>
                          {{ session('success') }}
                      </div>
                    @elseif(session('error'))
                          <div class="alert alert-danger" role="alert">
                              <button type="button" class="close" data-dismiss="alert">×</button>
                              {{ session('error') }}
                      </div>
                    @endif
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label for="title">Name (English)*</label>
                            <input type="text" name="name_en" id="name_en" placeholder="Name English" class="form-control required" autocomplete="off" value="{{ old('title',isset($testimonial)?$testimonial->name_en:'') }}" maxlength="60">
                            <div class="help-block with-errors" id="name_en_error"></div>
                            @error('name_en')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="form-group col-md-6">
                            <label for="title">Name (Arabic)*</label>
                            <input type="text" name="name_ar" id="name_ar" placeholder="Name Arabic" class="form-control required" autocomplete="off" value="{{ old('title',isset($testimonial)?$testimonial->name_ar:'') }}" maxlength="60">
                            <div class="help-block with-errors" id="name_ar_error"></div>
                            @error('name_ar')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label for="title">Designation (English)</label>
                                <input type="text" name="designation_en" id="designation_en" placeholder="Designation English" class="form-control" autocomplete="off" value="{{ old('title',isset($testimonial)?$testimonial->designation_en:'') }}" maxlength="255">
                                <div class="help-block with-errors" id="designation_en_error"></div>
                                @error('designation_en')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="form-group col-md-6">
                                <label for="title">Designation (Arabic)</label>
                                <input type="text" name="designation_ar" id="designation_ar" placeholder="Designation Arabic" class="form-control" autocomplete="off" value="{{ old('title',isset($testimonial)?$testimonial->designation_ar:'') }}" maxlength="255">
                                <div class="help-block with-errors" id="designation_ar_error"></div>
                                @error('designation_ar')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label for="title">Title (English)*</label>
                                <input type="text" name="title_en" id="title_en" placeholder="Title English" class="form-control required" autocomplete="off" value="{{ old('title_en',isset($testimonial)?$testimonial->title_en:'') }}" maxlength="255">
                                <div class="help-block with-errors" id="title_en_error"></div>
                                @error('$title_en')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="form-group col-md-6">
                                <label for="title">Title (Arabic)*</label>
                                <input type="text" name="title_ar" id="title_ar" placeholder="Title Arabic" class="form-control required" autocomplete="off" value="{{ old('title_ar',isset($testimonial)?$testimonial->title_ar:'') }}" maxlength="255">
                                <div class="help-block with-errors" id="title_ar_error"></div>
                                @error('title_ar')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>


                        <div class="form-row">
                        <div class="form-group col-md-6">
                            <label for="inputEmail4">Message (English)*</label>
                            <textarea class="form-control tinyeditor required" id="message_en" name="message_en">{{ old('message',isset($testimonial)?$testimonial->message_en:'') }}</textarea>
                            <div class="help-block with-errors" id="message_en_error"></div>
                            @error('message_en')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="form-group col-md-6">
                            <label for="inputEmail4">Message (Arabic)*</label>
                            <textarea class="form-control tinyeditor required" id="message_ar" name="message_ar">{{ old('message',isset($testimonial)?$testimonial->message_ar:'') }}</textarea>
                            <div class="help-block with-errors" id="message_ar_error"></div>
                            @error('message_ar')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label for="title"> Rating</label>
                                <input type="number" min="0" max="5" name="rating" id="rating" placeholder="Rating"
                                       class="form-control" autocomplete="off"
                                       value="{{ isset($testimonial)?$testimonial->rating:'' }}">
                                @error('rating')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="form-group col-md-6">
                                <label> Review Type*</label>
                                <select class="form-control required" name="review_type" id="review_type">
                                    <option value="Normal" {{ (@$testimonial->review_type=='Normal')?'selected':''}}>Normal</option>
                                    <option value="Google" {{  (@$testimonial->review_type=='Google')?'selected':'' }}>Google</option>
                                </select>
                                <div class="help-block with-errors" id="tax_error"></div>
                            </div>
                        </div>

                        <div class="form-row">
                        <div class="form-group col-md-6">
                            <label for="image">Image*</label>
                            <div class="file-loading">
                                <input id="image" name="image" type="file" accept="image/*">
                            </div>
                            <span class="caption_note">Note: Image dimension must be 492 X 286 PX and Size must be less than 512 KB</span>
                            @error('image')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="form-group col-md-6">
                            <label for="image_meta_tag">Image Meta Tag</label>
                            <input type="text" name="image_meta_tag" id="image_meta_tag"
                                   placeholder="Image Alternate Text" class="form-control placeholder-cls"
                                   required autocomplete="off"
                                   value="{{ isset($testimonial)?$testimonial->image_meta_tag:'' }}" maxlength="255">
                            @error('image_meta_tag')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                    </div>
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <input type="submit" class="btn btn-primary pull-left submitBtn" value="Submit">
                            <input type="reset" class="btn btn-default" value="Reset">
                            <img class="animation__shake loadingImg" src="{{url('app/dist/img/loading.gif')}}" style="display:none;">
                        </div>
                    </div>
                </div>
            </div>
        </form>
        </div>
    </section>
</div>
<script type="text/javascript">
$(document).ready(function(){
    $("#image").fileinput({
        'theme': 'explorer-fas',
        validateInitialCount: true,
        overwriteInitial: false,
        autoReplace: true,
        layoutTemplates: {actionDelete: ''},
        removeLabel: "Remove",
        initialPreviewAsData: true,
        dropZoneEnabled: false,
        required: true,
        allowedFileTypes: ['image'],
        minImageWidth: 492,
        minImageHeight: 286,
        maxImageWidth: 492,
        maxImageHeight: 286,
        maxFileSize: 512,
        showRemove: false,
        @if(isset($testimonial) && $testimonial->image!=NULL)
          initialPreview: ["{{asset($testimonial->image)}}",],
          initialPreviewConfig: [{
              caption: "{{last(explode('/',$testimonial->image))}}",
              width: "120px",
              key: "{{($testimonial->image)}}",
          }]
        @endif
    });
});
</script>
@endsection
