@extends('app.layouts.main')
@section('content')
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1><i class="nav-icon fas fa-user-shield"></i> Home About</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{url(sitePrefix().'dashboard')}}">Home</a></li>
                            <li class="breadcrumb-item active">Home About-us</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        <section class="content">
            <div class="container-fluid">
                @if (session('success'))
                    <div class="alert alert-success" role="alert">
                        <button type="button" class="close" data-dismiss="alert">×</button>
                        {{ session('success') }}
                    </div>
                @elseif(session('error'))
                    <div class="alert alert-danger" role="alert">
                        <button type="button" class="close" data-dismiss="alert">×</button>
                        {{ session('error') }}
                    </div>
                @endif
                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
                <form role="form" id="formWizard" class="form--wizard" enctype="multipart/form-data" method="post">
                    {{csrf_field()}}
                    <div class="card card-info">
                        <div class="card-header">
                            <h3 class="card-title">Home About-us Form</h3>
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label> Title(English)*</label>
                                    <input type="text" name="title_en" id="title_en" placeholder="Title(English)"
                                           class="form-control required" autocomplete="off"
                                           value="{{ old('title_en',isset($about)?$about->title_en:'') }}"
                                           maxlength="255">
                                    <div class="help-block with-errors" id="title_en_error"></div>
                                    @error('title_en')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group col-md-6">
                                    <label> Title(Arabic)*</label>
                                    <input type="text" name="title_ar" id="title_ar" placeholder="Title(Arabic)"
                                           class="form-control required" autocomplete="off"
                                           value="{{ old('title_ar',isset($about)?$about->title_ar:'') }}"
                                           maxlength="255">
                                    <div class="help-block with-errors" id="title_ar_error"></div>
                                    @error('title_ar')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group col-md-6">
                                    <label> Sub Title(English)</label>
                                    <input type="text" name="sub_title_en" id="sub_title_en"
                                           placeholder="Sub Title(English)"
                                           class="form-control" autocomplete="off"
                                           value="{{ old('sub_title_en',isset($about)?$about->sub_title_en:'') }}"
                                           maxlength="255">
                                    <div class="help-block with-errors" id="sub_title_en_error"></div>
                                </div>
                                <div class="form-group col-md-6">
                                    <label> Sub Title(Arabic)</label>
                                    <input type="text" name="sub_title_ar" id="sub_title_ar"
                                           placeholder="Sub Title(Arabic)"
                                           class="form-control" autocomplete="off"
                                           value="{{ old('sub_title_ar',isset($about)?$about->sub_title_ar:'') }}"
                                           maxlength="255">
                                    <div class="help-block with-errors" id="sub_title_ar_error"></div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label> Description(English)*</label>
                                    <textarea name="description_en" id="description_en"
                                              class="form-control tinyeditor required"
                                              placeholder="Description(English)"
                                    >{{ old('description_en',isset($about)?$about->description_en:'') }}</textarea>
                                    <div class="help-block with-errors" id="description_en_error"></div>
                                    @error('description_en')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group col-md-6">
                                    <label> Description(Arabic)*</label>
                                    <textarea name="description_ar" id="description_ar"
                                              class="form-control tinyeditor required"
                                              placeholder="Description(Arabic)"
                                    >{{ old('description_ar',isset($about)?$about->description_ar:'') }}</textarea>
                                    <div class="help-block with-errors" id="description_ar_error"></div>
                                    @error('description_ar')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-4">
                                    <label> First Image*</label>
                                    <div class="file-loading">
                                        <input id="first_image" name="first_image" type="file" accept="image/*">
                                    </div>
                                    <span class="caption_note">Note: Image dimension must be 653 X 607 PX and Size must be less than 512 KB</span>
                                    @error('first_image')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group col-md-4">
                                    <label> second Image*</label>
                                    <div class="file-loading">
                                        <input id="second_image" name="second_image" type="file" accept="image/*">
                                    </div>
                                    <span class="caption_note">Note: Image dimension must be 400 X 470 PX and Size must be less than 512 KB</span>
                                    @error('second_image')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group col-md-4">
                                    <label> Image Attribute *</label>
                                    <input type="text" class="form-control placeholder-cls required"
                                           id="image_attribute"
                                           name="image_attribute" placeholder="Alt='Home Image Attribute'"
                                           value="{{ old('image_attribute',isset($about)?$about->image_attribute:'') }}"
                                           maxlength="255">
                                    @error('image_attribute')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-4">
                                    <label> Button Text(English)*</label>
                                    <input type="text" name="button_text_en" id="button_text_en"
                                           placeholder="Button Text(English)"
                                           class="form-control required" autocomplete="off"
                                           value="{{ old('button_text_en',isset($about)?$about->button_text_en:'') }}"
                                           maxlength="255">
                                    <div class="help-block with-errors" id="button_text_en_error"></div>
                                    @error('button_text_en')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group col-md-4">
                                    <label> Button Text(Arabic)*</label>
                                    <input type="text" name="button_text_ar" id="button_text_ar"
                                           placeholder="Button Text(Arabic)"
                                           class="form-control required" autocomplete="off"
                                           value="{{ old('button_text_ar',isset($about)?$about->button_text_ar:'') }}"
                                           maxlength="255">
                                    <div class="help-block with-errors" id="button_text_ar_error"></div>
                                    @error('button_text_ar')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group col-md-4">
                                    <label> Button URL*</label>
                                    <input type="text" name="button_url" id="button_url" placeholder="Button URL"
                                           class="form-control required" autocomplete="off"
                                           value="{{ old('button_url',isset($about)?$about->button_url:'') }}"
                                           maxlength="255">
                                    <div class="help-block with-errors" id="button_url_error"></div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <input type="hidden" name="id" id="id" value="{{isset($about)?$about->id:'0'}}">
                            <input type="submit" name="btn_save" value="Submit"
                                   class="btn btn-primary pull-left submitBtn">
                        </div>
                    </div>
                </form>
            </div>
        </section>
    </div>
    <script type="text/javascript">
        $(document).ready(function () {
            $("#first_image").fileinput({
                'theme': 'explorer-fas',
                validateInitialCount: true,
                overwriteInitial: false,
                autoReplace: true,
                layoutTemplates: {actionDelete: ''},
                removeLabel: "Remove",
                initialPreviewAsData: true,
                dropZoneEnabled: false,
                required: true,
                allowedFileTypes: ['image'],
                minImageWidth: 653,
                minImageHeight: 607,
                maxImageWidth: 653,
                maxImageHeight: 607,
                maxFileSize: 512,
                showRemove: false,
                @if(isset($about) && $about->first_image!=NULL)
                initialPreview: [
                    "{{asset($about->first_image)}}",
                ],
                initialPreviewConfig: [
                    {caption: "{!! ($about->first_image!=NULL)?$about->title_en:'';!!}", width: "120px"}
                ]
                @endif
            });
            $("#second_image").fileinput({
                'theme': 'explorer-fas',
                validateInitialCount: true,
                overwriteInitial: false,
                autoReplace: true,
                layoutTemplates: {actionDelete: ''},
                removeLabel: "Remove",
                initialPreviewAsData: true,
                dropZoneEnabled: false,
                required: true,
                allowedFileTypes: ['image'],
                minImageWidth: 400,
                minImageHeight: 470,
                maxImageWidth: 400,
                maxImageHeight: 470,
                maxFileSize: 512,
                showRemove: false,
                @if(isset($about) && $about->second_image!=NULL)
                initialPreview: [
                    "{{asset($about->second_image)}}",
                ],
                initialPreviewConfig: [
                    {caption: "{!! ($about->second_image!=NULL)?$about->title_en:'';!!}", width: "120px"}
                ]
                @endif
            });
        });
    </script>
@endsection
