@extends('app.layouts.main')
@section('content')
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1><i class="nav-icon fas fa-user-shield"></i> {{$title}}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{url(sitePrefix().'dashboard')}}">Home</a>
                            </li>
                            <li class="breadcrumb-item"><a href="{{url(sitePrefix().'country')}}">Country</a>
                            </li>
                            <li class="breadcrumb-item active">{{$title}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        <section class="content">
            <div class="container-fluid">
                <form role="form" id="formWizard" class="form--wizard" enctype="multipart/form-data" method="post">
                    {{csrf_field()}}
                    <div class="card card-info">
                        <div class="card-header">
                            <h3 class="card-title">Country Form</h3>
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                    <i class="fas fa-minus"></i>
                                </button>

                            </div>
                        </div>
                        <div class="card-body">
                            @if (session('success'))
                                <div class="alert alert-success" role="alert">
                                    <button type="button" class="close" data-dismiss="alert">×</button>
                                    {{ session('success') }}
                                </div>
                            @elseif(session('error'))
                                <div class="alert alert-danger" role="alert">
                                    <button type="button" class="close" data-dismiss="alert">×</button>
                                    {{ session('error') }}
                                </div>
                            @endif
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label> Country Title (English)*</label>
                                    <input type="text" name="title_en" id="title_en" placeholder="Country English"
                                           class="form-control required" autocomplete="off"
                                           value="{{ isset($country)?$country->title_en:'' }}">
                                    <div class="help-block with-errors" id="title_en_error"></div>
                                    @error('title_en')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group col-md-6">
                                    <label> Country Title (Arabic)*</label>
                                    <input type="text" name="title_ar" id="title_ar" placeholder="Country Arabic"
                                           class="form-control required" autocomplete="off"
                                           value="{{ isset($country)?$country->title_ar:'' }}">
                                    <div class="help-block with-errors" id="title_ar_error"></div>
                                    @error('title_ar')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label> Nationality Title (English)*</label>
                                        <input type="text" name="nationality_en" id="nationality_en" placeholder="Nationality English"
                                               class="form-control required" autocomplete="off"
                                               value="{{ isset($country)?$country->nationality_en:'' }}">
                                        <div class="help-block with-errors" id="nationality_en_error"></div>
                                        @error('nationality_en')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label> Nationality Title (Arabic)*</label>
                                        <input type="text" name="nationality_ar" id="nationality_ar" placeholder="Nationality Arabic"
                                               class="form-control required" autocomplete="off"
                                               value="{{ isset($country)?$country->nationality_ar:'' }}">
                                        <div class="help-block with-errors" id="nationality_ar_error"></div>
                                        @error('nationality_ar')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                        </div>
                        <div class="card-footer">
                            <input type="submit" name="btn_save" value="Submit"
                                   class="btn btn-primary pull-left submitBtn">
                            <button type="reset" class="btn btn-default">Cancel</button>
                        </div>
                    </div>
                </form>
            </div>
        </section>
    </div>
@endsection
