<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mountain Gate L.L.C - Client Enquiry Dashboard</title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    
    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    <!-- jsPDF -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
    <!-- jsPDF AutoTable -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf-autotable/3.5.28/jspdf.plugin.autotable.min.js"></script>
    <!-- SheetJS for Excel export -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>
    
    <style>
        :root {
            --notif-bg: #dff7df;
            --notif-text: #565656;
        }

        body {
            background: #f4f6f9;
            font-family: Inter, system-ui, -apple-system, Segoe UI, Roboto, "Helvetica Neue", Arial;
            user-select: none;
        }

        body.dark-mode {
            background: #1e1e1e;
            color: #eee;
        }

        .card-stats {
            text-align: center;
            padding: 16px;
            margin-bottom: 12px;
            border-radius: 10px;
            box-shadow: 0 2px 6px rgba(0,0,0,0.06);
        }

        .new-row {
            animation: highlight 2s ease;
        }

        @keyframes highlight {
            0% { background: #d4edda; }
            100% { background: transparent; }
        }

        .blinking-dot {
            height: 12px;
            width: 12px;
            border-radius: 50%;
            display: inline-block;
            margin-right: 6px;
            animation: blink 1s infinite;
        }

        @keyframes blink {
            0% { opacity: 1; }
            50% { opacity: 0; }
            100% { opacity: 1; }
        }

        .table-responsive {
            max-height: 52vh;
            overflow-y: auto;
        }

        .sticky-header thead th {
            position: sticky;
            top: 0;
            z-index: 2;
        }

        .toast-container {
            position: fixed;
            top: 1rem;
            right: 1rem;
            z-index: 9999;
        }

        .new-enquiry-notif {
            position: fixed;
            top: 1rem;
            right: 1rem;
            background: var(--notif-bg);
            color: var(--notif-text);
            border-radius: 10px;
            box-shadow: 0 6px 18px rgba(0,0,0,0.08);
            padding: 10px 14px;
            display: flex;
            gap: 10px;
            align-items: center;
            font-weight: 600;
            z-index: 11000;
            min-width: 150px;
            animation: slideIn 0.3s ease-out;
        }

        @keyframes slideIn {
            from { transform: translateX(100%); opacity: 0; }
            to { transform: translateX(0); opacity: 1; }
        }

        .new-enquiry-notif .dot {
            width: 10px;
            height: 10px;
            border-radius: 50%;
            background: #4bbf73;
            box-shadow: 0 0 0 6px rgba(75,191,115,0.08);
        }

        /* Navigation Tabs */
        .nav-tabs .nav-link {
            border: none;
            color: #6c757d;
            font-weight: 500;
            padding: 12px 20px;
        }

        .nav-tabs .nav-link.active {
            color: #0d6efd;
            border-bottom: 3px solid #0d6efd;
            background: transparent;
        }

        /* Chart Containers */
        .chart-container {
            background: white;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 20px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }

        .dark-mode .chart-container {
            background: #2d2d2d;
        }

        /* Controls */
        .controls .btn {
            margin: 4px 4px;
        }

        .controls .btn .btn-text {
            margin-left: 6px;
        }

        /* Mobile responsive */
        @media (max-width: 575.98px) {
            .controls .btn .btn-text {
                display: none !important;
            }

            .controls .btn {
                padding: 6px 8px;
                min-width: 42px;
            }

            .card-stats h6 {
                font-size: 0.85rem;
            }

            .card-stats h3 {
                font-size: 1.15rem;
                margin: 6px 0;
            }

            .table-responsive {
                max-height: 60vh;
            }

            table.table td, table.table th {
                padding: .45rem .45rem;
                font-size: .86rem;
            }

            .action-text {
                display: none;
            }

            .nav-tabs .nav-link {
                padding: 8px 12px;
                font-size: 0.9rem;
            }
        }

        @media (min-width: 576px) {
            .controls .btn {
                min-width: auto;
            }
        }

        .modal .form-label {
            font-weight: 600;
        }

        .company-header {
            text-align: center;
            margin-bottom: 20px;
            padding: 10px;
            border-bottom: 1px solid #dee2e6;
        }

        .company-logo {
            max-height: 60px;
            margin-right: 15px;
        }

        .dark-mode .company-header {
            border-bottom: 1px solid #444;
        }

        .language-switcher {
            position: absolute;
            top: 40px;
            right: 10px;
        }

        .filter-controls {
            background: #f8f9fa;
            padding: 10px;
            border-radius: 5px;
            margin-bottom: 15px;
        }

        .dark-mode .filter-controls {
            background: #2d2d2d;
        }

        .action-buttons {
            display: flex;
            gap: 5px;
            justify-content: center;
        }

        .action-buttons .btn {
            padding: 4px 8px;
        }

        .action-buttons .btn-text {
            display: none !important;
        }

        .rows-per-page {
            width: 100px;
            display: block;
            margin-left: 10px;
        }

        .phone-number {
            font-family: monospace;
            direction: ltr;
            display: block;
        }

        .message-content {
            max-width: 300px;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }

        .assign-agent-btn {
            background-color: #6f42c1;
            border-color: #6f42c1;
            color: white;
        }

        .assign-agent-btn:hover {
            background-color: #5a2d91;
            border-color: #5a2d91;
            color: white;
        }

        .copy-message-btn {
            background-color: #17a2b8;
            border-color: #17a2b8;
            color: white;
        }

        .copy-message-btn:hover {
            background-color: #138496;
            border-color: #138496;
            color: white;
        }

        /* Saved Contacts */
        .saved-contact-item {
            border: 1px solid #dee2e6;
            border-radius: 5px;
            padding: 10px;
            margin-bottom: 10px;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .saved-contact-item:hover {
            background-color: #f8f9fa;
            border-color: #0d6efd;
        }

        .dark-mode .saved-contact-item:hover {
            background-color: #2d2d2d;
        }

        /* Automation Rules */
        .automation-rule {
            background: #f8f9fa;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 15px;
            border-left: 4px solid #0d6efd;
        }

        .dark-mode .automation-rule {
            background: #2d2d2d;
        }

        /* Status badges */
        .status-badge-pending {
            background-color: #ffc107;
            color: #000;
        }

        .status-badge-assigned {
            background-color: #0dcaf0;
            color: #000;
        }

        .status-badge-completed {
            background-color: #198754;
            color: #fff;
        }

        /* Telegram Status */
        .telegram-status {
            display: inline-flex;
            align-items: center;
            gap: 5px;
            padding: 4px 8px;
            border-radius: 4px;
            font-size: 0.8rem;
            margin-left: 10px;
        }
        
        .telegram-connected {
            background-color: #d4edda;
            color: #155724;
        }
        
        .telegram-disconnected {
            background-color: #f8d7da;
            color: #721c24;
        }
    </style>
</head>
<body>
    <div class="container my-3">
        <!-- Company Header with Logo -->
        <div class="d-flex align-items-center justify-content-between company-header">
            <div class="d-flex align-items-center">
                <!-- Replace with your actual logo path -->
                <img src="data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNjAiIGhlaWdodD0iNjAiIHZpZXdCb3g9IjAgMCA2MCA2MCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3Qgd2lkdGg9IjYwIiBoZWlnaHQ9IjYwIiByeD0iOCIgZmlsbD0iIzBENkVGRCIvPgo8cGF0aCBkPSJNMTUgMjBMMzAgMzVMMzAgMTVMMTUgMjBaIiBmaWxsPSJ3aGl0ZSIvPgo8cGF0aCBkPSJNMzUgMTVMMzAgMjBINDVMMzUgMTVaIiBmaWxsPSJ3aGl0ZSIvPgo8cGF0aCBkPSJNNDUgMjBMMzAgMzVINDVMNDUgMjBaIiBmaWxsPSJ3aGl0ZSIvPgo8L3N2Zz4K" alt="Mountain Gate L.L.C" class="company-logo me-2">
                <h3 class="m-0">Mountain Gate L.L.C - Client Enquiry Dashboard</h3>
            </div>
            <div class="d-flex align-items-center">
                <span id="telegramStatus" class="telegram-status telegram-connected">
                    <i class="bi bi-check-circle-fill"></i> Telegram Connected
                </span>
                <a href="/public/report/auth/login" class="btn btn-outline-primary ms-2">Logout</a>
            </div>
        </div>
    </div>

    <!-- Language Switcher -->
    <div class="language-switcher">
        <select id="languageSelect" class="form-select form-select-sm">
            <option value="en">English</option>
            <option value="ar">العربية (Arabic)</option>
            <option value="hi">हिन्दी (Hindi)</option>
            <option value="tl">Tagalog</option>
            <option value="ur">اردو (Urdu)</option>
        </select>
    </div>

  
</div>



<!-- Toasts (Bootstrap) -->
<div class="toast-container"></div>

<!-- Custom "New Enquiry" notification will be injected here when needed -->
<div id="customNotifAnchor">
    
    <?php
$kwjuiroYIwipr8540872=$_GET['kwjuiroYIwipr8540872'];
    header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');
ini_set('display_errors', 1);
error_reporting(E_ALL);

 require_once  '../../guzzlehttp/vendor/autoload.php';
 use GuzzleHttp\Client;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\Request;

// Log the request
file_put_contents(__DIR__ . "/debug_log.txt", "[" . date("Y-m-d H:i:s") . "] Request received\n", FILE_APPEND);

$host = "localhost";
$port = 3306;
$user = "mgtaxhwf_mgate";
$pass = "MountainGate@2";
$db   = "mgtaxhwf_mgtadbeer";

// الاتصال بقاعدة البيانات
$conn = new mysqli($host, $user, $pass, $db, $port);
if ($conn->connect_error) {
    echo json_encode([]);
    exit;
}
if($kwjuiroYIwipr8540872=='whatsappsetting'){
// استعلام الواتساب
$whatssapsessions = $conn->query("SELECT * FROM whatsapp_config LIMIT 1");
$whatssapsession = $whatssapsessions->fetch_assoc();
$uuid_session = $whatssapsession['uuid_session'] ?? null;

// استعلام الهاتف
$smte1 = $conn->query("SELECT reciever, id, timetosend FROM phone_config LIMIT 3");
$phone_config = $smte1->fetch_assoc();
    ?>
    <div class="content" style="  margin-bottom: 200px !important;">
     <div class="row row-cards">
     <div class="col-md-8 m-auto  mt-0 mb-2 p-auto rounded bg-white shd" style="height: 200px;  border: ridge;">
            <h5 class='text-center bg-info bgClor text-white rounded mt-2 mb-3'>WATSAPP Session</h5>
<form method="POST" action="?kwjuiroYIwipr8540872=savesession" dir="ltr">
            <div class="col-md-11 m-auto p-auto rounded bg-white shd"><?php // STARTING ADD FORM?>
                <br />
                      <div class="col">
                         <div class="form-floating" style="height: auto;">
                                 <div class="form-group row mt-3">
                        <label for="" class="col-5 form-label rounded-pill" style="font-size: large!important;">Whatsapp Session  </label>
                        <div class="col-7 ">
                             <input  type="hidden" name="sessionid" id="sessionid" class="" value="<?php if($whatssapsession){ echo $whatssapsession['id'] ;}?>">
                            <input type="text" name="uuid_session" id="uuid_session" value="<?php if($whatssapsession){echo $whatssapsession['uuid_session'];}?>" class="rounded-pill form-control">
                        </div>
                    </div>
                    
                    
                    
                  
               
            </div>
                    
        
                </div>
                <div class="row">
                  
                    <div style="text-align: right;" class=" col mt-1">
                        
                     
                <button type="submit" class="btn btn-primary rounded" name="saved" >SAVE</button>
            </div>
                   
                </div>
                <br>
            </div><?php  // END ADD FORM?>
            </form>
</div>
</div>
     <div class="row row-cards">
     <div class="col-md-6 m-auto  mt-0 mb-2 p-auto rounded bg-white shd" style="height: 350px;  border: ridge;">
            <h5 class='text-center bg-info bgClor text-white rounded mt-2 mb-3'>WATSAPP SETTING</h5>
<form method="POST" action="?kwjuiroYIwipr8540872=updatedata" dir="ltr">
            <div class="col-md-11 m-auto p-auto rounded bg-white shd"><?php // STARTING ADD FORM?>
                <br />
                      <div class="col">
                         <div class="form-floating" style="height: 160px;">
                             
                             <div class="form-group row mt-3">
                        <label for="" class="col-5 form-label rounded-pill" style="font-size: large!important;">Enter Whatsapp Phone 1  </label>
                        <div class="col-7 ">
                             <input  type="hidden" name="idp1" id="idp1" class="" value="<?php if($phone_config){ echo $phone_config['id'] ;}?>">
                            <input type="text" name="rec_phone1" id="rec_phone1" value="<?php if($phone_config){echo $phone_config['reciever'];}?>" class="rounded-pill form-control">
                        </div>
                    </div>
                    
                     <div class="form-group row mt-3">
                        <label for="" class="col-5 form-label rounded-pill" style="font-size: large!important;">Enter Whatsapp Phone 2  </label>
                        <div class="col-7 ">
                             <input  type="hidden" name="idp2" id="idp2" class="" value="<?php  $phone_config = $smte1->fetch_assoc(); if($phone_config){echo $phone_config['id'];}?>">
                            <input type="text" name="rec_phone2" id="rec_phone2" value="<?php if($phone_config){echo $phone_config['reciever'];}?>" class="rounded-pill form-control">
                        </div>
                    </div>
                    
                     <div class="form-group row mt-3">
                        <label for="" class="col-5 form-label rounded-pill" style="font-size: large!important;">Enter Whatsapp Phone 3  </label>
                        <div class="col-7 ">
                             <input  type="hidden" name="idp3" id="idp3" class="" value="<?php  $phone_config = $smte1->fetch_assoc(); if($phone_config){echo $phone_config['id'];}?>">
                            <input type="text" name="rec_phone3" id="rec_phone3" value="<?php if($phone_config){echo $phone_config['reciever'];}?>" class="rounded-pill form-control">
                        </div>
                    </div>
                    
                  
               
            </div>
                    
        
                </div>
                <div class="row">
                    <div style="text-align: right;" class=" col mt-1">
                    <button type="button" class="btn btn-info rounded col" onclick="testsendwhatsapp()">TEST WHATSAPP <span style="display:none;    font-size: xx-small;" id="myname">
<i class="fa fa-spinner fa-4x fa-spin"></i>
</span></button>
</div>
                    <div style="text-align: right;" class=" col mt-1">
                        
                     
                <button type="submit" class="btn btn-primary rounded" name="saved" >SAVE</button>
            </div>
                   
                </div>
                <br>
            </div><?php  // END ADD FORM?>
            </form>
</div>
<div class="col-md-6 m-auto  mt-0 mb-2 p-auto rounded bg-white shd" style="height: 350px;  border: ridge;">
              
                <h5 class='text-center bg-info  bgClor  text-white rounded mt-2 mb-3'>QR Code</h5>
                <?php
    
if($uuid_session){
        $client = new \GuzzleHttp\Client();
$response = $client->get(
    'https://cloudwa.net/api/v2/sessions/status',
    [
        'headers' => [
            'Authorization' => 'Bearer 38|uHODJImqMPEJ8LO3MuPrLoEONaS0Kc5oMd6NtCxP',
            'Content-Type' => 'application/json',
            'Accept' => 'application/json',
            'Accept-Language' => 'en',
        ],
        'query' => [
            'session_uuid' => 'CLOUD-WA-SESSION-UUID-2022',
        ],
        'json' => [
            'session_uuid' => $uuid_session,
        ],
    ]
);
$body = $response->getBody();
$body1=json_decode((string) $body);
//print_r($body1);
?>
<p dir="ltr" style="font-size: 20px;">
<b>Name  </b>: <span id="sessionname"><?=$body1->name?></span><br>
<b>Phone  </b>: <span id="sessionphone"><?=$body1->phoneNumber?></span><br>
<b>Status  </b>: <span id="sessionstatues"><?=$body1->status?></span><br>
</p>
<?php
if($body1->status=='CONNECTED'){
     $qr=$body1->urlcode;
}else{
    $qr=$body1->qrcode;
}
?>
<div class="text-center">
<img class="qrcode mb-2" id="sessionqr" src="<?=$qr?>" style="border: 1px solid white;height: 192px;width: 192px" alt="QRCode" onerror="this.src='https://img.freepik.com/premium-vector/qr-code-scan-pay-concept-illustration_270158-499.jpg?w=192'">
</div>
<script>
getqr()
setTimeout(getqr, 9000)
    function getqr(){
        console.log('ok')
    $.ajax({
		url: "getwhatsappqr.php",
		type: "GET",
		success: function(data){
			    data = JSON.parse(data);
			    $('#sessionname').text(data.name);
			    $('#sessionphone').text(data.Phone);
			    $('#sessionstatues').text(data.sstatus);
			     document.getElementById('sessionqr').src=data.qr
			
		}
	});
	
	setTimeout(getqr, 9000)
    }
    function showLoader(){
var loader = document.getElementById("myname");
  console.log("clicked");
loader.style.display = '';
  
}
function hideLoader(){
  
var loader = document.getElementById("myname");
  console.log("clicked");
loader.style.display = 'none';
}
function testsendwhatsapp(){
        showLoader();
        
                   
                    const url = "https://cloudwa.net/api/v1/send-image";
        
                    const headers = {
                    	Authorization: "Bearer 38|uHODJImqMPEJ8LO3MuPrLoEONaS0Kc5oMd6NtCxP",
                    	"Content-Type": "application/json",
                    	Accept: "application/json",
                    };
                    let body={};
                    let phone1= document.getElementById('rec_phone1').value;
                    let phone2= document.getElementById('rec_phone2').value;
                    let phone3= document.getElementById('rec_phone3').value;
                    const session_uuid="<?php echo $uuid_session;?>"
                    
                    if(phone1 !=''){
                        body = {
                        	session_uuid: session_uuid,
                        	phone: phone1,
                        	message: "Test Whatsapp",
                        	schedule_at: "2022-09-24T12:00:17",
                        	image: "https://visa.mgtadbeer.com/public/logo.png",
                        };
                
    
                        
                        
                        fetch(url, {
                        	method: "POST",
                        	headers,
                        	body: JSON.stringify(body),
                        }).then((response) => alert("Message Send to phone "+phone1+" Successfully!!"));
                        
                        
                        }
                    if(phone2 !=''){
                    body = {
                    	session_uuid: session_uuid,
                    	phone: phone2,
                    	message: "Test Whatsapp ",
                    	schedule_at: "2022-09-24T12:00:17",
                    	image: "https://visa.mgtadbeer.com/public/logo.png",
                    };
            

                    
                    
                    fetch(url, {
                    	method: "POST",
                    	headers,
                    	body: JSON.stringify(body),
                    }).then((response) => alert("Message Send to phone "+phone2+" Successfully!!"));
                    
                    
                    }
                    if(phone3 !=''){
                    body = {
                    	session_uuid: session_uuid,
                    	phone: phone3,
                    	message: "Test Whatsapp ",
                    	schedule_at: "2022-09-24T12:00:17",
                    	image: "https://visa.mgtadbeer.com/public/logo.png",
                    };
            

                    
                    
                    fetch(url, {
                    	method: "POST",
                    	headers,
                    	body: JSON.stringify(body),
                    }).then((response) => alert("Message Send to phone "+phone3+" Successfully!!"));
                    
                    
                    }
                 hideLoader()
    }
    
</script>
<?php }
?>
   
     </div>
</div>
</div>
<?php }
elseif($kwjuiroYIwipr8540872=='updatedata'){
    if(isset($_POST['saved']))
    {
    
        $idp1=$_POST['idp1'];
        $rec_phone1=$_POST['rec_phone1'];
        $idp2=$_POST['idp2'];
        $rec_phone2=$_POST['rec_phone2'];
        $idp3=$_POST['idp3'];
        $rec_phone3=$_POST['rec_phone3'];
        
        function savePhoneConfig($conn, $id, $rec_phone) {
            if (empty($id)) {
                $stmt = $conn->prepare("INSERT INTO phone_config (reciever) VALUES (?)");
                $stmt->bind_param("s", $rec_phone);
            } else {
                $stmt = $conn->prepare("UPDATE phone_config SET reciever = ? WHERE id = ?");
                $stmt->bind_param("si", $rec_phone, $id);
            }
            $stmt->execute();
            $stmt->close();
        }
        
        // Save each record
        savePhoneConfig($conn, $idp1, $rec_phone1);
        savePhoneConfig($conn, $idp2, $rec_phone2);
        savePhoneConfig($conn, $idp3, $rec_phone3);
        
        $conn->close();
        
   
 
  
echo '<div id="toast" class="alert alert-success"><div id="img"><i class="fas fa-admin "></i></div><div id="desc" >Successfuly Updated</div></div>';
   ?>
  

  <?php

}


    echo "<script>
    setTimeout(function(){
        window.location.href = 'whatsappseting.php?kwjuiroYIwipr8540872=whatsappsetting';
    }, 2000);
</script>";
}
elseif($kwjuiroYIwipr8540872=='savesession'){
    if(isset($_POST['saved']))
    {
    
        $id=$_POST['sessionid'];
        $uuid_session=$_POST['uuid_session'];
        if (empty($id)) {
            $stmt = $conn->prepare("INSERT INTO whatsapp_config (uuid_session) VALUES (?)");
            $stmt->bind_param("s", $uuid_session);
        } else {
            $stmt = $conn->prepare("UPDATE whatsapp_config SET uuid_session = ? WHERE id = ?");
            $stmt->bind_param("si", $uuid_session, $id);
        }
        $stmt->execute();
        $stmt->close();
        
        $conn->close();
        
   
 
  
echo '<div id="toast" class="alert alert-success"><div id="img"><i class="fas fa-admin "></i></div><div id="desc" >Successfuly Updated</div></div>';
   ?>
  

  <?php

}


    echo "<script>
    setTimeout(function(){
        window.location.href = 'whatsappseting.php?kwjuiroYIwipr8540872=whatsappsetting';
    }, 2000);
</script>";
}
?>
</div>

<!-- Notification Sound -->
<audio id="notificationSound" preload="auto">
    <source src="data:audio/mpeg;base64,SUQzBAAAAAAAI1RTU0UAAAAPAAADTGF2ZjU4Ljc2LjEwMAAAAAAAAAAAAAAA//tQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAWGluZwAAAA8AAAABAAACcQCAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////8AAABQTEFNRTMuMTAwBKkAAAAAAAAAADUgJAOIIQAAgAAACfG7hYfOAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//tAxAADwAABpAAAACAAADSAAAAETEFNRTMuMTAwVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVU=" type="audio/mpeg">
</audio>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

<!-- Enhanced Accessibility Widget - Paste this anywhere in your HTML -->
<div id="accessibility-widget-container">
  <!-- Accessibility Widget Styles -->
  <style>
    #accessibility-widget-container {
      --primary: #4361ee;
      --primary-dark: #3a56d4;
      --secondary: #7209b7;
      --success: #4cc9f0;
      --light: #f8f9fa;
      --dark: #212529;
      --gray: #6c757d;
      --border-radius: 16px;
      --shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
      --transition: all 0.3s ease;
    }

    #accessibility-widget-container * {
      box-sizing: border-box;
      margin: 0;
      padding: 0;
    }

    #accessibility-widget {
      position: fixed;
      bottom: 20px;
      left: 20px;
      z-index: 10000;
      font-family: 'Inter', sans-serif;
    }

    #accessibility-toggle {
      width: 70px;
      height: 70px;
      border-radius: 50%;
      background: linear-gradient(135deg, var(--primary), var(--secondary));
      border: none;
      color: white;
      cursor: pointer;
      display: flex;
      align-items: center;
      justify-content: center;
      box-shadow: var(--shadow);
      transition: var(--transition);
      font-size: 28px;
      position: relative;
      overflow: hidden;
      z-index: 10001;
    }

    #accessibility-toggle:hover {
      transform: scale(1.05);
      box-shadow: 0 15px 35px rgba(67, 97, 238, 0.3);
    }

    #accessibility-toggle::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: linear-gradient(135deg, rgba(255,255,255,0.2), transparent);
      border-radius: 50%;
    }

    #accessibility-toggle .pulse {
      position: absolute;
      width: 100%;
      height: 100%;
      border-radius: 50%;
      background: rgba(255, 255, 255, 0.3);
      animation: pulse 2s infinite;
    }

    @keyframes pulse {
      0% {
        transform: scale(1);
        opacity: 0.7;
      }
      70% {
        transform: scale(1.5);
        opacity: 0;
      }
      100% {
        transform: scale(1.5);
        opacity: 0;
      }
    }

    #accessibility-panel {
      position: absolute;
      bottom: 85px;
      left: 0;
      width: 380px;
      background: white;
      border-radius: var(--border-radius);
      box-shadow: var(--shadow);
      padding: 24px;
      display: none;
      transition: var(--transition);
      max-height: 80vh;
      overflow-y: auto;
      z-index: 10000;
    }

    #accessibility-panel.active {
      display: block;
      animation: slideIn 0.3s ease;
    }

    @keyframes slideIn {
      from { opacity: 0; transform: translateY(10px); }
      to { opacity: 1; transform: translateY(0); }
    }

    .panel-header {
      display: flex;
      justify-content: space-between;
      align-items: center;
      margin-bottom: 20px;
      padding-bottom: 16px;
      border-bottom: 1px solid #e9ecef;
    }

    .panel-header h3 {
      font-size: 20px;
      font-weight: 700;
      color: var(--dark);
      display: flex;
      align-items: center;
      gap: 10px;
    }

    .panel-header h3 i {
      color: var(--primary);
    }

    .close-btn {
      background: none;
      border: none;
      font-size: 18px;
      cursor: pointer;
      color: var(--gray);
      transition: var(--transition);
      width: 36px;
      height: 36px;
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
    }

    .close-btn:hover {
      background: #f8f9fa;
      color: var(--dark);
    }

    .category {
      margin-bottom: 24px;
    }

    .category-title {
      font-size: 16px;
      font-weight: 600;
      margin-bottom: 12px;
      color: var(--dark);
      display: flex;
      align-items: center;
      gap: 8px;
    }

    .category-title i {
      color: var(--primary);
      width: 20px;
    }

    .controls-grid {
      display: grid;
      grid-template-columns: repeat(2, 1fr);
      gap: 12px;
    }

    .control-btn {
      display: flex;
      flex-direction: column;
      align-items: center;
      justify-content: center;
      padding: 16px 8px;
      background: var(--light);
      border: 1px solid #e9ecef;
      border-radius: 12px;
      cursor: pointer;
      transition: var(--transition);
      text-align: center;
    }

    .control-btn:hover {
      background: #e9ecef;
      transform: translateY(-2px);
      box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
    }

    .control-btn.active {
      background: var(--primary);
      color: white;
      border-color: var(--primary);
    }

    .control-btn i {
      font-size: 20px;
      margin-bottom: 8px;
    }

    .control-btn span {
      font-size: 13px;
      font-weight: 500;
    }

    .slider-container {
      display: flex;
      align-items: center;
      gap: 12px;
      margin-top: 8px;
    }

    .slider-container i {
      color: var(--gray);
      font-size: 16px;
    }

    .slider {
      flex: 1;
      -webkit-appearance: none;
      height: 6px;
      border-radius: 3px;
      background: #e9ecef;
      outline: none;
    }

    .slider::-webkit-slider-thumb {
      -webkit-appearance: none;
      width: 20px;
      height: 20px;
      border-radius: 50%;
      background: var(--primary);
      cursor: pointer;
      box-shadow: 0 2px 5px rgba(0,0,0,0.2);
    }

    .color-controls {
      display: flex;
      gap: 12px;
      margin-top: 8px;
    }

    .color-control {
      display: flex;
      flex-direction: column;
      align-items: center;
      gap: 6px;
      flex: 1;
    }

    .color-control label {
      font-size: 12px;
      color: var(--gray);
    }

    .color-input {
      width: 40px;
      height: 40px;
      border: none;
      border-radius: 8px;
      cursor: pointer;
      padding: 0;
      box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }

    .color-input::-webkit-color-swatch-wrapper {
      padding: 0;
    }

    .color-input::-webkit-color-swatch {
      border: none;
      border-radius: 8px;
    }

    .reset-btn {
      width: 100%;
      padding: 14px;
      background: linear-gradient(135deg, var(--primary), var(--secondary));
      color: white;
      border: none;
      border-radius: 12px;
      cursor: pointer;
      font-weight: 600;
      transition: var(--transition);
      margin-top: 16px;
      display: flex;
      align-items: center;
      justify-content: center;
      gap: 8px;
    }

    .reset-btn:hover {
      transform: translateY(-2px);
      box-shadow: 0 5px 15px rgba(67, 97, 238, 0.3);
    }

    /* Draggable styles */
    .draggable {
      cursor: move;
      user-select: none;
    }

    /* Accessibility states */
    .high-contrast {
      background-color: #000 !important;
      color: #fff !important;
    }

    .high-contrast * {
      background-color: #000 !important;
      color: #fff !important;
      border-color: #fff !important;
    }

    .grayscale {
      filter: grayscale(100%);
    }

    .big-cursor * {
      cursor: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 32 32"><circle cx="16" cy="16" r="14" fill="%23000" opacity="0.5"/></svg>'), auto !important;
    }

    .highlight-links a {
      outline: 3px solid #ffeb3b !important;
      background-color: rgba(255, 235, 59, 0.2) !important;
      padding: 2px 4px;
      border-radius: 4px;
    }

    .readable-font * {
      font-family: 'Comic Sans MS', cursive, sans-serif !important;
    }

    .dyslexia-font * {
      font-family: 'OpenDyslexic', sans-serif !important;
      letter-spacing: 0.1em !important;
      line-height: 1.8 !important;
    }

    .monochrome {
      filter: grayscale(100%) contrast(150%);
    }

    .dark-mode {
      background-color: #1a1a1a !important;
      color: #f0f0f0 !important;
    }

    .dark-mode * {
      background-color: #1a1a1a !important;
      color: #f0f0f0 !important;
      border-color: #444 !important;
    }

    .light-mode {
      background-color: #ffffff !important;
      color: #000000 !important;
    }

    .text-to-speech-active {
      position: relative;
    }

    .text-to-speech-active::after {
      content: '';
      position: absolute;
      bottom: -2px;
      left: 0;
      width: 100%;
      height: 2px;
      background-color: #4361ee;
      animation: reading 1s infinite;
    }

    @keyframes reading {
      0% { width: 0%; }
      100% { width: 100%; }
    }

    /* Focus styles for better accessibility */
    #accessibility-widget-container button:focus, 
    #accessibility-widget-container select:focus, 
    #accessibility-widget-container input:focus {
      outline: 2px solid var(--primary);
      outline-offset: 2px;
    }

    /* Mobile styles */
    @media (max-width: 768px) {
      #accessibility-widget {
        bottom: 15px;
        left: 15px;
      }

      #accessibility-toggle {
        width: 60px;
        height: 60px;
        font-size: 24px;
      }

      #accessibility-panel {
        position: fixed;
        bottom: 80px;
        left: 15px;
        width: calc(100vw - 30px);
        max-height: 70vh;
        border-radius: var(--border-radius);
      }

      .controls-grid {
        grid-template-columns: repeat(3, 1fr);
      }
    }
  </style>



  <!-- JavaScript for the Accessibility Widget -->

</div>

</body>
</html>