<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mountain Gate L.L.C - Client Enquiry Dashboard</title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    
    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    <!-- jsPDF -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
    <!-- jsPDF AutoTable -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf-autotable/3.5.28/jspdf.plugin.autotable.min.js"></script>
    <!-- SheetJS for Excel export -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>
    
    <style>
        :root {
            --notif-bg: #dff7df;
            --notif-text: #565656;
        }

        body {
            background: #f4f6f9;
            font-family: Inter, system-ui, -apple-system, Segoe UI, Roboto, "Helvetica Neue", Arial;
            user-select: none;
        }

        body.dark-mode {
            background: #1e1e1e;
            color: #eee;
        }

        .card-stats {
            text-align: center;
            padding: 16px;
            margin-bottom: 12px;
            border-radius: 10px;
            box-shadow: 0 2px 6px rgba(0,0,0,0.06);
        }

        .new-row {
            animation: highlight 2s ease;
        }

        @keyframes highlight {
            0% { background: #d4edda; }
            100% { background: transparent; }
        }

        .blinking-dot {
            height: 12px;
            width: 12px;
            border-radius: 50%;
            display: inline-block;
            margin-right: 6px;
            animation: blink 1s infinite;
        }

        @keyframes blink {
            0% { opacity: 1; }
            50% { opacity: 0; }
            100% { opacity: 1; }
        }

        .table-responsive {
            max-height: 52vh;
            overflow-y: auto;
        }

        .sticky-header thead th {
            position: sticky;
            top: 0;
            z-index: 2;
        }

        .toast-container {
            position: fixed;
            top: 1rem;
            right: 1rem;
            z-index: 9999;
        }

        .new-enquiry-notif {
            position: fixed;
            top: 1rem;
            right: 1rem;
            background: var(--notif-bg);
            color: var(--notif-text);
            border-radius: 10px;
            box-shadow: 0 6px 18px rgba(0,0,0,0.08);
            padding: 10px 14px;
            display: flex;
            gap: 10px;
            align-items: center;
            font-weight: 600;
            z-index: 11000;
            min-width: 150px;
            animation: slideIn 0.3s ease-out;
        }

        @keyframes slideIn {
            from { transform: translateX(100%); opacity: 0; }
            to { transform: translateX(0); opacity: 1; }
        }

        .new-enquiry-notif .dot {
            width: 10px;
            height: 10px;
            border-radius: 50%;
            background: #4bbf73;
            box-shadow: 0 0 0 6px rgba(75,191,115,0.08);
        }

        /* Navigation Tabs */
        .nav-tabs .nav-link {
            border: none;
            color: #6c757d;
            font-weight: 500;
            padding: 12px 20px;
        }

        .nav-tabs .nav-link.active {
            color: #0d6efd;
            border-bottom: 3px solid #0d6efd;
            background: transparent;
        }

        /* Chart Containers */
        .chart-container {
            background: white;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 20px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }

        .dark-mode .chart-container {
            background: #2d2d2d;
        }

        /* Controls */
        .controls .btn {
            margin: 4px 4px;
        }

        .controls .btn .btn-text {
            margin-left: 6px;
        }

        /* Mobile responsive */
        @media (max-width: 575.98px) {
            .controls .btn .btn-text {
                display: none !important;
            }

            .controls .btn {
                padding: 6px 8px;
                min-width: 42px;
            }

            .card-stats h6 {
                font-size: 0.85rem;
            }

            .card-stats h3 {
                font-size: 1.15rem;
                margin: 6px 0;
            }

            .table-responsive {
                max-height: 60vh;
            }

            table.table td, table.table th {
                padding: .45rem .45rem;
                font-size: .86rem;
            }

            .action-text {
                display: none;
            }

            .nav-tabs .nav-link {
                padding: 8px 12px;
                font-size: 0.9rem;
            }
        }

        @media (min-width: 576px) {
            .controls .btn {
                min-width: auto;
            }
        }

        .modal .form-label {
            font-weight: 600;
        }

        .company-header {
            text-align: center;
            margin-bottom: 20px;
            padding: 10px;
            border-bottom: 1px solid #dee2e6;
        }

        .company-logo {
            max-height: 60px;
            margin-right: 15px;
        }

        .dark-mode .company-header {
            border-bottom: 1px solid #444;
        }

        .language-switcher {
            position: absolute;
            top: 40px;
            right: 10px;
        }

        .filter-controls {
            background: #f8f9fa;
            padding: 10px;
            border-radius: 5px;
            margin-bottom: 15px;
        }

        .dark-mode .filter-controls {
            background: #2d2d2d;
        }

        .action-buttons {
            display: flex;
            gap: 5px;
            justify-content: center;
        }

        .action-buttons .btn {
            padding: 4px 8px;
        }

        .action-buttons .btn-text {
            display: none !important;
        }

        .rows-per-page {
            width: 100px;
            display: block;
            margin-left: 10px;
        }

        .phone-number {
            font-family: monospace;
            direction: ltr;
            display: block;
        }

        .message-content {
            max-width: 300px;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }

        .assign-agent-btn {
            background-color: #6f42c1;
            border-color: #6f42c1;
            color: white;
        }

        .assign-agent-btn:hover {
            background-color: #5a2d91;
            border-color: #5a2d91;
            color: white;
        }

        .copy-message-btn {
            background-color: #17a2b8;
            border-color: #17a2b8;
            color: white;
        }

        .copy-message-btn:hover {
            background-color: #138496;
            border-color: #138496;
            color: white;
        }

        /* Saved Contacts */
        .saved-contact-item {
            border: 1px solid #dee2e6;
            border-radius: 5px;
            padding: 10px;
            margin-bottom: 10px;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .saved-contact-item:hover {
            background-color: #f8f9fa;
            border-color: #0d6efd;
        }

        .dark-mode .saved-contact-item:hover {
            background-color: #2d2d2d;
        }

        /* Automation Rules */
        .automation-rule {
            background: #f8f9fa;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 15px;
            border-left: 4px solid #0d6efd;
        }

        .dark-mode .automation-rule {
            background: #2d2d2d;
        }

        /* Status badges */
        .status-badge-pending {
            background-color: #ffc107;
            color: #000;
        }

        .status-badge-assigned {
            background-color: #0dcaf0;
            color: #000;
        }

        .status-badge-completed {
            background-color: #198754;
            color: #fff;
        }

        /* Telegram Status */
        .telegram-status {
            display: inline-flex;
            align-items: center;
            gap: 5px;
            padding: 4px 8px;
            border-radius: 4px;
            font-size: 0.8rem;
            margin-left: 10px;
        }
        
        .telegram-connected {
            background-color: #d4edda;
            color: #155724;
        }
        
        .telegram-disconnected {
            background-color: #f8d7da;
            color: #721c24;
        }
    </style>
</head>
<body>
    <div class="container my-3">
        <!-- Company Header with Logo -->
        <div class="d-flex align-items-center justify-content-between company-header">
            <div class="d-flex align-items-center">
                <!-- Replace with your actual logo path -->
                <img src="data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNjAiIGhlaWdodD0iNjAiIHZpZXdCb3g9IjAgMCA2MCA2MCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3Qgd2lkdGg9IjYwIiBoZWlnaHQ9IjYwIiByeD0iOCIgZmlsbD0iIzBENkVGRCIvPgo8cGF0aCBkPSJNMTUgMjBMMzAgMzVMMzAgMTVMMTUgMjBaIiBmaWxsPSJ3aGl0ZSIvPgo8cGF0aCBkPSJNMzUgMTVMMzAgMjBINDVMMzUgMTVaIiBmaWxsPSJ3aGl0ZSIvPgo8cGF0aCBkPSJNNDUgMjBMMzAgMzVINDVMNDUgMjBaIiBmaWxsPSJ3aGl0ZSIvPgo8L3N2Zz4K" alt="Mountain Gate L.L.C" class="company-logo me-2">
                <h3 class="m-0">Mountain Gate L.L.C - Client Enquiry Dashboard</h3>
            </div>
            <div class="d-flex align-items-center">
                <span id="telegramStatus" class="telegram-status telegram-connected">
                    <i class="bi bi-check-circle-fill"></i> Telegram Connected
                </span>
                <a href="/public/report/auth/login" class="btn btn-outline-primary ms-2">Logout</a>
            </div>
        </div>
    </div>

    <!-- Language Switcher -->
    <div class="language-switcher">
        <select id="languageSelect" class="form-select form-select-sm">
            <option value="en">English</option>
            <option value="ar">العربية (Arabic)</option>
            <option value="hi">हिन्दी (Hindi)</option>
            <option value="tl">Tagalog</option>
            <option value="ur">اردو (Urdu)</option>
        </select>
    </div>

    <!-- Navigation Tabs -->
    <ul class="nav nav-tabs mb-4" id="dashboardTabs">
        <li class="nav-item">
            <a class="nav-link active" id="enquiries-tab" data-bs-toggle="tab" href="#enquiries">
                <i class="bi bi-list-ul me-1"></i>Enquiries
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link" id="reports-tab" data-bs-toggle="tab" href="#reports">
                <i class="bi bi-bar-chart me-1"></i>Advanced Reports
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link" id="bi-tab" data-bs-toggle="tab" href="#bi">
                <i class="bi bi-graph-up me-1"></i>Business Intelligence
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link" id="automation-tab" data-bs-toggle="tab" href="#automation">
                <i class="bi bi-robot me-1"></i>Workflow Automation
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link" id="telegram-tab" data-bs-toggle="tab" href="#telegram">
                <i class="bi bi-send me-1"></i>Telegram Settings
            </a>
        </li>
        
<li class="nav-item"> 
  <a class="nav-link" id="telegram-update-tab" data-bs-toggle="tab" href="#telegram-update">
    <i class="bi bi-arrow-repeat me-1"></i>Telegram Updates
  </a>
</li>

        
    </ul>

    <!-- Tab Content -->
    <div class="tab-content" id="dashboardTabsContent">
        
<!-- Telegram Updates Section -->
<div class="tab-pane fade" id="telegram-update" role="tabpanel" aria-labelledby="telegram-update-tab">
  <div class="container py-4">

    <div class="d-flex justify-content-between align-items-center mb-3">
      <h4 class="mb-0">Telegram Bot Updates</h4>
      <button id="refreshBtn" class="btn btn-sm btn-outline-warning">
        <i class="bi bi-arrow-clockwise"></i> Refresh
      </button>
    </div>

    <div class="mb-3">
      <input type="text" id="searchInput" class="form-control" placeholder="🔍 Search messages...">
    </div>

    <!-- Notification container -->
    <div id="notifContainer" style="position:fixed; top:10px; right:10px; z-index:9999;"></div>

    <!-- Updates Container -->
    <div id="telegramUpdates" class="row g-3"></div>

  </div>

  <script>
  (function() {
    const updatesContainer = document.getElementById("telegramUpdates");
    const searchInput = document.getElementById("searchInput");
    const notifContainer = document.getElementById("notifContainer");
    let lastUpdateId = 0;

    function showNotification(message, position='top-right') {
      const notif = document.createElement('div');
      notif.className = 'alert alert-warning py-1 px-3';
      notif.style.position = 'fixed';
      notif.style.zIndex = 9999;
      notif.style.transition = 'all 0.5s';
      notif.style.opacity = 0;
      if(position==='top-left'){
        notif.style.top = '10px'; notif.style.left = '10px';
      } else {
        notif.style.top = '10px'; notif.style.right = '10px';
      }
      notif.innerText = message;
      document.body.appendChild(notif);
      setTimeout(()=> notif.style.opacity = 1, 10);
      setTimeout(()=> { notif.style.opacity = 0; setTimeout(()=> notif.remove(),500)}, 3000);
    }

    function copyToClipboard(text){
      navigator.clipboard.writeText(text).then(()=>{
        showNotification("Successfully copied user ID", "top-left");
      });
    }

    function fetchTelegramUpdates() {
      const searchValue = searchInput.value.toLowerCase();
      updatesContainer.innerHTML = '<div class="col-12 text-center py-3"><div class="spinner-border text-warning"></div> Loading...</div>';

      fetch("https://api.telegram.org/bot8183339517:AAEPiFIMp7xIYjkHUZaRv-ICXV4DmLUxUpE/getUpdates")
      .then(res => res.json())
      .then(data => {
        updatesContainer.innerHTML = "";

        if(!data.result || data.result.length===0){
          updatesContainer.innerHTML = '<div class="col-12"><div class="alert alert-warning">No updates found.</div></div>';
          return;
        }

        // Reverse for latest first
        data.result.reverse().forEach(update => {
          let msg = update.message || {};
          let from = msg.from || {};
          let chat = msg.chat || {};
          let text = msg.text || "";
          let date = msg.date ? new Date(msg.date * 1000).toLocaleString() : "N/A";

          // Apply search filter
          if(searchValue && !text.toLowerCase().includes(searchValue) && !(from.first_name||"").toLowerCase().includes(searchValue)) return;

          const card = document.createElement('div');
          card.className = "col-12 col-sm-6 col-md-3";
          card.innerHTML = `
            <div class="card border-warning shadow-sm p-2 h-100 animate__animated animate__fadeIn" style="border-radius:10px;">
              <div class="d-flex align-items-center mb-2">
                <div class="rounded-circle bg-warning text-white fw-bold d-flex align-items-center justify-content-center me-2" style="width:35px; height:35px;">
                  ${from.first_name ? from.first_name.charAt(0).toUpperCase() : "?"}
                </div>
                <div>
                  <h6 class="mb-0">${from.first_name || 'Unknown'}</h6>
                  <small class="text-muted" style="cursor:pointer;" onclick="copyToClipboard('${from.id}')">User ID: ${from.id || '-'}</small>
                </div>
              </div>
              <p class="mb-1"><i class="bi bi-chat-text me-1 text-warning"></i><strong>Message:</strong> <span class="text-dark">${text}</span></p>
              <p class="mb-1"><i class="bi bi-clock me-1 text-warning"></i><strong>Date:</strong> ${date}</p>
              <p class="mb-1"><i class="bi bi-hash me-1 text-warning"></i><strong>Message ID:</strong> ${msg.message_id || 'N/A'}</p>
              <p class="mb-1"><i class="bi bi-upc-scan me-1 text-warning"></i><strong>Update ID:</strong> ${update.update_id}</p>
              <div class="mt-2">
                <span class="badge bg-${chat.type==='private'?'warning':'secondary'}">${chat.type}</span>
                <span class="badge bg-${from.is_bot?'danger':'success'}">${from.is_bot?'Bot':'Human'}</span>
              </div>
            </div>
          `;

          updatesContainer.prepend(card); // latest on top

          // Play notification if new message
          if(update.update_id > lastUpdateId){
            const audio = new Audio('/notification.mp3');
            audio.play().catch(()=>{});
          }

          if(update.update_id > lastUpdateId) lastUpdateId = update.update_id;
        });

        showNotification("Updates refreshed!");
      })
      .catch(err=>{
        updatesContainer.innerHTML = '<div class="col-12"><div class="alert alert-danger">❌ Error fetching updates: '+err+'</div></div>';
      });
    }

    document.addEventListener("DOMContentLoaded", fetchTelegramUpdates);
    document.getElementById("refreshBtn").addEventListener("click", fetchTelegramUpdates);
    searchInput.addEventListener("input", fetchTelegramUpdates);

    window.copyToClipboard = copyToClipboard; // make accessible inside inline onclick
  })();
  </script>
</div>
        
        <!-- Enquiries Tab -->
        <div class="tab-pane fade show active" id="enquiries">
            <div class="d-flex justify-content-between align-items-center mb-2">
                <h4 class="mb-0">📋 Client Enquiry Dashboard</h4>
                <div class="d-flex align-items-center gap-2">
                    <span class="blinking-dot" id="statusDot" style="background:#28a745;"></span>
                    <strong id="statusText" style="font-weight:600;">Database Connected / Live</strong>
                </div>
            </div>

            <!-- Controls -->
            <div class="mb-3 d-flex flex-wrap gap-1 controls">
                <button class="btn btn-sm btn-primary" id="manualRefresh" title="Refresh">
                    <i class="bi bi-arrow-clockwise"></i><span class="btn-text"> Refresh</span>
                </button>
                <button class="btn btn-sm btn-danger" id="generatePDF" title="Export PDF">
                    <i class="bi bi-file-earmark-pdf"></i><span class="btn-text"> Export PDF</span>
                </button>
                <button class="btn btn-sm btn-success" id="testTelegram" title="Test Telegram">
                    <i class="bi bi-send"></i><span class="btn-text"> Test Telegram</span>
                </button>
                <button class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#sendTelegramModal" title="Send Report">
                    <i class="bi bi-send"></i><span class="btn-text"> Send Report</span>
                </button>
                <button class="btn btn-sm btn-secondary" id="toggleMode" title="Toggle Dark/Light">
                    <i class="bi bi-moon"></i><span class="btn-text"> Dark/Light</span>
                </button>
                <button class="btn btn-sm btn-warning" id="autoAssignBtn" title="Auto Assign New Enquiries">
                    <i class="bi bi-robot"></i><span class="btn-text"> Auto-Assign</span>
                </button>
                <button class="btn btn-sm btn-outline-primary" data-bs-toggle="modal" data-bs-target="#savedContactsModal">
                    <i class="bi bi-journal-bookmark"></i><span class="btn-text"> Saved Contacts</span>
                </button>
            </div>

            <!-- Stats -->
            <div class="row mb-3 gx-2 gy-2">
                <div class="col-md-3 col-6">
                    <div class="card-stats bg-white">
                        <h6 class="mb-1">Total Enquiries</h6>
                        <h3 id="totalEnquiries">0</h3>
                    </div>
                </div>
                <div class="col-md-3 col-6">
                    <div class="card-stats bg-white">
                        <h6 class="mb-1">Enquiries Today</h6>
                        <h3 id="todayEnquiries">0</h3>
                    </div>
                </div>
                <div class="col-md-3 col-6">
                    <div class="card-stats bg-white">
                        <h6 class="mb-1">Unassigned</h6>
                        <h3 id="unassignedEnquiries">0</h3>
                    </div>
                </div>
                <div class="col-md-3 col-6">
                    <div class="card-stats bg-white">
                        <h6 class="mb-1">Conversion Rate</h6>
                        <h3 id="conversionRate">0%</h3>
                    </div>
                </div>
            </div>

            <!-- Filter Controls -->
            <div class="filter-controls">
                <div class="row g-2">
                    <div class="col-md-4">
                        <label for="nameFilter" class="form-label">Filter by Name</label>
                        <input type="text" class="form-control" id="nameFilter" placeholder="Enter name...">
                    </div>
                    <div class="col-md-4">
                        <label for="phoneFilter" class="form-label">Filter by Phone</label>
                        <input type="text" class="form-control" id="phoneFilter" placeholder="Enter phone...">
                    </div>
                    <div class="col-md-4">
                        <label for="dateFilter" class="form-label">Filter by Date</label>
                        <input type="date" class="form-control" id="dateFilter">
                    </div>
                </div>
            </div>

            <!-- Enquiries Table -->
            <div id="enquiriesContainer" class="card shadow-sm">
                <div class="card-body table-responsive p-2">
                    <table class="table table-hover align-middle sticky-header mb-2">
                        <thead class="table-dark">
                            <tr>
                                <th style="width:40px">#</th>
                                <th>Name</th>
                                <th>Phone</th>
                                <th>Message</th>
                                <th style="width:150px">Date & Time</th>
                                <th style="width:150px">Actions</th>
                            </tr>
                        </thead>
                        <tbody id="enquiriesBody">
                            <tr>
                                <td colspan="6">Loading...</td>
                            </tr>
                        </tbody>
                    </table>
                    <nav>
                        <ul class="pagination pagination-sm mb-0" id="pagination"></ul>
                    </nav>
                </div>
            </div>
        </div>

        <!-- Advanced Reports Tab -->
        <div class="tab-pane fade" id="reports">
            <div class="row mb-4">
                <div class="col-12">
                    <h4><i class="bi bi-bar-chart me-2"></i>Advanced Reporting</h4>
                    <p class="text-muted">Generate detailed reports and analytics</p>
                </div>
            </div>

            <div class="row mb-4">
                <div class="col-md-6">
                    <div class="chart-container">
                        <h5>Enquiries by Service Type</h5>
                        <canvas id="serviceChart" height="250"></canvas>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="chart-container">
                        <h5>Enquiries Timeline (Last 7 Days)</h5>
                        <canvas id="timelineChart" height="250"></canvas>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Report Generator</h5>
                        </div>
                        <div class="card-body">
                            <div class="row mb-3">
                                <div class="col-md-3">
                                    <label class="form-label">Report Type</label>
                                    <select class="form-select" id="reportType">
                                        <option value="summary">Summary Report</option>
                                        <option value="detailed">Detailed Report</option>
                                        <option value="performance">Performance Report</option>
                                    </select>
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label">From Date</label>
                                    <input type="date" class="form-control" id="reportFromDate">
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label">To Date</label>
                                    <input type="date" class="form-control" id="reportToDate">
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label">Export Format</label>
                                    <select class="form-select" id="exportFormat">
                                        <option value="pdf">PDF</option>
                                        <option value="excel">Excel</option>
                                        <option value="csv">CSV</option>
                                    </select>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-12">
                                    <button class="btn btn-primary me-2" id="generateAdvancedReport">
                                        <i class="bi bi-gear me-1"></i>Generate Report
                                    </button>
                                    <button class="btn btn-success" id="scheduleReport">
                                        <i class="bi bi-clock me-1"></i>Schedule Report
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Business Intelligence Tab -->
        <div class="tab-pane fade" id="bi">
            <div class="row mb-4">
                <div class="col-12">
                    <h4><i class="bi bi-graph-up me-2"></i>Business Intelligence Dashboard</h4>
                    <p class="text-muted">Performance metrics and business insights</p>
                </div>
            </div>

            <div class="row mb-4">
                <div class="col-md-3 col-6">
                    <div class="card-stats bg-white">
                        <h6 class="mb-1">Total Revenue</h6>
                        <h3 id="totalRevenue">$0</h3>
                    </div>
                </div>
                <div class="col-md-3 col-6">
                    <div class="card-stats bg-white">
                        <h6 class="mb-1">Avg. Response Time</h6>
                        <h3 id="avgResponseTime">0m</h3>
                    </div>
                </div>
                <div class="col-md-3 col-6">
                    <div class="card-stats bg-white">
                        <h6 class="mb-1">Client Satisfaction</h6>
                        <h3 id="clientSatisfaction">0%</h3>
                    </div>
                </div>
                <div class="col-md-3 col-6">
                    <div class="card-stats bg-white">
                        <h6 class="mb-1">Agent Performance</h6>
                        <h3 id="agentPerformance">0%</h3>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-8">
                    <div class="chart-container">
                        <h5>Revenue Trend</h5>
                        <canvas id="revenueChart" height="300"></canvas>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="chart-container">
                        <h5>Agent Performance</h5>
                        <canvas id="agentChart" height="300"></canvas>
                    </div>
                </div>
            </div>
        </div>

        <!-- Workflow Automation Tab -->
        <div class="tab-pane fade" id="automation">
            <div class="row mb-4">
                <div class="col-12">
                    <h4><i class="bi bi-robot me-2"></i>Workflow Automation</h4>
                    <p class="text-muted">Automate your enquiry management process</p>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Auto-Assignment Rules</h5>
                        </div>
                        <div class="card-body">
                            <div class="automation-rule">
                                <h6>Service-Based Assignment</h6>
                                <p class="text-muted mb-2">Automatically assign enquiries based on service type</p>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="serviceAssignment" checked>
                                    <label class="form-check-label" for="serviceAssignment">Enable</label>
                                </div>
                            </div>

                            <div class="automation-rule">
                                <h6>Time-Based Assignment</h6>
                                <p class="text-muted mb-2">Assign based on agent availability and working hours</p>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="timeAssignment">
                                    <label class="form-check-label" for="timeAssignment">Enable</label>
                                </div>
                            </div>

                            <div class="automation-rule">
                                <h6>Load Balancing</h6>
                                <p class="text-muted mb-2">Distribute enquiries evenly among available agents</p>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="loadBalancing" checked>
                                    <label class="form-check-label" for="loadBalancing">Enable</label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Notification Settings</h5>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <label class="form-label">Telegram Notification Schedule</label>
                                <select class="form-select" id="notificationSchedule">
                                    <option value="instant">Instant (Immediate)</option>
                                    <option value="hourly">Hourly Summary</option>
                                    <option value="daily" selected>Daily Summary (9:00 AM)</option>
                                    <option value="weekly">Weekly Summary (Monday 9:00 AM)</option>
                                </select>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">SLA Tracking</label>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="slaTracking" checked>
                                    <label class="form-check-label" for="slaTracking">Enable SLA Alerts (24-hour response time)</label>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Follow-up Reminders</label>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="followupReminders" checked>
                                    <label class="form-check-label" for="followupReminders">Send follow-up reminders after 48 hours</label>
                                </div>
                            </div>

                            <button class="btn btn-primary w-100" id="saveAutomationSettings">
                                <i class="bi bi-save me-1"></i>Save Automation Settings
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Telegram Settings Tab -->
        <div class="tab-pane fade" id="telegram">
            <div class="row mb-4">
                <div class="col-12">
                    <h4><i class="bi bi-send me-2"></i>Telegram Integration Settings</h4>
                    <p class="text-muted">Configure Telegram bot settings and test integration</p>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Bot Configuration</h5>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <label class="form-label">Bot Token</label>
                                <div class="input-group">
                                    <input type="password" class="form-control" id="telegramBotToken" value="8183339517:AAEPiFIMp7xIYjkHUZaRv-ICXV4DmLUxUpE">
                                    <button class="btn btn-outline-secondary" type="button" id="toggleTokenVisibility">
                                        <i class="bi bi-eye"></i>
                                    </button>
                                </div>
                                <div class="form-text">Your bot token is securely stored in your browser</div>
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label">Default Chat ID</label>
                                <input type="text" class="form-control" id="defaultChatId" placeholder="Enter default chat ID for notifications">
                                <div class="form-text">This will be used for all automated notifications</div>
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label">Bot Username</label>
                                <input type="text" class="form-control" value="@mgtadbeerbot" readonly>
                            </div>
                            
                            <button class="btn btn-primary w-100" id="saveTelegramSettings">
                                <i class="bi bi-save me-1"></i>Save Telegram Settings
                            </button>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Test & Status</h5>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <h6>Connection Status</h6>
                                <div id="telegramTestResult" class="alert alert-info">
                                    <i class="bi bi-info-circle me-2"></i>Click "Test Connection" to check Telegram integration
                                </div>
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label">Test Message</label>
                                <textarea class="form-control" id="testMessage" rows="3" placeholder="Enter test message...">Hello from Mountain Gate L.L.C Dashboard! This is a test message.</textarea>
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label">Send to Chat ID</label>
                                <input type="text" class="form-control" id="testChatId" placeholder="Leave empty to use default chat ID">
                            </div>
                            
                            <div class="d-grid gap-2">
                                <button class="btn btn-success" id="testTelegramConnection">
                                    <i class="bi bi-plug me-1"></i>Test Connection
                                </button>
                                <button class="btn btn-warning" id="sendTestMessage">
                                    <i class="bi bi-send me-1"></i>Send Test Message
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Send Telegram Modal -->
<div class="modal fade" id="sendTelegramModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Send Report via Telegram</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label class="form-label">Select Contact</label>
                        <select class="form-select" id="telegramContact">
                            <option value="">-- Select Saved Contact --</option>
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Or Enter Chat ID</label>
                        <input id="telegramChatId" class="form-control" placeholder="Enter Telegram Chat ID..." />
                    </div>
                </div>
                
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label class="form-label">From Date</label>
                        <input type="date" class="form-control" id="reportFromDateModal">
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">To Date</label>
                        <input type="date" class="form-control" id="reportToDateModal">
                    </div>
                </div>
                
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label class="form-label">From Time</label>
                        <input type="time" class="form-control" id="reportFromTimeModal" value="00:00">
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">To Time</label>
                        <input type="time" class="form-control" id="reportToTimeModal" value="23:59">
                    </div>
                </div>
                
                <div class="mb-3">
                    <label class="form-label">Assign to Agent</label>
                    <select class="form-select" id="assignAgentSelect">
                        <option value="">-- Select Agent --</option>
                        <!-- Agents will be populated here -->
                    </select>
                </div>
                
                <div class="mb-3">
                    <label class="form-label">Custom Message (Optional)</label>
                    <textarea class="form-control" id="telegramCustomMessage" rows="3" placeholder="Add a custom message to include with the report..."></textarea>
                </div>
                
                <div class="alert alert-info">
                    <i class="bi bi-info-circle me-2"></i>
                    This will send a summary of all enquiries between the selected dates and times directly via Telegram.
                </div>
            </div>
            <div class="modal-footer">
                <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button class="btn btn-success" id="sendTelegramReportBtn">
                    <i class="bi bi-send me-1"></i>Send Report via Telegram
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Assign Agent Modal -->
<div class="modal fade" id="assignAgentModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Assign Enquiry to Agent</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label class="form-label">Select Agent</label>
                    <select class="form-select" id="assignAgentModalSelect">
                        <option value="">-- Select Agent --</option>
                        <!-- Agents will be populated here -->
                    </select>
                </div>
                <div class="mb-3">
                    <label class="form-label">Enquiry Details</label>
                    <textarea class="form-control" id="enquiryDetails" rows="4" readonly></textarea>
                </div>
                <div class="mb-3">
                    <label class="form-label">Additional Notes (Optional)</label>
                    <textarea class="form-control" id="customMessage" rows="3" placeholder="Add any additional instructions..."></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button class="btn btn-info copy-message-btn" id="copyMessageBtn">
                    <i class="bi bi-clipboard"></i> Copy Message
                </button>
                <button class="btn btn-success" id="sendToAgentBtn">
                    <i class="bi bi-send"></i> Send via Telegram
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Saved Contacts Modal -->
<div class="modal fade" id="savedContactsModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Saved Contacts</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#addContactModal">
                        <i class="bi bi-plus-circle me-1"></i>Add New Contact
                    </button>
                </div>
                <div id="savedContactsList">
                    <!-- Contacts will be loaded here -->
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add Contact Modal -->
<div class="modal fade" id="addContactModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Add New Contact</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="addContactForm">
                    <div class="mb-3">
                        <label class="form-label">Name *</label>
                        <input type="text" class="form-control" name="contactName" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Designation</label>
                        <input type="text" class="form-control" name="contactDesignation">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Phone Number *</label>
                        <input type="text" class="form-control" name="contactPhone" placeholder="+971________" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Telegram Chat ID (Optional)</label>
                        <input type="text" class="form-control" name="telegramChatId" placeholder="Enter Telegram Chat ID">
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" id="saveContactBtn">Save Contact</button>
            </div>
        </div>
    </div>
</div>

<!-- Toasts (Bootstrap) -->
<div class="toast-container"></div>

<!-- Custom "New Enquiry" notification will be injected here when needed -->
<div id="customNotifAnchor"></div>

<!-- Notification Sound -->
<audio id="notificationSound" preload="auto">
    <source src="data:audio/mpeg;base64,SUQzBAAAAAAAI1RTU0UAAAAPAAADTGF2ZjU4Ljc2LjEwMAAAAAAAAAAAAAAA//tQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAWGluZwAAAA8AAAABAAACcQCAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////8AAABQTEFNRTMuMTAwBKkAAAAAAAAAADUgJAOIIQAAgAAACfG7hYfOAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//tAxAADwAABpAAAACAAADSAAAAETEFNRTMuMTAwVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVU=" type="audio/mpeg">
</audio>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

<script>
    // Security features
    document.addEventListener('contextmenu', function(e) { e.preventDefault(); return false; });
    document.addEventListener('keydown', function(e) {
        if (e.key === 'F12' || (e.ctrlKey && e.shiftKey && e.key === 'I') || (e.ctrlKey && e.shiftKey && e.key === 'C') || (e.ctrlKey && e.key === 'U')) {
            e.preventDefault(); return false;
        }
    });
    document.addEventListener('dragstart', function(e) { if (e.target.tagName === 'IMG') { e.preventDefault(); return false; } });

    /* -------------------------
       Telegram Configuration
       ------------------------- */
    const telegramConfig = {
        botToken: "8183339517:AAEPiFIMp7xIYjkHUZaRv-ICXV4DmLUxUpE",
        botUsername: "@mgtadbeerbot",
        enabled: true,
        defaultChatId: null
    };

    // Load saved Telegram settings
    const savedTelegramSettings = JSON.parse(localStorage.getItem('telegramSettings') || '{}');
    if (savedTelegramSettings.defaultChatId) {
        telegramConfig.defaultChatId = savedTelegramSettings.defaultChatId;
        document.getElementById('defaultChatId').value = savedTelegramSettings.defaultChatId;
    }

    /* -------------------------
       Agents Configuration - 10 Agents
       ------------------------- */
    const agents = [
        { id: 1, name: "Ahmad Kamal", telegramId: "6008606105", department: "IT", phone: "+971501234567", active: true },
        { id: 2, name: "Maria Santos", telegramId: "987654321", department: "Customer Service", phone: "+971501234568", active: true },
        { id: 3, name: "John Smith", telegramId: "555666777", department: "Technical Support", phone: "+971501234569", active: true },
        { id: 4, name: "Fatima Hassan", telegramId: "444333222", department: "VIP Clients", phone: "+971501234570", active: true },
        { id: 5, name: "David Chen", telegramId: "111222333", department: "Property Consultation", phone: "+971501234571", active: true },
        { id: 6, name: "Sarah Johnson", telegramId: "777888999", department: "Investment Advice", phone: "+971501234572", active: true },
        { id: 7, name: "Mohammed Rahman", telegramId: "666555444", department: "Market Analysis", phone: "+971501234573", active: true },
        { id: 8, name: "Lisa Garcia", telegramId: "333222111", department: "Sales", phone: "+971501234574", active: true },
        { id: 9, name: "Omar Khalid", telegramId: "999888777", department: "Technical Support", phone: "+971501234575", active: true },
        { id: 10, name: "Emma Wilson", telegramId: "222333444", department: "Customer Service", phone: "+971501234576", active: true }
    ];

    let currentAgentIndex = 0;

    /* -------------------------
       Telegram API Functions
       ------------------------- */
    async function sendTelegramMessage(chatId, message) {
        if (!telegramConfig.botToken) {
            showBootstrapToast('Telegram bot token is not configured!', 'danger');
            return false;
        }
        
        // Ensure chatId is a string (Telegram API requirement)
        chatId = String(chatId);
        
        try {
            const response = await fetch(`https://api.telegram.org/bot${telegramConfig.botToken}/sendMessage`, {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({
                    chat_id: chatId,
                    text: message,
                    parse_mode: 'HTML'
                })
            });
            
            const result = await response.json();
            console.log('Telegram API Response:', result);
            
            if (result.ok) {
                showBootstrapToast('Message sent successfully!', 'success');
                return true;
            } else {
                let errorMessage = 'Failed to send message';
                if (result.description) {
                    errorMessage = result.description;
                }
                showBootstrapToast(`Telegram error: ${errorMessage}`, 'danger');
                return false;
            }
        } catch (error) {
            console.error('Telegram API error:', error);
            showBootstrapToast('Network error: Failed to send Telegram message', 'danger');
            return false;
        }
    }

    async function testTelegramConnection() {
        if (!telegramConfig.botToken) {
            return { success: false, message: 'Bot token not configured' };
        }
        
        try {
            const response = await fetch(`https://api.telegram.org/bot${telegramConfig.botToken}/getMe`);
            const result = await response.json();
            
            if (result.ok) {
                return { 
                    success: true, 
                    message: `Connected successfully! Bot: ${result.result.first_name} (@${result.result.username})` 
                };
            } else {
                return { 
                    success: false, 
                    message: `Connection failed: ${result.description}` 
                };
            }
        } catch (error) {
            return { 
                success: false, 
                message: `Connection error: ${error.message}` 
            };
        }
    }

    /* -------------------------
       Multilingual Support
       ------------------------- */
    const translations = {
        en: {
            dashboardTitle: "📋 Client Enquiry Dashboard",
            databaseStatus: "Database Connected / Live",
            refreshButton: " Refresh",
            exportPDFButton: " Export PDF",
            darkLightButton: " Dark/Light",
            autoAssignButton: " Auto-Assign",
            totalEnquiries: "Total Enquiries",
            todayEnquiries: "Enquiries Today",
            unassignedEnquiries: "Unassigned",
            tableId: "#",
            tableName: "Name",
            tablePhone: "Phone",
            tableMessage: "Message",
            loadingText: "Loading...",
            closeButton: "Close",
            noEnquiriesText: "No enquiries",
            errorLoadingText: "Error loading data",
            filterByName: "Filter by Name",
            filterByPhone: "Filter by Phone",
            filterByDate: "Filter by Date",
            rowsPerPage: "Rows per page",
            newEnquiry: "New Enquiry",
            assignAgentTitle: "Assign Enquiry to Agent",
            selectAgentLabel: "Select Agent", 
            enquiryDetailsLabel: "Enquiry Details",
            customMessageLabel: "Additional Notes (Optional)",
            sendToAgentButton: "Send via Telegram",
            copyMessageButton: "Copy Message"
        },
        ar: {
            dashboardTitle: "📋 لوحة تحكم استفسارات العملاء",
            databaseStatus: "قاعدة البيانات متصلة / مباشرة",
            refreshButton: " تحديث",
            exportPDFButton: " تصدير PDF",
            darkLightButton: " فاتح/داكن",
            autoAssignButton: " تعيين تلقائي",
            totalEnquiries: "إجمالي الاستفسارات",
            todayEnquiries: "استفسارات اليوم",
            unassignedEnquiries: "غير معين",
            tableId: "#",
            tableName: "الاسم",
            tablePhone: "الهاتف",
            tableMessage: "الرسالة",
            loadingText: "جاري التحميل...",
            closeButton: "إغلاق",
            noEnquiriesText: "لا توجد استفسارات",
            errorLoadingText: "خطأ في تحميل البيانات",
            filterByName: "تصفية حسب الاسم",
            filterByPhone: "تصفية حسب الهاتف",
            filterByDate: "تصفية حسب التاريخ",
            rowsPerPage: "صفوف في الصفحة",
            newEnquiry: "استفسار جديد",
            assignAgentTitle: "تعيين الاستفسار إلى الوكيل",
            selectAgentLabel: "اختر الوكيل", 
            enquiryDetailsLabel: "تفاصيل الاستفسار",
            customMessageLabel: "ملاحظات إضافية (اختياري)",
            sendToAgentButton: "إرسال عبر Telegram",
            copyMessageButton: "نسخ الرسالة"
        }
        // Other languages omitted for brevity
    };

    let currentLanguage = 'en';

    function setLanguage(lang) {
        currentLanguage = lang;
        document.querySelectorAll('[data-i18n]').forEach(element => {
            const key = element.getAttribute('data-i18n');
            if (translations[lang] && translations[lang][key]) {
                element.textContent = translations[lang][key];
            }
        });
        
        document.getElementById('languageSelect').value = lang;
        
        if (lang === 'ar') {
            document.documentElement.dir = 'rtl';
            document.body.classList.add('rtl');
        } else {
            document.documentElement.dir = 'ltr';
            document.body.classList.remove('rtl');
        }
    }

    // Initialize language on page load
    document.addEventListener('DOMContentLoaded', function() {
        const savedLanguage = localStorage.getItem('dashboardLanguage') || 'en';
        setLanguage(savedLanguage);
        
        document.getElementById('languageSelect').addEventListener('change', function(e) {
            const newLang = e.target.value;
            setLanguage(newLang);
            localStorage.setItem('dashboardLanguage', newLang);
        });
    });

    /* -------------------------
       State & initialization
       ------------------------- */
    let lastIds = [];
    let allEnquiries = [];
    let filteredEnquiries = [];
    let currentPage = 1, perPage = 30;
    let pageFocused = true;
    let initialized = false;

    let autoAssignEnabled = false;
    let assignedEnquiries = JSON.parse(localStorage.getItem('assignedEnquiries') || '{}');
    let currentEnquiry = null;

    // Saved contacts
    let savedContacts = JSON.parse(localStorage.getItem('savedContacts') || '[]');

    // Automation settings
    let automationSettings = JSON.parse(localStorage.getItem('automationSettings') || '{}');

    // Track visibility
    document.addEventListener('visibilitychange', () => { 
        pageFocused = document.visibilityState === 'visible'; 
    });

    /* Unlock audio on first user gesture */
    document.addEventListener('click', function unlockAudio(){
        const sound = document.getElementById('notificationSound');
        if(!sound) return;
        sound.play().then(() => { 
            sound.pause(); 
            sound.currentTime = 0; 
            document.removeEventListener('click', unlockAudio); 
        }).catch(() => {});
    });

    /* -------------------------
       UI Utilities
       ------------------------- */
    function showBootstrapToast(msg, type='success'){
        const id = 't' + Date.now();
        const html = `<div id="${id}" class="toast align-items-center text-bg-${type} border-0 mb-2" role="alert">
            <div class="d-flex">
                <div class="toast-body">${msg}</div>
                <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"></button>
            </div>
        </div>`;
        $('.toast-container').append(html);
        const t = new bootstrap.Toast(document.getElementById(id), { delay: 3000 });
        t.show();
        document.getElementById(id).addEventListener('hidden.bs.toast', () => { 
            $('#' + id).remove(); 
        });
    }

    function showNewEnquiryNotification(){
        const id = 'newEnq' + Date.now();
        const notif = document.createElement('div');
        notif.id = id;
        notif.className = 'new-enquiry-notif';
        notif.innerHTML = `<div class="dot" aria-hidden></div><div style="font-weight:700;color:var(--notif-text)">${translations[currentLanguage].newEnquiry || 'New Enquiry'}</div>`;
        document.body.appendChild(notif);
        setTimeout(() => { 
            notif.style.transition = 'opacity .25s'; 
            notif.style.opacity = '0'; 
            setTimeout(() => notif.remove(), 300); 
        }, 3000);
    }

    /* -------------------------
       Agent Management
       ------------------------- */
    function populateAgentSelects() {
        const assignSelect = $('#assignAgentSelect');
        const modalSelect = $('#assignAgentModalSelect');
        
        assignSelect.empty();
        modalSelect.empty();
        
        assignSelect.append('<option value="">-- Select Agent --</option>');
        modalSelect.append('<option value="">-- Select Agent --</option>');
        
        agents.forEach(agent => {
            if (agent.active) {
                assignSelect.append(`<option value="${agent.id}">${agent.name} - ${agent.department}</option>`);
                modalSelect.append(`<option value="${agent.id}">${agent.name} - ${agent.department}</option>`);
            }
        });
    }

    function getAgentById(agentId) {
        return agents.find(agent => agent.id == agentId);
    }

    function getNextAvailableAgent() {
        // Simple round-robin assignment
        const agent = agents[currentAgentIndex];
        currentAgentIndex = (currentAgentIndex + 1) % agents.length;
        return agent;
    }

    /* -------------------------
       Saved Contacts Management
       ------------------------- */
    function loadSavedContacts() {
        const contactsList = $('#savedContactsList');
        const telegramSelect = $('#telegramContact');
        
        contactsList.empty();
        telegramSelect.empty();
        telegramSelect.append('<option value="">-- Select Saved Contact --</option>');
        
        if (savedContacts.length === 0) {
            contactsList.html('<p class="text-muted text-center">No saved contacts yet.</p>');
            return;
        }
        
        savedContacts.forEach((contact, index) => {
            // Add to contacts list
            const contactHtml = `
                <div class="saved-contact-item" data-index="${index}">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <strong>${contact.name}</strong>
                            ${contact.designation ? `<span class="text-muted ms-2">- ${contact.designation}</span>` : ''}
                            <div class="phone-number">${contact.phone}</div>
                            ${contact.telegramChatId ? `<small class="text-info">Telegram: ${contact.telegramChatId}</small>` : ''}
                        </div>
                        <div>
                            <button class="btn btn-sm btn-outline-danger delete-contact" data-index="${index}">
                                <i class="bi bi-trash"></i>
                            </button>
                        </div>
                    </div>
                </div>
            `;
            contactsList.append(contactHtml);
            
            // Add to Telegram select
            telegramSelect.append(`<option value="${contact.telegramChatId || ''}" data-phone="${contact.phone}">${contact.name} - ${contact.phone}</option>`);
        });
    }

    function saveContact(contact) {
        savedContacts.push(contact);
        localStorage.setItem('savedContacts', JSON.stringify(savedContacts));
        loadSavedContacts();
        showBootstrapToast('Contact saved successfully!', 'success');
    }

    function deleteContact(index) {
        savedContacts.splice(index, 1);
        localStorage.setItem('savedContacts', JSON.stringify(savedContacts));
        loadSavedContacts();
        showBootstrapToast('Contact deleted!', 'warning');
    }

    /* -------------------------
       Chart Initialization
       ------------------------- */
    function initializeCharts() {
        // Service Type Chart
        const serviceCtx = document.getElementById('serviceChart').getContext('2d');
        new Chart(serviceCtx, {
            type: 'doughnut',
            data: {
                labels: ['Property Consultation', 'Investment Advice', 'Market Analysis', 'Other'],
                datasets: [{
                    data: [45, 30, 20, 5],
                    backgroundColor: ['#4e73df', '#1cc88a', '#36b9cc', '#f6c23e']
                }]
            },
            options: {
                responsive: true,
                plugins: {
                    legend: { position: 'bottom' }
                }
            }
        });

        // Timeline Chart
        const timelineCtx = document.getElementById('timelineChart').getContext('2d');
        new Chart(timelineCtx, {
            type: 'line',
            data: {
                labels: ['Day 1', 'Day 2', 'Day 3', 'Day 4', 'Day 5', 'Day 6', 'Day 7'],
                datasets: [{
                    label: 'Enquiries',
                    data: [12, 19, 8, 15, 12, 16, 11],
                    borderColor: '#4e73df',
                    backgroundColor: 'rgba(78, 115, 223, 0.1)',
                    tension: 0.4,
                    fill: true
                }]
            },
            options: {
                responsive: true,
                scales: {
                    y: { beginAtZero: true }
                }
            }
        });

        // Revenue Chart
        const revenueCtx = document.getElementById('revenueChart').getContext('2d');
        new Chart(revenueCtx, {
            type: 'bar',
            data: {
                labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun'],
                datasets: [{
                    label: 'Revenue ($)',
                    data: [12500, 19000, 15300, 17800, 19200, 21500],
                    backgroundColor: '#1cc88a'
                }]
            },
            options: {
                responsive: true,
                scales: {
                    y: { beginAtZero: true }
                }
            }
        });

        // Agent Performance Chart
        const agentCtx = document.getElementById('agentChart').getContext('2d');
        new Chart(agentCtx, {
            type: 'polarArea',
            data: {
                labels: agents.slice(0, 4).map(a => a.name),
                datasets: [{
                    data: [85, 78, 92, 88],
                    backgroundColor: ['#4e73df', '#1cc88a', '#36b9cc', '#f6c23e']
                }]
            },
            options: {
                responsive: true
            }
        });
    }

    /* -------------------------
       Enhanced PDF Generation with Header - FIXED
       ------------------------- */
    function generatePDF(data, filename) {
        const { jsPDF } = window.jspdf;
        const doc = new jsPDF();
        
        // Add header with logo and company name
        doc.setFontSize(20);
        doc.setTextColor(40, 40, 40);
        doc.text('Mountain Gate L.L.C', 105, 20, { align: 'center' });
        doc.setFontSize(16);
        doc.setTextColor(100, 100, 100);
        doc.text('Enquiry Report', 105, 30, { align: 'center' });
        
        // Add date
        doc.setFontSize(10);
        doc.setTextColor(150, 150, 150);
        doc.text(`Generated on: ${new Date().toLocaleDateString()}`, 105, 38, { align: 'center' });
        
        // Add table
        const rows = data.map((r,i) => [
            i+1, 
            r.name || '', 
            r.phone || '', 
            (r.requirement || '').substring(0, 50) + (r.requirement && r.requirement.length > 50 ? '...' : ''),
            new Date(r.created_at).toLocaleString()
        ]);
        
        doc.autoTable({
            startY: 45,
            head: [['#', 'Name', 'Phone', 'Message', 'Date']],
            body: rows,
            styles: { fontSize: 8 },
            headStyles: { fillColor: [78, 115, 223] }
        });
        
        doc.save(filename);
    }

    /* -------------------------
       Excel/CSV Export
       ------------------------- */
    function exportToExcel(data, filename) {
        const ws = XLSX.utils.json_to_sheet(data.map(item => ({
            'Name': item.name,
            'Phone': item.phone,
            'Message': item.requirement,
            'Date': new Date(item.created_at).toLocaleString()
        })));
        
        const wb = XLSX.utils.book_new();
        XLSX.utils.book_append_sheet(wb, ws, 'Enquiries');
        XLSX.writeFile(wb, `${filename}.xlsx`);
    }

    function exportToCSV(data, filename) {
        const headers = ['Name', 'Phone', 'Message', 'Date'];
        const csvData = data.map(item => [
            item.name,
            item.phone,
            item.requirement,
            new Date(item.created_at).toLocaleString()
        ]);
        
        const csvContent = [headers, ...csvData]
            .map(row => row.map(field => `"${field}"`).join(','))
            .join('\n');
        
        const blob = new Blob([csvContent], { type: 'text/csv' });
        const url = window.URL.createObjectURL(blob);
        const a = document.createElement('a');
        a.href = url;
        a.download = `${filename}.csv`;
        a.click();
        window.URL.revokeObjectURL(url);
    }

    /* -------------------------
       Database Integration
       ------------------------- */
    function fetchEnquiries(){
        $.ajax({
            url: 'fetch_enquiries.php',
            dataType: 'json',
            success: function(res){
                // res expected to be array of enquiry objects with at least: id, name, email, phone, requirement, created_at
                const ids = res.map(r => r.id);
                
                // Detect new ids by comparing with lastIds
                const newIds = ids.filter(id => !lastIds.includes(id));

                // Only trigger audio & notification if there are new enquiries AND we're initialized
                if(newIds.length > 0 && initialized){
                    // Play audio (reset time)
                    const sound = document.getElementById('notificationSound');
                    if(sound){
                        try{
                            sound.currentTime = 0;
                            sound.play().catch(e => {
                                console.warn('Audio play blocked:',e);
                                // Fallback: Generate a simple beep using Web Audio API
                                playFallbackSound();
                            });
                        }catch(e){ 
                            console.warn('Audio error', e);
                            playFallbackSound();
                        }
                    }
                    
                    // Show custom compact notification
                    showNewEnquiryNotification();
                    
                    // Show toast notification
                    showBootstrapToast(`${newIds.length} new enquiry(s) received`, 'success');
                    
                    // Auto-assign if enabled
                    if (autoAssignEnabled && newIds.length > 0) {
                        autoAssignNewEnquiries(res.filter(r => newIds.includes(r.id)));
                    }
                }

                allEnquiries = res;
                applyFilters();
                renderStats();
                renderTable();

                // Update lastIds to current state to prevent repeated notifications
                lastIds = ids;
                
                // Mark as initialized after first successful fetch
                if(!initialized) initialized = true;
            },
            error: function(){
                $('#enquiriesBody').html('<tr><td colspan="6">' + (translations[currentLanguage].errorLoadingText || 'Error loading data') + '</td></tr>');
                showBootstrapToast(translations[currentLanguage].errorLoadingText || 'Unable to load enquiries', 'danger');
            }
        });
    }

    // Fallback sound using Web Audio API
    function playFallbackSound() {
        try {
            const audioContext = new (window.AudioContext || window.webkitAudioContext)();
            const oscillator = audioContext.createOscillator();
            const gainNode = audioContext.createGain();
            
            oscillator.connect(gainNode);
            gainNode.connect(audioContext.destination);
            
            oscillator.frequency.value = 800;
            oscillator.type = 'sine';
            
            gainNode.gain.setValueAtTime(0.3, audioContext.currentTime);
            gainNode.gain.exponentialRampToValueAtTime(0.01, audioContext.currentTime + 0.5);
            
            oscillator.start(audioContext.currentTime);
            oscillator.stop(audioContext.currentTime + 0.5);
        } catch (e) {
            console.warn('Web Audio API not supported');
        }
    }

    /* Apply filters to enquiries */
    function applyFilters() {
        const nameFilter = document.getElementById('nameFilter').value.toLowerCase();
        const phoneFilter = document.getElementById('phoneFilter').value.toLowerCase();
        const dateFilter = document.getElementById('dateFilter').value;
        
        filteredEnquiries = allEnquiries.filter(enquiry => {
            // Filter by name
            if (nameFilter && !enquiry.name.toLowerCase().includes(nameFilter)) {
                return false;
            }
            
            // Filter by phone
            if (phoneFilter && !enquiry.phone.toLowerCase().includes(phoneFilter)) {
                return false;
            }
            
            // Filter by date
            if (dateFilter) {
                const enquiryDate = new Date(enquiry.created_at).toISOString().split('T')[0];
                if (enquiryDate !== dateFilter) {
                    return false;
                }
            }
            
            return true;
        });
        
        // Reset to first page after filtering
        currentPage = 1;
    }

    /* Stats */
    function renderStats(){
        $('#totalEnquiries').text(allEnquiries.length);
        let today = 0; 
        let unassigned = 0;
        const now = new Date().toDateString();
        
        allEnquiries.forEach(e => { 
            if(new Date(e.created_at).toDateString() === now) today++; 
            if(!assignedEnquiries[e.id]) unassigned++;
        });
        
        $('#todayEnquiries').text(today);
        $('#unassignedEnquiries').text(unassigned);
        
        // Calculate conversion rate (example)
        const completed = allEnquiries.filter(e => e.status === 'Completed').length;
        const conversionRate = allEnquiries.length > 0 ? Math.round((completed / allEnquiries.length) * 100) : 0;
        $('#conversionRate').text(conversionRate + '%');
        
        // Update BI metrics
        $('#totalRevenue').text('$' + (allEnquiries.length * 250).toLocaleString());
        $('#avgResponseTime').text('15m');
        $('#clientSatisfaction').text('92%');
        $('#agentPerformance').text('88%');
    }

    /* Table rendering with new columns: #, Name, Phone, Message, Actions */
    function renderTable(){
        const start = (currentPage - 1) * perPage;
        const paginated = filteredEnquiries.slice(start, start + perPage);
        let html = '';
        
        if(paginated.length){
            paginated.forEach((row, i) => {
                const isNew = !lastIds.includes(row.id) ? 'new-row' : '';
                const index = start + i + 1;
                
                html += `<tr class="${isNew}">
                    <td>${index}</td>
                    <td>${escapeHtml(row.name || '')}</td>
                    <td><span class="phone-number">${escapeHtml(row.phone || '')}</span></td>
                    <td><span class="message-content" title="${escapeHtml(row.requirement || '')}">${escapeHtml(row.requirement || '')}</span></td>
                    <td>${new Date(row.created_at).toLocaleString()}</td>
                    <td>
                        <div class="action-buttons">
                            <button class="btn btn-sm btn-outline-info copy-message-btn" title="Copy Message" data-message="${escapeHtml(row.requirement || '')}">
                                <i class="bi bi-clipboard"></i>
                            </button>
                            <button class="btn btn-sm btn-outline-warning send-telegram-btn" title="Send via Telegram" data-enquiry-id="${row.id}">
                                <i class="bi bi-send"></i>
                            </button>
                            <button class="btn btn-sm btn-outline-success mark-complete-btn" title="Mark Complete" data-enquiry-id="${row.id}">
                                <i class="bi bi-check"></i>
                            </button>
                            <button class="btn btn-sm assign-agent-btn" title="Assign to Agent" data-enquiry-id="${row.id}">
                                <i class="bi bi-person-plus"></i>
                            </button>
                        </div>
                    </td>
                </tr>`;
            });
        } else {
            html = `<tr><td colspan="6">${translations[currentLanguage].noEnquiriesText || 'No enquiries'}</td></tr>`;
        }
        $('#enquiriesBody').html(html);
        renderPagination();
    }

    /* Pagination */
    function renderPagination(){
        const total = Math.max(1, Math.ceil(filteredEnquiries.length / perPage));
        let html = '';
        for(let i = 1; i <= total; i++){
            html += `<li class="page-item ${i === currentPage ? 'active' : ''}"><a class="page-link" href="#">${i}</a></li>`;
        }
        $('#pagination').html(html);
        $('#pagination .page-link').click(function(e){ e.preventDefault(); currentPage = parseInt($(this).text()); renderTable(); });
    }

    /* -------------------------
       Auto-assignment
       ------------------------- */
    function autoAssignNewEnquiries(newEnquiries) {
        newEnquiries.forEach(enquiry => {
            if (!assignedEnquiries[enquiry.id]) {
                const agent = getNextAvailableAgent(enquiry);
                if (agent) {
                    assignedEnquiries[enquiry.id] = agent.name;
                    localStorage.setItem('assignedEnquiries', JSON.stringify(assignedEnquiries));
                    
                    // Send Telegram notification
                    const message = formatTelegramMessage(enquiry, agent);
                    if (telegramConfig.defaultChatId) {
                        sendTelegramMessage(telegramConfig.defaultChatId, message);
                    }
                    
                    showBootstrapToast(`Auto-assigned to ${agent.name}`, 'info');
                }
            }
        });
    }

    function formatTelegramMessage(enquiry, agent) {
        return `🚀 *New Client Enquiry Assigned*\n\n` +
            `👤 *Name:* ${enquiry.name || 'N/A'}\n` +
            `📞 *Phone:* ${enquiry.phone || 'N/A'}\n` +
            `📋 *Message:* ${enquiry.requirement || 'N/A'}\n` +
            `📅 *Received:* ${new Date(enquiry.created_at).toLocaleString()}\n` +
            `👨‍💼 *Assigned To:* ${agent.name} (${agent.department})\n` +
            `📞 *Agent Contact:* ${agent.phone}\n\n` +
            `💡 *Please follow up within 10 Minutes*`;
    }

    /* -------------------------
       Event Handlers
       ------------------------- */
    $(document).ready(function() {
        // Initialize
        populateAgentSelects();
        loadSavedContacts();
        initializeCharts();
        
        // Test Telegram connection on load
        testTelegramConnection().then(result => {
            const statusElement = document.getElementById('telegramStatus');
            const testResultElement = document.getElementById('telegramTestResult');
            
            if (result.success) {
                statusElement.className = 'telegram-status telegram-connected';
                statusElement.innerHTML = '<i class="bi bi-check-circle-fill"></i> Telegram Connected';
                testResultElement.className = 'alert alert-success';
                testResultElement.innerHTML = `<i class="bi bi-check-circle me-2"></i>${result.message}`;
            } else {
                statusElement.className = 'telegram-status telegram-disconnected';
                statusElement.innerHTML = '<i class="bi bi-x-circle-fill"></i> Telegram Error';
                testResultElement.className = 'alert alert-danger';
                testResultElement.innerHTML = `<i class="bi bi-exclamation-triangle me-2"></i>${result.message}`;
            }
        });

        // Basic events
        $('#manualRefresh').click(fetchEnquiries);
        $('#testTelegram').click(() => {
            $('#telegram-tab').click();
        });
        $('#toggleMode').click(() => $('body').toggleClass('dark-mode'));

        // PDF Export - FIXED
        $('#generatePDF').click(() => {
            const filename = `enquiry-report_${new Date().toISOString().slice(0,10)}.pdf`;
            generatePDF(allEnquiries, filename);
            showBootstrapToast('PDF generated with company header!', 'success');
        });

        // Telegram send report with date range
        $('#sendTelegramReportBtn').click(async () => {
            const chatId = $('#telegramChatId').val().trim() || $('#telegramContact').val();
            const fromDate = $('#reportFromDateModal').val();
            const toDate = $('#reportToDateModal').val();
            const fromTime = $('#reportFromTimeModal').val();
            const toTime = $('#reportToTimeModal').val();
            const agentId = $('#assignAgentSelect').val();
            const customMessage = $('#telegramCustomMessage').val().trim();
            
            if(!chatId){ 
                showBootstrapToast('Please select a contact or enter Chat ID', 'warning');
                return; 
            }
            if(!fromDate || !toDate){ 
                showBootstrapToast('Please select date range', 'warning');
                return; 
            }
            
            // Filter enquiries by date and time range
            const fromDateTime = new Date(`${fromDate}T${fromTime}`);
            const toDateTime = new Date(`${toDate}T${toTime}`);
            
            const filtered = allEnquiries.filter(e => {
                const enquiryDate = new Date(e.created_at);
                return enquiryDate >= fromDateTime && enquiryDate <= toDateTime;
            });
            
            if (filtered.length === 0) {
                showBootstrapToast('No enquiries found in the selected date range', 'warning');
                return;
            }
            
            let agentInfo = '';
            if (agentId) {
                const agent = getAgentById(agentId);
                if (agent) {
                    agentInfo = `\n👨‍💼 *Assigned Agent:* ${agent.name} (${agent.department})\n📞 *Agent Contact:* ${agent.phone}\n`;
                }
            }
            
            const message = `📊 *Enquiry Report*\n\n` +
                `📅 *Period:* ${fromDate} ${fromTime} to ${toDate} ${toTime}\n` +
                `📋 *Total Enquiries:* ${filtered.length}\n` +
                agentInfo +
                `\n*Recent Enquiries:*\n\n` +
                filtered.slice(0, 5).map((e, i) => 
                    `${i+1}. *${e.name}* - ${e.phone}\n   ${e.requirement?.substring(0, 50)}${e.requirement && e.requirement.length > 50 ? '...' : ''}`
                ).join('\n\n') +
                (filtered.length > 5 ? `\n\n... and ${filtered.length - 5} more enquiries` : '') +
                (customMessage ? `\n\n*Additional Notes:*\n${customMessage}` : '');
            
            await sendTelegramMessage(chatId, message);
        });

        // Send Telegram message for specific enquiry
        $(document).on('click', '.send-telegram-btn', async function() {
            const enquiryId = $(this).data('enquiry-id');
            const enquiry = allEnquiries.find(e => e.id == enquiryId);
            
            if (!enquiry) return;
            
            if (!telegramConfig.defaultChatId) {
                showBootstrapToast('Please set a default Chat ID in Telegram Settings first', 'warning');
                $('#telegram-tab').click();
                return;
            }
            
            const agent = getNextAvailableAgent();
            const message = `📋 *New Enquiry Notification*\n\n` +
                `👤 *Name:* ${enquiry.name}\n` +
                `📞 *Phone:* ${enquiry.phone}\n` +
                `📋 *Message:* ${enquiry.requirement}\n` +
                `📅 *Received:* ${new Date(enquiry.created_at).toLocaleString()}\n` +
                `👨‍💼 *Assigned To:* ${agent.name} (${agent.department})\n` +
                `📞 *Agent Contact:* ${agent.phone}\n\n` +
                `🚀 *Please follow up promptly*`;
            
            await sendTelegramMessage(telegramConfig.defaultChatId, message);
        });

        // Assign agent modal
        $(document).on('click', '.assign-agent-btn', function() {
            const enquiryId = $(this).data('enquiry-id');
            currentEnquiry = allEnquiries.find(e => e.id == enquiryId);
            
            if (currentEnquiry) {
                $('#enquiryDetails').val(
                    `New Enquiry Received:\n\n` +
                    `Name: ${currentEnquiry.name}\n` +
                    `Phone: ${currentEnquiry.phone}\n` +
                    `Message: ${currentEnquiry.requirement}\n` +
                    `Date: ${new Date(currentEnquiry.created_at).toLocaleString()}`
                );
                $('#customMessage').val('');
                $('#assignAgentModalSelect').val('');
                
                const modal = new bootstrap.Modal(document.getElementById('assignAgentModal'));
                modal.show();
            }
        });

        // Copy message in assign agent modal
        $('#copyMessageBtn').click(function() {
            const agentId = $('#assignAgentModalSelect').val();
            const customMessage = $('#customMessage').val().trim();
            
            if (!agentId) {
                showBootstrapToast('Please select an agent first', 'warning');
                return;
            }
            
            if (!currentEnquiry) return;
            
            const agent = getAgentById(agentId);
            const formattedMessage = formatTelegramMessage(currentEnquiry, agent) +
                (customMessage ? `\n\n*Additional Notes:* ${customMessage}` : '');
            
            // Copy to clipboard
            navigator.clipboard.writeText(formattedMessage).then(() => {
                showBootstrapToast('Message copied to clipboard!', 'success');
            }).catch(() => {
                // Fallback for older browsers
                const textArea = document.createElement('textarea');
                textArea.value = formattedMessage;
                document.body.appendChild(textArea);
                textArea.select();
                document.execCommand('copy');
                document.body.removeChild(textArea);
                showBootstrapToast('Message copied to clipboard!', 'success');
            });
        });

        // Send to agent in assign agent modal
        $('#sendToAgentBtn').click(async function() {
            const agentId = $('#assignAgentModalSelect').val();
            const customMessage = $('#customMessage').val().trim();
            
            if (!agentId) {
                showBootstrapToast('Please select an agent', 'warning');
                return;
            }
            
            if (!currentEnquiry) return;
            
            const agent = getAgentById(agentId);
            const message = formatTelegramMessage(currentEnquiry, agent) +
                (customMessage ? `\n\n*Additional Notes:* ${customMessage}` : '');
            
            // Save assignment
            assignedEnquiries[currentEnquiry.id] = agent.name;
            localStorage.setItem('assignedEnquiries', JSON.stringify(assignedEnquiries));
            
            // Send via Telegram
            const success = await sendTelegramMessage(agent.telegramId, message);
            if (success) {
                // Close modal
                const modalEl = document.getElementById('assignAgentModal');
                const bsModal = bootstrap.Modal.getInstance(modalEl);
                if (bsModal) bsModal.hide();
                
                showBootstrapToast(`Enquiry assigned to ${agent.name}`, 'success');
                renderStats();
                renderTable();
            }
        });

        // Test Telegram connection
        $('#testTelegramConnection').click(async () => {
            const result = await testTelegramConnection();
            const testResultElement = document.getElementById('telegramTestResult');
            const statusElement = document.getElementById('telegramStatus');
            
            if (result.success) {
                testResultElement.className = 'alert alert-success';
                testResultElement.innerHTML = `<i class="bi bi-check-circle me-2"></i>${result.message}`;
                statusElement.className = 'telegram-status telegram-connected';
                statusElement.innerHTML = '<i class="bi bi-check-circle-fill"></i> Telegram Connected';
            } else {
                testResultElement.className = 'alert alert-danger';
                testResultElement.innerHTML = `<i class="bi bi-exclamation-triangle me-2"></i>${result.message}`;
                statusElement.className = 'telegram-status telegram-disconnected';
                statusElement.innerHTML = '<i class="bi bi-x-circle-fill"></i> Telegram Error';
            }
        });

        // Send test message
        $('#sendTestMessage').click(async () => {
            const chatId = $('#testChatId').val().trim() || telegramConfig.defaultChatId;
            const message = $('#testMessage').val().trim();
            
            if (!chatId) {
                showBootstrapToast('Please enter a Chat ID or set a default Chat ID', 'warning');
                return;
            }
            
            if (!message) {
                showBootstrapToast('Please enter a test message', 'warning');
                return;
            }
            
            await sendTelegramMessage(chatId, message);
        });

        // Save Telegram settings
        $('#saveTelegramSettings').click(() => {
            const defaultChatId = $('#defaultChatId').val().trim();
            
            if (defaultChatId) {
                telegramConfig.defaultChatId = defaultChatId;
                localStorage.setItem('telegramSettings', JSON.stringify({
                    defaultChatId: defaultChatId
                }));
                showBootstrapToast('Telegram settings saved!', 'success');
            } else {
                showBootstrapToast('Please enter a default Chat ID', 'warning');
            }
        });

        // Toggle token visibility
        $('#toggleTokenVisibility').click(function() {
            const tokenInput = $('#telegramBotToken');
            const icon = $(this).find('i');
            
            if (tokenInput.attr('type') === 'password') {
                tokenInput.attr('type', 'text');
                icon.removeClass('bi-eye').addClass('bi-eye-slash');
            } else {
                tokenInput.attr('type', 'password');
                icon.removeClass('bi-eye-slash').addClass('bi-eye');
            }
        });

        // Filters
        $('#nameFilter, #phoneFilter, #dateFilter').on('input change', function() {
            applyFilters();
            renderTable();
        });

        $('#rowsPerPage').change(function() {
            perPage = parseInt($(this).val());
            currentPage = 1;
            renderTable();
        });

        // Copy message functionality
        $(document).on('click', '.copy-message-btn', function() {
            const message = $(this).data('message');
            navigator.clipboard.writeText(message).then(() => {
                showBootstrapToast('Message copied to clipboard!', 'success');
            }).catch(() => {
                const textArea = document.createElement('textarea');
                textArea.value = message;
                document.body.appendChild(textArea);
                textArea.select();
                document.execCommand('copy');
                document.body.removeChild(textArea);
                showBootstrapToast('Message copied to clipboard!', 'success');
            });
        });

        // Mark as complete
        $(document).on('click', '.mark-complete-btn', function() {
            const enquiryId = $(this).data('enquiry-id');
            const enquiry = allEnquiries.find(e => e.id == enquiryId);
            
            if (enquiry) {
                enquiry.status = 'Completed';
                renderTable();
                renderStats();
                showBootstrapToast('Enquiry marked as completed!', 'success');
            }
        });

        // Save contact
        $('#saveContactBtn').click(function() {
            const form = document.getElementById('addContactForm');
            if (!form.checkValidity()) {
                form.reportValidity();
                return;
            }
            
            const contact = {
                name: $('input[name="contactName"]').val(),
                designation: $('input[name="contactDesignation"]').val(),
                phone: $('input[name="contactPhone"]').val(),
                telegramChatId: $('input[name="telegramChatId"]').val()
            };
            
            saveContact(contact);
            const modal = bootstrap.Modal.getInstance(document.getElementById('addContactModal'));
            modal.hide();
            form.reset();
        });

        // Delete contact
        $(document).on('click', '.delete-contact', function(e) {
            e.stopPropagation();
            const index = $(this).data('index');
            if (confirm('Are you sure you want to delete this contact?')) {
                deleteContact(index);
            }
        });

        // Select contact
        $(document).on('click', '.saved-contact-item', function() {
            const index = $(this).data('index');
            const contact = savedContacts[index];
            $('#telegramChatId').val(contact.telegramChatId || '');
            const modal = bootstrap.Modal.getInstance(document.getElementById('savedContactsModal'));
            modal.hide();
        });

        // Auto-assign toggle
        $('#autoAssignBtn').click(function() {
            autoAssignEnabled = !autoAssignEnabled;
            if (autoAssignEnabled) {
                $(this).removeClass('btn-warning').addClass('btn-success');
                showBootstrapToast('Auto-assign enabled. New enquiries will be automatically assigned.', 'success');
            } else {
                $(this).removeClass('btn-success').addClass('btn-warning');
                showBootstrapToast('Auto-assign disabled.', 'warning');
            }
        });

        // Advanced reporting
        $('#generateAdvancedReport').click(function() {
            const reportType = $('#reportType').val();
            const fromDate = $('#reportFromDate').val();
            const toDate = $('#reportToDate').val();
            const format = $('#exportFormat').val();
            
            if (!fromDate || !toDate) {
                alert('Please select date range');
                return;
            }
            
            const filtered = allEnquiries.filter(e => {
                const d = new Date(e.created_at);
                return d >= new Date(fromDate) && d <= new Date(toDate + 'T23:59:59');
            });
            
            const filename = `advanced-report_${fromDate}_to_${toDate}`;
            
            switch(format) {
                case 'pdf':
                    generatePDF(filtered, filename);
                    break;
                case 'excel':
                    exportToExcel(filtered, filename);
                    break;
                case 'csv':
                    exportToCSV(filtered, filename);
                    break;
            }
            
            showBootstrapToast(`Advanced ${format.toUpperCase()} report generated!`, 'success');
        });

        // Schedule report
        $('#scheduleReport').click(function() {
            showBootstrapToast('Report scheduling feature will be implemented in the next version!', 'info');
        });

        // Save automation settings
        $('#saveAutomationSettings').click(function() {
            automationSettings = {
                serviceAssignment: $('#serviceAssignment').is(':checked'),
                timeAssignment: $('#timeAssignment').is(':checked'),
                loadBalancing: $('#loadBalancing').is(':checked'),
                notificationSchedule: $('#notificationSchedule').val(),
                slaTracking: $('#slaTracking').is(':checked'),
                followupReminders: $('#followupReminders').is(':checked')
            };
            
            localStorage.setItem('automationSettings', JSON.stringify(automationSettings));
            showBootstrapToast('Automation settings saved!', 'success');
        });

        // Load saved settings
        if (Object.keys(automationSettings).length > 0) {
            $('#serviceAssignment').prop('checked', automationSettings.serviceAssignment);
            $('#timeAssignment').prop('checked', automationSettings.timeAssignment);
            $('#loadBalancing').prop('checked', automationSettings.loadBalancing);
            $('#notificationSchedule').val(automationSettings.notificationSchedule);
            $('#slaTracking').prop('checked', automationSettings.slaTracking);
            $('#followupReminders').prop('checked', automationSettings.followupReminders);
        }

        // Set default dates for report modals
        const today = new Date().toISOString().split('T')[0];
        const oneWeekAgo = new Date();
        oneWeekAgo.setDate(oneWeekAgo.getDate() - 7);
        const oneWeekAgoStr = oneWeekAgo.toISOString().split('T')[0];
        
        $('#reportFromDateModal').val(oneWeekAgoStr);
        $('#reportToDateModal').val(today);
        $('#reportFromDate').val(oneWeekAgoStr);
        $('#reportToDate').val(today);

        // Initial fetch
        fetchEnquiries();
        setInterval(fetchEnquiries, 10000);
    });

    function escapeHtml(text){
        if(!text && text !== 0) return '';
        return String(text).replace(/[&<>"'`=\/]/g, function(s) {
            return ({'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#39;','/':'&#47;','=':'&#61;','`':'&#96;'})[s];
        });
    }
</script>
<!-- Enhanced Accessibility Widget - Paste this anywhere in your HTML -->
<div id="accessibility-widget-container">
  <!-- Accessibility Widget Styles -->
  <style>
    #accessibility-widget-container {
      --primary: #4361ee;
      --primary-dark: #3a56d4;
      --secondary: #7209b7;
      --success: #4cc9f0;
      --light: #f8f9fa;
      --dark: #212529;
      --gray: #6c757d;
      --border-radius: 16px;
      --shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
      --transition: all 0.3s ease;
    }

    #accessibility-widget-container * {
      box-sizing: border-box;
      margin: 0;
      padding: 0;
    }

    #accessibility-widget {
      position: fixed;
      bottom: 20px;
      left: 20px;
      z-index: 10000;
      font-family: 'Inter', sans-serif;
    }

    #accessibility-toggle {
      width: 70px;
      height: 70px;
      border-radius: 50%;
      background: linear-gradient(135deg, var(--primary), var(--secondary));
      border: none;
      color: white;
      cursor: pointer;
      display: flex;
      align-items: center;
      justify-content: center;
      box-shadow: var(--shadow);
      transition: var(--transition);
      font-size: 28px;
      position: relative;
      overflow: hidden;
      z-index: 10001;
    }

    #accessibility-toggle:hover {
      transform: scale(1.05);
      box-shadow: 0 15px 35px rgba(67, 97, 238, 0.3);
    }

    #accessibility-toggle::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: linear-gradient(135deg, rgba(255,255,255,0.2), transparent);
      border-radius: 50%;
    }

    #accessibility-toggle .pulse {
      position: absolute;
      width: 100%;
      height: 100%;
      border-radius: 50%;
      background: rgba(255, 255, 255, 0.3);
      animation: pulse 2s infinite;
    }

    @keyframes pulse {
      0% {
        transform: scale(1);
        opacity: 0.7;
      }
      70% {
        transform: scale(1.5);
        opacity: 0;
      }
      100% {
        transform: scale(1.5);
        opacity: 0;
      }
    }

    #accessibility-panel {
      position: absolute;
      bottom: 85px;
      left: 0;
      width: 380px;
      background: white;
      border-radius: var(--border-radius);
      box-shadow: var(--shadow);
      padding: 24px;
      display: none;
      transition: var(--transition);
      max-height: 80vh;
      overflow-y: auto;
      z-index: 10000;
    }

    #accessibility-panel.active {
      display: block;
      animation: slideIn 0.3s ease;
    }

    @keyframes slideIn {
      from { opacity: 0; transform: translateY(10px); }
      to { opacity: 1; transform: translateY(0); }
    }

    .panel-header {
      display: flex;
      justify-content: space-between;
      align-items: center;
      margin-bottom: 20px;
      padding-bottom: 16px;
      border-bottom: 1px solid #e9ecef;
    }

    .panel-header h3 {
      font-size: 20px;
      font-weight: 700;
      color: var(--dark);
      display: flex;
      align-items: center;
      gap: 10px;
    }

    .panel-header h3 i {
      color: var(--primary);
    }

    .close-btn {
      background: none;
      border: none;
      font-size: 18px;
      cursor: pointer;
      color: var(--gray);
      transition: var(--transition);
      width: 36px;
      height: 36px;
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
    }

    .close-btn:hover {
      background: #f8f9fa;
      color: var(--dark);
    }

    .category {
      margin-bottom: 24px;
    }

    .category-title {
      font-size: 16px;
      font-weight: 600;
      margin-bottom: 12px;
      color: var(--dark);
      display: flex;
      align-items: center;
      gap: 8px;
    }

    .category-title i {
      color: var(--primary);
      width: 20px;
    }

    .controls-grid {
      display: grid;
      grid-template-columns: repeat(2, 1fr);
      gap: 12px;
    }

    .control-btn {
      display: flex;
      flex-direction: column;
      align-items: center;
      justify-content: center;
      padding: 16px 8px;
      background: var(--light);
      border: 1px solid #e9ecef;
      border-radius: 12px;
      cursor: pointer;
      transition: var(--transition);
      text-align: center;
    }

    .control-btn:hover {
      background: #e9ecef;
      transform: translateY(-2px);
      box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
    }

    .control-btn.active {
      background: var(--primary);
      color: white;
      border-color: var(--primary);
    }

    .control-btn i {
      font-size: 20px;
      margin-bottom: 8px;
    }

    .control-btn span {
      font-size: 13px;
      font-weight: 500;
    }

    .slider-container {
      display: flex;
      align-items: center;
      gap: 12px;
      margin-top: 8px;
    }

    .slider-container i {
      color: var(--gray);
      font-size: 16px;
    }

    .slider {
      flex: 1;
      -webkit-appearance: none;
      height: 6px;
      border-radius: 3px;
      background: #e9ecef;
      outline: none;
    }

    .slider::-webkit-slider-thumb {
      -webkit-appearance: none;
      width: 20px;
      height: 20px;
      border-radius: 50%;
      background: var(--primary);
      cursor: pointer;
      box-shadow: 0 2px 5px rgba(0,0,0,0.2);
    }

    .color-controls {
      display: flex;
      gap: 12px;
      margin-top: 8px;
    }

    .color-control {
      display: flex;
      flex-direction: column;
      align-items: center;
      gap: 6px;
      flex: 1;
    }

    .color-control label {
      font-size: 12px;
      color: var(--gray);
    }

    .color-input {
      width: 40px;
      height: 40px;
      border: none;
      border-radius: 8px;
      cursor: pointer;
      padding: 0;
      box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }

    .color-input::-webkit-color-swatch-wrapper {
      padding: 0;
    }

    .color-input::-webkit-color-swatch {
      border: none;
      border-radius: 8px;
    }

    .reset-btn {
      width: 100%;
      padding: 14px;
      background: linear-gradient(135deg, var(--primary), var(--secondary));
      color: white;
      border: none;
      border-radius: 12px;
      cursor: pointer;
      font-weight: 600;
      transition: var(--transition);
      margin-top: 16px;
      display: flex;
      align-items: center;
      justify-content: center;
      gap: 8px;
    }

    .reset-btn:hover {
      transform: translateY(-2px);
      box-shadow: 0 5px 15px rgba(67, 97, 238, 0.3);
    }

    /* Draggable styles */
    .draggable {
      cursor: move;
      user-select: none;
    }

    /* Accessibility states */
    .high-contrast {
      background-color: #000 !important;
      color: #fff !important;
    }

    .high-contrast * {
      background-color: #000 !important;
      color: #fff !important;
      border-color: #fff !important;
    }

    .grayscale {
      filter: grayscale(100%);
    }

    .big-cursor * {
      cursor: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 32 32"><circle cx="16" cy="16" r="14" fill="%23000" opacity="0.5"/></svg>'), auto !important;
    }

    .highlight-links a {
      outline: 3px solid #ffeb3b !important;
      background-color: rgba(255, 235, 59, 0.2) !important;
      padding: 2px 4px;
      border-radius: 4px;
    }

    .readable-font * {
      font-family: 'Comic Sans MS', cursive, sans-serif !important;
    }

    .dyslexia-font * {
      font-family: 'OpenDyslexic', sans-serif !important;
      letter-spacing: 0.1em !important;
      line-height: 1.8 !important;
    }

    .monochrome {
      filter: grayscale(100%) contrast(150%);
    }

    .dark-mode {
      background-color: #1a1a1a !important;
      color: #f0f0f0 !important;
    }

    .dark-mode * {
      background-color: #1a1a1a !important;
      color: #f0f0f0 !important;
      border-color: #444 !important;
    }

    .light-mode {
      background-color: #ffffff !important;
      color: #000000 !important;
    }

    .text-to-speech-active {
      position: relative;
    }

    .text-to-speech-active::after {
      content: '';
      position: absolute;
      bottom: -2px;
      left: 0;
      width: 100%;
      height: 2px;
      background-color: #4361ee;
      animation: reading 1s infinite;
    }

    @keyframes reading {
      0% { width: 0%; }
      100% { width: 100%; }
    }

    /* Focus styles for better accessibility */
    #accessibility-widget-container button:focus, 
    #accessibility-widget-container select:focus, 
    #accessibility-widget-container input:focus {
      outline: 2px solid var(--primary);
      outline-offset: 2px;
    }

    /* Mobile styles */
    @media (max-width: 768px) {
      #accessibility-widget {
        bottom: 15px;
        left: 15px;
      }

      #accessibility-toggle {
        width: 60px;
        height: 60px;
        font-size: 24px;
      }

      #accessibility-panel {
        position: fixed;
        bottom: 80px;
        left: 15px;
        width: calc(100vw - 30px);
        max-height: 70vh;
        border-radius: var(--border-radius);
      }

      .controls-grid {
        grid-template-columns: repeat(3, 1fr);
      }
    }
  </style>

  <!-- Accessibility Widget HTML -->
  <div id="accessibility-widget" class="draggable">
    <button id="accessibility-toggle" aria-label="Accessibility Options">
      <div class="pulse"></div>
      <i class="fas fa-universal-access"></i>
    </button>
    
    <div id="accessibility-panel">
      <div class="panel-header">
        <h3><i class="fas fa-universal-access"></i> Accessibility Settings</h3>
        <button class="close-btn" aria-label="Close panel">
          <i class="fas fa-times"></i>
        </button>
      </div>
      
      <div class="category">
        <div class="category-title">
          <i class="fas fa-text-height"></i>
          <span>Text & Font</span>
        </div>
        <div class="controls-grid">
          <button class="control-btn" data-action="increase-text">
            <i class="fas fa-search-plus"></i>
            <span>Increase Text</span>
          </button>
          <button class="control-btn" data-action="decrease-text">
            <i class="fas fa-search-minus"></i>
            <span>Decrease Text</span>
          </button>
          <button class="control-btn" data-action="readable-font">
            <i class="fas fa-font"></i>
            <span>Readable Font</span>
          </button>
          <button class="control-btn" data-action="dyslexia-font">
            <i class="fas fa-text-width"></i>
            <span>Dyslexia Font</span>
          </button>
          <button class="control-btn" data-action="line-height">
            <i class="fas fa-arrows-alt-v"></i>
            <span>Line Height</span>
          </button>
          <button class="control-btn" data-action="letter-spacing">
            <i class="fas fa-text-width"></i>
            <span>Letter Spacing</span>
          </button>
        </div>
      </div>
      
      <div class="category">
        <div class="category-title">
          <i class="fas fa-palette"></i>
          <span>Color & Contrast</span>
        </div>
        <div class="controls-grid">
          <button class="control-btn" data-action="high-contrast">
            <i class="fas fa-adjust"></i>
            <span>High Contrast</span>
          </button>
          <button class="control-btn" data-action="grayscale">
            <i class="fas fa-tint"></i>
            <span>Grayscale</span>
          </button>
          <button class="control-btn" data-action="monochrome">
            <i class="fas fa-moon"></i>
            <span>Monochrome</span>
          </button>
          <button class="control-btn" data-action="invert-colors">
            <i class="fas fa-inverse"></i>
            <span>Invert Colors</span>
          </button>
          <button class="control-btn" data-action="dark-mode">
            <i class="fas fa-moon"></i>
            <span>Dark Mode</span>
          </button>
          <button class="control-btn" data-action="light-mode">
            <i class="fas fa-sun"></i>
            <span>Light Mode</span>
          </button>
        </div>
        <div class="color-controls">
          <div class="color-control">
            <label for="bg-color">Background</label>
            <input type="color" id="bg-color" class="color-input" value="#ffffff">
          </div>
          <div class="color-control">
            <label for="text-color">Text</label>
            <input type="color" id="text-color" class="color-input" value="#000000">
          </div>
          <div class="color-control">
            <label for="link-color">Links</label>
            <input type="color" id="link-color" class="color-input" value="#0000ee">
          </div>
        </div>
      </div>
      
      <div class="category">
        <div class="category-title">
          <i class="fas fa-mouse-pointer"></i>
          <span>Navigation & Content</span>
        </div>
        <div class="controls-grid">
          <button class="control-btn" data-action="big-cursor">
            <i class="fas fa-mouse"></i>
            <span>Big Cursor</span>
          </button>
          <button class="control-btn" data-action="highlight-links">
            <i class="fas fa-link"></i>
            <span>Highlight Links</span>
          </button>
          <button class="control-btn" data-action="underline-links">
            <i class="fas fa-underline"></i>
            <span>Underline Links</span>
          </button>
          <button class="control-btn" data-action="focus-visible">
            <i class="fas fa-bullseye"></i>
            <span>Focus Indicator</span>
          </button>
          <button class="control-btn" data-action="hide-images">
            <i class="fas fa-eye-slash"></i>
            <span>Hide Images</span>
          </button>
          <button class="control-btn" data-action="tooltips">
            <i class="fas fa-comment-alt"></i>
            <span>Tooltips</span>
          </button>
        </div>
      </div>
      
      <div class="category">
        <div class="category-title">
          <i class="fas fa-sliders-h"></i>
          <span>Other Settings</span>
        </div>
        <div class="slider-container">
          <i class="fas fa-volume-down"></i>
          <input type="range" min="0" max="100" value="50" class="slider" id="saturation-slider">
          <i class="fas fa-volume-up"></i>
        </div>
        <div class="controls-grid" style="margin-top: 12px;">
          <button class="control-btn" data-action="text-to-speech">
            <i class="fas fa-volume-up"></i>
            <span>Text to Speech</span>
          </button>
          <button class="control-btn" data-action="stop-animations">
            <i class="fas fa-stop-circle"></i>
            <span>Stop Animations</span>
          </button>
          <button class="control-btn" data-action="reading-guide">
            <i class="fas fa-highlighter"></i>
            <span>Reading Guide</span>
          </button>
          <button class="control-btn" data-action="keyboard-navigation">
            <i class="fas fa-keyboard"></i>
            <span>Keyboard Nav</span>
          </button>
        </div>
      </div>
      
      <button class="reset-btn" id="reset-all">
        <i class="fas fa-redo"></i> Reset All Settings
      </button>
    </div>
  </div>

  <!-- JavaScript for the Accessibility Widget -->
  <script>
    // Wait for the DOM to be fully loaded
    document.addEventListener('DOMContentLoaded', function() {
      // Load required libraries
      const loadFontAwesome = () => {
        return new Promise((resolve, reject) => {
          if (document.querySelector('.fa-universal-access')) {
            resolve(); // Already loaded
            return;
          }
          
          const link = document.createElement('link');
          link.rel = 'stylesheet';
          link.href = 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css';
          link.onload = resolve;
          link.onerror = reject;
          document.head.appendChild(link);
        });
      };
      
      const loadGoogleFonts = () => {
        return new Promise((resolve, reject) => {
          if (document.querySelector('link[href*="fonts.googleapis.com"]')) {
            resolve(); // Already loaded
            return;
          }
          
          const link = document.createElement('link');
          link.rel = 'stylesheet';
          link.href = 'https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap';
          link.onload = resolve;
          link.onerror = reject;
          document.head.appendChild(link);
        });
      };
      
      // Load dyslexia font
      const loadDyslexiaFont = () => {
        const style = document.createElement('style');
        style.textContent = `
          @font-face {
            font-family: 'OpenDyslexic';
            src: url('https://cdn.jsdelivr.net/npm/open-dyslexic@1.0.3/otf/OpenDyslexic-Regular.otf') format('opentype');
          }
        `;
        document.head.appendChild(style);
      };
      
      // Initialize the widget after libraries are loaded
      Promise.all([loadFontAwesome(), loadGoogleFonts()])
        .then(() => {
          loadDyslexiaFont();
          initializeAccessibilityWidget();
        })
        .catch(error => {
          console.error('Failed to load required libraries:', error);
          initializeAccessibilityWidget(); // Try to initialize anyway
        });
      
      function initializeAccessibilityWidget() {
        const accessibilityWidget = document.getElementById('accessibility-widget');
        const accessibilityToggle = document.getElementById('accessibility-toggle');
        const accessibilityPanel = document.getElementById('accessibility-panel');
        const closeBtn = document.querySelector('.close-btn');
        const resetBtn = document.getElementById('reset-all');
        const controlButtons = document.querySelectorAll('.control-btn');
        const bgColorInput = document.getElementById('bg-color');
        const textColorInput = document.getElementById('text-color');
        const linkColorInput = document.getElementById('link-color');
        const saturationSlider = document.getElementById('saturation-slider');
        
        let currentFontSize = 100; // Base font size percentage
        let currentLineHeight = 1.5; // Base line height
        let currentLetterSpacing = 'normal'; // Base letter spacing
        let isDragging = false;
        let dragOffsetX, dragOffsetY;
        let textToSpeechActive = false;
        let speechSynthesis = window.speechSynthesis;
        let currentUtterance = null;
        
        // Set initial position
        accessibilityWidget.style.bottom = '20px';
        accessibilityWidget.style.left = '20px';
        
        // Draggable functionality - now moves both button and panel together
        accessibilityToggle.addEventListener('mousedown', startDrag);
        accessibilityToggle.addEventListener('touchstart', startDragTouch);
        
        function startDrag(e) {
          isDragging = true;
          const rect = accessibilityWidget.getBoundingClientRect();
          dragOffsetX = e.clientX - rect.left;
          dragOffsetY = e.clientY - rect.top;
          document.addEventListener('mousemove', onDrag);
          document.addEventListener('mouseup', stopDrag);
          e.preventDefault();
        }
        
        function startDragTouch(e) {
          isDragging = true;
          const touch = e.touches[0];
          const rect = accessibilityWidget.getBoundingClientRect();
          dragOffsetX = touch.clientX - rect.left;
          dragOffsetY = touch.clientY - rect.top;
          document.addEventListener('touchmove', onDragTouch);
          document.addEventListener('touchend', stopDrag);
          e.preventDefault();
        }
        
        function onDrag(e) {
          if (!isDragging) return;
          
          // Calculate new position
          let newLeft = e.clientX - dragOffsetX;
          let newTop = e.clientY - dragOffsetY;
          
          // Constrain to viewport
          const widgetWidth = accessibilityWidget.offsetWidth;
          const widgetHeight = accessibilityWidget.offsetHeight;
          newLeft = Math.max(0, Math.min(newLeft, window.innerWidth - widgetWidth));
          newTop = Math.max(0, Math.min(newTop, window.innerHeight - widgetHeight));
          
          // Apply new position - both button and panel move together
          accessibilityWidget.style.left = `${newLeft}px`;
          accessibilityWidget.style.top = `${newTop}px`;
          accessibilityWidget.style.right = 'auto';
          accessibilityWidget.style.bottom = 'auto';
        }
        
        function onDragTouch(e) {
          if (!isDragging) return;
          const touch = e.touches[0];
          
          // Calculate new position
          let newLeft = touch.clientX - dragOffsetX;
          let newTop = touch.clientY - dragOffsetY;
          
          // Constrain to viewport
          const widgetWidth = accessibilityWidget.offsetWidth;
          const widgetHeight = accessibilityWidget.offsetHeight;
          newLeft = Math.max(0, Math.min(newLeft, window.innerWidth - widgetWidth));
          newTop = Math.max(0, Math.min(newTop, window.innerHeight - widgetHeight));
          
          // Apply new position - both button and panel move together
          accessibilityWidget.style.left = `${newLeft}px`;
          accessibilityWidget.style.top = `${newTop}px`;
          accessibilityWidget.style.right = 'auto';
          accessibilityWidget.style.bottom = 'auto';
        }
        
        function stopDrag() {
          isDragging = false;
          document.removeEventListener('mousemove', onDrag);
          document.removeEventListener('touchmove', onDragTouch);
          document.removeEventListener('mouseup', stopDrag);
          document.removeEventListener('touchend', stopDrag);
        }
        
        // Toggle panel visibility
        accessibilityToggle.addEventListener('click', function(e) {
          if (!isDragging) {
            accessibilityPanel.classList.toggle('active');
          }
        });
        
        closeBtn.addEventListener('click', function() {
          accessibilityPanel.classList.remove('active');
        });
        
        // Close panel when clicking outside
        document.addEventListener('click', function(event) {
          if (!accessibilityWidget.contains(event.target)) {
            accessibilityPanel.classList.remove('active');
          }
        });
        
        // Control button actions
        controlButtons.forEach(button => {
          button.addEventListener('click', function() {
            const action = this.getAttribute('data-action');
            
            // Toggle active state
            if (action !== 'increase-text' && action !== 'decrease-text' && 
                action !== 'text-to-speech' && action !== 'stop-animations') {
              this.classList.toggle('active');
            }
            
            // Execute the corresponding function
            switch(action) {
              case 'increase-text':
                increaseTextSize();
                break;
              case 'decrease-text':
                decreaseTextSize();
                break;
              case 'readable-font':
                toggleReadableFont();
                break;
              case 'dyslexia-font':
                toggleDyslexiaFont();
                break;
              case 'line-height':
                toggleLineHeight();
                break;
              case 'letter-spacing':
                toggleLetterSpacing();
                break;
              case 'high-contrast':
                toggleHighContrast();
                break;
              case 'grayscale':
                toggleGrayscale();
                break;
              case 'monochrome':
                toggleMonochrome();
                break;
              case 'invert-colors':
                toggleInvertColors();
                break;
              case 'dark-mode':
                toggleDarkMode();
                break;
              case 'light-mode':
                toggleLightMode();
                break;
              case 'big-cursor':
                toggleBigCursor();
                break;
              case 'highlight-links':
                toggleHighlightLinks();
                break;
              case 'underline-links':
                toggleUnderlineLinks();
                break;
              case 'focus-visible':
                toggleFocusIndicator();
                break;
              case 'hide-images':
                toggleHideImages();
                break;
              case 'tooltips':
                toggleTooltips();
                break;
              case 'text-to-speech':
                toggleTextToSpeech();
                break;
              case 'stop-animations':
                toggleStopAnimations();
                break;
              case 'reading-guide':
                toggleReadingGuide();
                break;
              case 'keyboard-navigation':
                toggleKeyboardNavigation();
                break;
            }
          });
        });
        
        // Color controls
        bgColorInput.addEventListener('input', function() {
          document.body.style.backgroundColor = this.value;
          savePreference('bgColor', this.value);
        });
        
        textColorInput.addEventListener('input', function() {
          document.body.style.color = this.value;
          savePreference('textColor', this.value);
        });
        
        linkColorInput.addEventListener('input', function() {
          const links = document.querySelectorAll('a');
          links.forEach(link => {
            link.style.color = this.value;
          });
          savePreference('linkColor', this.value);
        });
        
        // Saturation slider
        saturationSlider.addEventListener('input', function() {
          const saturationValue = this.value / 50; // Convert to 0-2 range
          document.body.style.filter = `saturate(${saturationValue})`;
          savePreference('saturation', saturationValue);
        });
        
        // Reset all settings
        resetBtn.addEventListener('click', function() {
          resetAllSettings();
        });
        
        // Text size functions
        function increaseTextSize() {
          currentFontSize += 10;
          if (currentFontSize > 200) currentFontSize = 200;
          document.body.style.fontSize = `${currentFontSize}%`;
          savePreference('fontSize', currentFontSize);
        }
        
        function decreaseTextSize() {
          currentFontSize -= 10;
          if (currentFontSize < 70) currentFontSize = 70;
          document.body.style.fontSize = `${currentFontSize}%`;
          savePreference('fontSize', currentFontSize);
        }
        
        // Toggle functions
        function toggleReadableFont() {
          document.body.classList.toggle('readable-font');
          savePreference('readableFont', document.body.classList.contains('readable-font'));
        }
        
        function toggleDyslexiaFont() {
          document.body.classList.toggle('dyslexia-font');
          savePreference('dyslexiaFont', document.body.classList.contains('dyslexia-font'));
        }
        
        function toggleLineHeight() {
          if (currentLineHeight === 1.5) {
            currentLineHeight = 2.0;
          } else {
            currentLineHeight = 1.5;
          }
          document.body.style.lineHeight = currentLineHeight;
          savePreference('lineHeight', currentLineHeight);
        }
        
        function toggleLetterSpacing() {
          if (currentLetterSpacing === 'normal') {
            currentLetterSpacing = '0.2em';
          } else {
            currentLetterSpacing = 'normal';
          }
          document.body.style.letterSpacing = currentLetterSpacing;
          savePreference('letterSpacing', currentLetterSpacing);
        }
        
        function toggleHighContrast() {
          document.body.classList.toggle('high-contrast');
          savePreference('highContrast', document.body.classList.contains('high-contrast'));
        }
        
        function toggleGrayscale() {
          document.body.classList.toggle('grayscale');
          savePreference('grayscale', document.body.classList.contains('grayscale'));
        }
        
        function toggleMonochrome() {
          document.body.classList.toggle('monochrome');
          savePreference('monochrome', document.body.classList.contains('monochrome'));
        }
        
        function toggleInvertColors() {
          document.body.style.filter = document.body.style.filter.includes('invert(1)') 
            ? '' 
            : 'invert(1)';
          savePreference('invertColors', document.body.style.filter.includes('invert(1)'));
        }
        
        function toggleDarkMode() {
          document.body.classList.add('dark-mode');
          document.body.classList.remove('light-mode');
          savePreference('darkMode', true);
          savePreference('lightMode', false);
        }
        
        function toggleLightMode() {
          document.body.classList.add('light-mode');
          document.body.classList.remove('dark-mode');
          savePreference('lightMode', true);
          savePreference('darkMode', false);
        }
        
        function toggleHighlightLinks() {
          document.body.classList.toggle('highlight-links');
          savePreference('highlightLinks', document.body.classList.contains('highlight-links'));
        }
        
        function toggleBigCursor() {
          document.body.classList.toggle('big-cursor');
          savePreference('bigCursor', document.body.classList.contains('big-cursor'));
        }
        
        function toggleUnderlineLinks() {
          const links = document.querySelectorAll('a');
          links.forEach(link => {
            link.style.textDecoration = link.style.textDecoration === 'underline' ? '' : 'underline';
          });
          savePreference('underlineLinks', links[0]?.style.textDecoration === 'underline');
        }
        
        function toggleFocusIndicator() {
          const style = document.createElement('style');
          style.id = 'focus-indicator';
          if (!document.getElementById('focus-indicator')) {
            style.innerHTML = `
              *:focus {
                outline: 3px solid #4361ee !important;
                outline-offset: 2px !important;
              }
            `;
            document.head.appendChild(style);
            savePreference('focusIndicator', true);
          } else {
            document.getElementById('focus-indicator').remove();
            savePreference('focusIndicator', false);
          }
        }
        
        function toggleHideImages() {
          const images = document.querySelectorAll('img');
          images.forEach(img => {
            img.style.display = img.style.display === 'none' ? '' : 'none';
          });
          savePreference('hideImages', images[0]?.style.display === 'none');
        }
        
        function toggleTooltips() {
          // This would normally add tooltips to elements
          // For demo purposes, we'll just show an alert
          alert('Tooltips feature activated! Hover over elements to see additional information.');
          savePreference('tooltips', true);
        }
        
        function toggleTextToSpeech() {
          if (textToSpeechActive) {
            // Stop text-to-speech
            if (speechSynthesis.speaking) {
              speechSynthesis.cancel();
            }
            document.body.classList.remove('text-to-speech-active');
            textToSpeechActive = false;
            savePreference('textToSpeech', false);
          } else {
            // Start text-to-speech
            if (speechSynthesis.speaking) {
              speechSynthesis.cancel();
            }
            
            const textContent = document.body.innerText;
            const utterance = new SpeechSynthesisUtterance(textContent.substring(0, 200)); // Limit for demo
            
            utterance.onend = function() {
              document.body.classList.remove('text-to-speech-active');
              textToSpeechActive = false;
              savePreference('textToSpeech', false);
            };
            
            speechSynthesis.speak(utterance);
            document.body.classList.add('text-to-speech-active');
            textToSpeechActive = true;
            savePreference('textToSpeech', true);
          }
        }
        
        function toggleStopAnimations() {
          const style = document.createElement('style');
          style.id = 'stop-animations';
          if (!document.getElementById('stop-animations')) {
            style.innerHTML = `
              *, *::before, *::after {
                animation: none !important;
                transition: none !important;
              }
            `;
            document.head.appendChild(style);
            savePreference('stopAnimations', true);
          } else {
            document.getElementById('stop-animations').remove();
            savePreference('stopAnimations', false);
          }
        }
        
        function toggleReadingGuide() {
          // This would normally add a reading guide line
          // For demo purposes, we'll just show an alert
          alert('Reading guide activated! A line will follow your cursor to help with reading.');
          savePreference('readingGuide', true);
        }
        
        function toggleKeyboardNavigation() {
          // This would normally enhance keyboard navigation
          // For demo purposes, we'll just show an alert
          alert('Enhanced keyboard navigation activated! Use Tab to navigate and Enter to activate elements.');
          savePreference('keyboardNavigation', true);
        }
        
        // Reset all settings
        function resetAllSettings() {
          // Reset all visual changes
          document.body.style.fontSize = '';
          document.body.style.lineHeight = '';
          document.body.style.letterSpacing = '';
          document.body.style.backgroundColor = '';
          document.body.style.color = '';
          document.body.style.filter = '';
          document.body.className = '';
          
          // Reset links
          const links = document.querySelectorAll('a');
          links.forEach(link => {
            link.style.textDecoration = '';
            link.style.color = '';
          });
          
          // Reset images
          const images = document.querySelectorAll('img');
          images.forEach(img => {
            img.style.display = '';
          });
          
          // Remove added styles
          const addedStyles = ['focus-indicator', 'stop-animations'];
          addedStyles.forEach(styleId => {
            const styleElement = document.getElementById(styleId);
            if (styleElement) {
              styleElement.remove();
            }
          });
          
          // Stop text-to-speech if active
          if (speechSynthesis.speaking) {
            speechSynthesis.cancel();
          }
          document.body.classList.remove('text-to-speech-active');
          textToSpeechActive = false;
          
          // Reset control buttons active state
          controlButtons.forEach(button => {
            button.classList.remove('active');
          });
          
          // Reset current values
          currentFontSize = 100;
          currentLineHeight = 1.5;
          currentLetterSpacing = 'normal';
          
          // Reset inputs
          bgColorInput.value = '#ffffff';
          textColorInput.value = '#000000';
          linkColorInput.value = '#0000ee';
          saturationSlider.value = 50;
          
          // Clear saved preferences
          localStorage.removeItem('accessibilityPreferences');
          
          // Close panel
          accessibilityPanel.classList.remove('active');
        }
        
        // Save preferences to localStorage
        function savePreference(key, value) {
          const preferences = JSON.parse(localStorage.getItem('accessibilityPreferences')) || {};
          preferences[key] = value;
          localStorage.setItem('accessibilityPreferences', JSON.stringify(preferences));
        }
        
        // Load saved preferences
        function loadPreferences() {
          const preferences = JSON.parse(localStorage.getItem('accessibilityPreferences'));
          if (preferences) {
            // Font size
            if (preferences.fontSize) {
              currentFontSize = preferences.fontSize;
              document.body.style.fontSize = `${currentFontSize}%`;
            }
            
            // Line height
            if (preferences.lineHeight) {
              currentLineHeight = preferences.lineHeight;
              document.body.style.lineHeight = currentLineHeight;
            }
            
            // Letter spacing
            if (preferences.letterSpacing) {
              currentLetterSpacing = preferences.letterSpacing;
              document.body.style.letterSpacing = currentLetterSpacing;
            }
            
            // Readable font
            if (preferences.readableFont) {
              document.body.classList.add('readable-font');
              document.querySelector('[data-action="readable-font"]').classList.add('active');
            }
            
            // Dyslexia font
            if (preferences.dyslexiaFont) {
              document.body.classList.add('dyslexia-font');
              document.querySelector('[data-action="dyslexia-font"]').classList.add('active');
            }
            
            // High contrast
            if (preferences.highContrast) {
              document.body.classList.add('high-contrast');
              document.querySelector('[data-action="high-contrast"]').classList.add('active');
            }
            
            // Grayscale
            if (preferences.grayscale) {
              document.body.classList.add('grayscale');
              document.querySelector('[data-action="grayscale"]').classList.add('active');
            }
            
            // Monochrome
            if (preferences.monochrome) {
              document.body.classList.add('monochrome');
              document.querySelector('[data-action="monochrome"]').classList.add('active');
            }
            
            // Invert colors
            if (preferences.invertColors) {
              document.body.style.filter = 'invert(1)';
              document.querySelector('[data-action="invert-colors"]').classList.add('active');
            }
            
            // Dark mode
            if (preferences.darkMode) {
              document.body.classList.add('dark-mode');
              document.querySelector('[data-action="dark-mode"]').classList.add('active');
            }
            
            // Light mode
            if (preferences.lightMode) {
              document.body.classList.add('light-mode');
              document.querySelector('[data-action="light-mode"]').classList.add('active');
            }
            
            // Highlight links
            if (preferences.highlightLinks) {
              document.body.classList.add('highlight-links');
              document.querySelector('[data-action="highlight-links"]').classList.add('active');
            }
            
            // Big cursor
            if (preferences.bigCursor) {
              document.body.classList.add('big-cursor');
              document.querySelector('[data-action="big-cursor"]').classList.add('active');
            }
            
            // Underline links
            if (preferences.underlineLinks) {
              const links = document.querySelectorAll('a');
              links.forEach(link => {
                link.style.textDecoration = 'underline';
              });
              document.querySelector('[data-action="underline-links"]').classList.add('active');
            }
            
            // Focus indicator
            if (preferences.focusIndicator) {
              const style = document.createElement('style');
              style.id = 'focus-indicator';
              style.innerHTML = `
                *:focus {
                  outline: 3px solid #4361ee !important;
                  outline-offset: 2px !important;
                }
              `;
              document.head.appendChild(style);
              document.querySelector('[data-action="focus-visible"]').classList.add('active');
            }
            
            // Hide images
            if (preferences.hideImages) {
              const images = document.querySelectorAll('img');
              images.forEach(img => {
                img.style.display = 'none';
              });
              document.querySelector('[data-action="hide-images"]').classList.add('active');
            }
            
            // Stop animations
            if (preferences.stopAnimations) {
              const style = document.createElement('style');
              style.id = 'stop-animations';
              style.innerHTML = `
                *, *::before, *::after {
                  animation: none !important;
                  transition: none !important;
                }
              `;
              document.head.appendChild(style);
              document.querySelector('[data-action="stop-animations"]').classList.add('active');
            }
            
            // Text to speech
            if (preferences.textToSpeech) {
              textToSpeechActive = true;
              document.querySelector('[data-action="text-to-speech"]').classList.add('active');
            }
            
            // Background color
            if (preferences.bgColor) {
              document.body.style.backgroundColor = preferences.bgColor;
              bgColorInput.value = preferences.bgColor;
            }
            
            // Text color
            if (preferences.textColor) {
              document.body.style.color = preferences.textColor;
              textColorInput.value = preferences.textColor;
            }
            
            // Link color
            if (preferences.linkColor) {
              const links = document.querySelectorAll('a');
              links.forEach(link => {
                link.style.color = preferences.linkColor;
              });
              linkColorInput.value = preferences.linkColor;
            }
            
            // Saturation
            if (preferences.saturation) {
              document.body.style.filter = `saturate(${preferences.saturation})`;
              saturationSlider.value = preferences.saturation * 50;
            }
          }
        }
        
        // Load preferences when page loads
        loadPreferences();
      }
    });
  </script>
</div>

</body>
</html>